/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import com.jfoenix.controls.JFXRippler;
import java.util.ArrayList;
import java.util.List;
import javafx.animation.Transition;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.PaintConverter;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import org.jackhuang.hmcl.theme.Themes;
import org.jackhuang.hmcl.ui.animation.AnimationUtils;
import org.jackhuang.hmcl.ui.animation.Motion;

public class RipplerContainer
extends StackPane {
    private static final String DEFAULT_STYLE_CLASS = "rippler-container";
    private static final CornerRadii DEFAULT_RADII = new CornerRadii(3.0);
    private static final Color DEFAULT_RIPPLER_FILL = Color.rgb((int)0, (int)200, (int)255);
    private final Node container;
    private final StackPane buttonContainer = new StackPane();
    private final JFXRippler buttonRippler = new JFXRippler((Node)new StackPane()){
        private static final Background DEFAULT_MASK_BACKGROUND = new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, DEFAULT_RADII, Insets.EMPTY)});

        @Override
        protected Node getMask() {
            StackPane mask = new StackPane();
            mask.shapeProperty().bind((ObservableValue)RipplerContainer.this.buttonContainer.shapeProperty());
            mask.setBackground(DEFAULT_MASK_BACKGROUND);
            mask.resize(RipplerContainer.this.buttonContainer.getWidth() - RipplerContainer.this.buttonContainer.snappedRightInset() - RipplerContainer.this.buttonContainer.snappedLeftInset(), RipplerContainer.this.buttonContainer.getHeight() - RipplerContainer.this.buttonContainer.snappedBottomInset() - RipplerContainer.this.buttonContainer.snappedTopInset());
            return mask;
        }
    };
    private Transition coverAnimation;
    private final StyleableObjectProperty<Paint> ripplerFill = new StyleableObjectProperty<Paint>((Paint)DEFAULT_RIPPLER_FILL){

        public Object getBean() {
            return RipplerContainer.this;
        }

        public String getName() {
            return "ripplerFill";
        }

        public CssMetaData<? extends Styleable, Paint> getCssMetaData() {
            return StyleableProperties.RIPPLER_FILL;
        }

        protected void invalidated() {
            RipplerContainer.this.buttonRippler.setRipplerFill((Paint)this.get());
        }
    };

    public RipplerContainer(Node container) {
        this.container = container;
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.buttonRippler.setPosition(JFXRippler.RipplerPos.BACK);
        this.buttonContainer.getChildren().add((Object)this.buttonRippler);
        this.focusedProperty().addListener((a, b, newValue) -> {
            if (newValue.booleanValue()) {
                if (!this.isPressed()) {
                    this.buttonRippler.showOverlay();
                }
            } else {
                this.buttonRippler.hideOverlay();
            }
        });
        this.pressedProperty().addListener(o -> this.buttonRippler.hideOverlay());
        this.setPickOnBounds(false);
        this.buttonContainer.setPickOnBounds(false);
        this.updateChildren();
        Rectangle shape = new Rectangle();
        shape.widthProperty().bind((ObservableValue)this.widthProperty());
        shape.heightProperty().bind((ObservableValue)this.heightProperty());
        this.setShape((Shape)shape);
        EventHandler mouseEventHandler = AnimationUtils.isAnimationEnabled() ? event -> {
            if (this.coverAnimation != null) {
                this.coverAnimation.stop();
                this.coverAnimation = null;
            }
            this.coverAnimation = event.getEventType() == MouseEvent.MOUSE_ENTERED ? new Transition(){
                {
                    this.setCycleDuration(Motion.SHORT4);
                    this.setInterpolator(Motion.EASE_IN);
                }

                protected void interpolate(double frac) {
                    RipplerContainer.this.interpolateBackground(frac);
                }
            } : new Transition(){
                {
                    this.setCycleDuration(Motion.SHORT4);
                    this.setInterpolator(Motion.EASE_OUT);
                }

                protected void interpolate(double frac) {
                    RipplerContainer.this.interpolateBackground(1.0 - frac);
                }
            };
            this.coverAnimation.play();
        } : event -> this.interpolateBackground(event.getEventType() == MouseEvent.MOUSE_ENTERED ? 1.0 : 0.0);
        this.addEventHandler(MouseEvent.MOUSE_ENTERED, mouseEventHandler);
        this.addEventHandler(MouseEvent.MOUSE_EXITED, mouseEventHandler);
    }

    private void interpolateBackground(double frac) {
        if (frac < 0.01) {
            this.setBackground(null);
        } else {
            Color onSurface = Themes.getColorScheme().getOnSurface();
            this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.color((double)onSurface.getRed(), (double)onSurface.getGreen(), (double)onSurface.getBlue(), (double)(frac * 0.04)), CornerRadii.EMPTY, Insets.EMPTY)}));
        }
    }

    protected void updateChildren() {
        Node container = this.getContainer();
        if (this.buttonRippler.getPosition() == JFXRippler.RipplerPos.BACK) {
            this.getChildren().setAll((Object[])new Node[]{this.buttonContainer, container});
            container.setPickOnBounds(false);
        } else {
            this.getChildren().setAll((Object[])new Node[]{container, this.buttonContainer});
            this.buttonContainer.setPickOnBounds(false);
        }
    }

    public void setPosition(JFXRippler.RipplerPos pos) {
        this.buttonRippler.setPosition(pos);
        this.updateChildren();
    }

    public JFXRippler getRippler() {
        return this.buttonRippler;
    }

    public Node getContainer() {
        return this.container;
    }

    public StyleableObjectProperty<Paint> ripplerFillProperty() {
        return this.ripplerFill;
    }

    public Paint getRipplerFill() {
        return (Paint)this.ripplerFillProperty().get();
    }

    public void setRipplerFill(Paint ripplerFill) {
        this.ripplerFillProperty().set((Object)ripplerFill);
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return RipplerContainer.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    private static final class StyleableProperties {
        private static final CssMetaData<RipplerContainer, Paint> RIPPLER_FILL = new CssMetaData<RipplerContainer, Paint>("-jfx-rippler-fill", PaintConverter.getInstance(), (Paint)DEFAULT_RIPPLER_FILL){

            public boolean isSettable(RipplerContainer styleable) {
                return styleable.ripplerFill == null || !styleable.ripplerFill.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(RipplerContainer styleable) {
                return styleable.ripplerFillProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<CssMetaData<RipplerContainer, Paint>> styleables = new ArrayList<CssMetaData<RipplerContainer, Paint>>(StackPane.getClassCssMetaData());
            styleables.add(RIPPLER_FILL);
            STYLEABLES = List.copyOf(styleables);
        }
    }
}

