/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.download;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.effects.JFXDepthManager;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.scene.shape.SVGPath;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.jackhuang.hmcl.game.ModpackHelper;
import org.jackhuang.hmcl.mod.server.ServerModpackManifest;
import org.jackhuang.hmcl.task.FileDownloadTask;
import org.jackhuang.hmcl.task.GetTask;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.construct.TwoLineListItem;
import org.jackhuang.hmcl.ui.construct.URLValidator;
import org.jackhuang.hmcl.ui.download.DownloadPage;
import org.jackhuang.hmcl.ui.download.LocalModpackPage;
import org.jackhuang.hmcl.ui.download.RemoteModpackPage;
import org.jackhuang.hmcl.ui.wizard.WizardController;
import org.jackhuang.hmcl.ui.wizard.WizardPage;
import org.jackhuang.hmcl.util.SettingsMap;
import org.jackhuang.hmcl.util.TaskCancellationAction;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.FileUtils;

public final class ModpackSelectionPage
extends VBox
implements WizardPage {
    private final WizardController controller;

    public ModpackSelectionPage(WizardController controller) {
        this.controller = controller;
        Label title = new Label(I18n.i18n("install.modpack"));
        title.setPadding(new Insets(8.0));
        this.getStyleClass().add((Object)"jfx-list-view");
        this.setMaxSize(400.0, 150.0);
        this.setSpacing(8.0);
        this.getChildren().setAll((Object[])new Node[]{title, this.createButton("local", this::onChooseLocalFile), this.createButton("remote", this::onChooseRemoteFile), this.createButton("repository", this::onChooseRepository)});
        Path filePath = controller.getSettings().get(LocalModpackPage.MODPACK_FILE);
        if (filePath != null) {
            controller.getSettings().put(LocalModpackPage.MODPACK_FILE, filePath);
            Platform.runLater(controller::onNext);
        }
        FXUtils.applyDragListener((Node)this, ModpackHelper::isFileModpackByExtension, modpacks -> {
            Path modpack = (Path)modpacks.get(0);
            controller.getSettings().put(LocalModpackPage.MODPACK_FILE, modpack);
            controller.onNext();
        });
    }

    private JFXButton createButton(String type, Runnable action) {
        JFXButton button = new JFXButton();
        button.getStyleClass().add((Object)"card");
        button.setStyle("-fx-cursor: HAND;");
        button.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        button.setOnAction(e -> action.run());
        BorderPane graphic = new BorderPane();
        graphic.setMouseTransparent(true);
        graphic.setLeft((Node)new TwoLineListItem(I18n.i18n("modpack.choose." + type), I18n.i18n("modpack.choose." + type + ".detail")));
        SVGPath arrow = new SVGPath();
        arrow.setContent(SVG.ARROW_FORWARD.getPath());
        BorderPane.setAlignment((Node)arrow, (Pos)Pos.CENTER);
        graphic.setRight((Node)arrow);
        button.setGraphic((Node)graphic);
        JFXDepthManager.setDepth((Node)button, 1);
        return button;
    }

    private void onChooseLocalFile() {
        FileChooser chooser = new FileChooser();
        chooser.setTitle(I18n.i18n("modpack.choose"));
        chooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(I18n.i18n("modpack"), new String[]{"*.zip", "*.mrpack"}));
        Path selectedFile = FileUtils.toPath(chooser.showOpenDialog((Window)Controllers.getStage()));
        if (selectedFile == null) {
            Platform.runLater(this.controller::onEnd);
            return;
        }
        this.controller.getSettings().put(LocalModpackPage.MODPACK_FILE, selectedFile);
        this.controller.onNext();
    }

    private void onChooseRemoteFile() {
        Controllers.prompt(I18n.i18n("modpack.choose.remote.tooltip"), (url, handler) -> {
            try {
                if (url.endsWith("server-manifest.json")) {
                    Controllers.taskDialog(new GetTask((String)url).whenComplete(Schedulers.javafx(), (result, e) -> {
                        ServerModpackManifest manifest = JsonUtils.fromMaybeMalformedJson(result, ServerModpackManifest.class);
                        if (manifest == null) {
                            handler.reject(I18n.i18n("modpack.type.server.malformed"));
                        } else if (e == null) {
                            handler.resolve();
                            this.controller.getSettings().put(RemoteModpackPage.MODPACK_SERVER_MANIFEST, manifest);
                            this.controller.onNext();
                        } else {
                            handler.reject(e.getMessage());
                        }
                    }).executor(true), I18n.i18n("message.downloading"), TaskCancellationAction.NORMAL);
                } else {
                    Path modpack = Files.createTempFile("modpack", ".zip", new FileAttribute[0]);
                    handler.resolve();
                    Controllers.taskDialog(new FileDownloadTask((String)url, modpack).whenComplete(Schedulers.javafx(), e -> {
                        if (e == null) {
                            handler.resolve();
                            this.controller.getSettings().put(LocalModpackPage.MODPACK_FILE, modpack);
                            this.controller.onNext();
                        } else {
                            handler.reject(e.getMessage());
                        }
                    }).executor(true), I18n.i18n("message.downloading"), TaskCancellationAction.NORMAL);
                }
            }
            catch (IOException e2) {
                handler.reject(e2.getMessage());
            }
        }, "", new URLValidator());
    }

    public void onChooseRepository() {
        String modPackName = this.controller.getSettings().get(LocalModpackPage.MODPACK_NAME);
        DownloadPage downloadPage = new DownloadPage(modPackName);
        downloadPage.showModpackDownloads();
        Controllers.navigate((Node)downloadPage);
    }

    @Override
    public void cleanup(SettingsMap settings) {
    }

    @Override
    public String getTitle() {
        return I18n.i18n("modpack.task.install");
    }
}

