/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.download;

import com.jfoenix.validation.base.ValidatorBase;
import java.io.IOException;
import javafx.application.Platform;
import javafx.scene.Node;
import org.jackhuang.hmcl.game.HMCLGameRepository;
import org.jackhuang.hmcl.mod.Modpack;
import org.jackhuang.hmcl.mod.server.ServerModpackManifest;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.WebPage;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.construct.RequiredValidator;
import org.jackhuang.hmcl.ui.construct.Validator;
import org.jackhuang.hmcl.ui.download.ModpackPage;
import org.jackhuang.hmcl.ui.wizard.WizardController;
import org.jackhuang.hmcl.util.SettingsMap;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;

public final class RemoteModpackPage
extends ModpackPage {
    private final ServerModpackManifest manifest;
    public static final SettingsMap.Key<ServerModpackManifest> MODPACK_SERVER_MANIFEST = new SettingsMap.Key("MODPACK_SERVER_MANIFEST");
    public static final SettingsMap.Key<String> MODPACK_NAME = new SettingsMap.Key("MODPACK_NAME");
    public static final SettingsMap.Key<Modpack> MODPACK_MANIFEST = new SettingsMap.Key("MODPACK_MANIFEST");

    public RemoteModpackPage(WizardController controller) {
        super(controller);
        this.manifest = controller.getSettings().get(MODPACK_SERVER_MANIFEST);
        if (this.manifest == null) {
            throw new IllegalStateException("MODPACK_SERVER_MANIFEST should exist");
        }
        try {
            controller.getSettings().put(MODPACK_MANIFEST, this.manifest.toModpack(null));
        }
        catch (IOException e) {
            Controllers.dialog(I18n.i18n("modpack.type.server.malformed"), I18n.i18n("message.error"), MessageDialogPane.MessageType.ERROR);
            Platform.runLater(controller::onEnd);
            return;
        }
        this.nameProperty.set((Object)this.manifest.getName());
        this.versionProperty.set((Object)this.manifest.getVersion());
        this.authorProperty.set((Object)this.manifest.getAuthor());
        Profile profile = controller.getSettings().get(ModpackPage.PROFILE);
        String name = controller.getSettings().get(MODPACK_NAME);
        if (name != null) {
            this.txtModpackName.setText(name);
            this.txtModpackName.setDisable(true);
        } else {
            this.txtModpackName.setText(this.manifest.getName().trim());
            this.txtModpackName.getValidators().addAll((Object[])new ValidatorBase[]{new RequiredValidator(), new Validator(I18n.i18n("install.new_game.already_exists"), str -> !profile.getRepository().versionIdConflicts((String)str)), new Validator(I18n.i18n("install.new_game.malformed"), HMCLGameRepository::isValidVersionId)});
        }
        this.btnDescription.setVisible(StringUtils.isNotBlank(this.manifest.getDescription()));
    }

    @Override
    public void cleanup(SettingsMap settings) {
        settings.remove(MODPACK_SERVER_MANIFEST);
    }

    @Override
    protected void onInstall() {
        if (!this.txtModpackName.validate()) {
            return;
        }
        this.controller.getSettings().put(MODPACK_NAME, this.txtModpackName.getText());
        this.controller.onFinish();
    }

    @Override
    protected void onDescribe() {
        Controllers.navigate((Node)new WebPage(I18n.i18n("modpack.description"), this.manifest.getDescription()));
    }
}

