/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.main;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXListView;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ListCell;
import javafx.scene.control.Skin;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.jackhuang.hmcl.java.JavaInfo;
import org.jackhuang.hmcl.java.JavaManager;
import org.jackhuang.hmcl.java.JavaRuntime;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.setting.DownloadProviders;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.ListPageBase;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.ToolbarListPageSkin;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.construct.RipplerContainer;
import org.jackhuang.hmcl.ui.construct.TwoLineListItem;
import org.jackhuang.hmcl.ui.main.JavaDownloadDialog;
import org.jackhuang.hmcl.ui.main.JavaInstallPage;
import org.jackhuang.hmcl.ui.main.JavaRestorePage;
import org.jackhuang.hmcl.ui.wizard.SinglePageWizardProvider;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.TaskCancellationAction;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.platform.Architecture;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jackhuang.hmcl.util.platform.Platform;
import org.jackhuang.hmcl.util.platform.UnsupportedPlatformException;
import org.jackhuang.hmcl.util.tree.ArchiveFileTree;

public final class JavaManagementPage
extends ListPageBase<JavaRuntime> {
    private final ChangeListener<Collection<JavaRuntime>> listener = FXUtils.onWeakChangeAndOperate(JavaManager.getAllJavaProperty(), this::loadJava);
    private final Runnable onInstallJava = Platform.SYSTEM_PLATFORM.equals(OperatingSystem.LINUX, Architecture.LOONGARCH64_OW) ? () -> FXUtils.openLink("https://www.loongnix.cn/zh/api/java/") : JavaDownloadDialog.showDialogAction(DownloadProviders.getDownloadProvider());

    public JavaManagementPage() {
        FXUtils.applyDragListener((Node)this, it -> {
            String name = FileUtils.getName(it);
            return Files.isDirectory(it, new LinkOption[0]) || name.endsWith(".zip") || name.endsWith(".tar.gz") || name.equals(OperatingSystem.CURRENT_OS.getJavaExecutable());
        }, files -> {
            for (Path file : files) {
                if (Files.isDirectory(file, new LinkOption[0])) {
                    this.onAddJavaHome(file);
                    continue;
                }
                String fileName = FileUtils.getName(file);
                if (fileName.equals(OperatingSystem.CURRENT_OS.getJavaExecutable())) {
                    this.onAddJavaBinary(file);
                    continue;
                }
                if (fileName.endsWith(".zip") || fileName.endsWith(".tar.gz")) {
                    this.onInstallArchive(file);
                    continue;
                }
                throw new AssertionError((Object)"Unreachable code");
            }
        });
    }

    protected Skin<?> createDefaultSkin() {
        return new JavaPageSkin(this);
    }

    void onAddJava() {
        FileChooser chooser = new FileChooser();
        if (OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS) {
            chooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Java", new String[]{"java.exe"}));
        }
        chooser.setTitle(I18n.i18n("settings.game.java_directory.choose"));
        Path file = FileUtils.toPath(chooser.showOpenDialog((Window)Controllers.getStage()));
        if (file != null) {
            JavaManager.getAddJavaTask(file).whenComplete(Schedulers.javafx(), exception -> {
                if (exception != null) {
                    Logger.LOG.warning("Failed to add java", exception);
                    Controllers.dialog(I18n.i18n("java.add.failed"), I18n.i18n("message.error"), MessageDialogPane.MessageType.ERROR);
                }
            }).start();
        }
    }

    void onShowRestoreJavaPage() {
        Controllers.navigateForward((Node)new JavaRestorePage(ConfigHolder.globalConfig().getDisabledJava()));
    }

    private void onAddJavaBinary(Path file) {
        JavaManager.getAddJavaTask(file).whenComplete(Schedulers.javafx(), exception -> {
            if (exception != null) {
                Logger.LOG.warning("Failed to add java", exception);
                Controllers.dialog(I18n.i18n("java.add.failed"), I18n.i18n("message.error"), MessageDialogPane.MessageType.ERROR);
            }
        }).start();
    }

    private void onAddJavaHome(Path file) {
        Task.composeAsync(() -> {
            Path releaseFile = file.resolve("release");
            if (Files.notExists(releaseFile, new LinkOption[0])) {
                throw new IOException("Missing release file " + String.valueOf(releaseFile));
            }
            return JavaManager.getAddJavaTask(file.resolve("bin").resolve(OperatingSystem.CURRENT_OS.getJavaExecutable()));
        }).whenComplete(Schedulers.javafx(), exception -> {
            if (exception != null) {
                Logger.LOG.warning("Failed to add java", exception);
                Controllers.dialog(I18n.i18n("java.add.failed"), I18n.i18n("message.error"), MessageDialogPane.MessageType.ERROR);
            }
        }).start();
    }

    private void onInstallArchive(Path file) {
        Task.supplyAsync(() -> {
            try (ArchiveFileTree<?, ?> tree = ArchiveFileTree.open(file);){
                JavaInfo info = JavaInfo.fromArchive(tree);
                if (!JavaManager.isCompatible(info.getPlatform())) {
                    throw new UnsupportedPlatformException(info.getPlatform().toString());
                }
                Pair<String, JavaInfo> pair = Pair.pair(tree.getRoot().getSubDirs().keySet().iterator().next(), info);
                return pair;
            }
        }).whenComplete(Schedulers.javafx(), (result, exception) -> {
            if (exception == null) {
                Controllers.getDecorator().startWizard(new SinglePageWizardProvider(controller -> new JavaInstallPage(controller::onFinish, (JavaInfo)result.getValue(), null, null, (String)result.getKey(), file)));
            } else if (exception instanceof UnsupportedPlatformException) {
                Controllers.dialog(I18n.i18n("java.install.failed.unsupported_platform"), null, MessageDialogPane.MessageType.WARNING);
            } else {
                Controllers.dialog(I18n.i18n("java.install.failed.invalid"), null, MessageDialogPane.MessageType.WARNING);
            }
        }).start();
    }

    private void loadJava(Collection<JavaRuntime> javaRuntimes) {
        if (javaRuntimes != null) {
            this.setItems(FXCollections.observableArrayList(javaRuntimes));
            this.setLoading(false);
        } else {
            this.setLoading(true);
        }
    }

    private static final class JavaPageSkin
    extends ToolbarListPageSkin<JavaRuntime, JavaManagementPage> {
        JavaPageSkin(JavaManagementPage skinnable) {
            super(skinnable);
        }

        @Override
        protected List<Node> initializeToolbar(JavaManagementPage skinnable) {
            ArrayList<Node> res = new ArrayList<Node>(4);
            res.add((Node)JavaPageSkin.createToolbarButton2(I18n.i18n("button.refresh"), SVG.REFRESH, JavaManager::refresh));
            if (skinnable.onInstallJava != null) {
                res.add((Node)JavaPageSkin.createToolbarButton2(I18n.i18n("java.download"), SVG.DOWNLOAD, skinnable.onInstallJava));
            }
            res.add((Node)JavaPageSkin.createToolbarButton2(I18n.i18n("java.add"), SVG.ADD, skinnable::onAddJava));
            JFXButton disableJava = JavaPageSkin.createToolbarButton2(I18n.i18n("java.disabled.management"), SVG.FORMAT_LIST_BULLETED, skinnable::onShowRestoreJavaPage);
            disableJava.disableProperty().bind((ObservableValue)Bindings.isEmpty(ConfigHolder.globalConfig().getDisabledJava()));
            res.add((Node)disableJava);
            return res;
        }

        @Override
        protected ListCell<JavaRuntime> createListCell(JFXListView<JavaRuntime> listView) {
            return new JavaItemCell(listView);
        }
    }

    private static final class JavaItemCell
    extends ListCell<JavaRuntime> {
        private final Node graphic;
        private final TwoLineListItem content;
        private SVG removeIcon;
        private final StackPane removeIconPane;
        private final Tooltip removeTooltip = new Tooltip();

        JavaItemCell(JFXListView<JavaRuntime> listView) {
            BorderPane root = new BorderPane();
            HBox center = new HBox();
            center.setMouseTransparent(true);
            center.setSpacing(8.0);
            center.setAlignment(Pos.CENTER_LEFT);
            this.content = new TwoLineListItem();
            HBox.setHgrow((Node)this.content, (Priority)Priority.ALWAYS);
            BorderPane.setAlignment((Node)this.content, (Pos)Pos.CENTER);
            center.getChildren().setAll((Object[])new Node[]{this.content});
            root.setCenter((Node)center);
            HBox right = new HBox();
            right.setAlignment(Pos.CENTER_RIGHT);
            JFXButton revealButton = new JFXButton();
            revealButton.setGraphic(SVG.FOLDER_OPEN.createIcon());
            revealButton.getStyleClass().add((Object)"toggle-icon4");
            revealButton.setOnAction(e -> {
                JavaRuntime java = (JavaRuntime)this.getItem();
                if (java != null) {
                    this.onReveal(java);
                }
            });
            FXUtils.installFastTooltip((Node)revealButton, I18n.i18n("reveal.in_file_manager"));
            JFXButton removeButton = new JFXButton();
            removeButton.getStyleClass().add((Object)"toggle-icon4");
            removeButton.setOnAction(e -> {
                JavaRuntime java = (JavaRuntime)this.getItem();
                if (java != null) {
                    this.onRemove(java);
                }
            });
            FXUtils.installFastTooltip((Node)removeButton, this.removeTooltip);
            this.removeIconPane = new StackPane();
            this.removeIconPane.setAlignment(Pos.CENTER);
            FXUtils.setLimitWidth((Region)this.removeIconPane, 24.0);
            FXUtils.setLimitHeight((Region)this.removeIconPane, 24.0);
            removeButton.setGraphic((Node)this.removeIconPane);
            right.getChildren().setAll((Object[])new Node[]{revealButton, removeButton});
            root.setRight((Node)right);
            root.getStyleClass().add((Object)"md-list-cell");
            root.setPadding(new Insets(8.0));
            this.graphic = new RipplerContainer((Node)root);
            FXUtils.limitCellWidth(listView, this);
        }

        protected void updateItem(JavaRuntime item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty || item == null) {
                this.setGraphic(null);
            } else {
                SVG newRemoveIcon;
                this.content.setTitle((item.isJDK() ? "JDK" : "JRE") + " " + item.getVersion());
                this.content.setSubtitle(item.getBinary().toString());
                this.content.getTags().clear();
                this.content.addTag(I18n.i18n("java.info.architecture") + ": " + item.getArchitecture().getDisplayName());
                String vendor = JavaInfo.normalizeVendor(item.getVendor());
                if (vendor != null) {
                    this.content.addTag(I18n.i18n("java.info.vendor") + ": " + vendor);
                }
                SVG sVG = newRemoveIcon = item.isManaged() ? SVG.DELETE_FOREVER : SVG.DELETE;
                if (this.removeIcon != newRemoveIcon) {
                    this.removeIcon = newRemoveIcon;
                    this.removeIconPane.getChildren().setAll((Object[])new Node[]{this.removeIcon.createIcon(24.0)});
                    this.removeTooltip.setText(item.isManaged() ? I18n.i18n("java.uninstall") : I18n.i18n("java.disable"));
                }
                this.setGraphic(this.graphic);
            }
        }

        private void onReveal(JavaRuntime java) {
            Path parent = java.getBinary().getParent();
            Path target = parent != null && parent.getParent() != null && parent.getFileName() != null && parent.getFileName().toString().equals("bin") && Files.exists(parent.getParent().resolve("release"), new LinkOption[0]) ? parent.getParent() : java.getBinary();
            FXUtils.showFileInExplorer(target);
        }

        private void onRemove(JavaRuntime java) {
            if (java.isManaged()) {
                Controllers.confirm(I18n.i18n("java.uninstall.confirm"), I18n.i18n("message.warning"), () -> Controllers.taskDialog(JavaManager.getUninstallJavaTask(java), I18n.i18n("java.uninstall"), TaskCancellationAction.NORMAL), null);
            } else {
                Controllers.confirm(I18n.i18n("java.disable.confirm"), I18n.i18n("message.warning"), () -> {
                    String path = java.getBinary().toString();
                    ConfigHolder.globalConfig().getUserJava().remove((Object)path);
                    ConfigHolder.globalConfig().getDisabledJava().add((Object)path);
                    try {
                        JavaManager.removeJava(java);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }, null);
            }
        }
    }
}

