/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.i18n;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.TextDirection;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.platform.NativeUtils;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jackhuang.hmcl.util.platform.windows.Kernel32;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class LocaleUtils {
    public static final Locale SYSTEM_DEFAULT = Locale.getDefault();
    public static final boolean IS_CHINA_MAINLAND = LocaleUtils.isChinaMainland();
    public static final Locale LOCALE_ZH_HANS = Locale.forLanguageTag("zh-Hans");
    public static final Locale LOCALE_ZH_HANT = Locale.forLanguageTag("zh-Hant");
    public static final String DEFAULT_LANGUAGE_KEY = "default";
    private static final Map<String, String> PARENT_LANGUAGE = LocaleUtils.loadCSV("sublanguages.csv");
    private static final Map<String, String> NORMALIZED_TAG = LocaleUtils.loadCSV("language_aliases.csv");
    private static final Map<String, String> DEFAULT_SCRIPT = LocaleUtils.loadCSV("default_script.csv");
    private static final Map<String, String> PREFERRED_LANGUAGE = Map.of("zh", "cmn");
    private static final Set<String> RTL_SCRIPTS = Set.of("Qabs", "Arab", "Hebr");
    private static final Set<String> CHINESE_TRADITIONAL_REGIONS = Set.of("TW", "HK", "MO");
    private static final ConcurrentMap<Locale, List<Locale>> CANDIDATE_LOCALES = new ConcurrentHashMap<Locale, List<Locale>>();

    private static boolean isChinaMainland() {
        if ("Asia/Shanghai".equals(ZoneId.systemDefault().getId())) {
            return true;
        }
        if ((long)ZonedDateTime.now().getOffset().getTotalSeconds() == Duration.ofHours(8L).toSeconds()) {
            Kernel32 kernel32;
            if ("CN".equals(SYSTEM_DEFAULT.getCountry())) {
                return true;
            }
            if (OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS && NativeUtils.USE_JNA && (kernel32 = Kernel32.INSTANCE) != null && kernel32.GetUserGeoID(16) == 45) {
                return true;
            }
        }
        return false;
    }

    private static Map<String, String> loadCSV(String fileName) {
        InputStream resource = LocaleUtils.class.getResourceAsStream("/assets/lang/" + fileName);
        if (resource == null) {
            Logger.LOG.warning("Can't find file: " + fileName);
            return Map.of();
        }
        HashMap result = new HashMap();
        try (InputStream inputStream = resource;){
            new String(resource.readAllBytes(), StandardCharsets.UTF_8).lines().forEach(line -> {
                if (line.startsWith("#") || line.isBlank()) {
                    return;
                }
                String[] items = line.split(",");
                if (items.length < 2) {
                    Logger.LOG.warning("Invalid line in " + fileName + ": " + line);
                    return;
                }
                String parent = items[0];
                for (int i = 1; i < items.length; ++i) {
                    result.put(items[i], parent);
                }
            });
        }
        catch (Throwable e) {
            Logger.LOG.warning("Failed to load " + fileName, e);
        }
        return Map.copyOf(result);
    }

    private static Locale getInstance(String language, String script, String region, String variant) {
        Locale.Builder builder = new Locale.Builder();
        if (!language.isEmpty()) {
            builder.setLanguage(language);
        }
        if (!script.isEmpty()) {
            builder.setScript(script);
        }
        if (!region.isEmpty()) {
            builder.setRegion(region);
        }
        if (!variant.isEmpty()) {
            builder.setVariant(variant);
        }
        return builder.build();
    }

    public static String toLanguageKey(Locale locale) {
        return locale.getLanguage().isEmpty() ? DEFAULT_LANGUAGE_KEY : locale.stripExtensions().toLanguageTag();
    }

    public static boolean isEnglish(Locale locale) {
        return "en".equals(LocaleUtils.getRootLanguage(locale));
    }

    public static boolean isChinese(Locale locale) {
        return "zh".equals(LocaleUtils.getRootLanguage(locale));
    }

    @NotNull
    public static String normalizeLanguage(String language) {
        return language.isEmpty() ? "en" : NORMALIZED_TAG.getOrDefault(language, language);
    }

    @Nullable
    public static String getParentLanguage(String language) {
        return PARENT_LANGUAGE.get(language);
    }

    @NotNull
    public static String getRootLanguage(Locale locale) {
        return LocaleUtils.getRootLanguage(locale.getLanguage());
    }

    @NotNull
    public static String getRootLanguage(String language) {
        String parent = LocaleUtils.getParentLanguage(language = LocaleUtils.normalizeLanguage(language));
        return parent != null ? parent : language;
    }

    @NotNull
    public static String getPreferredLanguage(String language) {
        language = LocaleUtils.normalizeLanguage(language);
        return PREFERRED_LANGUAGE.getOrDefault(language, language);
    }

    @NotNull
    public static String getScript(Locale locale) {
        if (locale.getScript().isEmpty()) {
            String script;
            if (!locale.getVariant().isEmpty() && (script = DEFAULT_SCRIPT.get(locale.getVariant())) != null) {
                return script;
            }
            if ("UD".equals(locale.getCountry())) {
                return "Qabs";
            }
            script = DEFAULT_SCRIPT.get(LocaleUtils.normalizeLanguage(locale.getLanguage()));
            if (script != null) {
                return script;
            }
            if (LocaleUtils.isChinese(locale)) {
                return CHINESE_TRADITIONAL_REGIONS.contains(locale.getCountry()) ? "Hant" : "Hans";
            }
            return "";
        }
        return locale.getScript();
    }

    @NotNull
    public static TextDirection getTextDirection(Locale locale) {
        return RTL_SCRIPTS.contains(LocaleUtils.getScript(locale)) ? TextDirection.RIGHT_TO_LEFT : TextDirection.LEFT_TO_RIGHT;
    }

    @NotNull
    public static List<Locale> getCandidateLocales(Locale locale) {
        return CANDIDATE_LOCALES.computeIfAbsent(locale, LocaleUtils::createCandidateLocaleList);
    }

    private static List<Locale> createCandidateLocaleList(Locale locale) {
        String language = LocaleUtils.getPreferredLanguage(locale.getLanguage());
        String script = LocaleUtils.getScript(locale);
        String region = locale.getCountry();
        List<String> variants = locale.getVariant().isEmpty() ? List.of() : List.of(locale.getVariant().split("[_\\-]"));
        ArrayList<Locale> result = new ArrayList<Locale>();
        do {
            LocaleUtils.addCandidateLocales(result, language, script, region, variants);
        } while ((language = LocaleUtils.getParentLanguage(language)) != null);
        result.add(Locale.ROOT);
        return List.copyOf(result);
    }

    private static void addCandidateLocales(ArrayList<Locale> list, String language, String script, String region, List<String> variants) {
        if (!variants.isEmpty()) {
            for (String v : variants) {
                list.add(LocaleUtils.getInstance(language, script, region, v));
            }
        }
        if (!region.isEmpty()) {
            list.add(LocaleUtils.getInstance(language, script, region, ""));
        }
        if (!script.isEmpty()) {
            list.add(LocaleUtils.getInstance(language, script, "", ""));
            if (!variants.isEmpty()) {
                for (String v : variants) {
                    list.add(LocaleUtils.getInstance(language, "", region, v));
                }
            }
            if (!region.isEmpty()) {
                list.add(LocaleUtils.getInstance(language, "", region, ""));
            }
        }
        list.add(LocaleUtils.getInstance(language, "", "", ""));
        if (language.equals("zh")) {
            int chineseIdx;
            int chineseIdx2;
            if (list.contains(LOCALE_ZH_HANT) && !list.contains(Locale.TRADITIONAL_CHINESE) && (chineseIdx2 = list.indexOf(Locale.CHINESE)) >= 0) {
                list.add(chineseIdx2, Locale.TRADITIONAL_CHINESE);
            }
            if (!list.contains(Locale.SIMPLIFIED_CHINESE) && (chineseIdx = list.indexOf(Locale.CHINESE)) >= 0) {
                if (list.contains(LOCALE_ZH_HANS)) {
                    list.add(chineseIdx, Locale.SIMPLIFIED_CHINESE);
                } else {
                    list.add(chineseIdx + 1, Locale.SIMPLIFIED_CHINESE);
                }
            }
        }
    }

    @Nullable
    public static <T> T getByCandidateLocales(Map<String, T> map, List<Locale> candidateLocales) {
        for (Locale locale : candidateLocales) {
            String key = LocaleUtils.toLanguageKey(locale);
            if (!map.containsKey(key)) continue;
            return map.get(key);
        }
        return null;
    }

    @NotNull
    public static @Unmodifiable Map<String, Path> findAllLocalizedFiles(Path dir, String baseName, String ext) {
        if (Files.isDirectory(dir, new LinkOption[0])) {
            LinkedHashMap<String, Path> linkedHashMap;
            block9: {
                String suffix = "." + ext;
                String defaultName = baseName + suffix;
                String noDefaultPrefix = baseName + "_";
                Stream<Path> list = Files.list(dir);
                try {
                    LinkedHashMap<String, Path> result = new LinkedHashMap<String, Path>();
                    list.forEach(file -> {
                        if (Files.isRegularFile(file, new LinkOption[0])) {
                            String languageKey;
                            String fileName = file.getFileName().toString();
                            if (fileName.equals(defaultName)) {
                                result.put(DEFAULT_LANGUAGE_KEY, (Path)file);
                            } else if (fileName.startsWith(noDefaultPrefix) && fileName.endsWith(suffix) && !(languageKey = fileName.substring(noDefaultPrefix.length(), fileName.length() - suffix.length()).replace('_', '-')).isEmpty()) {
                                result.put(languageKey, (Path)file);
                            }
                        }
                    });
                    linkedHashMap = result;
                    if (list == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (list != null) {
                            try {
                                list.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        Logger.LOG.warning("Failed to list files in directory " + String.valueOf(dir), e);
                    }
                }
                list.close();
            }
            return linkedHashMap;
        }
        return Map.of();
    }

    @NotNull
    public static @Unmodifiable Map<String, Map<String, Path>> findAllLocalizedFiles(Path dir, String baseName, Collection<String> exts) {
        if (Files.isDirectory(dir, new LinkOption[0])) {
            LinkedHashMap<String, Map<String, Path>> linkedHashMap;
            block9: {
                Stream<Path> list = Files.list(dir);
                try {
                    LinkedHashMap<String, Map<String, Path>> result = new LinkedHashMap<String, Map<String, Path>>();
                    list.forEach(file -> {
                        if (Files.isRegularFile(file, new LinkOption[0])) {
                            String languageKey;
                            String fileName = file.getFileName().toString();
                            if (!fileName.startsWith(baseName)) {
                                return;
                            }
                            String ext = StringUtils.substringAfterLast(fileName, '.');
                            if (!exts.contains(ext)) {
                                return;
                            }
                            int defaultFileNameLength = baseName.length() + ext.length() + 1;
                            if (fileName.length() == defaultFileNameLength) {
                                languageKey = DEFAULT_LANGUAGE_KEY;
                            } else if (fileName.length() > defaultFileNameLength + 1 && fileName.charAt(baseName.length()) == '_') {
                                languageKey = fileName.substring(baseName.length() + 1, fileName.length() - ext.length() - 1).replace('_', '-');
                            } else {
                                return;
                            }
                            result.computeIfAbsent(languageKey, key -> new HashMap()).put(ext, file);
                        }
                    });
                    linkedHashMap = result;
                    if (list == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (list != null) {
                            try {
                                list.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        Logger.LOG.warning("Failed to list files in directory " + String.valueOf(dir), e);
                    }
                }
                list.close();
            }
            return linkedHashMap;
        }
        return Map.of();
    }

    private LocaleUtils() {
    }
}

