/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.controls.JFXButton;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;

public class JFXSnackbarLayout
extends BorderPane {
    private final Label toast;
    private JFXButton action;
    private final StackPane actionContainer;
    private static final String DEFAULT_STYLE_CLASS = "jfx-snackbar-layout";

    public JFXSnackbarLayout(String message) {
        this(message, null, null);
    }

    public JFXSnackbarLayout(String message, String actionText, EventHandler<ActionEvent> actionHandler) {
        this.initialize();
        this.toast = new Label();
        this.toast.setMinWidth(Double.NEGATIVE_INFINITY);
        this.toast.getStyleClass().add((Object)"jfx-snackbar-toast");
        this.toast.setWrapText(true);
        this.toast.setText(message);
        StackPane toastContainer = new StackPane(new Node[]{this.toast});
        toastContainer.setPadding(new Insets(20.0));
        this.actionContainer = new StackPane();
        this.actionContainer.setPadding(new Insets(0.0, 10.0, 0.0, 0.0));
        this.toast.prefWidthProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> {
            if (this.getPrefWidth() == -1.0) {
                return this.getPrefWidth();
            }
            double actionWidth = this.actionContainer.isVisible() ? this.actionContainer.getWidth() : 0.0;
            return this.prefWidthProperty().get() - actionWidth;
        }, (Observable[])new Observable[]{this.prefWidthProperty(), this.actionContainer.widthProperty(), this.actionContainer.visibleProperty()}));
        this.setLeft((Node)toastContainer);
        this.setRight((Node)this.actionContainer);
        if (actionText != null) {
            this.action = new JFXButton();
            this.action.setText(actionText);
            this.action.setOnAction(actionHandler);
            this.action.setMinWidth(Double.NEGATIVE_INFINITY);
            this.action.setButtonType(JFXButton.ButtonType.FLAT);
            this.action.getStyleClass().add((Object)"jfx-snackbar-action");
            this.actionContainer.getChildren().add((Object)this.action);
            if (!actionText.isEmpty()) {
                this.action.setVisible(true);
                this.actionContainer.setVisible(true);
                this.actionContainer.setManaged(true);
                this.action.setText("");
                this.action.setText(actionText);
                this.action.setOnAction(actionHandler);
            } else {
                this.actionContainer.setVisible(false);
                this.actionContainer.setManaged(false);
                this.action.setVisible(false);
            }
        }
    }

    public String getToast() {
        return this.toast.getText();
    }

    public void setToast(String toast) {
        this.toast.setText(toast);
    }

    private void initialize() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
    }
}

