/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.adapters.skins.JFXTreeTableViewSkin;
import com.jfoenix.concurrency.JFXUtilities;
import com.jfoenix.controls.JFXTreeTableRow;
import com.jfoenix.controls.RecursiveTreeItem;
import com.jfoenix.controls.datamodels.treetable.RecursiveTreeObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Semaphore;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.Skin;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.scene.input.MouseEvent;

public class JFXTreeTableView<S extends RecursiveTreeObject<S>>
extends TreeTableView<S> {
    private TreeItem<S> originalRoot;
    private boolean itemWasSelected = false;
    private ObservableList<TreeTableColumn<S, ?>> groupOrder = FXCollections.observableArrayList();
    private Semaphore groupingSemaphore = new Semaphore(1);
    private Timer t;
    private ObjectProperty<Predicate<TreeItem<S>>> predicate = new SimpleObjectProperty(t -> true);
    private IntegerProperty currentItemsCount = new SimpleIntegerProperty(0);
    private Map<Object, Map<Object, ?>> groups;

    public JFXTreeTableView() {
        this.init();
    }

    public JFXTreeTableView(TreeItem<S> root) {
        super(root);
        this.originalRoot = root;
        this.init();
    }

    public void propagateMouseEventsToParent() {
        this.addEventHandler(MouseEvent.ANY, e -> {
            e.consume();
            this.getParent().fireEvent(e);
        });
    }

    protected Skin<?> createDefaultSkin() {
        return new JFXTreeTableViewSkin(this);
    }

    protected void init() {
        this.setRowFactory(param -> new JFXTreeTableRow());
        this.getSelectionModel().selectedItemProperty().addListener((o, oldVal, newVal) -> {
            if (newVal != null && newVal.getValue() != null) {
                this.itemWasSelected = true;
            }
        });
        this.predicate.addListener((o, oldVal, newVal) -> this.filter((Predicate<TreeItem<S>>)newVal));
        this.rootProperty().addListener((o, oldVal, newVal) -> {
            if (newVal != null) {
                this.setCurrentItemsCount(this.count(this.getRoot()));
            }
        });
        this.setCurrentItemsCount(this.count(this.getRoot()));
    }

    public int getTreeItemLevel(TreeItem<?> node) {
        TreeItem root = this.getRoot();
        if (node == null) {
            return -1;
        }
        if (node == root) {
            return 0;
        }
        int level = 0;
        for (TreeItem parent = node.getParent(); parent != null; parent = parent.getParent()) {
            ++level;
            if (parent == root) break;
            if (parent.getValue() == null || !(parent.getValue() instanceof RecursiveTreeObject) || ((RecursiveTreeObject)parent.getValue()).getGroupedColumn() == null) continue;
            --level;
        }
        return level;
    }

    public void sort() {
        this.getSelectionModel().clearSelection();
        super.sort();
        if (this.itemWasSelected) {
            this.getSelectionModel().select(0);
        }
    }

    final ObservableList<TreeTableColumn<S, ?>> getGroupOrder() {
        return this.groupOrder;
    }

    public void group(TreeTableColumn<S, ?> ... treeTableColumns) {
        if (this.groupingSemaphore.tryAcquire()) {
            if (this.groupOrder.size() == 0) {
                this.groups = new HashMap();
            }
            try {
                if (this.originalRoot == null) {
                    this.originalRoot = this.getRoot();
                }
                for (TreeTableColumn<S, ?> treeTableColumn : treeTableColumns) {
                    this.groups = this.group(treeTableColumn, this.groups, null, (RecursiveTreeItem)this.originalRoot);
                }
                this.groupOrder.addAll((Object[])treeTableColumns);
                this.buildGroupedRoot(this.groups, null, 0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.groupingSemaphore.release();
        }
    }

    private void refreshGroups(List<TreeTableColumn<S, ?>> groupColumns) {
        this.groups = new HashMap();
        for (TreeTableColumn<S, ?> treeTableColumn : groupColumns) {
            this.groups = this.group(treeTableColumn, this.groups, null, (RecursiveTreeItem)this.originalRoot);
        }
        this.groupOrder.addAll(groupColumns);
        this.buildGroupedRoot(this.groups, null, 0);
    }

    public void unGroup(TreeTableColumn<S, ?> ... treeTableColumns) {
        if (this.groupingSemaphore.tryAcquire()) {
            try {
                if (this.groupOrder.size() > 0) {
                    this.groupOrder.removeAll((Object[])treeTableColumns);
                    ArrayList grouped = new ArrayList();
                    grouped.addAll((Collection<TreeTableColumn<S, ?>>)this.groupOrder);
                    this.groupOrder.clear();
                    JFXUtilities.runInFXAndWait(() -> {
                        ArrayList sortOrder = new ArrayList();
                        sortOrder.addAll(this.getSortOrder());
                        List<Object> children = Arrays.asList(this.originalRoot.getChildren().toArray());
                        this.originalRoot.getChildren().clear();
                        this.originalRoot.getChildren().setAll(children);
                        this.setRoot(this.originalRoot);
                        this.getSelectionModel().select(0);
                        this.getSortOrder().addAll(sortOrder);
                        if (grouped.size() != 0) {
                            this.refreshGroups(grouped);
                        }
                    });
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.groupingSemaphore.release();
        }
    }

    private Map group(TreeTableColumn<S, ?> column, Map parentGroup, Object key, RecursiveTreeItem<S> root) {
        if (parentGroup.isEmpty()) {
            parentGroup = this.groupByFunction((List<TreeItem<S>>)root.filteredItems, column);
            return parentGroup;
        }
        Object value = parentGroup.get(key);
        if (value instanceof List) {
            Map newGroup = this.groupByFunction((List)value, column);
            parentGroup.put(key, newGroup);
            return parentGroup;
        }
        if (value instanceof Map) {
            for (Object childKey : ((Map)value).keySet()) {
                value = this.group(column, (Map)value, childKey, root);
            }
            parentGroup.put(key, value);
            return parentGroup;
        }
        if (key == null) {
            for (Object childKey : parentGroup.keySet()) {
                parentGroup = this.group(column, parentGroup, childKey, root);
            }
            return parentGroup;
        }
        return parentGroup;
    }

    protected Map groupByFunction(List<TreeItem<S>> items, TreeTableColumn<S, ?> column) {
        HashMap<Object, List> map = new HashMap<Object, List>();
        for (TreeItem<S> child : items) {
            Object key = column.getCellData(child);
            map.computeIfAbsent(key, k -> new ArrayList());
            ((List)map.get(key)).add(child);
        }
        return map;
    }

    private void buildGroupedRoot(Map groupedItems, RecursiveTreeItem parent, int groupIndex) {
        boolean setRoot = false;
        if (parent == null) {
            parent = new RecursiveTreeItem(new RecursiveTreeObject(), RecursiveTreeObject::getChildren);
            setRoot = true;
        }
        for (Object key : groupedItems.keySet()) {
            RecursiveTreeObject groupItem = new RecursiveTreeObject();
            groupItem.setGroupedValue(key);
            groupItem.setGroupedColumn((TreeTableColumn)this.groupOrder.get(groupIndex));
            RecursiveTreeItem node = new RecursiveTreeItem(groupItem, RecursiveTreeObject::getChildren);
            node.expandedProperty().addListener((o, oldVal, newVal) -> this.getSelectionModel().clearSelection());
            parent.originalItems.add(node);
            parent.getChildren().add(node);
            Object children = groupedItems.get(key);
            if (children instanceof List) {
                node.originalItems.addAll((Collection)((List)children));
                node.getChildren().addAll((Collection)((List)children));
                continue;
            }
            if (!(children instanceof Map)) continue;
            this.buildGroupedRoot((Map)children, node, groupIndex + 1);
        }
        if (setRoot) {
            RecursiveTreeItem newParent = parent;
            JFXUtilities.runInFX(() -> {
                ArrayList sortOrder = new ArrayList();
                sortOrder.addAll(this.getSortOrder());
                this.setRoot(newParent);
                this.getSortOrder().addAll(sortOrder);
                this.getSelectionModel().select(0);
            });
        }
    }

    private void filter(final Predicate<TreeItem<S>> predicate) {
        if (this.originalRoot == null) {
            this.originalRoot = this.getRoot();
        }
        if (this.t != null) {
            this.t.cancel();
            this.t.purge();
        }
        this.t = new Timer();
        this.t.schedule(new TimerTask(){

            @Override
            public void run() {
                new Thread(() -> {
                    ((RecursiveTreeItem)JFXTreeTableView.this.originalRoot).setPredicate(predicate);
                    JFXTreeTableView.this.reGroup();
                    Platform.runLater(() -> {
                        JFXTreeTableView.this.getSelectionModel().select(0);
                        JFXTreeTableView.this.setCurrentItemsCount(JFXTreeTableView.this.count(JFXTreeTableView.this.getRoot()));
                    });
                }).start();
            }
        }, 500L);
    }

    public void reGroup() {
        if (!this.groupOrder.isEmpty()) {
            ArrayList tempGroups = new ArrayList(this.groupOrder);
            this.groupOrder.clear();
            this.group(tempGroups.toArray(new TreeTableColumn[tempGroups.size()]));
        }
    }

    public final ObjectProperty<Predicate<TreeItem<S>>> predicateProperty() {
        return this.predicate;
    }

    public final Predicate<TreeItem<S>> getPredicate() {
        return (Predicate)this.predicateProperty().get();
    }

    public final void setPredicate(Predicate<TreeItem<S>> predicate) {
        this.predicateProperty().set(predicate);
    }

    public final IntegerProperty currentItemsCountProperty() {
        return this.currentItemsCount;
    }

    public final int getCurrentItemsCount() {
        return this.currentItemsCountProperty().get();
    }

    public final void setCurrentItemsCount(int currentItemsCount) {
        this.currentItemsCountProperty().set(currentItemsCount);
    }

    private int count(TreeItem<?> node) {
        if (node == null) {
            return 0;
        }
        int count = 1;
        if (node.getValue() == null || node.getValue() != null && node.getValue().getClass().equals(RecursiveTreeObject.class)) {
            count = 0;
        }
        for (TreeItem child : node.getChildren()) {
            count += this.count(child);
        }
        return count;
    }
}

