/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.game;

import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jackhuang.hmcl.game.ModpackHelper;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.io.CompressingUtils;
import org.jackhuang.hmcl.util.io.Unzipper;

public class ManuallyCreatedModpackInstallTask
extends Task<Path> {
    private final Profile profile;
    private final Path zipFile;
    private final Charset charset;
    private final String name;

    public ManuallyCreatedModpackInstallTask(Profile profile, Path zipFile, Charset charset, String name) {
        this.profile = profile;
        this.zipFile = zipFile;
        this.charset = charset;
        this.name = name;
    }

    @Override
    public void execute() throws Exception {
        Path subdirectory;
        try (FileSystem fs = CompressingUtils.readonly(this.zipFile).setEncoding(this.charset).build();){
            subdirectory = ModpackHelper.findMinecraftDirectoryInManuallyCreatedModpack(this.zipFile.toString(), fs);
        }
        Path dest = Paths.get("externalgames", new String[0]).resolve(this.name);
        this.setResult(dest);
        new Unzipper(this.zipFile, dest).setSubDirectory(subdirectory.toString()).setTerminateIfSubDirectoryNotExists().setEncoding(this.charset).unzip();
    }
}

