/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.util.Duration;
import org.jackhuang.hmcl.theme.Themes;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.animation.AnimationUtils;
import org.jackhuang.hmcl.ui.animation.Motion;
import org.jackhuang.hmcl.ui.construct.ComponentSublist;
import org.jackhuang.hmcl.ui.construct.NoPaddingComponent;
import org.jackhuang.hmcl.ui.construct.RipplerContainer;

final class ComponentSublistWrapper
extends VBox
implements NoPaddingComponent {
    private VBox container;
    private Animation expandAnimation;
    private boolean expanded = false;

    ComponentSublistWrapper(ComponentSublist sublist) {
        boolean noPadding = !sublist.hasComponentPadding();
        this.getStyleClass().add((Object)"options-sublist-wrapper");
        Node expandIcon = SVG.KEYBOARD_ARROW_DOWN.createIcon(20.0);
        expandIcon.getStyleClass().add((Object)"expand-icon");
        expandIcon.setMouseTransparent(true);
        VBox labelVBox = new VBox();
        labelVBox.setMouseTransparent(true);
        labelVBox.setAlignment(Pos.CENTER_LEFT);
        Node leftNode = sublist.getHeaderLeft();
        if (leftNode == null) {
            Label label = new Label();
            label.textProperty().bind((ObservableValue)sublist.titleProperty());
            label.getStyleClass().add((Object)"title-label");
            labelVBox.getChildren().add((Object)label);
            if (sublist.isHasSubtitle()) {
                Label subtitleLabel = new Label();
                subtitleLabel.textProperty().bind((ObservableValue)sublist.subtitleProperty());
                subtitleLabel.getStyleClass().add((Object)"subtitle-label");
                subtitleLabel.textFillProperty().bind(Themes.colorSchemeProperty().getOnSurfaceVariant());
                labelVBox.getChildren().add((Object)subtitleLabel);
            }
        } else {
            labelVBox.getChildren().setAll((Object[])new Node[]{leftNode});
        }
        HBox header = new HBox();
        header.setSpacing(12.0);
        header.getChildren().add((Object)labelVBox);
        header.setPadding(new Insets(10.0, 16.0, 10.0, 16.0));
        header.setAlignment(Pos.CENTER_LEFT);
        HBox.setHgrow((Node)labelVBox, (Priority)Priority.ALWAYS);
        Node rightNode = sublist.getHeaderRight();
        if (rightNode != null) {
            header.getChildren().add((Object)rightNode);
        }
        header.getChildren().add((Object)expandIcon);
        RipplerContainer headerRippler = new RipplerContainer((Node)header);
        this.getChildren().add((Object)headerRippler);
        headerRippler.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            boolean expanded;
            if (event.getButton() != MouseButton.PRIMARY) {
                return;
            }
            event.consume();
            if (this.expandAnimation != null && this.expandAnimation.getStatus() == Animation.Status.RUNNING) {
                this.expandAnimation.stop();
            }
            this.expanded = expanded = !this.expanded;
            if (expanded) {
                sublist.doLazyInit();
                if (this.container == null) {
                    this.container = new VBox();
                    if (!noPadding) {
                        this.container.setPadding(new Insets(8.0, 16.0, 10.0, 16.0));
                    }
                    FXUtils.setLimitHeight((Region)this.container, 0.0);
                    FXUtils.setOverflowHidden((Region)this.container);
                    this.container.getChildren().setAll((Object[])new Node[]{sublist});
                    this.getChildren().add((Object)this.container);
                    this.applyCss();
                }
                this.layout();
            }
            Platform.runLater(() -> {
                double targetRotate;
                double contentHeight = expanded ? sublist.prefHeight(sublist.getWidth()) + (double)(noPadding ? 4 : 18) : 0.0;
                double d = targetRotate = expanded ? -180.0 : 0.0;
                if (AnimationUtils.isAnimationEnabled()) {
                    double currentRotate = expandIcon.getRotate();
                    Duration duration = Motion.LONG2.multiply(Math.abs(currentRotate - targetRotate) / 180.0);
                    Interpolator interpolator = Motion.EASE_IN_OUT_CUBIC_EMPHASIZED;
                    this.expandAnimation = new Timeline(new KeyFrame[]{new KeyFrame(duration, new KeyValue[]{new KeyValue((WritableValue)this.container.minHeightProperty(), (Object)contentHeight, interpolator), new KeyValue((WritableValue)this.container.maxHeightProperty(), (Object)contentHeight, interpolator), new KeyValue((WritableValue)expandIcon.rotateProperty(), (Object)targetRotate, interpolator)})});
                    this.expandAnimation.play();
                } else {
                    this.container.setMinHeight(contentHeight);
                    this.container.setMaxHeight(contentHeight);
                    expandIcon.setRotate(targetRotate);
                }
            });
        });
    }
}

