/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import com.jfoenix.controls.JFXPopup;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.construct.LineButton;
import org.jackhuang.hmcl.ui.construct.PopupMenu;
import org.jackhuang.hmcl.ui.construct.RipplerContainer;
import org.jackhuang.hmcl.util.javafx.MappedObservableList;

public final class LineSelectButton<T>
extends LineButton {
    private static final String DEFAULT_STYLE_CLASS = "line-select-button";
    private static final PseudoClass SELECTED_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"selected");
    private JFXPopup popup;
    private final ObjectProperty<T> value = new SimpleObjectProperty((Object)this, "value");
    private final ObjectProperty<Function<T, String>> converter = new SimpleObjectProperty((Object)this, "converter");
    private ObjectProperty<Function<T, String>> descriptionConverter;
    private final ListProperty<T> items = new SimpleListProperty((Object)this, "items", FXCollections.emptyObservableList());

    public LineSelectButton() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        InvalidationListener updateTrailingText = observable -> {
            T value = this.getValue();
            if (value != null) {
                Function<T, String> converter = this.getConverter();
                this.setTrailingText(converter != null ? converter.apply(value) : value.toString());
            } else {
                this.setTrailingText(null);
            }
        };
        this.converterProperty().addListener(updateTrailingText);
        this.valueProperty().addListener(updateTrailingText);
        this.setTrailingIcon(SVG.UNFOLD_MORE);
        this.ripplerContainer.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            if (event.getButton() == MouseButton.SECONDARY) {
                if (this.popup != null) {
                    this.popup.hide();
                }
                event.consume();
            }
        });
    }

    @Override
    public void fire() {
        super.fire();
        if (this.popup == null) {
            PopupMenu popupMenu = new PopupMenu();
            this.popup = new JFXPopup((Region)popupMenu);
            this.ripplerContainer.addEventFilter(ScrollEvent.ANY, ignored -> this.popup.hide());
            Bindings.bindContent(popupMenu.getContent(), MappedObservableList.create(this.itemsProperty(), item -> {
                VBox vbox = new VBox();
                Label itemTitleLabel = new Label();
                itemTitleLabel.getStyleClass().add((Object)"title-label");
                itemTitleLabel.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
                    if (item == null) {
                        return "";
                    }
                    Function<Object, String> converter = this.getConverter();
                    return converter != null ? converter.apply(item) : Objects.toString(item, "");
                }, (Observable[])new Observable[]{this.converterProperty()}));
                Label itemSubtitleLabel = new Label();
                itemSubtitleLabel.getStyleClass().add((Object)"subtitle-label");
                itemSubtitleLabel.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
                    Function<Object, String> descriptionConverter = this.getDescriptionConverter();
                    return descriptionConverter != null ? descriptionConverter.apply(item) : "";
                }, (Observable[])new Observable[]{this.descriptionConverterProperty()}));
                FXUtils.onChangeAndOperate(itemSubtitleLabel.textProperty(), text -> {
                    if (text == null || text.isEmpty()) {
                        vbox.getChildren().setAll((Object[])new Node[]{itemTitleLabel});
                    } else {
                        vbox.getChildren().setAll((Object[])new Node[]{itemTitleLabel, itemSubtitleLabel});
                    }
                });
                StackPane wrapper = new StackPane(new Node[]{vbox});
                wrapper.setAlignment(Pos.CENTER_LEFT);
                wrapper.getStyleClass().add((Object)"menu-container");
                wrapper.setMouseTransparent(true);
                RipplerContainer ripplerContainer = new RipplerContainer((Node)wrapper);
                FXUtils.onClicked((Node)ripplerContainer, () -> {
                    this.setValue(item);
                    this.popup.hide();
                });
                FXUtils.onChangeAndOperate(this.valueProperty(), value -> wrapper.pseudoClassStateChanged(SELECTED_PSEUDO_CLASS, Objects.equals(value, item)));
                return ripplerContainer;
            }));
            this.popup.showingProperty().addListener((observable, oldValue, newValue) -> this.ripplerContainer.getRippler().setRipplerDisabled((boolean)newValue));
        }
        if (this.popup.isShowing()) {
            this.popup.hide();
        } else {
            JFXPopup.PopupVPosition vPosition;
            this.popup.show((Node)this, vPosition, JFXPopup.PopupHPosition.RIGHT, 0.0, (vPosition = FXUtils.determineOptimalPopupPosition((Node)this, this.popup)) == JFXPopup.PopupVPosition.TOP ? this.getHeight() : -this.getHeight(), true);
        }
    }

    public ObjectProperty<T> valueProperty() {
        return this.value;
    }

    public T getValue() {
        return (T)this.valueProperty().get();
    }

    public void setValue(T value) {
        this.valueProperty().set(value);
    }

    public ObjectProperty<Function<T, String>> converterProperty() {
        return this.converter;
    }

    public Function<T, String> getConverter() {
        return (Function)this.converterProperty().get();
    }

    public void setConverter(Function<T, String> value) {
        this.converterProperty().set(value);
    }

    public ObjectProperty<Function<T, String>> descriptionConverterProperty() {
        if (this.descriptionConverter == null) {
            this.descriptionConverter = new SimpleObjectProperty((Object)this, "descriptionConverter");
        }
        return this.descriptionConverter;
    }

    public Function<T, String> getDescriptionConverter() {
        return (Function)this.descriptionConverterProperty().get();
    }

    public void setDescriptionConverter(Function<T, String> value) {
        this.descriptionConverterProperty().set(value);
    }

    public ListProperty<T> itemsProperty() {
        return this.items;
    }

    public void setItems(ObservableList<T> value) {
        this.itemsProperty().set(value);
    }

    public void setItems(Collection<T> value) {
        if (value instanceof ObservableList) {
            ObservableList observableList = (ObservableList)value;
            this.setItems(observableList);
        } else {
            this.setItems(FXCollections.observableArrayList(value));
        }
    }

    @SafeVarargs
    public final void setItems(T ... values) {
        this.setItems(FXCollections.observableArrayList((Object[])values));
    }

    public ObservableList<T> getItems() {
        return (ObservableList)this.items.get();
    }
}

