/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.image.internal;

import java.lang.ref.WeakReference;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.WritableImage;
import javafx.util.Duration;
import org.jackhuang.hmcl.ui.image.AnimationImage;

public final class AnimationImageImpl
extends WritableImage
implements AnimationImage {
    private Animation animation;
    private final int[][] frames;
    private final int[] durations;
    private final int cycleCount;

    public AnimationImageImpl(int width, int height, int[][] frames, int[] durations, int cycleCount) {
        super(width, height);
        if (frames.length != durations.length) {
            throw new IllegalArgumentException("frames.length != durations.length");
        }
        this.frames = frames;
        this.durations = durations;
        this.cycleCount = cycleCount;
        this.play();
    }

    public void play() {
        if (this.animation == null) {
            this.animation = new Animation(this);
            this.animation.timeline.play();
        }
    }

    private void updateImage(int frameIndex) {
        int width = (int)this.getWidth();
        int height = (int)this.getHeight();
        int[] frame = this.frames[frameIndex];
        this.getPixelWriter().setPixels(0, 0, width, height, (PixelFormat)PixelFormat.getIntArgbInstance(), frame, 0, width);
    }

    private static final class Animation
    implements WritableValue<Integer> {
        private final Timeline timeline = new Timeline();
        private final WeakReference<AnimationImageImpl> imageRef;
        private Integer value;

        private Animation(AnimationImageImpl image) {
            this.imageRef = new WeakReference<AnimationImageImpl>(image);
            this.timeline.setCycleCount(image.cycleCount);
            int duration = 0;
            for (int i = 0; i < image.frames.length; ++i) {
                this.timeline.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)duration), new KeyValue[]{new KeyValue((WritableValue)this, (Object)i, Interpolator.DISCRETE)}));
                duration += image.durations[i];
            }
            this.timeline.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)duration), new KeyValue[0]));
        }

        public Integer getValue() {
            return this.value;
        }

        public void setValue(Integer value) {
            this.value = value;
            AnimationImageImpl image = (AnimationImageImpl)this.imageRef.get();
            if (image == null) {
                this.timeline.stop();
                return;
            }
            image.updateImage(value);
        }
    }
}

