/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.auth.authlibinjector;

import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorArtifactInfo;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorArtifactProvider;
import org.jackhuang.hmcl.download.DownloadProvider;
import org.jackhuang.hmcl.task.FileDownloadTask;
import org.jackhuang.hmcl.util.io.HttpRequest;
import org.jackhuang.hmcl.util.logging.Logger;

public class AuthlibInjectorDownloader
implements AuthlibInjectorArtifactProvider {
    private static final String LATEST_BUILD_URL = "https://authlib-injector.yushi.moe/artifact/latest.json";
    private final Path artifactLocation;
    private final Supplier<DownloadProvider> downloadProvider;
    private final AtomicBoolean updateChecked = new AtomicBoolean(false);

    public AuthlibInjectorDownloader(Path artifactLocation, Supplier<DownloadProvider> downloadProvider) {
        this.artifactLocation = artifactLocation;
        this.downloadProvider = downloadProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthlibInjectorArtifactInfo getArtifactInfo() throws IOException {
        Optional<AuthlibInjectorArtifactInfo> cached = this.getArtifactInfoImmediately();
        if (cached.isPresent()) {
            return cached.get();
        }
        AuthlibInjectorDownloader authlibInjectorDownloader = this;
        synchronized (authlibInjectorDownloader) {
            Optional<AuthlibInjectorArtifactInfo> local = this.getLocalArtifact();
            if (local.isPresent()) {
                return local.get();
            }
            Logger.LOG.info("No local authlib-injector found, downloading");
            this.updateChecked.set(true);
            this.update();
            local = this.getLocalArtifact();
            return local.orElseThrow(() -> new IOException("The downloaded authlib-inejector cannot be recognized"));
        }
    }

    @Override
    public Optional<AuthlibInjectorArtifactInfo> getArtifactInfoImmediately() {
        return this.getLocalArtifact();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkUpdate() throws IOException {
        if (this.updateChecked.compareAndSet(false, true)) {
            AuthlibInjectorDownloader authlibInjectorDownloader = this;
            synchronized (authlibInjectorDownloader) {
                Logger.LOG.info("Checking update of authlib-injector");
                this.update();
            }
        }
    }

    private void update() throws IOException {
        AuthlibInjectorVersionInfo latest = this.getLatestArtifactInfo();
        Optional<AuthlibInjectorArtifactInfo> local = this.getLocalArtifact();
        if (local.isPresent() && local.get().getBuildNumber() >= latest.buildNumber) {
            return;
        }
        try {
            new FileDownloadTask(this.downloadProvider.get().injectURLWithCandidates(latest.downloadUrl), this.artifactLocation.toFile(), (FileDownloadTask.IntegrityCheck)Optional.ofNullable(latest.checksums.get("sha256")).map(checksum -> new FileDownloadTask.IntegrityCheck("SHA-256", (String)checksum)).orElse(null)).run();
        }
        catch (Exception e) {
            throw new IOException("Failed to download authlib-injector", e);
        }
        Logger.LOG.info("Updated authlib-injector to " + latest.version);
    }

    private AuthlibInjectorVersionInfo getLatestArtifactInfo() throws IOException {
        IOException exception = null;
        for (URL url : this.downloadProvider.get().injectURLWithCandidates(LATEST_BUILD_URL)) {
            try {
                return HttpRequest.GET(url.toExternalForm()).getJson(AuthlibInjectorVersionInfo.class);
            }
            catch (JsonParseException | IOException e) {
                if (exception == null) {
                    exception = new IOException("Failed to fetch authlib-injector artifact info");
                }
                exception.addSuppressed(e);
            }
        }
        if (exception == null) {
            exception = new IOException("No authlib-injector download providers available");
        }
        throw exception;
    }

    private Optional<AuthlibInjectorArtifactInfo> getLocalArtifact() {
        return AuthlibInjectorDownloader.parseArtifact(this.artifactLocation);
    }

    protected static Optional<AuthlibInjectorArtifactInfo> parseArtifact(Path path) {
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            return Optional.empty();
        }
        try {
            return Optional.of(AuthlibInjectorArtifactInfo.from(path));
        }
        catch (IOException e) {
            Logger.LOG.warning("Bad authlib-injector artifact", e);
            return Optional.empty();
        }
    }

    private static final class AuthlibInjectorVersionInfo {
        @SerializedName(value="build_number")
        public int buildNumber;
        @SerializedName(value="version")
        public String version;
        @SerializedName(value="download_url")
        public String downloadUrl;
        @SerializedName(value="checksums")
        public Map<String, String> checksums;

        private AuthlibInjectorVersionInfo() {
        }
    }
}

