/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.download;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXCheckBox;
import com.jfoenix.controls.JFXListView;
import com.jfoenix.controls.JFXSpinner;
import com.jfoenix.controls.JFXTextField;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javafx.animation.PauseTransition;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Paint;
import javafx.util.Duration;
import org.jackhuang.hmcl.download.DownloadProvider;
import org.jackhuang.hmcl.download.RemoteVersion;
import org.jackhuang.hmcl.download.VersionList;
import org.jackhuang.hmcl.download.fabric.FabricAPIRemoteVersion;
import org.jackhuang.hmcl.download.fabric.FabricRemoteVersion;
import org.jackhuang.hmcl.download.forge.ForgeRemoteVersion;
import org.jackhuang.hmcl.download.game.GameRemoteVersion;
import org.jackhuang.hmcl.download.liteloader.LiteLoaderRemoteVersion;
import org.jackhuang.hmcl.download.neoforge.NeoForgeRemoteVersion;
import org.jackhuang.hmcl.download.optifine.OptiFineRemoteVersion;
import org.jackhuang.hmcl.download.quilt.QuiltAPIRemoteVersion;
import org.jackhuang.hmcl.download.quilt.QuiltRemoteVersion;
import org.jackhuang.hmcl.setting.Theme;
import org.jackhuang.hmcl.setting.VersionIconType;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.ToolbarListPageSkin;
import org.jackhuang.hmcl.ui.animation.ContainerAnimations;
import org.jackhuang.hmcl.ui.animation.TransitionPane;
import org.jackhuang.hmcl.ui.construct.ComponentList;
import org.jackhuang.hmcl.ui.construct.HintPane;
import org.jackhuang.hmcl.ui.construct.IconedTwoLineListItem;
import org.jackhuang.hmcl.ui.construct.RipplerContainer;
import org.jackhuang.hmcl.ui.wizard.Navigation;
import org.jackhuang.hmcl.ui.wizard.Refreshable;
import org.jackhuang.hmcl.ui.wizard.WizardPage;
import org.jackhuang.hmcl.util.Holder;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.logging.Logger;

public final class VersionsPage
extends BorderPane
implements WizardPage,
Refreshable {
    private final String gameVersion;
    private final String libraryId;
    private final String title;
    private final Navigation navigation;
    private final JFXListView<RemoteVersion> list;
    private final JFXSpinner spinner;
    private final StackPane failedPane;
    private final StackPane emptyPane;
    private final TransitionPane root;
    private final JFXCheckBox chkRelease;
    private final JFXCheckBox chkSnapshot;
    private final JFXCheckBox chkOld;
    private final ComponentList centrePane;
    private final StackPane center;
    private final VersionList<?> versionList;
    private CompletableFuture<?> executor;
    private final HBox searchBar;
    private final StringProperty queryString = new SimpleStringProperty();

    public VersionsPage(Navigation navigation, String title, String gameVersion, DownloadProvider downloadProvider, String libraryId, Runnable callback) {
        this.title = title;
        this.gameVersion = gameVersion;
        this.libraryId = libraryId;
        this.navigation = navigation;
        HintPane hintPane = new HintPane();
        hintPane.setText(I18n.i18n("sponsor.bmclapi"));
        hintPane.getStyleClass().add((Object)"sponsor-pane");
        FXUtils.onClicked((Node)hintPane, this::onSponsor);
        BorderPane.setMargin((Node)hintPane, (Insets)new Insets(10.0, 10.0, 0.0, 10.0));
        this.setTop((Node)hintPane);
        this.root = new TransitionPane();
        BorderPane toolbarPane = new BorderPane();
        this.spinner = new JFXSpinner();
        this.center = new StackPane();
        this.center.setStyle("-fx-padding: 10;");
        this.centrePane = new ComponentList();
        this.centrePane.getStyleClass().add((Object)"no-padding");
        HBox checkPane = new HBox();
        checkPane.setSpacing(10.0);
        this.chkRelease = new JFXCheckBox(I18n.i18n("version.game.releases"));
        this.chkRelease.setSelected(true);
        HBox.setMargin((Node)this.chkRelease, (Insets)new Insets(10.0, 0.0, 10.0, 0.0));
        this.chkSnapshot = new JFXCheckBox(I18n.i18n("version.game.snapshots"));
        HBox.setMargin((Node)this.chkSnapshot, (Insets)new Insets(10.0, 0.0, 10.0, 0.0));
        this.chkOld = new JFXCheckBox(I18n.i18n("version.game.old"));
        HBox.setMargin((Node)this.chkOld, (Insets)new Insets(10.0, 0.0, 10.0, 0.0));
        checkPane.getChildren().setAll((Object[])new Node[]{this.chkRelease, this.chkSnapshot, this.chkOld});
        this.list = new JFXListView();
        this.list.getStyleClass().add((Object)"jfx-list-view-float");
        VBox.setVgrow(this.list, (Priority)Priority.ALWAYS);
        TransitionPane rightToolbarPane = new TransitionPane();
        HBox refreshPane = new HBox();
        refreshPane.setAlignment(Pos.CENTER_RIGHT);
        JFXButton btnRefresh = new JFXButton(I18n.i18n("button.refresh"));
        btnRefresh.getStyleClass().add((Object)"jfx-tool-bar-button");
        btnRefresh.setOnAction(e -> this.onRefresh());
        JFXButton btnSearch = new JFXButton(I18n.i18n("search"));
        btnSearch.getStyleClass().add((Object)"jfx-tool-bar-button");
        btnSearch.setGraphic(ToolbarListPageSkin.wrap(SVG.SEARCH.createIcon((Paint)Theme.blackFill(), -1.0)));
        this.searchBar = new HBox();
        this.searchBar.setAlignment(Pos.CENTER);
        this.searchBar.setPadding(new Insets(0.0, 5.0, 0.0, 0.0));
        JFXTextField searchField = new JFXTextField();
        searchField.setPromptText(I18n.i18n("search"));
        HBox.setHgrow((Node)searchField, (Priority)Priority.ALWAYS);
        JFXButton closeSearchBar = new JFXButton();
        closeSearchBar.getStyleClass().add((Object)"jfx-tool-bar-button");
        closeSearchBar.setGraphic(ToolbarListPageSkin.wrap(SVG.CLOSE.createIcon((Paint)Theme.blackFill(), -1.0)));
        closeSearchBar.setOnAction(e -> {
            searchField.clear();
            rightToolbarPane.setContent((Node)refreshPane, ContainerAnimations.FADE);
        });
        FXUtils.onEscPressed((Node)searchField, () -> ((JFXButton)closeSearchBar).fire());
        PauseTransition pause = new PauseTransition(Duration.millis((double)100.0));
        pause.setOnFinished(e -> this.queryString.set((Object)searchField.getText()));
        searchField.textProperty().addListener((observable, oldValue, newValue) -> {
            pause.setRate(1.0);
            pause.playFromStart();
        });
        this.searchBar.getChildren().setAll((Object[])new Node[]{searchField, closeSearchBar});
        btnSearch.setOnAction(e -> {
            rightToolbarPane.setContent((Node)this.searchBar, ContainerAnimations.FADE);
            searchField.requestFocus();
        });
        refreshPane.getChildren().setAll((Object[])new Node[]{new HBox(new Node[]{btnSearch, btnRefresh})});
        rightToolbarPane.setContent((Node)refreshPane, ContainerAnimations.NONE);
        FXUtils.ignoreEvent(this.list, KeyEvent.KEY_PRESSED, e -> e.getCode() == KeyCode.ESCAPE);
        toolbarPane.setLeft((Node)checkPane);
        toolbarPane.setRight((Node)rightToolbarPane);
        this.centrePane.getContent().setAll((Object[])new Node[]{toolbarPane, this.list});
        this.center.getChildren().setAll((Object[])new Node[]{this.centrePane});
        this.failedPane = new StackPane();
        this.failedPane.getStyleClass().add((Object)"notice-pane");
        Label label = new Label(I18n.i18n("download.failed.refresh"));
        FXUtils.onClicked((Node)label, this::onRefresh);
        this.failedPane.getChildren().setAll((Object[])new Node[]{label});
        this.emptyPane = new StackPane();
        this.emptyPane.getStyleClass().add((Object)"notice-pane");
        label = new Label(I18n.i18n("download.failed.empty"));
        FXUtils.onClicked((Node)label, this::onBack);
        this.emptyPane.getChildren().setAll((Object[])new Node[]{label});
        this.setCenter((Node)this.root);
        this.versionList = downloadProvider.getVersionListById(libraryId);
        boolean hasType = this.versionList.hasType();
        this.chkRelease.setManaged(hasType);
        this.chkRelease.setVisible(hasType);
        this.chkSnapshot.setManaged(hasType);
        this.chkSnapshot.setVisible(hasType);
        this.chkOld.setManaged(hasType);
        this.chkOld.setVisible(hasType);
        if (hasType) {
            this.centrePane.getContent().setAll((Object[])new Node[]{toolbarPane, this.list});
        } else {
            this.centrePane.getContent().setAll((Object[])new Node[]{this.list});
        }
        ComponentList.setVgrow(this.list, Priority.ALWAYS);
        InvalidationListener listener = o -> {
            List<RemoteVersion> versions = this.loadVersions();
            String query = (String)this.queryString.get();
            if (!StringUtils.isBlank(query)) {
                Predicate<RemoteVersion> predicate;
                if (query.startsWith("regex:")) {
                    try {
                        Pattern pattern = Pattern.compile(query.substring("regex:".length()));
                        predicate = it -> pattern.matcher(it.getSelfVersion()).find();
                    }
                    catch (Throwable e) {
                        Logger.LOG.warning("Illegal regular expression", e);
                        return;
                    }
                } else {
                    String lowerQueryString = query.toLowerCase(Locale.ROOT);
                    predicate = it -> it.getSelfVersion().toLowerCase(Locale.ROOT).contains(lowerQueryString);
                }
                versions = versions.stream().filter(predicate).collect(Collectors.toList());
            }
            this.list.getItems().setAll(versions);
        };
        this.chkRelease.selectedProperty().addListener(listener);
        this.chkSnapshot.selectedProperty().addListener(listener);
        this.chkOld.selectedProperty().addListener(listener);
        this.queryString.addListener(listener);
        btnRefresh.setGraphic(ToolbarListPageSkin.wrap(SVG.REFRESH.createIcon((Paint)Theme.blackFill(), -1.0)));
        Holder lastCell = new Holder();
        this.list.setCellFactory(listView -> new RemoteVersionListCell(lastCell, libraryId));
        FXUtils.onClicked(this.list, () -> {
            if (this.list.getSelectionModel().getSelectedIndex() < 0) {
                return;
            }
            navigation.getSettings().put(libraryId, this.list.getSelectionModel().getSelectedItem());
            callback.run();
        });
        this.refresh();
    }

    private List<RemoteVersion> loadVersions() {
        return this.versionList.getVersions(this.gameVersion).stream().filter(it -> {
            switch (it.getVersionType()) {
                case RELEASE: {
                    return this.chkRelease.isSelected();
                }
                case PENDING: 
                case SNAPSHOT: {
                    return this.chkSnapshot.isSelected();
                }
                case OLD: {
                    return this.chkOld.isSelected();
                }
            }
            return true;
        }).sorted().collect(Collectors.toList());
    }

    @Override
    public void refresh() {
        VersionList<?> currentVersionList = this.versionList;
        this.root.setContent((Node)this.spinner, ContainerAnimations.FADE);
        this.executor = currentVersionList.refreshAsync(this.gameVersion).whenComplete((result, exception) -> {
            if (exception == null) {
                List<RemoteVersion> items = this.loadVersions();
                Platform.runLater(() -> {
                    if (this.versionList != currentVersionList) {
                        return;
                    }
                    if (currentVersionList.getVersions(this.gameVersion).isEmpty()) {
                        this.root.setContent((Node)this.emptyPane, ContainerAnimations.FADE);
                    } else {
                        if (items.isEmpty()) {
                            this.chkRelease.setSelected(true);
                            this.chkSnapshot.setSelected(true);
                            this.chkOld.setSelected(true);
                        } else {
                            this.list.getItems().setAll((Collection)items);
                        }
                        this.root.setContent((Node)this.center, ContainerAnimations.FADE);
                    }
                });
            } else {
                Logger.LOG.warning("Failed to fetch versions list", (Throwable)exception);
                Platform.runLater(() -> {
                    if (this.versionList != currentVersionList) {
                        return;
                    }
                    this.root.setContent((Node)this.failedPane, ContainerAnimations.FADE);
                });
            }
            System.gc();
        });
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void cleanup(Map<String, Object> settings) {
        settings.remove(this.libraryId);
        if (this.executor != null) {
            this.executor.cancel(true);
        }
    }

    private void onRefresh() {
        this.refresh();
    }

    private void onBack() {
        this.navigation.onPrev(true);
    }

    private void onSponsor() {
        FXUtils.openLink("https://bmclapidoc.bangbang93.com");
    }

    private static class RemoteVersionListCell
    extends ListCell<RemoteVersion> {
        final IconedTwoLineListItem content = new IconedTwoLineListItem();
        final RipplerContainer ripplerContainer = new RipplerContainer((Node)this.content);
        final StackPane pane = new StackPane();
        private final Holder<RemoteVersionListCell> lastCell;

        RemoteVersionListCell(Holder<RemoteVersionListCell> lastCell, String libraryId) {
            this.lastCell = lastCell;
            if ("game".equals(libraryId)) {
                this.content.getExternalLinkButton().setGraphic(SVG.GLOBE_BOOK.createIcon((Paint)Theme.blackFill(), -1.0));
                FXUtils.installFastTooltip((Node)this.content.getExternalLinkButton(), I18n.i18n("wiki.tooltip"));
            }
            this.pane.getStyleClass().add((Object)"md-list-cell");
            StackPane.setMargin((Node)this.content, (Insets)new Insets(10.0, 16.0, 10.0, 16.0));
            this.pane.getChildren().setAll((Object[])new Node[]{this.ripplerContainer});
        }

        public void updateItem(RemoteVersion remoteVersion, boolean empty) {
            super.updateItem((Object)remoteVersion, empty);
            if (this == this.lastCell.value && !this.isVisible()) {
                return;
            }
            this.lastCell.value = this;
            if (empty) {
                this.setGraphic(null);
                return;
            }
            this.setGraphic((Node)this.pane);
            this.content.setTitle(remoteVersion.getSelfVersion());
            if (remoteVersion.getReleaseDate() != null) {
                this.content.setSubtitle(I18n.formatDateTime(remoteVersion.getReleaseDate()));
            } else {
                this.content.setSubtitle(null);
            }
            if (remoteVersion instanceof GameRemoteVersion) {
                switch (remoteVersion.getVersionType()) {
                    case RELEASE: {
                        this.content.getTags().setAll((Object[])new String[]{I18n.i18n("version.game.release")});
                        this.content.setImage(VersionIconType.GRASS.getIcon());
                        this.content.setExternalLink(I18n.i18n("wiki.version.game.release", remoteVersion.getGameVersion()));
                        break;
                    }
                    case PENDING: 
                    case SNAPSHOT: {
                        this.content.getTags().setAll((Object[])new String[]{I18n.i18n("version.game.snapshot")});
                        this.content.setImage(VersionIconType.COMMAND.getIcon());
                        this.content.setExternalLink(I18n.i18n("wiki.version.game.snapshot", remoteVersion.getGameVersion()));
                        break;
                    }
                    default: {
                        this.content.getTags().setAll((Object[])new String[]{I18n.i18n("version.game.old")});
                        this.content.setImage(VersionIconType.CRAFT_TABLE.getIcon());
                        this.content.setExternalLink(null);
                        break;
                    }
                }
            } else {
                VersionIconType iconType = remoteVersion instanceof LiteLoaderRemoteVersion ? VersionIconType.CHICKEN : (remoteVersion instanceof OptiFineRemoteVersion ? VersionIconType.OPTIFINE : (remoteVersion instanceof ForgeRemoteVersion ? VersionIconType.FORGE : (remoteVersion instanceof NeoForgeRemoteVersion ? VersionIconType.NEO_FORGE : (remoteVersion instanceof FabricRemoteVersion || remoteVersion instanceof FabricAPIRemoteVersion ? VersionIconType.FABRIC : (remoteVersion instanceof QuiltRemoteVersion || remoteVersion instanceof QuiltAPIRemoteVersion ? VersionIconType.QUILT : null)))));
                this.content.setImage(iconType != null ? iconType.getIcon() : null);
                if (this.content.getSubtitle() == null) {
                    this.content.setSubtitle(remoteVersion.getGameVersion());
                } else {
                    this.content.getTags().setAll((Object[])new String[]{remoteVersion.getGameVersion()});
                }
                this.content.setExternalLink(null);
            }
        }
    }
}

