/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.main;

import com.jfoenix.controls.JFXButton;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Paint;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.jackhuang.hmcl.java.JavaInfo;
import org.jackhuang.hmcl.java.JavaManager;
import org.jackhuang.hmcl.java.JavaRuntime;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.setting.DownloadProviders;
import org.jackhuang.hmcl.setting.Theme;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.ListPageBase;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.ToolbarListPageSkin;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.construct.RipplerContainer;
import org.jackhuang.hmcl.ui.construct.TwoLineListItem;
import org.jackhuang.hmcl.ui.main.JavaDownloadDialog;
import org.jackhuang.hmcl.ui.main.JavaInstallPage;
import org.jackhuang.hmcl.ui.main.JavaRestorePage;
import org.jackhuang.hmcl.ui.wizard.SinglePageWizardProvider;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.TaskCancellationAction;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.platform.Architecture;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jackhuang.hmcl.util.platform.Platform;
import org.jackhuang.hmcl.util.platform.UnsupportedPlatformException;
import org.jackhuang.hmcl.util.tree.ArchiveFileTree;

public final class JavaManagementPage
extends ListPageBase<JavaItem> {
    private final ChangeListener<Collection<JavaRuntime>> listener = FXUtils.onWeakChangeAndOperate(JavaManager.getAllJavaProperty(), this::loadJava);
    private final Runnable onInstallJava = Platform.SYSTEM_PLATFORM.equals(OperatingSystem.LINUX, Architecture.LOONGARCH64_OW) ? () -> FXUtils.openLink("https://www.loongnix.cn/zh/api/java/") : JavaDownloadDialog.showDialogAction(DownloadProviders.getDownloadProvider());

    public JavaManagementPage() {
        FXUtils.applyDragListener((Node)this, it -> {
            String name = it.getName();
            return it.isDirectory() || name.endsWith(".zip") || name.endsWith(".tar.gz") || name.equals(OperatingSystem.CURRENT_OS.getJavaExecutable());
        }, files -> {
            for (File file : files) {
                if (file.isDirectory()) {
                    this.onAddJavaHome(file.toPath());
                    continue;
                }
                String fileName = file.getName();
                if (fileName.equals(OperatingSystem.CURRENT_OS.getJavaExecutable())) {
                    this.onAddJavaBinary(file.toPath());
                    continue;
                }
                if (fileName.endsWith(".zip") || fileName.endsWith(".tar.gz")) {
                    this.onInstallArchive(file.toPath());
                    continue;
                }
                throw new AssertionError((Object)"Unreachable code");
            }
        });
    }

    protected Skin<?> createDefaultSkin() {
        return new JavaPageSkin(this);
    }

    void onAddJava() {
        FileChooser chooser = new FileChooser();
        if (OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS) {
            chooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Java", new String[]{"java.exe"}));
        }
        chooser.setTitle(I18n.i18n("settings.game.java_directory.choose"));
        File file = chooser.showOpenDialog((Window)Controllers.getStage());
        if (file != null) {
            JavaManager.getAddJavaTask(file.toPath()).whenComplete(Schedulers.javafx(), exception -> {
                if (exception != null) {
                    Logger.LOG.warning("Failed to add java", exception);
                    Controllers.dialog(I18n.i18n("java.add.failed"), I18n.i18n("message.error"), MessageDialogPane.MessageType.ERROR);
                }
            }).start();
        }
    }

    void onShowRestoreJavaPage() {
        Controllers.navigate((Node)new JavaRestorePage(ConfigHolder.globalConfig().getDisabledJava()));
    }

    private void onAddJavaBinary(Path file) {
        JavaManager.getAddJavaTask(file).whenComplete(Schedulers.javafx(), exception -> {
            if (exception != null) {
                Logger.LOG.warning("Failed to add java", exception);
                Controllers.dialog(I18n.i18n("java.add.failed"), I18n.i18n("message.error"), MessageDialogPane.MessageType.ERROR);
            }
        }).start();
    }

    private void onAddJavaHome(Path file) {
        Task.composeAsync(() -> {
            Path releaseFile = file.resolve("release");
            if (Files.notExists(releaseFile, new LinkOption[0])) {
                throw new IOException("Missing release file " + releaseFile);
            }
            return JavaManager.getAddJavaTask(file.resolve("bin").resolve(OperatingSystem.CURRENT_OS.getJavaExecutable()));
        }).whenComplete(Schedulers.javafx(), exception -> {
            if (exception != null) {
                Logger.LOG.warning("Failed to add java", exception);
                Controllers.dialog(I18n.i18n("java.add.failed"), I18n.i18n("message.error"), MessageDialogPane.MessageType.ERROR);
            }
        }).start();
    }

    private void onInstallArchive(Path file) {
        Task.supplyAsync(() -> {
            try (ArchiveFileTree<?, ?> tree = ArchiveFileTree.open(file);){
                JavaInfo info = JavaInfo.fromArchive(tree);
                if (!JavaManager.isCompatible(info.getPlatform())) {
                    throw new UnsupportedPlatformException(info.getPlatform().toString());
                }
                Pair<String, JavaInfo> pair = Pair.pair(tree.getRoot().getSubDirs().keySet().iterator().next(), info);
                return pair;
            }
        }).whenComplete(Schedulers.javafx(), (result, exception) -> {
            if (exception == null) {
                Controllers.getDecorator().startWizard(new SinglePageWizardProvider(controller -> new JavaInstallPage(controller::onFinish, (JavaInfo)result.getValue(), null, null, (String)result.getKey(), file)));
            } else if (exception instanceof UnsupportedPlatformException) {
                Controllers.dialog(I18n.i18n("java.install.failed.unsupported_platform"), null, MessageDialogPane.MessageType.WARNING);
            } else {
                Controllers.dialog(I18n.i18n("java.install.failed.invalid"), null, MessageDialogPane.MessageType.WARNING);
            }
        }).start();
    }

    private void loadJava(Collection<JavaRuntime> javaRuntimes) {
        if (javaRuntimes != null) {
            ArrayList<JavaItem> items = new ArrayList<JavaItem>();
            for (JavaRuntime java : javaRuntimes) {
                items.add(new JavaItem(java));
            }
            this.setItems(FXCollections.observableList(items));
            this.setLoading(false);
        } else {
            this.setLoading(true);
        }
    }

    private static final class JavaPageSkin
    extends ToolbarListPageSkin<JavaManagementPage> {
        JavaPageSkin(JavaManagementPage skinnable) {
            super(skinnable);
        }

        @Override
        protected List<Node> initializeToolbar(JavaManagementPage skinnable) {
            ArrayList<Node> res = new ArrayList<Node>(4);
            res.add((Node)JavaPageSkin.createToolbarButton2(I18n.i18n("button.refresh"), SVG.REFRESH, JavaManager::refresh));
            if (skinnable.onInstallJava != null) {
                res.add((Node)JavaPageSkin.createToolbarButton2(I18n.i18n("java.download"), SVG.DOWNLOAD, skinnable.onInstallJava));
            }
            res.add((Node)JavaPageSkin.createToolbarButton2(I18n.i18n("java.add"), SVG.ADD, skinnable::onAddJava));
            JFXButton disableJava = JavaPageSkin.createToolbarButton2(I18n.i18n("java.disabled.management"), SVG.FORMAT_LIST_BULLETED, skinnable::onShowRestoreJavaPage);
            disableJava.disableProperty().bind((ObservableValue)Bindings.isEmpty(ConfigHolder.globalConfig().getDisabledJava()));
            res.add((Node)disableJava);
            return res;
        }
    }

    static final class JavaItem
    extends Control {
        private final JavaRuntime java;

        public JavaItem(JavaRuntime java) {
            this.java = java;
        }

        public JavaRuntime getJava() {
            return this.java;
        }

        public void onReveal() {
            Path parent = this.java.getBinary().getParent();
            Path target = parent != null && parent.getParent() != null && parent.getFileName() != null && parent.getFileName().toString().equals("bin") && Files.exists(parent.getParent().resolve("release"), new LinkOption[0]) ? parent.getParent() : this.java.getBinary();
            FXUtils.showFileInExplorer(target);
        }

        public void onRemove() {
            if (this.java.isManaged()) {
                Controllers.taskDialog(JavaManager.getUninstallJavaTask(this.java), I18n.i18n("java.uninstall"), TaskCancellationAction.NORMAL);
            } else {
                String path = this.java.getBinary().toString();
                ConfigHolder.globalConfig().getUserJava().remove((Object)path);
                ConfigHolder.globalConfig().getDisabledJava().add((Object)path);
                try {
                    JavaManager.removeJava(this.java);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        protected Skin<?> createDefaultSkin() {
            return new JavaRuntimeItemSkin(this);
        }
    }

    private static final class JavaRuntimeItemSkin
    extends SkinBase<JavaItem> {
        JavaRuntimeItemSkin(JavaItem control) {
            super((Control)control);
            JavaRuntime java = control.getJava();
            String vendor = JavaInfo.normalizeVendor(java.getVendor());
            BorderPane root = new BorderPane();
            HBox center = new HBox();
            center.setMouseTransparent(true);
            center.setSpacing(8.0);
            center.setAlignment(Pos.CENTER_LEFT);
            TwoLineListItem item = new TwoLineListItem();
            item.setTitle((java.isJDK() ? "JDK" : "JRE") + " " + java.getVersion());
            item.setSubtitle(java.getBinary().toString());
            item.getTags().add((Object)(I18n.i18n("java.info.architecture") + ": " + java.getArchitecture().getDisplayName()));
            if (vendor != null) {
                item.getTags().add((Object)(I18n.i18n("java.info.vendor") + ": " + vendor));
            }
            BorderPane.setAlignment((Node)item, (Pos)Pos.CENTER);
            center.getChildren().setAll((Object[])new Node[]{item});
            root.setCenter((Node)center);
            HBox right = new HBox();
            right.setAlignment(Pos.CENTER_RIGHT);
            JFXButton revealButton = new JFXButton();
            revealButton.getStyleClass().add((Object)"toggle-icon4");
            revealButton.setGraphic(FXUtils.limitingSize(SVG.FOLDER_OPEN.createIcon((Paint)Theme.blackFill(), 24.0), 24.0, 24.0));
            revealButton.setOnAction(e -> control.onReveal());
            FXUtils.installFastTooltip((Node)revealButton, I18n.i18n("reveal.in_file_manager"));
            JFXButton removeButton = new JFXButton();
            removeButton.getStyleClass().add((Object)"toggle-icon4");
            removeButton.setOnAction(e -> Controllers.confirm(java.isManaged() ? I18n.i18n("java.uninstall.confirm") : I18n.i18n("java.disable.confirm"), I18n.i18n("message.warning"), control::onRemove, null));
            if (java.isManaged()) {
                removeButton.setGraphic(FXUtils.limitingSize(SVG.DELETE_FOREVER.createIcon((Paint)Theme.blackFill(), 24.0), 24.0, 24.0));
                FXUtils.installFastTooltip((Node)removeButton, I18n.i18n("java.uninstall"));
                if (JavaRuntime.CURRENT_JAVA != null && java.getBinary().equals(JavaRuntime.CURRENT_JAVA.getBinary())) {
                    removeButton.setDisable(true);
                }
            } else {
                removeButton.setGraphic(FXUtils.limitingSize(SVG.DELETE.createIcon((Paint)Theme.blackFill(), 24.0), 24.0, 24.0));
                FXUtils.installFastTooltip((Node)removeButton, I18n.i18n("java.disable"));
            }
            right.getChildren().setAll((Object[])new Node[]{revealButton, removeButton});
            root.setRight((Node)right);
            root.getStyleClass().add((Object)"md-list-cell");
            root.setPadding(new Insets(8.0));
            this.getChildren().setAll((Object[])new Node[]{new RipplerContainer((Node)root)});
        }
    }
}

