/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.java;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jackhuang.hmcl.java.JavaInfo;
import org.jackhuang.hmcl.util.platform.Architecture;
import org.jackhuang.hmcl.util.platform.Bits;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jackhuang.hmcl.util.platform.Platform;
import org.jackhuang.hmcl.util.versioning.VersionNumber;
import org.jetbrains.annotations.NotNull;

public final class JavaRuntime
implements Comparable<JavaRuntime> {
    private final Path binary;
    private final JavaInfo info;
    private final boolean isManaged;
    private final boolean isJDK;
    public static final JavaRuntime CURRENT_JAVA;
    public static final int CURRENT_VERSION;
    public static final boolean CURRENT_JIT_ENABLED;

    public static JavaRuntime of(Path binary, JavaInfo info, boolean isManaged) {
        String javacName = info.getPlatform().getOperatingSystem() == OperatingSystem.WINDOWS ? "javac.exe" : "javac";
        return new JavaRuntime(binary, info, isManaged, Files.isRegularFile(binary.resolveSibling(javacName), new LinkOption[0]));
    }

    public JavaRuntime(Path binary, JavaInfo info, boolean isManaged, boolean isJDK) {
        this.binary = binary;
        this.info = info;
        this.isManaged = isManaged;
        this.isJDK = isJDK;
    }

    public boolean isManaged() {
        return this.isManaged;
    }

    public Path getBinary() {
        return this.binary;
    }

    public String getVersion() {
        return this.info.getVersion();
    }

    public Platform getPlatform() {
        return this.info.getPlatform();
    }

    public Architecture getArchitecture() {
        return this.getPlatform().getArchitecture();
    }

    public Bits getBits() {
        return this.getPlatform().getBits();
    }

    public VersionNumber getVersionNumber() {
        return this.info.getVersionNumber();
    }

    public int getParsedVersion() {
        return this.info.getParsedVersion();
    }

    public String getVendor() {
        return this.info.getVendor();
    }

    public boolean isJDK() {
        return this.isJDK;
    }

    @Override
    public int compareTo(@NotNull JavaRuntime that) {
        if (this.isManaged != that.isManaged) {
            return this.isManaged ? -1 : 1;
        }
        int c = Integer.compare(this.getParsedVersion(), that.getParsedVersion());
        if (c != 0) {
            return c;
        }
        c = this.getVersionNumber().compareTo(that.getVersionNumber());
        if (c != 0) {
            return c;
        }
        c = this.getArchitecture().compareTo(that.getArchitecture());
        if (c != 0) {
            return c;
        }
        return this.getBinary().compareTo(that.getBinary());
    }

    public int hashCode() {
        return this.binary.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JavaRuntime)) {
            return false;
        }
        JavaRuntime that = (JavaRuntime)o;
        return this.getBinary().equals(that.getBinary());
    }

    public static JavaRuntime getDefault() {
        return CURRENT_JAVA;
    }

    static {
        String javaHome = System.getProperty("java.home");
        Path executable = null;
        if (javaHome != null) {
            executable = Paths.get(javaHome, "bin", OperatingSystem.CURRENT_OS.getJavaExecutable());
            try {
                executable = executable.toRealPath(new LinkOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!Files.isRegularFile(executable, new LinkOption[0])) {
                executable = null;
            }
        }
        CURRENT_JAVA = executable != null ? JavaRuntime.of(executable, JavaInfo.CURRENT_ENVIRONMENT, false) : null;
        CURRENT_VERSION = JavaInfo.CURRENT_ENVIRONMENT.getParsedVersion();
        String vmInfo = System.getProperty("java.vm.info", "");
        CURRENT_JIT_ENABLED = !vmInfo.contains("interpreted mode") && !vmInfo.contains("JIT disabled");
    }
}

