/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.upgrade;

import java.nio.file.Files;
import java.nio.file.Path;
import org.jackhuang.hmcl.task.FileDownloadTask;
import org.jackhuang.hmcl.upgrade.RemoteVersion;

final class HMCLDownloadTask
extends FileDownloadTask {
    private final RemoteVersion.Type archiveFormat;

    public HMCLDownloadTask(RemoteVersion version, Path target) {
        super(version.getUrl(), target, version.getIntegrityCheck());
        this.archiveFormat = version.getType();
    }

    @Override
    public void execute() throws Exception {
        super.execute();
        try {
            Path target = this.getPath();
            switch (this.archiveFormat) {
                case JAR: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown format: " + String.valueOf((Object)this.archiveFormat));
                }
            }
        }
        catch (Throwable e) {
            try {
                Files.deleteIfExists(this.getPath());
            }
            catch (Throwable e2) {
                e.addSuppressed(e2);
            }
            throw e;
        }
    }
}

