/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.platform;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jackhuang.hmcl.launch.StreamPump;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.platform.OperatingSystem;

public final class ManagedProcess {
    private final ReentrantLock lock = new ReentrantLock();
    private final Process process;
    private final List<String> commands;
    private final String classpath;
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final List<String> lines = new ArrayList<String>();
    private final List<Thread> relatedThreads = new ArrayList<Thread>();

    public ManagedProcess(ProcessBuilder processBuilder) throws IOException {
        this.process = processBuilder.start();
        this.commands = processBuilder.command();
        this.classpath = null;
    }

    public ManagedProcess(Process process, List<String> commands) {
        this.process = process;
        this.commands = List.copyOf(commands);
        this.classpath = null;
    }

    public ManagedProcess(Process process, List<String> commands, String classpath) {
        this.process = process;
        this.commands = List.copyOf(commands);
        this.classpath = classpath;
    }

    public Process getProcess() {
        return this.process;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public String getClasspath() {
        return this.classpath;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public List<String> getLines(Predicate<String> lineFilter) {
        this.lock.lock();
        if (lineFilter == null) {
            return List.copyOf(this.lines);
        }
        ArrayList<String> res = new ArrayList<String>();
        for (String line : this.lines) {
            if (!lineFilter.test(line)) continue;
            res.add(line);
        }
        return Collections.unmodifiableList(res);
    }

    public void addLine(String line) {
        this.lock.lock();
        try {
            this.lines.add(line);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addRelatedThread(Thread thread) {
        this.lock.lock();
        try {
            this.relatedThreads.add(thread);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void pumpInputStream(Consumer<String> onLogLine) {
        this.addRelatedThread(Lang.thread(new StreamPump(this.process.getInputStream(), onLogLine, OperatingSystem.NATIVE_CHARSET), "ProcessInputStreamPump", true));
    }

    public void pumpErrorStream(Consumer<String> onLogLine) {
        this.addRelatedThread(Lang.thread(new StreamPump(this.process.getErrorStream(), onLogLine, OperatingSystem.NATIVE_CHARSET), "ProcessErrorStreamPump", true));
    }

    public boolean isRunning() {
        try {
            this.process.exitValue();
            return false;
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
    }

    public int getExitCode() {
        return this.process.exitValue();
    }

    public void stop() {
        this.process.destroy();
        this.destroyRelatedThreads();
    }

    public void destroyRelatedThreads() {
        this.lock.lock();
        try {
            this.relatedThreads.forEach(Thread::interrupt);
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return "ManagedProcess[commands=" + String.valueOf(this.commands) + ", isRunning=" + this.isRunning() + "]";
    }
}

