/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls.cells.editors.base;

import com.jfoenix.controls.JFXTreeTableColumn;
import com.jfoenix.controls.cells.editors.TextFieldEditorBuilder;
import com.jfoenix.controls.cells.editors.base.EditorNodeBuilder;
import com.jfoenix.controls.cells.editors.base.JFXTreeTableCell;
import com.jfoenix.controls.datamodels.treetable.RecursiveTreeObject;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.value.ChangeListener;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Region;

public class GenericEditableTreeTableCell<S, T>
extends JFXTreeTableCell<S, T> {
    protected EditorNodeBuilder builder;
    protected Region editorNode;

    public GenericEditableTreeTableCell(EditorNodeBuilder builder) {
        this.builder = builder;
    }

    public GenericEditableTreeTableCell() {
        this.builder = new TextFieldEditorBuilder();
    }

    protected void commitHelper(boolean losingFocus) {
        block3: {
            if (this.editorNode == null) {
                return;
            }
            try {
                this.builder.validateValue();
                this.commitEdit(this.builder.getValue());
            }
            catch (Exception ex) {
                if (!losingFocus) break block3;
                this.cancelEdit();
            }
        }
    }

    protected Object getValue() {
        return this.getItem() == null ? "" : this.getItem();
    }

    public void startEdit() {
        if (this.checkGroupedColumn()) {
            super.startEdit();
            if (this.editorNode == null) {
                this.createEditorNode();
            }
            this.builder.startEdit();
            this.setGraphic((Node)this.editorNode);
            this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        }
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.builder.cancelEdit();
        this.builder.setValue(this.getValue());
        this.setContentDisplay(ContentDisplay.TEXT_ONLY);
        this.editorNode = null;
    }

    private boolean checkGroupedColumn() {
        boolean allowEdit = true;
        if (this.getTreeTableRow().getTreeItem() != null) {
            Object rowObject = this.getTreeTableRow().getTreeItem().getValue();
            if (rowObject instanceof RecursiveTreeObject && rowObject.getClass() == RecursiveTreeObject.class) {
                allowEdit = false;
            } else if (this.getTableColumn() instanceof JFXTreeTableColumn && ((JFXTreeTableColumn)this.getTableColumn()).isGrouped() && this.getTreeTableRow().getTreeItem().getParent() != null && this.getTreeTableRow().getTreeItem().getParent().getValue().getClass() == RecursiveTreeObject.class) {
                allowEdit = false;
            }
        }
        return allowEdit;
    }

    public void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else if (this.isEditing() && this.checkGroupedColumn()) {
            if (this.editorNode != null) {
                this.builder.setValue(this.getValue());
            }
            this.setGraphic((Node)this.editorNode);
            this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            this.builder.updateItem(item, empty);
        } else {
            Object value = this.getValue();
            if (value instanceof Node) {
                this.setGraphic((Node)value);
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            } else {
                this.setText(value.toString());
                this.setContentDisplay(ContentDisplay.TEXT_ONLY);
            }
        }
    }

    private void createEditorNode() {
        EventHandler keyEventsHandler = t -> {
            if (t.getCode() == KeyCode.ENTER) {
                this.commitHelper(false);
            } else if (t.getCode() == KeyCode.ESCAPE) {
                this.cancelEdit();
            } else if (t.getCode() == KeyCode.TAB) {
                this.commitHelper(false);
                TreeTableColumn<S, ?> nextColumn = this.getNextColumn(!t.isShiftDown());
                if (nextColumn != null) {
                    this.getTreeTableView().edit(this.getIndex(), nextColumn);
                }
            }
        };
        ChangeListener focusChangeListener = (observable, oldValue, newValue) -> {
            if (!newValue.booleanValue() && this.editorNode != null) {
                this.commitHelper(true);
            }
        };
        DoubleBinding minWidthBinding = Bindings.createDoubleBinding(() -> this.getWidth() - this.getGraphicTextGap() * 2.0 - this.getBaselineOffset(), (Observable[])new Observable[]{this.widthProperty(), this.graphicTextGapProperty()});
        this.editorNode = this.builder.createNode(this.getValue(), minWidthBinding, (EventHandler<KeyEvent>)keyEventsHandler, (ChangeListener<Boolean>)focusChangeListener);
    }

    private TreeTableColumn<S, ?> getNextColumn(boolean forward) {
        ArrayList columns = new ArrayList();
        for (TreeTableColumn column : this.getTreeTableView().getColumns()) {
            columns.addAll(this.getLeaves(column));
        }
        if (columns.size() < 2) {
            return null;
        }
        int nextIndex = columns.indexOf(this.getTableColumn());
        if (forward) {
            if (++nextIndex > columns.size() - 1) {
                nextIndex = 0;
            }
        } else if (--nextIndex < 0) {
            nextIndex = columns.size() - 1;
        }
        return (TreeTableColumn)columns.get(nextIndex);
    }

    private List<TreeTableColumn<S, ?>> getLeaves(TreeTableColumn<S, ?> root) {
        ArrayList columns = new ArrayList();
        if (root.getColumns().isEmpty()) {
            if (root.isEditable()) {
                columns.add(root);
            }
            return columns;
        }
        for (TreeTableColumn column : root.getColumns()) {
            columns.addAll(this.getLeaves(column));
        }
        return columns;
    }
}

