/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.image.WritablePixelFormat;

public final class SwingFXUtils {
    private SwingFXUtils() {
    }

    public static WritableImage toFXImage(BufferedImage bimg, WritableImage wimg) {
        int bw = bimg.getWidth();
        int bh = bimg.getHeight();
        switch (bimg.getType()) {
            case 2: 
            case 3: {
                break;
            }
            default: {
                BufferedImage converted = new BufferedImage(bw, bh, 3);
                Graphics2D g2d = converted.createGraphics();
                g2d.drawImage((Image)bimg, 0, 0, null);
                g2d.dispose();
                bimg = converted;
            }
        }
        if (wimg != null) {
            int iw = (int)wimg.getWidth();
            int ih = (int)wimg.getHeight();
            if (iw < bw || ih < bh) {
                wimg = null;
            } else if (bw < iw || bh < ih) {
                int[] empty = new int[iw];
                PixelWriter pw = wimg.getPixelWriter();
                WritablePixelFormat pf = PixelFormat.getIntArgbPreInstance();
                if (bw < iw) {
                    pw.setPixels(bw, 0, iw - bw, bh, (PixelFormat)pf, empty, 0, 0);
                }
                if (bh < ih) {
                    pw.setPixels(0, bh, iw, ih - bh, (PixelFormat)pf, empty, 0, 0);
                }
            }
        }
        if (wimg == null) {
            wimg = new WritableImage(bw, bh);
        }
        PixelWriter pw = wimg.getPixelWriter();
        DataBufferInt db = (DataBufferInt)bimg.getRaster().getDataBuffer();
        int[] data = db.getData();
        int offset = bimg.getRaster().getDataBuffer().getOffset();
        int scan = 0;
        SampleModel sm = bimg.getRaster().getSampleModel();
        if (sm instanceof SinglePixelPackedSampleModel) {
            scan = ((SinglePixelPackedSampleModel)sm).getScanlineStride();
        }
        WritablePixelFormat pf = bimg.isAlphaPremultiplied() ? PixelFormat.getIntArgbPreInstance() : PixelFormat.getIntArgbInstance();
        pw.setPixels(0, 0, bw, bh, (PixelFormat)pf, data, offset, scan);
        return wimg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WritableImage toFXImage(BufferedImage bimg, double requestedWidth, double requestedHeight, boolean preserveRatio, boolean smooth) {
        if (requestedWidth <= 0.0 || requestedHeight <= 0.0) {
            return SwingFXUtils.toFXImage(bimg, null);
        }
        int width = (int)requestedWidth;
        int height = (int)requestedHeight;
        if (preserveRatio) {
            double originalWidth = bimg.getWidth();
            double originalHeight = bimg.getHeight();
            double scaleX = requestedWidth / originalWidth;
            double scaleY = requestedHeight / originalHeight;
            double scale = Math.min(scaleX, scaleY);
            width = (int)(originalWidth * scale);
            height = (int)(originalHeight * scale);
        }
        BufferedImage scaledImage = new BufferedImage(width, height, 3);
        Graphics2D g2d = scaledImage.createGraphics();
        try {
            if (smooth) {
                g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            g2d.drawImage(bimg, 0, 0, width, height, null);
        }
        finally {
            g2d.dispose();
        }
        return SwingFXUtils.toFXImage(scaledImage, null);
    }
}

