/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.monetfx.internal.contrast;

import org.glavo.monetfx.internal.utils.ColorUtils;

public final class Contrast {
    public static final double RATIO_MIN = 1.0;
    public static final double RATIO_MAX = 21.0;
    public static final double RATIO_30 = 3.0;
    public static final double RATIO_45 = 4.5;
    public static final double RATIO_70 = 7.0;
    private static final double CONTRAST_RATIO_EPSILON = 0.04;
    private static final double LUMINANCE_GAMUT_MAP_TOLERANCE = 0.4;

    private Contrast() {
    }

    public static double ratioOfYs(double y1, double y2) {
        double lighter = Math.max(y1, y2);
        double darker = lighter == y2 ? y1 : y2;
        return (lighter + 5.0) / (darker + 5.0);
    }

    public static double ratioOfTones(double t1, double t2) {
        return Contrast.ratioOfYs(ColorUtils.yFromLstar(t1), ColorUtils.yFromLstar(t2));
    }

    public static double lighter(double tone, double ratio) {
        if (tone < 0.0 || tone > 100.0) {
            return -1.0;
        }
        double darkY = ColorUtils.yFromLstar(tone);
        double lightY = ratio * (darkY + 5.0) - 5.0;
        if (lightY < 0.0 || lightY > 100.0) {
            return -1.0;
        }
        double realContrast = Contrast.ratioOfYs(lightY, darkY);
        double delta = Math.abs(realContrast - ratio);
        if (realContrast < ratio && delta > 0.04) {
            return -1.0;
        }
        double returnValue = ColorUtils.lstarFromY(lightY) + 0.4;
        if (returnValue < 0.0 || returnValue > 100.0) {
            return -1.0;
        }
        return returnValue;
    }

    public static double lighterUnsafe(double tone, double ratio) {
        double lighterSafe = Contrast.lighter(tone, ratio);
        return lighterSafe < 0.0 ? 100.0 : lighterSafe;
    }

    public static double darker(double tone, double ratio) {
        if (tone < 0.0 || tone > 100.0) {
            return -1.0;
        }
        double lightY = ColorUtils.yFromLstar(tone);
        double darkY = (lightY + 5.0) / ratio - 5.0;
        if (darkY < 0.0 || darkY > 100.0) {
            return -1.0;
        }
        double realContrast = Contrast.ratioOfYs(lightY, darkY);
        double delta = Math.abs(realContrast - ratio);
        if (realContrast < ratio && delta > 0.04) {
            return -1.0;
        }
        double returnValue = ColorUtils.lstarFromY(darkY) - 0.4;
        if (returnValue < 0.0 || returnValue > 100.0) {
            return -1.0;
        }
        return returnValue;
    }

    public static double darkerUnsafe(double tone, double ratio) {
        double darkerSafe = Contrast.darker(tone, ratio);
        return Math.max(0.0, darkerSafe);
    }
}

