/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.game;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jackhuang.hmcl.game.Argument;
import org.jackhuang.hmcl.game.CompatibilityRule;
import org.jackhuang.hmcl.game.StringArgument;
import org.jackhuang.hmcl.util.Immutable;
import org.jackhuang.hmcl.util.gson.JsonUtils;

@JsonAdapter(value=Serializer.class)
@Immutable
public class RuledArgument
implements Argument {
    private final List<CompatibilityRule> rules;
    private final List<String> value;

    public RuledArgument() {
        this(null, null);
    }

    public RuledArgument(List<CompatibilityRule> rules, List<String> args) {
        this.rules = rules;
        this.value = args;
    }

    public List<CompatibilityRule> getRules() {
        return Collections.unmodifiableList(this.rules);
    }

    public List<String> getValue() {
        return Collections.unmodifiableList(this.value);
    }

    public Object clone() {
        return new RuledArgument(this.rules == null ? null : new ArrayList<CompatibilityRule>(this.rules), (List<String>)(this.value == null ? null : new ArrayList<String>(this.value)));
    }

    @Override
    public List<String> toString(Map<String, String> keys, Map<String, Boolean> features) {
        if (CompatibilityRule.appliesToCurrentEnvironment(this.rules, features) && this.value != null) {
            return this.value.stream().filter(Objects::nonNull).map(StringArgument::new).map(str -> str.toString(keys, features).get(0)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static class Serializer
    implements JsonSerializer<RuledArgument>,
    JsonDeserializer<RuledArgument> {
        @Override
        public JsonElement serialize(RuledArgument src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject obj = new JsonObject();
            obj.add("rules", context.serialize(src.rules));
            obj.add("value", context.serialize(src.value));
            return obj;
        }

        @Override
        public RuledArgument deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonElement valuesElement;
            JsonObject obj = json.getAsJsonObject();
            List rules = (List)context.deserialize(obj.get("rules"), JsonUtils.listTypeOf(CompatibilityRule.class).getType());
            if (obj.has("values")) {
                valuesElement = obj.get("values");
            } else if (obj.has("value")) {
                valuesElement = obj.get("value");
            } else {
                throw new JsonParseException("RuledArguments instance does not have either value or values member.");
            }
            List values = valuesElement.isJsonPrimitive() ? Collections.singletonList(valuesElement.getAsString()) : (List)context.deserialize(valuesElement, JsonUtils.listTypeOf(String.class).getType());
            return new RuledArgument(rules, values);
        }
    }
}

