/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.OptionalLong;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.jackhuang.hmcl.util.logging.Logger;

public final class WindowsNativeUtils {
    public static OptionalLong getWindowHandle(Stage stage) {
        try {
            Class<?> windowStageClass = Class.forName("com.sun.javafx.tk.quantum.WindowStage");
            Class<?> glassWindowClass = Class.forName("com.sun.glass.ui.Window");
            Class<?> tkStageClass = Class.forName("com.sun.javafx.tk.TKStage");
            Object tkStage = MethodHandles.privateLookupIn(Window.class, MethodHandles.lookup()).findVirtual(Window.class, "getPeer", MethodType.methodType(tkStageClass)).invoke(stage);
            MethodHandles.Lookup windowStageLookup = MethodHandles.privateLookupIn(windowStageClass, MethodHandles.lookup());
            MethodHandle getPlatformWindow = windowStageLookup.findVirtual(windowStageClass, "getPlatformWindow", MethodType.methodType(glassWindowClass));
            Object platformWindow = getPlatformWindow.invoke(tkStage);
            long handle = MethodHandles.privateLookupIn(glassWindowClass, MethodHandles.lookup()).findVirtual(glassWindowClass, "getNativeWindow", MethodType.methodType(Long.TYPE)).invoke(platformWindow);
            return OptionalLong.of(handle);
        }
        catch (Throwable ex) {
            Logger.LOG.warning("Failed to get window handle", ex);
            return OptionalLong.empty();
        }
    }

    private WindowsNativeUtils() {
    }
}

