/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.CodeSource;
import java.util.Properties;
import org.jetbrains.annotations.Nullable;

public final class JarUtils {
    private static final Path THIS_JAR;
    private static final Properties properties;

    private JarUtils() {
    }

    @Nullable
    public static Path thisJarPath() {
        return THIS_JAR;
    }

    public static String getAttribute(String name, String defaultValue) {
        return properties.getProperty(name, defaultValue);
    }

    static {
        InputStream input;
        properties = new Properties();
        Class<?> entryPointClass = null;
        CodeSource cs = null;
        try {
            entryPointClass = Class.forName("org.jackhuang.hmcl.EntryPoint");
            cs = entryPointClass.getProtectionDomain().getCodeSource();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (cs == null) {
            THIS_JAR = null;
        } else {
            Path path;
            try {
                path = Path.of(cs.getLocation().toURI()).toAbsolutePath();
            }
            catch (IllegalArgumentException | URISyntaxException | FileSystemNotFoundException e) {
                path = null;
            }
            Path path2 = THIS_JAR = path != null && Files.isRegularFile(path, new LinkOption[0]) ? path : null;
        }
        if (entryPointClass != null && (input = entryPointClass.getResourceAsStream("/assets/hmcl.properties")) != null) {
            try (InputStreamReader reader = new InputStreamReader(input, StandardCharsets.UTF_8);){
                properties.load(reader);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

