/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import kala.compress.archivers.zip.ZipArchiveEntry;
import kala.compress.archivers.zip.ZipArchiveReader;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.io.CompressingUtils;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.platform.OperatingSystem;

public final class Unzipper {
    private final Path zipFile;
    private final Path dest;
    private boolean replaceExistentFile = false;
    private boolean terminateIfSubDirectoryNotExists = false;
    private String subDirectory = "/";
    private EntryFilter filter;
    private Charset encoding = StandardCharsets.UTF_8;

    public Unzipper(Path zipFile, Path destDir) {
        this.zipFile = zipFile;
        this.dest = destDir;
    }

    public Unzipper setReplaceExistentFile(boolean replaceExistentFile) {
        this.replaceExistentFile = replaceExistentFile;
        return this;
    }

    public Unzipper setFilter(EntryFilter filter) {
        this.filter = filter;
        return this;
    }

    public Unzipper setSubDirectory(String subDirectory) {
        this.subDirectory = FileUtils.normalizePath(subDirectory);
        return this;
    }

    public Unzipper setEncoding(Charset encoding) {
        this.encoding = encoding;
        return this;
    }

    public Unzipper setTerminateIfSubDirectoryNotExists() {
        this.terminateIfSubDirectoryNotExists = true;
        return this;
    }

    public void unzip() throws IOException {
        CopyOption[] copyOptionArray;
        Path destDir = this.dest.toAbsolutePath().normalize();
        Files.createDirectories(destDir, new FileAttribute[0]);
        if (this.replaceExistentFile) {
            CopyOption[] copyOptionArray2 = new CopyOption[1];
            copyOptionArray = copyOptionArray2;
            copyOptionArray2[0] = StandardCopyOption.REPLACE_EXISTING;
        } else {
            copyOptionArray = new CopyOption[]{};
        }
        CopyOption[] copyOptions = copyOptionArray;
        long entryCount = 0L;
        try (ZipArchiveReader reader = CompressingUtils.openZipFileWithPossibleEncoding(this.zipFile, this.encoding);){
            String pathPrefix = StringUtils.addSuffix(this.subDirectory, "/");
            for (ZipArchiveEntry entry : reader.getEntries()) {
                Path destFile;
                block27: {
                    String normalizedPath = FileUtils.normalizePath(entry.getName());
                    if (!normalizedPath.startsWith(pathPrefix)) continue;
                    String relativePath = normalizedPath.substring(pathPrefix.length());
                    destFile = destDir.resolve(relativePath).toAbsolutePath().normalize();
                    if (!destFile.startsWith(destDir)) {
                        throw new IOException("Zip entry is trying to write outside of the destination directory: " + entry.getName());
                    }
                    if (this.filter != null && !this.filter.accept(entry, destFile, relativePath)) continue;
                    ++entryCount;
                    if (entry.isDirectory()) {
                        Files.createDirectories(destFile, new FileAttribute[0]);
                        continue;
                    }
                    Files.createDirectories(destFile.getParent(), new FileAttribute[0]);
                    if (entry.isUnixSymlink()) {
                        Path targetPath;
                        String linkTarget = reader.getUnixSymlink(entry);
                        if (this.replaceExistentFile) {
                            Files.deleteIfExists(destFile);
                        }
                        try {
                            targetPath = Path.of(linkTarget, new String[0]);
                        }
                        catch (InvalidPathException e) {
                            throw new IOException("Zip entry has an invalid symlink target: " + entry.getName(), e);
                        }
                        if (!destFile.getParent().resolve(targetPath).toAbsolutePath().normalize().startsWith(destDir)) {
                            throw new IOException("Zip entry is trying to create a symlink outside of the destination directory: " + entry.getName());
                        }
                        try {
                            Files.createSymbolicLink(destFile, targetPath, new FileAttribute[0]);
                        }
                        catch (FileAlreadyExistsException fileAlreadyExistsException) {}
                        continue;
                    }
                    try (InputStream input = reader.getInputStream(entry);){
                        Files.copy(input, destFile, copyOptions);
                    }
                    catch (FileAlreadyExistsException e) {
                        if (!this.replaceExistentFile) break block27;
                        throw e;
                    }
                }
                if (entry.getUnixMode() == 0 || OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS) continue;
                Files.setPosixFilePermissions(destFile, FileUtils.parsePosixFilePermission(entry.getUnixMode()));
            }
            if (entryCount == 0L && !"/".equals(this.subDirectory) && !this.terminateIfSubDirectoryNotExists) {
                throw new NoSuchFileException("Subdirectory " + this.subDirectory + " does not exist in the zip file.");
            }
        }
    }

    @FunctionalInterface
    public static interface EntryFilter {
        public boolean accept(ZipArchiveEntry var1, Path var2, String var3) throws IOException;
    }
}

