/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.theme;

import java.util.Objects;
import org.glavo.monetfx.Brightness;
import org.glavo.monetfx.ColorScheme;
import org.glavo.monetfx.ColorSpecVersion;
import org.glavo.monetfx.ColorStyle;
import org.glavo.monetfx.Contrast;
import org.jackhuang.hmcl.theme.ThemeColor;

public final class Theme {
    public static final Theme DEFAULT = new Theme(ThemeColor.DEFAULT, Brightness.DEFAULT, ColorStyle.FIDELITY, Contrast.DEFAULT);
    private final ThemeColor primaryColorSeed;
    private final Brightness brightness;
    private final ColorStyle colorStyle;
    private final Contrast contrast;

    public Theme(ThemeColor primaryColorSeed, Brightness brightness, ColorStyle colorStyle, Contrast contrast) {
        this.primaryColorSeed = primaryColorSeed;
        this.brightness = brightness;
        this.colorStyle = colorStyle;
        this.contrast = contrast;
    }

    public ColorScheme toColorScheme() {
        return ColorScheme.newBuilder().setPrimaryColorSeed(this.primaryColorSeed.color()).setColorStyle(this.colorStyle).setBrightness(this.brightness).setSpecVersion(ColorSpecVersion.SPEC_2025).setContrast(this.contrast).build();
    }

    public ThemeColor primaryColorSeed() {
        return this.primaryColorSeed;
    }

    public Brightness brightness() {
        return this.brightness;
    }

    public ColorStyle colorStyle() {
        return this.colorStyle;
    }

    public Contrast contrast() {
        return this.contrast;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof Theme)) return false;
        Theme that = (Theme)obj;
        if (!this.primaryColorSeed.color().equals((Object)that.primaryColorSeed.color())) return false;
        if (!this.brightness.equals((Object)that.brightness)) return false;
        if (!this.colorStyle.equals((Object)that.colorStyle)) return false;
        if (!this.contrast.equals(that.contrast)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.primaryColorSeed, this.brightness, this.colorStyle, this.contrast});
    }

    public String toString() {
        return "Theme[primaryColorSeed=" + String.valueOf(this.primaryColorSeed) + ", brightness=" + String.valueOf((Object)this.brightness) + ", colorStyle=" + String.valueOf((Object)this.colorStyle) + ", contrast=" + String.valueOf(this.contrast) + "]";
    }
}

