/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.image.apng;

public class PngFilter {
    public static void undoSubFilter(byte[] bytes, int pixelStart, int pixelEnd, int filterUnit, byte[] previousRow) {
        int ai = pixelStart;
        for (int i = pixelStart + filterUnit; i < pixelEnd; ++i) {
            byte x = bytes[i];
            byte a = bytes[ai];
            bytes[i] = (byte)(x + a & 0xFF);
            ++ai;
        }
    }

    public static void undoUpFilter(byte[] bytes, int pixelStart, int pixelEnd, int filterUnit, byte[] previousRow) {
        int bi = 0;
        for (int i = pixelStart; i < pixelEnd; ++i) {
            byte x = bytes[i];
            byte b = previousRow[bi];
            bytes[i] = (byte)(x + b & 0xFF);
            ++bi;
        }
    }

    public static void undoAverageFilter(byte[] bytes, int pixelStart, int pixelEnd, int filterUnit, byte[] previousRow) {
        int ai = pixelStart - filterUnit;
        int bi = 0;
        for (int i = pixelStart; i < pixelEnd; ++i) {
            byte x = bytes[i];
            int a = ai < pixelStart ? 0 : 0xFF & bytes[ai];
            int b = 0xFF & previousRow[bi];
            int z = x + (a + b) / 2;
            bytes[i] = (byte)(0xFF & z);
            ++ai;
            ++bi;
        }
    }

    public static void undoPaethFilter(byte[] bytes, int pixelStart, int pixelEnd, int filterUnit, byte[] previousRow) {
        int ai = pixelStart - filterUnit;
        int bi = 0;
        int ci = -filterUnit;
        for (int i = pixelStart; i < pixelEnd; ++i) {
            int pc;
            int a;
            int c;
            byte x = bytes[i];
            if (ai < pixelStart) {
                c = 0;
                a = 0;
            } else {
                a = 0xFF & bytes[ai];
                c = 0xFF & previousRow[ci];
            }
            int b = 0xFF & previousRow[bi];
            int p = a + b - c;
            int pa = p >= a ? p - a : a - p;
            int pb = p >= b ? p - b : b - p;
            int n = pc = p >= c ? p - c : c - p;
            int predicted = pa <= pb && pa <= pc ? a : (pb <= pc ? b : c);
            bytes[i] = (byte)(x + predicted & 0xFF);
            ++ai;
            ++bi;
            ++ci;
        }
    }
}

