```@meta
CurrentModule = AbstractAlgebra
CollapsedDocStrings = true
DocTestSetup = AbstractAlgebra.doctestsetup()
```
# Visualization of the types of AbstractAlgebra.jl

AbstractAlgebra.jl implements a couple of abstract types which can be extended.

## Abstract parents

The following diagram shows a complete list of all abstract types in
AbstractAlgebra.jl.

```@raw html
<img src="img/parents_diagram.svg" alt="Diagram of parent types"/>
```
```@raw latex
\begin{figure}
\centering
\includegraphics[max width=\linewidth]{assets/parents_diagram.pdf}
\caption{Diagram of parent types}
\end{figure}
```
## Abstract elements

Similarly the following diagram shows a complete list of all abstract types in
AbstractAlgebra.jl.

```@raw html
<img src="img/elements_diagram.svg" alt="Diagram of element types"/>
```
```@raw latex
\begin{figure}
\centering
\includegraphics[max width=\linewidth]{assets/elements_diagram.pdf}
\caption{Diagram of element types}
\end{figure}
```
## Concrete types in AbstractAlgebra.jl

Until now we have discussed the abstract types of AbstractAlgebra.jl. Under this
subsection we will instead give some examples of concrete types in
AbstractAlgebra.jl.

In parentheses we put the types of the corresponding parent objects.

  - `Perm{<:Integer}` (`SymmetricGroup{<:Integer}`)
  - `GFElem{<:Integer}` (`GFField{<:Integer}`)

We also think of various Julia types as though they were AbstractAlgebra.jl types:

  - `BigInt` (`Integers{BigInt}`)
  - `Rational{BigInt}` (`Rationals{BigInt}`)

Then there are various types for generic constructions over a base ring. They are all
parameterised by a type `T` which is the type of the *elements* of the base ring they
are defined over.

  - `Generic.Poly{T}` (`Generic.PolyRing{T}`)
  - `Generic.MPoly{T}` (`Generic.MPolyRing{T}`)
  - `Generic.RelSeries{T}` (`Generic.RelPowerSeriesRing{T}`)
  - `Generic.AbsSeries{T}` (`Generic.AbsPowerSeriesRing{T}`)
  - `Generic.LaurentSeriesRingElem{T}` (`Generic.LaurentSeriesRing{T}`)
  - `Generic.LaurentSeriesFieldElem{T}` (`Generic.LaurentSeriesField{T}`)
  - `Generic.EuclideanRingResidueRingElem{T}` (`Generic.EuclideanRingResidueRing{T}`)
  - `Generic.FracFieldElem{T}` (`Generic.FracField{T}`)
  - `Generic.Mat{T}` (`MatSpace{T}`)
