# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: chatbot
using AWS.Compat
using AWS.UUIDs

"""
    create_chime_webhook_configuration(configuration_name, iam_role_arn, sns_topic_arns, webhook_description, webhook_url)
    create_chime_webhook_configuration(configuration_name, iam_role_arn, sns_topic_arns, webhook_description, webhook_url, params::Dict{String,<:Any})

Creates Chime Webhook Configuration

# Arguments
- `configuration_name`: The name of the configuration.
- `iam_role_arn`: This is a user-defined role that AWS Chatbot will assume. This is not the
  service-linked role. For more information, see IAM Policies for AWS Chatbot.
- `sns_topic_arns`: The ARNs of the SNS topics that deliver notifications to AWS Chatbot.
- `webhook_description`: Description of the webhook. Recommend using the convention
  `RoomName/WebhookName`. See Chime setup tutorial for more details:
  https://docs.aws.amazon.com/chatbot/latest/adminguide/chime-setup.html.
- `webhook_url`: URL for the Chime webhook.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"LoggingLevel"`: Logging levels include ERROR, INFO, or NONE.
- `"Tags"`: A list of tags to apply to the configuration.
"""
function create_chime_webhook_configuration(
    ConfigurationName,
    IamRoleArn,
    SnsTopicArns,
    WebhookDescription,
    WebhookUrl;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chatbot(
        "POST",
        "/create-chime-webhook-configuration",
        Dict{String,Any}(
            "ConfigurationName" => ConfigurationName,
            "IamRoleArn" => IamRoleArn,
            "SnsTopicArns" => SnsTopicArns,
            "WebhookDescription" => WebhookDescription,
            "WebhookUrl" => WebhookUrl,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_chime_webhook_configuration(
    ConfigurationName,
    IamRoleArn,
    SnsTopicArns,
    WebhookDescription,
    WebhookUrl,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chatbot(
        "POST",
        "/create-chime-webhook-configuration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ConfigurationName" => ConfigurationName,
                    "IamRoleArn" => IamRoleArn,
                    "SnsTopicArns" => SnsTopicArns,
                    "WebhookDescription" => WebhookDescription,
                    "WebhookUrl" => WebhookUrl,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_microsoft_teams_channel_configuration(channel_id, configuration_name, iam_role_arn, team_id, tenant_id)
    create_microsoft_teams_channel_configuration(channel_id, configuration_name, iam_role_arn, team_id, tenant_id, params::Dict{String,<:Any})

Creates MS Teams Channel Configuration

# Arguments
- `channel_id`: The ID of the Microsoft Teams channel.
- `configuration_name`: The name of the configuration.
- `iam_role_arn`: The ARN of the IAM role that defines the permissions for AWS Chatbot.
  This is a user-defined role that AWS Chatbot will assume. This is not the service-linked
  role. For more information, see IAM Policies for AWS Chatbot.
- `team_id`: The ID of the Microsoft Team authorized with AWS Chatbot. To get the team ID,
  you must perform the initial authorization flow with Microsoft Teams in the AWS Chatbot
  console. Then you can copy and paste the team ID from the console. For more details, see
  steps 1-4 in Get started with Microsoft Teams in the AWS Chatbot Administrator Guide.
- `tenant_id`: The ID of the Microsoft Teams tenant.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ChannelName"`: The name of the Microsoft Teams channel.
- `"GuardrailPolicyArns"`: The list of IAM policy ARNs that are applied as channel
  guardrails. The AWS managed 'AdministratorAccess' policy is applied by default if this is
  not set.
- `"LoggingLevel"`: Logging levels include ERROR, INFO, or NONE.
- `"SnsTopicArns"`: The ARNs of the SNS topics that deliver notifications to AWS Chatbot.
- `"Tags"`: A list of tags to apply to the configuration.
- `"TeamName"`: The name of the Microsoft Teams Team.
- `"UserAuthorizationRequired"`: Enables use of a user role requirement in your chat
  configuration.
"""
function create_microsoft_teams_channel_configuration(
    ChannelId,
    ConfigurationName,
    IamRoleArn,
    TeamId,
    TenantId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chatbot(
        "POST",
        "/create-ms-teams-channel-configuration",
        Dict{String,Any}(
            "ChannelId" => ChannelId,
            "ConfigurationName" => ConfigurationName,
            "IamRoleArn" => IamRoleArn,
            "TeamId" => TeamId,
            "TenantId" => TenantId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_microsoft_teams_channel_configuration(
    ChannelId,
    ConfigurationName,
    IamRoleArn,
    TeamId,
    TenantId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chatbot(
        "POST",
        "/create-ms-teams-channel-configuration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ChannelId" => ChannelId,
                    "ConfigurationName" => ConfigurationName,
                    "IamRoleArn" => IamRoleArn,
                    "TeamId" => TeamId,
                    "TenantId" => TenantId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_slack_channel_configuration(configuration_name, iam_role_arn, slack_channel_id, slack_team_id)
    create_slack_channel_configuration(configuration_name, iam_role_arn, slack_channel_id, slack_team_id, params::Dict{String,<:Any})

Creates Slack Channel Configuration

# Arguments
- `configuration_name`: The name of the configuration.
- `iam_role_arn`: The ARN of the IAM role that defines the permissions for AWS Chatbot.
  This is a user-defined role that AWS Chatbot will assume. This is not the service-linked
  role. For more information, see IAM Policies for AWS Chatbot.
- `slack_channel_id`: The ID of the Slack channel. To get the ID, open Slack, right click
  on the channel name in the left pane, then choose Copy Link. The channel ID is the
  9-character string at the end of the URL. For example, ABCBBLZZZ.
- `slack_team_id`: The ID of the Slack workspace authorized with AWS Chatbot.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"GuardrailPolicyArns"`: The list of IAM policy ARNs that are applied as channel
  guardrails. The AWS managed 'AdministratorAccess' policy is applied by default if this is
  not set.
- `"LoggingLevel"`: Logging levels include ERROR, INFO, or NONE.
- `"SlackChannelName"`: The name of the Slack Channel.
- `"SnsTopicArns"`: The ARNs of the SNS topics that deliver notifications to AWS Chatbot.
- `"Tags"`: A list of tags to apply to the configuration.
- `"UserAuthorizationRequired"`: Enables use of a user role requirement in your chat
  configuration.
"""
function create_slack_channel_configuration(
    ConfigurationName,
    IamRoleArn,
    SlackChannelId,
    SlackTeamId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chatbot(
        "POST",
        "/create-slack-channel-configuration",
        Dict{String,Any}(
            "ConfigurationName" => ConfigurationName,
            "IamRoleArn" => IamRoleArn,
            "SlackChannelId" => SlackChannelId,
            "SlackTeamId" => SlackTeamId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_slack_channel_configuration(
    ConfigurationName,
    IamRoleArn,
    SlackChannelId,
    SlackTeamId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chatbot(
        "POST",
        "/create-slack-channel-configuration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ConfigurationName" => ConfigurationName,
                    "IamRoleArn" => IamRoleArn,
                    "SlackChannelId" => SlackChannelId,
                    "SlackTeamId" => SlackTeamId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_chime_webhook_configuration(chat_configuration_arn)
    delete_chime_webhook_configuration(chat_configuration_arn, params::Dict{String,<:Any})

Deletes a Chime Webhook Configuration

# Arguments
- `chat_configuration_arn`: The ARN of the ChimeWebhookConfiguration to delete.

"""
function delete_chime_webhook_configuration(
    ChatConfigurationArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chatbot(
        "POST",
        "/delete-chime-webhook-configuration",
        Dict{String,Any}("ChatConfigurationArn" => ChatConfigurationArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_chime_webhook_configuration(
    ChatConfigurationArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chatbot(
        "POST",
        "/delete-chime-webhook-configuration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ChatConfigurationArn" => ChatConfigurationArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_microsoft_teams_channel_configuration(chat_configuration_arn)
    delete_microsoft_teams_channel_configuration(chat_configuration_arn, params::Dict{String,<:Any})

Deletes MS Teams Channel Configuration

# Arguments
- `chat_configuration_arn`: The ARN of the MicrosoftTeamsChannelConfiguration to delete.

"""
function delete_microsoft_teams_channel_configuration(
    ChatConfigurationArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chatbot(
        "POST",
        "/delete-ms-teams-channel-configuration",
        Dict{String,Any}("ChatConfigurationArn" => ChatConfigurationArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_microsoft_teams_channel_configuration(
    ChatConfigurationArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chatbot(
        "POST",
        "/delete-ms-teams-channel-configuration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ChatConfigurationArn" => ChatConfigurationArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_microsoft_teams_configured_team(team_id)
    delete_microsoft_teams_configured_team(team_id, params::Dict{String,<:Any})

Deletes the Microsoft Teams team authorization allowing for channels to be configured in
that Microsoft Teams team. Note that the Microsoft Teams team must have no channels
configured to remove it.

# Arguments
- `team_id`: The ID of the Microsoft Team authorized with AWS Chatbot. To get the team ID,
  you must perform the initial authorization flow with Microsoft Teams in the AWS Chatbot
  console. Then you can copy and paste the team ID from the console. For more details, see
  steps 1-4 in Get started with Microsoft Teams in the AWS Chatbot Administrator Guide.

"""
function delete_microsoft_teams_configured_team(
    TeamId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chatbot(
        "POST",
        "/delete-ms-teams-configured-teams",
        Dict{String,Any}("TeamId" => TeamId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_microsoft_teams_configured_team(
    TeamId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chatbot(
        "POST",
        "/delete-ms-teams-configured-teams",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("TeamId" => TeamId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_microsoft_teams_user_identity(chat_configuration_arn, user_id)
    delete_microsoft_teams_user_identity(chat_configuration_arn, user_id, params::Dict{String,<:Any})

Deletes a Teams user identity

# Arguments
- `chat_configuration_arn`: The ARN of the MicrosoftTeamsChannelConfiguration associated
  with the user identity to delete.
- `user_id`: Id from Microsoft Teams for user.

"""
function delete_microsoft_teams_user_identity(
    ChatConfigurationArn, UserId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chatbot(
        "POST",
        "/delete-ms-teams-user-identity",
        Dict{String,Any}(
            "ChatConfigurationArn" => ChatConfigurationArn, "UserId" => UserId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_microsoft_teams_user_identity(
    ChatConfigurationArn,
    UserId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chatbot(
        "POST",
        "/delete-ms-teams-user-identity",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ChatConfigurationArn" => ChatConfigurationArn, "UserId" => UserId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_slack_channel_configuration(chat_configuration_arn)
    delete_slack_channel_configuration(chat_configuration_arn, params::Dict{String,<:Any})

Deletes Slack Channel Configuration

# Arguments
- `chat_configuration_arn`: The ARN of the SlackChannelConfiguration to delete.

"""
function delete_slack_channel_configuration(
    ChatConfigurationArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chatbot(
        "POST",
        "/delete-slack-channel-configuration",
        Dict{String,Any}("ChatConfigurationArn" => ChatConfigurationArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_slack_channel_configuration(
    ChatConfigurationArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chatbot(
        "POST",
        "/delete-slack-channel-configuration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ChatConfigurationArn" => ChatConfigurationArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_slack_user_identity(chat_configuration_arn, slack_team_id, slack_user_id)
    delete_slack_user_identity(chat_configuration_arn, slack_team_id, slack_user_id, params::Dict{String,<:Any})

Deletes a Slack user identity

# Arguments
- `chat_configuration_arn`: The ARN of the SlackChannelConfiguration associated with the
  user identity to delete.
- `slack_team_id`: The ID of the Slack workspace authorized with AWS Chatbot.
- `slack_user_id`: The ID of the user in Slack.

"""
function delete_slack_user_identity(
    ChatConfigurationArn,
    SlackTeamId,
    SlackUserId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chatbot(
        "POST",
        "/delete-slack-user-identity",
        Dict{String,Any}(
            "ChatConfigurationArn" => ChatConfigurationArn,
            "SlackTeamId" => SlackTeamId,
            "SlackUserId" => SlackUserId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_slack_user_identity(
    ChatConfigurationArn,
    SlackTeamId,
    SlackUserId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chatbot(
        "POST",
        "/delete-slack-user-identity",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ChatConfigurationArn" => ChatConfigurationArn,
                    "SlackTeamId" => SlackTeamId,
                    "SlackUserId" => SlackUserId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_slack_workspace_authorization(slack_team_id)
    delete_slack_workspace_authorization(slack_team_id, params::Dict{String,<:Any})

Deletes the Slack workspace authorization that allows channels to be configured in that
workspace. This requires all configured channels in the workspace to be deleted.

# Arguments
- `slack_team_id`: The ID of the Slack workspace authorized with AWS Chatbot.

"""
function delete_slack_workspace_authorization(
    SlackTeamId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chatbot(
        "POST",
        "/delete-slack-workspace-authorization",
        Dict{String,Any}("SlackTeamId" => SlackTeamId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_slack_workspace_authorization(
    SlackTeamId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chatbot(
        "POST",
        "/delete-slack-workspace-authorization",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("SlackTeamId" => SlackTeamId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_chime_webhook_configurations()
    describe_chime_webhook_configurations(params::Dict{String,<:Any})

Lists Chime Webhook Configurations optionally filtered by ChatConfigurationArn

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ChatConfigurationArn"`: An optional ARN of a ChimeWebhookConfiguration to describe.
- `"MaxResults"`: The maximum number of results to include in the response. If more results
  exist than the specified MaxResults value, a token is included in the response so that the
  remaining results can be retrieved.
- `"NextToken"`: An optional token returned from a prior request. Use this token for
  pagination of results from this action. If this parameter is specified, the response
  includes only results beyond the token, up to the value specified by MaxResults.
"""
function describe_chime_webhook_configurations(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return chatbot(
        "POST",
        "/describe-chime-webhook-configurations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_chime_webhook_configurations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chatbot(
        "POST",
        "/describe-chime-webhook-configurations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_slack_channel_configurations()
    describe_slack_channel_configurations(params::Dict{String,<:Any})

Lists Slack Channel Configurations optionally filtered by ChatConfigurationArn

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ChatConfigurationArn"`: An optional ARN of a SlackChannelConfiguration to describe.
- `"MaxResults"`: The maximum number of results to include in the response. If more results
  exist than the specified MaxResults value, a token is included in the response so that the
  remaining results can be retrieved.
- `"NextToken"`: An optional token returned from a prior request. Use this token for
  pagination of results from this action. If this parameter is specified, the response
  includes only results beyond the token, up to the value specified by MaxResults.
"""
function describe_slack_channel_configurations(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return chatbot(
        "POST",
        "/describe-slack-channel-configurations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_slack_channel_configurations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chatbot(
        "POST",
        "/describe-slack-channel-configurations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_slack_user_identities()
    describe_slack_user_identities(params::Dict{String,<:Any})

Lists all Slack user identities with a mapped role.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ChatConfigurationArn"`: The ARN of the SlackChannelConfiguration associated with the
  user identities to describe.
- `"MaxResults"`: The maximum number of results to include in the response. If more results
  exist than the specified MaxResults value, a token is included in the response so that the
  remaining results can be retrieved.
- `"NextToken"`: An optional token returned from a prior request. Use this token for
  pagination of results from this action. If this parameter is specified, the response
  includes only results beyond the token, up to the value specified by MaxResults.
"""
function describe_slack_user_identities(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return chatbot(
        "POST",
        "/describe-slack-user-identities";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_slack_user_identities(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chatbot(
        "POST",
        "/describe-slack-user-identities",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_slack_workspaces()
    describe_slack_workspaces(params::Dict{String,<:Any})

Lists all authorized Slack Workspaces for AWS Account

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of results to include in the response. If more results
  exist than the specified MaxResults value, a token is included in the response so that the
  remaining results can be retrieved.
- `"NextToken"`: An optional token returned from a prior request. Use this token for
  pagination of results from this action. If this parameter is specified, the response
  includes only results beyond the token, up to the value specified by MaxResults.
"""
function describe_slack_workspaces(; aws_config::AbstractAWSConfig=current_aws_config())
    return chatbot(
        "POST",
        "/describe-slack-workspaces";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_slack_workspaces(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chatbot(
        "POST",
        "/describe-slack-workspaces",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_account_preferences()
    get_account_preferences(params::Dict{String,<:Any})

Get Chatbot account level preferences

"""
function get_account_preferences(; aws_config::AbstractAWSConfig=current_aws_config())
    return chatbot(
        "POST",
        "/get-account-preferences";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_account_preferences(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chatbot(
        "POST",
        "/get-account-preferences",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_microsoft_teams_channel_configuration(chat_configuration_arn)
    get_microsoft_teams_channel_configuration(chat_configuration_arn, params::Dict{String,<:Any})

Get a single MS Teams Channel Configurations

# Arguments
- `chat_configuration_arn`: The ARN of the MicrosoftTeamsChannelConfiguration to retrieve.

"""
function get_microsoft_teams_channel_configuration(
    ChatConfigurationArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chatbot(
        "POST",
        "/get-ms-teams-channel-configuration",
        Dict{String,Any}("ChatConfigurationArn" => ChatConfigurationArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_microsoft_teams_channel_configuration(
    ChatConfigurationArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chatbot(
        "POST",
        "/get-ms-teams-channel-configuration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ChatConfigurationArn" => ChatConfigurationArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_microsoft_teams_channel_configurations()
    list_microsoft_teams_channel_configurations(params::Dict{String,<:Any})

Lists MS Teams Channel Configurations optionally filtered by TeamId

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of results to include in the response. If more results
  exist than the specified MaxResults value, a token is included in the response so that the
  remaining results can be retrieved.
- `"NextToken"`: An optional token returned from a prior request. Use this token for
  pagination of results from this action. If this parameter is specified, the response
  includes only results beyond the token, up to the value specified by MaxResults.
- `"TeamId"`: The ID of the Microsoft Team authorized with AWS Chatbot. To get the team ID,
  you must perform the initial authorization flow with Microsoft Teams in the AWS Chatbot
  console. Then you can copy and paste the team ID from the console. For more details, see
  steps 1-4 in Get started with Microsoft Teams in the AWS Chatbot Administrator Guide.
"""
function list_microsoft_teams_channel_configurations(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return chatbot(
        "POST",
        "/list-ms-teams-channel-configurations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_microsoft_teams_channel_configurations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chatbot(
        "POST",
        "/list-ms-teams-channel-configurations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_microsoft_teams_configured_teams()
    list_microsoft_teams_configured_teams(params::Dict{String,<:Any})

Lists all authorized MS teams for AWS Account

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of results to include in the response. If more results
  exist than the specified MaxResults value, a token is included in the response so that the
  remaining results can be retrieved.
- `"NextToken"`: An optional token returned from a prior request. Use this token for
  pagination of results from this action. If this parameter is specified, the response
  includes only results beyond the token, up to the value specified by MaxResults.
"""
function list_microsoft_teams_configured_teams(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return chatbot(
        "POST",
        "/list-ms-teams-configured-teams";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_microsoft_teams_configured_teams(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chatbot(
        "POST",
        "/list-ms-teams-configured-teams",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_microsoft_teams_user_identities()
    list_microsoft_teams_user_identities(params::Dict{String,<:Any})

Lists all Microsoft Teams user identities with a mapped role.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ChatConfigurationArn"`: The ARN of the MicrosoftTeamsChannelConfiguration associated
  with the user identities to list.
- `"MaxResults"`: The maximum number of results to include in the response. If more results
  exist than the specified MaxResults value, a token is included in the response so that the
  remaining results can be retrieved.
- `"NextToken"`: An optional token returned from a prior request. Use this token for
  pagination of results from this action. If this parameter is specified, the response
  includes only results beyond the token, up to the value specified by MaxResults.
"""
function list_microsoft_teams_user_identities(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return chatbot(
        "POST",
        "/list-ms-teams-user-identities";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_microsoft_teams_user_identities(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chatbot(
        "POST",
        "/list-ms-teams-user-identities",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Retrieves the list of tags applied to a configuration.

# Arguments
- `resource_arn`: The ARN of the configuration.

"""
function list_tags_for_resource(
    ResourceARN; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chatbot(
        "POST",
        "/list-tags-for-resource",
        Dict{String,Any}("ResourceARN" => ResourceARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    ResourceARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chatbot(
        "POST",
        "/list-tags-for-resource",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceARN" => ResourceARN), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Applies the supplied tags to a configuration.

# Arguments
- `resource_arn`: The ARN of the configuration.
- `tags`: A list of tags to apply to the configuration.

"""
function tag_resource(ResourceARN, Tags; aws_config::AbstractAWSConfig=current_aws_config())
    return chatbot(
        "POST",
        "/tag-resource",
        Dict{String,Any}("ResourceARN" => ResourceARN, "Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    ResourceARN,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chatbot(
        "POST",
        "/tag-resource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceARN" => ResourceARN, "Tags" => Tags),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Removes the supplied tags from a configuration

# Arguments
- `resource_arn`: The ARN of the configuration.
- `tag_keys`: A list of tag keys to remove from the configuration.

"""
function untag_resource(
    ResourceARN, TagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chatbot(
        "POST",
        "/untag-resource",
        Dict{String,Any}("ResourceARN" => ResourceARN, "TagKeys" => TagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    ResourceARN,
    TagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chatbot(
        "POST",
        "/untag-resource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceARN" => ResourceARN, "TagKeys" => TagKeys),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_account_preferences()
    update_account_preferences(params::Dict{String,<:Any})

Update Chatbot account level preferences

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"TrainingDataCollectionEnabled"`: Turns on training data collection. This helps improve
  the AWS Chatbot experience by allowing AWS Chatbot to store and use your customer
  information, such as AWS Chatbot configurations, notifications, user inputs, AWS Chatbot
  generated responses, and interaction data. This data helps us to continuously improve and
  develop Artificial Intelligence (AI) technologies. Your data is not shared with any third
  parties and is protected using sophisticated controls to prevent unauthorized access and
  misuse. AWS Chatbot does not store or use interactions in chat channels with Amazon Q for
  training AWS Chatbot’s AI technologies.
- `"UserAuthorizationRequired"`: Enables use of a user role requirement in your chat
  configuration.
"""
function update_account_preferences(; aws_config::AbstractAWSConfig=current_aws_config())
    return chatbot(
        "POST",
        "/update-account-preferences";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_account_preferences(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chatbot(
        "POST",
        "/update-account-preferences",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_chime_webhook_configuration(chat_configuration_arn)
    update_chime_webhook_configuration(chat_configuration_arn, params::Dict{String,<:Any})

Updates a Chime Webhook Configuration

# Arguments
- `chat_configuration_arn`: The ARN of the ChimeWebhookConfiguration to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"IamRoleArn"`: The ARN of the IAM role that defines the permissions for AWS Chatbot.
  This is a user-defined role that AWS Chatbot will assume. This is not the service-linked
  role. For more information, see IAM Policies for AWS Chatbot.
- `"LoggingLevel"`: Logging levels include ERROR, INFO, or NONE.
- `"SnsTopicArns"`: The ARNs of the SNS topics that deliver notifications to AWS Chatbot.
- `"WebhookDescription"`: Description of the webhook. Recommend using the convention
  `RoomName/WebhookName`. See Chime setup tutorial for more details:
  https://docs.aws.amazon.com/chatbot/latest/adminguide/chime-setup.html.
- `"WebhookUrl"`: URL for the Chime webhook.
"""
function update_chime_webhook_configuration(
    ChatConfigurationArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chatbot(
        "POST",
        "/update-chime-webhook-configuration",
        Dict{String,Any}("ChatConfigurationArn" => ChatConfigurationArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_chime_webhook_configuration(
    ChatConfigurationArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chatbot(
        "POST",
        "/update-chime-webhook-configuration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ChatConfigurationArn" => ChatConfigurationArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_microsoft_teams_channel_configuration(channel_id, chat_configuration_arn)
    update_microsoft_teams_channel_configuration(channel_id, chat_configuration_arn, params::Dict{String,<:Any})

Updates MS Teams Channel Configuration

# Arguments
- `channel_id`: The ID of the Microsoft Teams channel.
- `chat_configuration_arn`: The ARN of the MicrosoftTeamsChannelConfiguration to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ChannelName"`: The name of the Microsoft Teams channel.
- `"GuardrailPolicyArns"`: The list of IAM policy ARNs that are applied as channel
  guardrails. The AWS managed 'AdministratorAccess' policy is applied by default if this is
  not set.
- `"IamRoleArn"`: The ARN of the IAM role that defines the permissions for AWS Chatbot.
  This is a user-defined role that AWS Chatbot will assume. This is not the service-linked
  role. For more information, see IAM Policies for AWS Chatbot.
- `"LoggingLevel"`: Logging levels include ERROR, INFO, or NONE.
- `"SnsTopicArns"`: The ARNs of the SNS topics that deliver notifications to AWS Chatbot.
- `"UserAuthorizationRequired"`: Enables use of a user role requirement in your chat
  configuration.
"""
function update_microsoft_teams_channel_configuration(
    ChannelId, ChatConfigurationArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chatbot(
        "POST",
        "/update-ms-teams-channel-configuration",
        Dict{String,Any}(
            "ChannelId" => ChannelId, "ChatConfigurationArn" => ChatConfigurationArn
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_microsoft_teams_channel_configuration(
    ChannelId,
    ChatConfigurationArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chatbot(
        "POST",
        "/update-ms-teams-channel-configuration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ChannelId" => ChannelId, "ChatConfigurationArn" => ChatConfigurationArn
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_slack_channel_configuration(chat_configuration_arn, slack_channel_id)
    update_slack_channel_configuration(chat_configuration_arn, slack_channel_id, params::Dict{String,<:Any})

Updates Slack Channel Configuration

# Arguments
- `chat_configuration_arn`: The ARN of the SlackChannelConfiguration to update.
- `slack_channel_id`: The ID of the Slack channel. To get the ID, open Slack, right click
  on the channel name in the left pane, then choose Copy Link. The channel ID is the
  9-character string at the end of the URL. For example, ABCBBLZZZ.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"GuardrailPolicyArns"`: The list of IAM policy ARNs that are applied as channel
  guardrails. The AWS managed 'AdministratorAccess' policy is applied by default if this is
  not set.
- `"IamRoleArn"`: The ARN of the IAM role that defines the permissions for AWS Chatbot.
  This is a user-defined role that AWS Chatbot will assume. This is not the service-linked
  role. For more information, see IAM Policies for AWS Chatbot.
- `"LoggingLevel"`: Logging levels include ERROR, INFO, or NONE.
- `"SlackChannelName"`: The name of the Slack Channel.
- `"SnsTopicArns"`: The ARNs of the SNS topics that deliver notifications to AWS Chatbot.
- `"UserAuthorizationRequired"`: Enables use of a user role requirement in your chat
  configuration.
"""
function update_slack_channel_configuration(
    ChatConfigurationArn, SlackChannelId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chatbot(
        "POST",
        "/update-slack-channel-configuration",
        Dict{String,Any}(
            "ChatConfigurationArn" => ChatConfigurationArn,
            "SlackChannelId" => SlackChannelId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_slack_channel_configuration(
    ChatConfigurationArn,
    SlackChannelId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chatbot(
        "POST",
        "/update-slack-channel-configuration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ChatConfigurationArn" => ChatConfigurationArn,
                    "SlackChannelId" => SlackChannelId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
