# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: config_service
using AWS.Compat
using AWS.UUIDs

"""
    batch_get_aggregate_resource_config(configuration_aggregator_name, resource_identifiers)
    batch_get_aggregate_resource_config(configuration_aggregator_name, resource_identifiers, params::Dict{String,<:Any})

Returns the current configuration items for resources that are present in your Config
aggregator. The operation also returns a list of resources that are not processed in the
current request. If there are no unprocessed resources, the operation returns an empty
unprocessedResourceIdentifiers list.     The API does not return results for deleted
resources.    The API does not return tags and relationships.

# Arguments
- `configuration_aggregator_name`: The name of the configuration aggregator.
- `resource_identifiers`: A list of aggregate ResourceIdentifiers objects.

"""
function batch_get_aggregate_resource_config(
    ConfigurationAggregatorName,
    ResourceIdentifiers;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "BatchGetAggregateResourceConfig",
        Dict{String,Any}(
            "ConfigurationAggregatorName" => ConfigurationAggregatorName,
            "ResourceIdentifiers" => ResourceIdentifiers,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_get_aggregate_resource_config(
    ConfigurationAggregatorName,
    ResourceIdentifiers,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "BatchGetAggregateResourceConfig",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ConfigurationAggregatorName" => ConfigurationAggregatorName,
                    "ResourceIdentifiers" => ResourceIdentifiers,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_get_resource_config(resource_keys)
    batch_get_resource_config(resource_keys, params::Dict{String,<:Any})

Returns the BaseConfigurationItem for one or more requested resources. The operation also
returns a list of resources that are not processed in the current request. If there are no
unprocessed resources, the operation returns an empty unprocessedResourceKeys list.     The
API does not return results for deleted resources.    The API does not return any tags for
the requested resources. This information is filtered out of the supplementaryConfiguration
section of the API response.

# Arguments
- `resource_keys`: A list of resource keys to be processed with the current request. Each
  element in the list consists of the resource type and resource ID.

"""
function batch_get_resource_config(
    resourceKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "BatchGetResourceConfig",
        Dict{String,Any}("resourceKeys" => resourceKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_get_resource_config(
    resourceKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "BatchGetResourceConfig",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("resourceKeys" => resourceKeys), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_aggregation_authorization(authorized_account_id, authorized_aws_region)
    delete_aggregation_authorization(authorized_account_id, authorized_aws_region, params::Dict{String,<:Any})

Deletes the authorization granted to the specified configuration aggregator account in a
specified region.

# Arguments
- `authorized_account_id`: The 12-digit account ID of the account authorized to aggregate
  data.
- `authorized_aws_region`: The region authorized to collect aggregated data.

"""
function delete_aggregation_authorization(
    AuthorizedAccountId,
    AuthorizedAwsRegion;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "DeleteAggregationAuthorization",
        Dict{String,Any}(
            "AuthorizedAccountId" => AuthorizedAccountId,
            "AuthorizedAwsRegion" => AuthorizedAwsRegion,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_aggregation_authorization(
    AuthorizedAccountId,
    AuthorizedAwsRegion,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "DeleteAggregationAuthorization",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AuthorizedAccountId" => AuthorizedAccountId,
                    "AuthorizedAwsRegion" => AuthorizedAwsRegion,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_config_rule(config_rule_name)
    delete_config_rule(config_rule_name, params::Dict{String,<:Any})

Deletes the specified Config rule and all of its evaluation results. Config sets the state
of a rule to DELETING until the deletion is complete. You cannot update a rule while it is
in this state. If you make a PutConfigRule or DeleteConfigRule request for the rule, you
will receive a ResourceInUseException. You can check the state of a rule by using the
DescribeConfigRules request.

# Arguments
- `config_rule_name`: The name of the Config rule that you want to delete.

"""
function delete_config_rule(
    ConfigRuleName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "DeleteConfigRule",
        Dict{String,Any}("ConfigRuleName" => ConfigRuleName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_config_rule(
    ConfigRuleName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "DeleteConfigRule",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ConfigRuleName" => ConfigRuleName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_configuration_aggregator(configuration_aggregator_name)
    delete_configuration_aggregator(configuration_aggregator_name, params::Dict{String,<:Any})

Deletes the specified configuration aggregator and the aggregated data associated with the
aggregator.

# Arguments
- `configuration_aggregator_name`: The name of the configuration aggregator.

"""
function delete_configuration_aggregator(
    ConfigurationAggregatorName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "DeleteConfigurationAggregator",
        Dict{String,Any}("ConfigurationAggregatorName" => ConfigurationAggregatorName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_configuration_aggregator(
    ConfigurationAggregatorName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "DeleteConfigurationAggregator",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ConfigurationAggregatorName" => ConfigurationAggregatorName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_configuration_recorder(configuration_recorder_name)
    delete_configuration_recorder(configuration_recorder_name, params::Dict{String,<:Any})

Deletes the configuration recorder. After the configuration recorder is deleted, Config
will not record resource configuration changes until you create a new configuration
recorder. This action does not delete the configuration information that was previously
recorded. You will be able to access the previously recorded information by using the
GetResourceConfigHistory action, but you will not be able to access this information in the
Config console until you create a new configuration recorder.

# Arguments
- `configuration_recorder_name`: The name of the configuration recorder to be deleted. You
  can retrieve the name of your configuration recorder by using the
  DescribeConfigurationRecorders action.

"""
function delete_configuration_recorder(
    ConfigurationRecorderName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "DeleteConfigurationRecorder",
        Dict{String,Any}("ConfigurationRecorderName" => ConfigurationRecorderName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_configuration_recorder(
    ConfigurationRecorderName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "DeleteConfigurationRecorder",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ConfigurationRecorderName" => ConfigurationRecorderName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_conformance_pack(conformance_pack_name)
    delete_conformance_pack(conformance_pack_name, params::Dict{String,<:Any})

Deletes the specified conformance pack and all the Config rules, remediation actions, and
all evaluation results within that conformance pack. Config sets the conformance pack to
DELETE_IN_PROGRESS until the deletion is complete. You cannot update a conformance pack
while it is in this state.

# Arguments
- `conformance_pack_name`: Name of the conformance pack you want to delete.

"""
function delete_conformance_pack(
    ConformancePackName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "DeleteConformancePack",
        Dict{String,Any}("ConformancePackName" => ConformancePackName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_conformance_pack(
    ConformancePackName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "DeleteConformancePack",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ConformancePackName" => ConformancePackName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_delivery_channel(delivery_channel_name)
    delete_delivery_channel(delivery_channel_name, params::Dict{String,<:Any})

Deletes the delivery channel. Before you can delete the delivery channel, you must stop the
configuration recorder by using the StopConfigurationRecorder action.

# Arguments
- `delivery_channel_name`: The name of the delivery channel to delete.

"""
function delete_delivery_channel(
    DeliveryChannelName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "DeleteDeliveryChannel",
        Dict{String,Any}("DeliveryChannelName" => DeliveryChannelName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_delivery_channel(
    DeliveryChannelName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "DeleteDeliveryChannel",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DeliveryChannelName" => DeliveryChannelName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_evaluation_results(config_rule_name)
    delete_evaluation_results(config_rule_name, params::Dict{String,<:Any})

Deletes the evaluation results for the specified Config rule. You can specify one Config
rule per request. After you delete the evaluation results, you can call the
StartConfigRulesEvaluation API to start evaluating your Amazon Web Services resources
against the rule.

# Arguments
- `config_rule_name`: The name of the Config rule for which you want to delete the
  evaluation results.

"""
function delete_evaluation_results(
    ConfigRuleName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "DeleteEvaluationResults",
        Dict{String,Any}("ConfigRuleName" => ConfigRuleName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_evaluation_results(
    ConfigRuleName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "DeleteEvaluationResults",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ConfigRuleName" => ConfigRuleName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_organization_config_rule(organization_config_rule_name)
    delete_organization_config_rule(organization_config_rule_name, params::Dict{String,<:Any})

Deletes the specified organization Config rule and all of its evaluation results from all
member accounts in that organization.  Only a management account and a delegated
administrator account can delete an organization Config rule. When calling this API with a
delegated administrator, you must ensure Organizations ListDelegatedAdministrator
permissions are added. Config sets the state of a rule to DELETE_IN_PROGRESS until the
deletion is complete. You cannot update a rule while it is in this state.

# Arguments
- `organization_config_rule_name`: The name of organization Config rule that you want to
  delete.

"""
function delete_organization_config_rule(
    OrganizationConfigRuleName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "DeleteOrganizationConfigRule",
        Dict{String,Any}("OrganizationConfigRuleName" => OrganizationConfigRuleName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_organization_config_rule(
    OrganizationConfigRuleName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "DeleteOrganizationConfigRule",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "OrganizationConfigRuleName" => OrganizationConfigRuleName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_organization_conformance_pack(organization_conformance_pack_name)
    delete_organization_conformance_pack(organization_conformance_pack_name, params::Dict{String,<:Any})

Deletes the specified organization conformance pack and all of the Config rules and
remediation actions from all member accounts in that organization.   Only a management
account or a delegated administrator account can delete an organization conformance pack.
When calling this API with a delegated administrator, you must ensure Organizations
ListDelegatedAdministrator permissions are added. Config sets the state of a conformance
pack to DELETE_IN_PROGRESS until the deletion is complete. You cannot update a conformance
pack while it is in this state.

# Arguments
- `organization_conformance_pack_name`: The name of organization conformance pack that you
  want to delete.

"""
function delete_organization_conformance_pack(
    OrganizationConformancePackName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "DeleteOrganizationConformancePack",
        Dict{String,Any}(
            "OrganizationConformancePackName" => OrganizationConformancePackName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_organization_conformance_pack(
    OrganizationConformancePackName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "DeleteOrganizationConformancePack",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "OrganizationConformancePackName" => OrganizationConformancePackName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_pending_aggregation_request(requester_account_id, requester_aws_region)
    delete_pending_aggregation_request(requester_account_id, requester_aws_region, params::Dict{String,<:Any})

Deletes pending authorization requests for a specified aggregator account in a specified
region.

# Arguments
- `requester_account_id`: The 12-digit account ID of the account requesting to aggregate
  data.
- `requester_aws_region`: The region requesting to aggregate data.

"""
function delete_pending_aggregation_request(
    RequesterAccountId,
    RequesterAwsRegion;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "DeletePendingAggregationRequest",
        Dict{String,Any}(
            "RequesterAccountId" => RequesterAccountId,
            "RequesterAwsRegion" => RequesterAwsRegion,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_pending_aggregation_request(
    RequesterAccountId,
    RequesterAwsRegion,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "DeletePendingAggregationRequest",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "RequesterAccountId" => RequesterAccountId,
                    "RequesterAwsRegion" => RequesterAwsRegion,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_remediation_configuration(config_rule_name)
    delete_remediation_configuration(config_rule_name, params::Dict{String,<:Any})

Deletes the remediation configuration.

# Arguments
- `config_rule_name`: The name of the Config rule for which you want to delete remediation
  configuration.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ResourceType"`: The type of a resource.
"""
function delete_remediation_configuration(
    ConfigRuleName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "DeleteRemediationConfiguration",
        Dict{String,Any}("ConfigRuleName" => ConfigRuleName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_remediation_configuration(
    ConfigRuleName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "DeleteRemediationConfiguration",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ConfigRuleName" => ConfigRuleName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_remediation_exceptions(config_rule_name, resource_keys)
    delete_remediation_exceptions(config_rule_name, resource_keys, params::Dict{String,<:Any})

Deletes one or more remediation exceptions mentioned in the resource keys.  Config
generates a remediation exception when a problem occurs executing a remediation action to a
specific resource. Remediation exceptions blocks auto-remediation until the exception is
cleared.

# Arguments
- `config_rule_name`: The name of the Config rule for which you want to delete remediation
  exception configuration.
- `resource_keys`: An exception list of resource exception keys to be processed with the
  current request. Config adds exception for each resource key. For example, Config adds 3
  exceptions for 3 resource keys.

"""
function delete_remediation_exceptions(
    ConfigRuleName, ResourceKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "DeleteRemediationExceptions",
        Dict{String,Any}(
            "ConfigRuleName" => ConfigRuleName, "ResourceKeys" => ResourceKeys
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_remediation_exceptions(
    ConfigRuleName,
    ResourceKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "DeleteRemediationExceptions",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ConfigRuleName" => ConfigRuleName, "ResourceKeys" => ResourceKeys
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_resource_config(resource_id, resource_type)
    delete_resource_config(resource_id, resource_type, params::Dict{String,<:Any})

Records the configuration state for a custom resource that has been deleted. This API
records a new ConfigurationItem with a ResourceDeleted status. You can retrieve the
ConfigurationItems recorded for this resource in your Config History.

# Arguments
- `resource_id`: Unique identifier of the resource.
- `resource_type`: The type of the resource.

"""
function delete_resource_config(
    ResourceId, ResourceType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "DeleteResourceConfig",
        Dict{String,Any}("ResourceId" => ResourceId, "ResourceType" => ResourceType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_resource_config(
    ResourceId,
    ResourceType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "DeleteResourceConfig",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ResourceId" => ResourceId, "ResourceType" => ResourceType
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_retention_configuration(retention_configuration_name)
    delete_retention_configuration(retention_configuration_name, params::Dict{String,<:Any})

Deletes the retention configuration.

# Arguments
- `retention_configuration_name`: The name of the retention configuration to delete.

"""
function delete_retention_configuration(
    RetentionConfigurationName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "DeleteRetentionConfiguration",
        Dict{String,Any}("RetentionConfigurationName" => RetentionConfigurationName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_retention_configuration(
    RetentionConfigurationName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "DeleteRetentionConfiguration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "RetentionConfigurationName" => RetentionConfigurationName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_stored_query(query_name)
    delete_stored_query(query_name, params::Dict{String,<:Any})

Deletes the stored query for a single Amazon Web Services account and a single Amazon Web
Services Region.

# Arguments
- `query_name`: The name of the query that you want to delete.

"""
function delete_stored_query(QueryName; aws_config::AbstractAWSConfig=current_aws_config())
    return config_service(
        "DeleteStoredQuery",
        Dict{String,Any}("QueryName" => QueryName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_stored_query(
    QueryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "DeleteStoredQuery",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("QueryName" => QueryName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    deliver_config_snapshot(delivery_channel_name)
    deliver_config_snapshot(delivery_channel_name, params::Dict{String,<:Any})

Schedules delivery of a configuration snapshot to the Amazon S3 bucket in the specified
delivery channel. After the delivery has started, Config sends the following notifications
using an Amazon SNS topic that you have specified.   Notification of the start of the
delivery.   Notification of the completion of the delivery, if the delivery was
successfully completed.   Notification of delivery failure, if the delivery failed.

# Arguments
- `delivery_channel_name`: The name of the delivery channel through which the snapshot is
  delivered.

"""
function deliver_config_snapshot(
    deliveryChannelName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "DeliverConfigSnapshot",
        Dict{String,Any}("deliveryChannelName" => deliveryChannelName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function deliver_config_snapshot(
    deliveryChannelName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "DeliverConfigSnapshot",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("deliveryChannelName" => deliveryChannelName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_aggregate_compliance_by_config_rules(configuration_aggregator_name)
    describe_aggregate_compliance_by_config_rules(configuration_aggregator_name, params::Dict{String,<:Any})

Returns a list of compliant and noncompliant rules with the number of resources for
compliant and noncompliant rules. Does not display rules that do not have compliance
results.   The results can return an empty result page, but if you have a nextToken, the
results are displayed on the next page.

# Arguments
- `configuration_aggregator_name`: The name of the configuration aggregator.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: Filters the results by ConfigRuleComplianceFilters object.
- `"Limit"`: The maximum number of evaluation results returned on each page. The default is
  maximum. If you specify 0, Config uses the default.
- `"NextToken"`: The nextToken string returned on a previous page that you use to get the
  next page of results in a paginated response.
"""
function describe_aggregate_compliance_by_config_rules(
    ConfigurationAggregatorName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "DescribeAggregateComplianceByConfigRules",
        Dict{String,Any}("ConfigurationAggregatorName" => ConfigurationAggregatorName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_aggregate_compliance_by_config_rules(
    ConfigurationAggregatorName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "DescribeAggregateComplianceByConfigRules",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ConfigurationAggregatorName" => ConfigurationAggregatorName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_aggregate_compliance_by_conformance_packs(configuration_aggregator_name)
    describe_aggregate_compliance_by_conformance_packs(configuration_aggregator_name, params::Dict{String,<:Any})

Returns a list of the conformance packs and their associated compliance status with the
count of compliant and noncompliant Config rules within each conformance pack. Also returns
the total rule count which includes compliant rules, noncompliant rules, and rules that
cannot be evaluated due to insufficient data.  The results can return an empty result page,
but if you have a nextToken, the results are displayed on the next page.

# Arguments
- `configuration_aggregator_name`: The name of the configuration aggregator.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: Filters the result by AggregateConformancePackComplianceFilters object.
- `"Limit"`: The maximum number of conformance packs compliance details returned on each
  page. The default is maximum. If you specify 0, Config uses the default.
- `"NextToken"`: The nextToken string returned on a previous page that you use to get the
  next page of results in a paginated response.
"""
function describe_aggregate_compliance_by_conformance_packs(
    ConfigurationAggregatorName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "DescribeAggregateComplianceByConformancePacks",
        Dict{String,Any}("ConfigurationAggregatorName" => ConfigurationAggregatorName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_aggregate_compliance_by_conformance_packs(
    ConfigurationAggregatorName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "DescribeAggregateComplianceByConformancePacks",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ConfigurationAggregatorName" => ConfigurationAggregatorName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_aggregation_authorizations()
    describe_aggregation_authorizations(params::Dict{String,<:Any})

Returns a list of authorizations granted to various aggregator accounts and regions.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Limit"`: The maximum number of AggregationAuthorizations returned on each page. The
  default is maximum. If you specify 0, Config uses the default.
- `"NextToken"`: The nextToken string returned on a previous page that you use to get the
  next page of results in a paginated response.
"""
function describe_aggregation_authorizations(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "DescribeAggregationAuthorizations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_aggregation_authorizations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "DescribeAggregationAuthorizations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_compliance_by_config_rule()
    describe_compliance_by_config_rule(params::Dict{String,<:Any})

Indicates whether the specified Config rules are compliant. If a rule is noncompliant, this
action returns the number of Amazon Web Services resources that do not comply with the
rule. A rule is compliant if all of the evaluated resources comply with it. It is
noncompliant if any of these resources do not comply. If Config has no current evaluation
results for the rule, it returns INSUFFICIENT_DATA. This result might indicate one of the
following conditions:   Config has never invoked an evaluation for the rule. To check
whether it has, use the DescribeConfigRuleEvaluationStatus action to get the
LastSuccessfulInvocationTime and LastFailedInvocationTime.   The rule's Lambda function is
failing to send evaluation results to Config. Verify that the role you assigned to your
configuration recorder includes the config:PutEvaluations permission. If the rule is a
custom rule, verify that the Lambda execution role includes the config:PutEvaluations
permission.   The rule's Lambda function has returned NOT_APPLICABLE for all evaluation
results. This can occur if the resources were deleted or removed from the rule's scope.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ComplianceTypes"`: Filters the results by compliance.
- `"ConfigRuleNames"`: Specify one or more Config rule names to filter the results by rule.
- `"NextToken"`: The nextToken string returned on a previous page that you use to get the
  next page of results in a paginated response.
"""
function describe_compliance_by_config_rule(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "DescribeComplianceByConfigRule";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_compliance_by_config_rule(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "DescribeComplianceByConfigRule",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_compliance_by_resource()
    describe_compliance_by_resource(params::Dict{String,<:Any})

Indicates whether the specified Amazon Web Services resources are compliant. If a resource
is noncompliant, this action returns the number of Config rules that the resource does not
comply with. A resource is compliant if it complies with all the Config rules that evaluate
it. It is noncompliant if it does not comply with one or more of these rules. If Config has
no current evaluation results for the resource, it returns INSUFFICIENT_DATA. This result
might indicate one of the following conditions about the rules that evaluate the resource:
 Config has never invoked an evaluation for the rule. To check whether it has, use the
DescribeConfigRuleEvaluationStatus action to get the LastSuccessfulInvocationTime and
LastFailedInvocationTime.   The rule's Lambda function is failing to send evaluation
results to Config. Verify that the role that you assigned to your configuration recorder
includes the config:PutEvaluations permission. If the rule is a custom rule, verify that
the Lambda execution role includes the config:PutEvaluations permission.   The rule's
Lambda function has returned NOT_APPLICABLE for all evaluation results. This can occur if
the resources were deleted or removed from the rule's scope.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ComplianceTypes"`: Filters the results by compliance.
- `"Limit"`: The maximum number of evaluation results returned on each page. The default is
  10. You cannot specify a number greater than 100. If you specify 0, Config uses the default.
- `"NextToken"`: The nextToken string returned on a previous page that you use to get the
  next page of results in a paginated response.
- `"ResourceId"`: The ID of the Amazon Web Services resource for which you want compliance
  information. You can specify only one resource ID. If you specify a resource ID, you must
  also specify a type for ResourceType.
- `"ResourceType"`: The types of Amazon Web Services resources for which you want
  compliance information (for example, AWS::EC2::Instance). For this action, you can specify
  that the resource type is an Amazon Web Services account by specifying AWS::::Account.
"""
function describe_compliance_by_resource(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "DescribeComplianceByResource";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_compliance_by_resource(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "DescribeComplianceByResource",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_config_rule_evaluation_status()
    describe_config_rule_evaluation_status(params::Dict{String,<:Any})

Returns status information for each of your Config managed rules. The status includes
information such as the last time Config invoked the rule, the last time Config failed to
invoke the rule, and the related error for the last failure.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ConfigRuleNames"`: The name of the Config managed rules for which you want status
  information. If you do not specify any names, Config returns status information for all
  Config managed rules that you use.
- `"Limit"`: The number of rule evaluation results that you want returned. This parameter
  is required if the rule limit for your account is more than the default of 1000 rules. For
  information about requesting a rule limit increase, see Config Limits in the Amazon Web
  Services General Reference Guide.
- `"NextToken"`: The nextToken string returned on a previous page that you use to get the
  next page of results in a paginated response.
"""
function describe_config_rule_evaluation_status(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "DescribeConfigRuleEvaluationStatus";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_config_rule_evaluation_status(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "DescribeConfigRuleEvaluationStatus",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_config_rules()
    describe_config_rules(params::Dict{String,<:Any})

Returns details about your Config rules.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ConfigRuleNames"`: The names of the Config rules for which you want details. If you do
  not specify any names, Config returns details for all your rules.
- `"Filters"`: Returns a list of Detective or Proactive Config rules. By default, this API
  returns an unfiltered list. For more information on Detective or Proactive Config rules,
  see  Evaluation Mode  in the Config Developer Guide.
- `"NextToken"`: The nextToken string returned on a previous page that you use to get the
  next page of results in a paginated response.
"""
function describe_config_rules(; aws_config::AbstractAWSConfig=current_aws_config())
    return config_service(
        "DescribeConfigRules"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_config_rules(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "DescribeConfigRules",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_configuration_aggregator_sources_status(configuration_aggregator_name)
    describe_configuration_aggregator_sources_status(configuration_aggregator_name, params::Dict{String,<:Any})

Returns status information for sources within an aggregator. The status includes
information about the last time Config verified authorization between the source account
and an aggregator account. In case of a failure, the status contains the related error code
or message.

# Arguments
- `configuration_aggregator_name`: The name of the configuration aggregator.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Limit"`: The maximum number of AggregatorSourceStatus returned on each page. The
  default is maximum. If you specify 0, Config uses the default.
- `"NextToken"`: The nextToken string returned on a previous page that you use to get the
  next page of results in a paginated response.
- `"UpdateStatus"`: Filters the status type.   Valid value FAILED indicates errors while
  moving data.   Valid value SUCCEEDED indicates the data was successfully moved.   Valid
  value OUTDATED indicates the data is not the most recent.
"""
function describe_configuration_aggregator_sources_status(
    ConfigurationAggregatorName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "DescribeConfigurationAggregatorSourcesStatus",
        Dict{String,Any}("ConfigurationAggregatorName" => ConfigurationAggregatorName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_configuration_aggregator_sources_status(
    ConfigurationAggregatorName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "DescribeConfigurationAggregatorSourcesStatus",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ConfigurationAggregatorName" => ConfigurationAggregatorName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_configuration_aggregators()
    describe_configuration_aggregators(params::Dict{String,<:Any})

Returns the details of one or more configuration aggregators. If the configuration
aggregator is not specified, this action returns the details for all the configuration
aggregators associated with the account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ConfigurationAggregatorNames"`: The name of the configuration aggregators.
- `"Limit"`: The maximum number of configuration aggregators returned on each page. The
  default is maximum. If you specify 0, Config uses the default.
- `"NextToken"`: The nextToken string returned on a previous page that you use to get the
  next page of results in a paginated response.
"""
function describe_configuration_aggregators(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "DescribeConfigurationAggregators";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_configuration_aggregators(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "DescribeConfigurationAggregators",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_configuration_recorder_status()
    describe_configuration_recorder_status(params::Dict{String,<:Any})

Returns the current status of the specified configuration recorder as well as the status of
the last recording event for the recorder. If a configuration recorder is not specified,
this action returns the status of all configuration recorders associated with the account.
&gt;You can specify only one configuration recorder for each Amazon Web Services Region for
each account. For a detailed status of recording events over time, add your Config events
to Amazon CloudWatch metrics and use CloudWatch metrics.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ConfigurationRecorderNames"`: The name(s) of the configuration recorder. If the name is
  not specified, the action returns the current status of all the configuration recorders
  associated with the account.
"""
function describe_configuration_recorder_status(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "DescribeConfigurationRecorderStatus";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_configuration_recorder_status(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "DescribeConfigurationRecorderStatus",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_configuration_recorders()
    describe_configuration_recorders(params::Dict{String,<:Any})

Returns the details for the specified configuration recorders. If the configuration
recorder is not specified, this action returns the details for all configuration recorders
associated with the account.  You can specify only one configuration recorder for each
Amazon Web Services Region for each account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ConfigurationRecorderNames"`: A list of configuration recorder names.
"""
function describe_configuration_recorders(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "DescribeConfigurationRecorders";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_configuration_recorders(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "DescribeConfigurationRecorders",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_conformance_pack_compliance(conformance_pack_name)
    describe_conformance_pack_compliance(conformance_pack_name, params::Dict{String,<:Any})

Returns compliance details for each rule in that conformance pack.  You must provide exact
rule names.

# Arguments
- `conformance_pack_name`: Name of the conformance pack.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: A ConformancePackComplianceFilters object.
- `"Limit"`: The maximum number of Config rules within a conformance pack are returned on
  each page.
- `"NextToken"`: The nextToken string returned in a previous request that you use to
  request the next page of results in a paginated response.
"""
function describe_conformance_pack_compliance(
    ConformancePackName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "DescribeConformancePackCompliance",
        Dict{String,Any}("ConformancePackName" => ConformancePackName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_conformance_pack_compliance(
    ConformancePackName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "DescribeConformancePackCompliance",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ConformancePackName" => ConformancePackName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_conformance_pack_status()
    describe_conformance_pack_status(params::Dict{String,<:Any})

Provides one or more conformance packs deployment status.  If there are no conformance
packs then you will see an empty result.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ConformancePackNames"`: Comma-separated list of conformance pack names.
- `"Limit"`: The maximum number of conformance packs status returned on each page.
- `"NextToken"`: The nextToken string returned in a previous request that you use to
  request the next page of results in a paginated response.
"""
function describe_conformance_pack_status(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "DescribeConformancePackStatus";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_conformance_pack_status(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "DescribeConformancePackStatus",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_conformance_packs()
    describe_conformance_packs(params::Dict{String,<:Any})

Returns a list of one or more conformance packs.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ConformancePackNames"`: Comma-separated list of conformance pack names for which you
  want details. If you do not specify any names, Config returns details for all your
  conformance packs.
- `"Limit"`: The maximum number of conformance packs returned on each page.
- `"NextToken"`: The nextToken string returned in a previous request that you use to
  request the next page of results in a paginated response.
"""
function describe_conformance_packs(; aws_config::AbstractAWSConfig=current_aws_config())
    return config_service(
        "DescribeConformancePacks"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_conformance_packs(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "DescribeConformancePacks",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_delivery_channel_status()
    describe_delivery_channel_status(params::Dict{String,<:Any})

Returns the current status of the specified delivery channel. If a delivery channel is not
specified, this action returns the current status of all delivery channels associated with
the account.  Currently, you can specify only one delivery channel per region in your
account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DeliveryChannelNames"`: A list of delivery channel names.
"""
function describe_delivery_channel_status(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "DescribeDeliveryChannelStatus";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_delivery_channel_status(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "DescribeDeliveryChannelStatus",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_delivery_channels()
    describe_delivery_channels(params::Dict{String,<:Any})

Returns details about the specified delivery channel. If a delivery channel is not
specified, this action returns the details of all delivery channels associated with the
account.  Currently, you can specify only one delivery channel per region in your account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DeliveryChannelNames"`: A list of delivery channel names.
"""
function describe_delivery_channels(; aws_config::AbstractAWSConfig=current_aws_config())
    return config_service(
        "DescribeDeliveryChannels"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_delivery_channels(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "DescribeDeliveryChannels",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_organization_config_rule_statuses()
    describe_organization_config_rule_statuses(params::Dict{String,<:Any})

Provides organization Config rule deployment status for an organization.  The status is not
considered successful until organization Config rule is successfully deployed in all the
member accounts with an exception of excluded accounts. When you specify the limit and the
next token, you receive a paginated response. Limit and next token are not applicable if
you specify organization Config rule names. It is only applicable, when you request all the
organization Config rules.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Limit"`: The maximum number of OrganizationConfigRuleStatuses returned on each page. If
  you do no specify a number, Config uses the default. The default is 100.
- `"NextToken"`: The nextToken string returned on a previous page that you use to get the
  next page of results in a paginated response.
- `"OrganizationConfigRuleNames"`: The names of organization Config rules for which you
  want status details. If you do not specify any names, Config returns details for all your
  organization Config rules.
"""
function describe_organization_config_rule_statuses(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "DescribeOrganizationConfigRuleStatuses";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_organization_config_rule_statuses(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "DescribeOrganizationConfigRuleStatuses",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_organization_config_rules()
    describe_organization_config_rules(params::Dict{String,<:Any})

Returns a list of organization Config rules.   When you specify the limit and the next
token, you receive a paginated response. Limit and next token are not applicable if you
specify organization Config rule names. It is only applicable, when you request all the
organization Config rules.  For accounts within an organization  If you deploy an
organizational rule or conformance pack in an organization administrator account, and then
establish a delegated administrator and deploy an organizational rule or conformance pack
in the delegated administrator account, you won't be able to see the organizational rule or
conformance pack in the organization administrator account from the delegated administrator
account or see the organizational rule or conformance pack in the delegated administrator
account from organization administrator account. The DescribeOrganizationConfigRules and
DescribeOrganizationConformancePacks APIs can only see and interact with the
organization-related resource that were deployed from within the account calling those
APIs.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Limit"`: The maximum number of organization Config rules returned on each page. If you
  do no specify a number, Config uses the default. The default is 100.
- `"NextToken"`: The nextToken string returned on a previous page that you use to get the
  next page of results in a paginated response.
- `"OrganizationConfigRuleNames"`: The names of organization Config rules for which you
  want details. If you do not specify any names, Config returns details for all your
  organization Config rules.
"""
function describe_organization_config_rules(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "DescribeOrganizationConfigRules";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_organization_config_rules(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "DescribeOrganizationConfigRules",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_organization_conformance_pack_statuses()
    describe_organization_conformance_pack_statuses(params::Dict{String,<:Any})

Provides organization conformance pack deployment status for an organization.   The status
is not considered successful until organization conformance pack is successfully deployed
in all the member accounts with an exception of excluded accounts. When you specify the
limit and the next token, you receive a paginated response. Limit and next token are not
applicable if you specify organization conformance pack names. They are only applicable,
when you request all the organization conformance packs.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Limit"`: The maximum number of OrganizationConformancePackStatuses returned on each
  page. If you do no specify a number, Config uses the default. The default is 100.
- `"NextToken"`: The nextToken string returned on a previous page that you use to get the
  next page of results in a paginated response.
- `"OrganizationConformancePackNames"`: The names of organization conformance packs for
  which you want status details. If you do not specify any names, Config returns details for
  all your organization conformance packs.
"""
function describe_organization_conformance_pack_statuses(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "DescribeOrganizationConformancePackStatuses";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_organization_conformance_pack_statuses(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "DescribeOrganizationConformancePackStatuses",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_organization_conformance_packs()
    describe_organization_conformance_packs(params::Dict{String,<:Any})

Returns a list of organization conformance packs.   When you specify the limit and the next
token, you receive a paginated response.  Limit and next token are not applicable if you
specify organization conformance packs names. They are only applicable, when you request
all the organization conformance packs.   For accounts within an organization  If you
deploy an organizational rule or conformance pack in an organization administrator account,
and then establish a delegated administrator and deploy an organizational rule or
conformance pack in the delegated administrator account, you won't be able to see the
organizational rule or conformance pack in the organization administrator account from the
delegated administrator account or see the organizational rule or conformance pack in the
delegated administrator account from organization administrator account. The
DescribeOrganizationConfigRules and DescribeOrganizationConformancePacks APIs can only see
and interact with the organization-related resource that were deployed from within the
account calling those APIs.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Limit"`: The maximum number of organization config packs returned on each page. If you
  do no specify a number, Config uses the default. The default is 100.
- `"NextToken"`: The nextToken string returned on a previous page that you use to get the
  next page of results in a paginated response.
- `"OrganizationConformancePackNames"`: The name that you assign to an organization
  conformance pack.
"""
function describe_organization_conformance_packs(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "DescribeOrganizationConformancePacks";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_organization_conformance_packs(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "DescribeOrganizationConformancePacks",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_pending_aggregation_requests()
    describe_pending_aggregation_requests(params::Dict{String,<:Any})

Returns a list of all pending aggregation requests.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Limit"`: The maximum number of evaluation results returned on each page. The default is
  maximum. If you specify 0, Config uses the default.
- `"NextToken"`: The nextToken string returned on a previous page that you use to get the
  next page of results in a paginated response.
"""
function describe_pending_aggregation_requests(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "DescribePendingAggregationRequests";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_pending_aggregation_requests(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "DescribePendingAggregationRequests",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_remediation_configurations(config_rule_names)
    describe_remediation_configurations(config_rule_names, params::Dict{String,<:Any})

Returns the details of one or more remediation configurations.

# Arguments
- `config_rule_names`: A list of Config rule names of remediation configurations for which
  you want details.

"""
function describe_remediation_configurations(
    ConfigRuleNames; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "DescribeRemediationConfigurations",
        Dict{String,Any}("ConfigRuleNames" => ConfigRuleNames);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_remediation_configurations(
    ConfigRuleNames,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "DescribeRemediationConfigurations",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ConfigRuleNames" => ConfigRuleNames), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_remediation_exceptions(config_rule_name)
    describe_remediation_exceptions(config_rule_name, params::Dict{String,<:Any})

Returns the details of one or more remediation exceptions. A detailed view of a remediation
exception for a set of resources that includes an explanation of an exception and the time
when the exception will be deleted. When you specify the limit and the next token, you
receive a paginated response.   Config generates a remediation exception when a problem
occurs executing a remediation action to a specific resource. Remediation exceptions blocks
auto-remediation until the exception is cleared. When you specify the limit and the next
token, you receive a paginated response.  Limit and next token are not applicable if you
request resources in batch. It is only applicable, when you request all resources.

# Arguments
- `config_rule_name`: The name of the Config rule.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Limit"`: The maximum number of RemediationExceptionResourceKey returned on each page.
  The default is 25. If you specify 0, Config uses the default.
- `"NextToken"`: The nextToken string returned in a previous request that you use to
  request the next page of results in a paginated response.
- `"ResourceKeys"`: An exception list of resource exception keys to be processed with the
  current request. Config adds exception for each resource key. For example, Config adds 3
  exceptions for 3 resource keys.
"""
function describe_remediation_exceptions(
    ConfigRuleName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "DescribeRemediationExceptions",
        Dict{String,Any}("ConfigRuleName" => ConfigRuleName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_remediation_exceptions(
    ConfigRuleName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "DescribeRemediationExceptions",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ConfigRuleName" => ConfigRuleName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_remediation_execution_status(config_rule_name)
    describe_remediation_execution_status(config_rule_name, params::Dict{String,<:Any})

Provides a detailed view of a Remediation Execution for a set of resources including state,
timestamps for when steps for the remediation execution occur, and any error messages for
steps that have failed. When you specify the limit and the next token, you receive a
paginated response.

# Arguments
- `config_rule_name`: A list of Config rule names.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Limit"`: The maximum number of RemediationExecutionStatuses returned on each page. The
  default is maximum. If you specify 0, Config uses the default.
- `"NextToken"`: The nextToken string returned on a previous page that you use to get the
  next page of results in a paginated response.
- `"ResourceKeys"`: A list of resource keys to be processed with the current request. Each
  element in the list consists of the resource type and resource ID.
"""
function describe_remediation_execution_status(
    ConfigRuleName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "DescribeRemediationExecutionStatus",
        Dict{String,Any}("ConfigRuleName" => ConfigRuleName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_remediation_execution_status(
    ConfigRuleName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "DescribeRemediationExecutionStatus",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ConfigRuleName" => ConfigRuleName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_retention_configurations()
    describe_retention_configurations(params::Dict{String,<:Any})

Returns the details of one or more retention configurations. If the retention configuration
name is not specified, this action returns the details for all the retention configurations
for that account.  Currently, Config supports only one retention configuration per region
in your account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"NextToken"`: The nextToken string returned on a previous page that you use to get the
  next page of results in a paginated response.
- `"RetentionConfigurationNames"`: A list of names of retention configurations for which
  you want details. If you do not specify a name, Config returns details for all the
  retention configurations for that account.  Currently, Config supports only one retention
  configuration per region in your account.
"""
function describe_retention_configurations(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "DescribeRetentionConfigurations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_retention_configurations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "DescribeRetentionConfigurations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_aggregate_compliance_details_by_config_rule(account_id, aws_region, config_rule_name, configuration_aggregator_name)
    get_aggregate_compliance_details_by_config_rule(account_id, aws_region, config_rule_name, configuration_aggregator_name, params::Dict{String,<:Any})

Returns the evaluation results for the specified Config rule for a specific resource in a
rule. The results indicate which Amazon Web Services resources were evaluated by the rule,
when each resource was last evaluated, and whether each resource complies with the rule.
The results can return an empty result page. But if you have a nextToken, the results are
displayed on the next page.

# Arguments
- `account_id`: The 12-digit account ID of the source account.
- `aws_region`: The source region from where the data is aggregated.
- `config_rule_name`: The name of the Config rule for which you want compliance information.
- `configuration_aggregator_name`: The name of the configuration aggregator.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ComplianceType"`: The resource compliance status.  For the
  GetAggregateComplianceDetailsByConfigRuleRequest data type, Config supports only the
  COMPLIANT and NON_COMPLIANT. Config does not support the NOT_APPLICABLE and
  INSUFFICIENT_DATA values.
- `"Limit"`: The maximum number of evaluation results returned on each page. The default is
  50. You cannot specify a number greater than 100. If you specify 0, Config uses the default.
- `"NextToken"`: The nextToken string returned on a previous page that you use to get the
  next page of results in a paginated response.
"""
function get_aggregate_compliance_details_by_config_rule(
    AccountId,
    AwsRegion,
    ConfigRuleName,
    ConfigurationAggregatorName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "GetAggregateComplianceDetailsByConfigRule",
        Dict{String,Any}(
            "AccountId" => AccountId,
            "AwsRegion" => AwsRegion,
            "ConfigRuleName" => ConfigRuleName,
            "ConfigurationAggregatorName" => ConfigurationAggregatorName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_aggregate_compliance_details_by_config_rule(
    AccountId,
    AwsRegion,
    ConfigRuleName,
    ConfigurationAggregatorName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "GetAggregateComplianceDetailsByConfigRule",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AccountId" => AccountId,
                    "AwsRegion" => AwsRegion,
                    "ConfigRuleName" => ConfigRuleName,
                    "ConfigurationAggregatorName" => ConfigurationAggregatorName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_aggregate_config_rule_compliance_summary(configuration_aggregator_name)
    get_aggregate_config_rule_compliance_summary(configuration_aggregator_name, params::Dict{String,<:Any})

Returns the number of compliant and noncompliant rules for one or more accounts and regions
in an aggregator.  The results can return an empty result page, but if you have a
nextToken, the results are displayed on the next page.

# Arguments
- `configuration_aggregator_name`: The name of the configuration aggregator.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: Filters the results based on the ConfigRuleComplianceSummaryFilters object.
- `"GroupByKey"`: Groups the result based on ACCOUNT_ID or AWS_REGION.
- `"Limit"`: The maximum number of evaluation results returned on each page. The default is
  1000. You cannot specify a number greater than 1000. If you specify 0, Config uses the
  default.
- `"NextToken"`: The nextToken string returned on a previous page that you use to get the
  next page of results in a paginated response.
"""
function get_aggregate_config_rule_compliance_summary(
    ConfigurationAggregatorName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "GetAggregateConfigRuleComplianceSummary",
        Dict{String,Any}("ConfigurationAggregatorName" => ConfigurationAggregatorName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_aggregate_config_rule_compliance_summary(
    ConfigurationAggregatorName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "GetAggregateConfigRuleComplianceSummary",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ConfigurationAggregatorName" => ConfigurationAggregatorName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_aggregate_conformance_pack_compliance_summary(configuration_aggregator_name)
    get_aggregate_conformance_pack_compliance_summary(configuration_aggregator_name, params::Dict{String,<:Any})

Returns the count of compliant and noncompliant conformance packs across all Amazon Web
Services accounts and Amazon Web Services Regions in an aggregator. You can filter based on
Amazon Web Services account ID or Amazon Web Services Region.  The results can return an
empty result page, but if you have a nextToken, the results are displayed on the next page.

# Arguments
- `configuration_aggregator_name`: The name of the configuration aggregator.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: Filters the results based on the
  AggregateConformancePackComplianceSummaryFilters object.
- `"GroupByKey"`: Groups the result based on Amazon Web Services account ID or Amazon Web
  Services Region.
- `"Limit"`: The maximum number of results returned on each page. The default is maximum.
  If you specify 0, Config uses the default.
- `"NextToken"`: The nextToken string returned on a previous page that you use to get the
  next page of results in a paginated response.
"""
function get_aggregate_conformance_pack_compliance_summary(
    ConfigurationAggregatorName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "GetAggregateConformancePackComplianceSummary",
        Dict{String,Any}("ConfigurationAggregatorName" => ConfigurationAggregatorName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_aggregate_conformance_pack_compliance_summary(
    ConfigurationAggregatorName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "GetAggregateConformancePackComplianceSummary",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ConfigurationAggregatorName" => ConfigurationAggregatorName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_aggregate_discovered_resource_counts(configuration_aggregator_name)
    get_aggregate_discovered_resource_counts(configuration_aggregator_name, params::Dict{String,<:Any})

Returns the resource counts across accounts and regions that are present in your Config
aggregator. You can request the resource counts by providing filters and GroupByKey. For
example, if the input contains accountID 12345678910 and region us-east-1 in filters, the
API returns the count of resources in account ID 12345678910 and region us-east-1. If the
input contains ACCOUNT_ID as a GroupByKey, the API returns resource counts for all source
accounts that are present in your aggregator.

# Arguments
- `configuration_aggregator_name`: The name of the configuration aggregator.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: Filters the results based on the ResourceCountFilters object.
- `"GroupByKey"`: The key to group the resource counts.
- `"Limit"`: The maximum number of GroupedResourceCount objects returned on each page. The
  default is 1000. You cannot specify a number greater than 1000. If you specify 0, Config
  uses the default.
- `"NextToken"`: The nextToken string returned on a previous page that you use to get the
  next page of results in a paginated response.
"""
function get_aggregate_discovered_resource_counts(
    ConfigurationAggregatorName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "GetAggregateDiscoveredResourceCounts",
        Dict{String,Any}("ConfigurationAggregatorName" => ConfigurationAggregatorName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_aggregate_discovered_resource_counts(
    ConfigurationAggregatorName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "GetAggregateDiscoveredResourceCounts",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ConfigurationAggregatorName" => ConfigurationAggregatorName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_aggregate_resource_config(configuration_aggregator_name, resource_identifier)
    get_aggregate_resource_config(configuration_aggregator_name, resource_identifier, params::Dict{String,<:Any})

Returns configuration item that is aggregated for your specific resource in a specific
source account and region.

# Arguments
- `configuration_aggregator_name`: The name of the configuration aggregator.
- `resource_identifier`: An object that identifies aggregate resource.

"""
function get_aggregate_resource_config(
    ConfigurationAggregatorName,
    ResourceIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "GetAggregateResourceConfig",
        Dict{String,Any}(
            "ConfigurationAggregatorName" => ConfigurationAggregatorName,
            "ResourceIdentifier" => ResourceIdentifier,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_aggregate_resource_config(
    ConfigurationAggregatorName,
    ResourceIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "GetAggregateResourceConfig",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ConfigurationAggregatorName" => ConfigurationAggregatorName,
                    "ResourceIdentifier" => ResourceIdentifier,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_compliance_details_by_config_rule(config_rule_name)
    get_compliance_details_by_config_rule(config_rule_name, params::Dict{String,<:Any})

Returns the evaluation results for the specified Config rule. The results indicate which
Amazon Web Services resources were evaluated by the rule, when each resource was last
evaluated, and whether each resource complies with the rule.

# Arguments
- `config_rule_name`: The name of the Config rule for which you want compliance information.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ComplianceTypes"`: Filters the results by compliance.  INSUFFICIENT_DATA is a valid
  ComplianceType that is returned when an Config rule cannot be evaluated. However,
  INSUFFICIENT_DATA cannot be used as a ComplianceType for filtering results.
- `"Limit"`: The maximum number of evaluation results returned on each page. The default is
  10. You cannot specify a number greater than 100. If you specify 0, Config uses the default.
- `"NextToken"`: The nextToken string returned on a previous page that you use to get the
  next page of results in a paginated response.
"""
function get_compliance_details_by_config_rule(
    ConfigRuleName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "GetComplianceDetailsByConfigRule",
        Dict{String,Any}("ConfigRuleName" => ConfigRuleName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_compliance_details_by_config_rule(
    ConfigRuleName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "GetComplianceDetailsByConfigRule",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ConfigRuleName" => ConfigRuleName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_compliance_details_by_resource()
    get_compliance_details_by_resource(params::Dict{String,<:Any})

Returns the evaluation results for the specified Amazon Web Services resource. The results
indicate which Config rules were used to evaluate the resource, when each rule was last
invoked, and whether the resource complies with each rule.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ComplianceTypes"`: Filters the results by compliance.  INSUFFICIENT_DATA is a valid
  ComplianceType that is returned when an Config rule cannot be evaluated. However,
  INSUFFICIENT_DATA cannot be used as a ComplianceType for filtering results.
- `"NextToken"`: The nextToken string returned on a previous page that you use to get the
  next page of results in a paginated response.
- `"ResourceEvaluationId"`: The unique ID of Amazon Web Services resource execution for
  which you want to retrieve evaluation results.   You need to only provide either a
  ResourceEvaluationID or a ResourceID and ResourceType.
- `"ResourceId"`: The ID of the Amazon Web Services resource for which you want compliance
  information.
- `"ResourceType"`: The type of the Amazon Web Services resource for which you want
  compliance information.
"""
function get_compliance_details_by_resource(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "GetComplianceDetailsByResource";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_compliance_details_by_resource(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "GetComplianceDetailsByResource",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_compliance_summary_by_config_rule()
    get_compliance_summary_by_config_rule(params::Dict{String,<:Any})

Returns the number of Config rules that are compliant and noncompliant, up to a maximum of
25 for each.

"""
function get_compliance_summary_by_config_rule(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "GetComplianceSummaryByConfigRule";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_compliance_summary_by_config_rule(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "GetComplianceSummaryByConfigRule",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_compliance_summary_by_resource_type()
    get_compliance_summary_by_resource_type(params::Dict{String,<:Any})

Returns the number of resources that are compliant and the number that are noncompliant.
You can specify one or more resource types to get these numbers for each resource type. The
maximum number returned is 100.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ResourceTypes"`: Specify one or more resource types to get the number of resources that
  are compliant and the number that are noncompliant for each resource type. For this
  request, you can specify an Amazon Web Services resource type such as AWS::EC2::Instance.
  You can specify that the resource type is an Amazon Web Services account by specifying
  AWS::::Account.
"""
function get_compliance_summary_by_resource_type(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "GetComplianceSummaryByResourceType";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_compliance_summary_by_resource_type(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "GetComplianceSummaryByResourceType",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_conformance_pack_compliance_details(conformance_pack_name)
    get_conformance_pack_compliance_details(conformance_pack_name, params::Dict{String,<:Any})

Returns compliance details of a conformance pack for all Amazon Web Services resources that
are monitered by conformance pack.

# Arguments
- `conformance_pack_name`: Name of the conformance pack.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: A ConformancePackEvaluationFilters object.
- `"Limit"`: The maximum number of evaluation results returned on each page. If you do no
  specify a number, Config uses the default. The default is 100.
- `"NextToken"`: The nextToken string returned in a previous request that you use to
  request the next page of results in a paginated response.
"""
function get_conformance_pack_compliance_details(
    ConformancePackName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "GetConformancePackComplianceDetails",
        Dict{String,Any}("ConformancePackName" => ConformancePackName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_conformance_pack_compliance_details(
    ConformancePackName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "GetConformancePackComplianceDetails",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ConformancePackName" => ConformancePackName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_conformance_pack_compliance_summary(conformance_pack_names)
    get_conformance_pack_compliance_summary(conformance_pack_names, params::Dict{String,<:Any})

Returns compliance details for the conformance pack based on the cumulative compliance
results of all the rules in that conformance pack.

# Arguments
- `conformance_pack_names`: Names of conformance packs.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Limit"`: The maximum number of conformance packs returned on each page.
- `"NextToken"`: The nextToken string returned on a previous page that you use to get the
  next page of results in a paginated response.
"""
function get_conformance_pack_compliance_summary(
    ConformancePackNames; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "GetConformancePackComplianceSummary",
        Dict{String,Any}("ConformancePackNames" => ConformancePackNames);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_conformance_pack_compliance_summary(
    ConformancePackNames,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "GetConformancePackComplianceSummary",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ConformancePackNames" => ConformancePackNames),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_custom_rule_policy()
    get_custom_rule_policy(params::Dict{String,<:Any})

Returns the policy definition containing the logic for your Config Custom Policy rule.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ConfigRuleName"`: The name of your Config Custom Policy rule.
"""
function get_custom_rule_policy(; aws_config::AbstractAWSConfig=current_aws_config())
    return config_service(
        "GetCustomRulePolicy"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_custom_rule_policy(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "GetCustomRulePolicy",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_discovered_resource_counts()
    get_discovered_resource_counts(params::Dict{String,<:Any})

Returns the resource types, the number of each resource type, and the total number of
resources that Config is recording in this region for your Amazon Web Services account.
Example    Config is recording three resource types in the US East (Ohio) Region for your
account: 25 EC2 instances, 20 IAM users, and 15 S3 buckets.   You make a call to the
GetDiscoveredResourceCounts action and specify that you want all resource types.    Config
returns the following:   The resource types (EC2 instances, IAM users, and S3 buckets).
The number of each resource type (25, 20, and 15).   The total number of all resources
(60).     The response is paginated. By default, Config lists 100 ResourceCount objects on
each page. You can customize this number with the limit parameter. The response includes a
nextToken string. To get the next page of results, run the request again and specify the
string for the nextToken parameter.  If you make a call to the GetDiscoveredResourceCounts
action, you might not immediately receive resource counts in the following situations:
You are a new Config customer.   You just enabled resource recording.   It might take a few
minutes for Config to record and count your resources. Wait a few minutes and then retry
the GetDiscoveredResourceCounts action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"limit"`: The maximum number of ResourceCount objects returned on each page. The default
  is 100. You cannot specify a number greater than 100. If you specify 0, Config uses the
  default.
- `"nextToken"`: The nextToken string returned on a previous page that you use to get the
  next page of results in a paginated response.
- `"resourceTypes"`: The comma-separated list that specifies the resource types that you
  want Config to return (for example, \"AWS::EC2::Instance\", \"AWS::IAM::User\"). If a value
  for resourceTypes is not specified, Config returns all resource types that Config is
  recording in the region for your account.  If the configuration recorder is turned off,
  Config returns an empty list of ResourceCount objects. If the configuration recorder is not
  recording a specific resource type (for example, S3 buckets), that resource type is not
  returned in the list of ResourceCount objects.
"""
function get_discovered_resource_counts(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "GetDiscoveredResourceCounts";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_discovered_resource_counts(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "GetDiscoveredResourceCounts",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_organization_config_rule_detailed_status(organization_config_rule_name)
    get_organization_config_rule_detailed_status(organization_config_rule_name, params::Dict{String,<:Any})

Returns detailed status for each member account within an organization for a given
organization Config rule.

# Arguments
- `organization_config_rule_name`: The name of your organization Config rule for which you
  want status details for member accounts.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: A StatusDetailFilters object.
- `"Limit"`: The maximum number of OrganizationConfigRuleDetailedStatus returned on each
  page. If you do not specify a number, Config uses the default. The default is 100.
- `"NextToken"`: The nextToken string returned on a previous page that you use to get the
  next page of results in a paginated response.
"""
function get_organization_config_rule_detailed_status(
    OrganizationConfigRuleName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "GetOrganizationConfigRuleDetailedStatus",
        Dict{String,Any}("OrganizationConfigRuleName" => OrganizationConfigRuleName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_organization_config_rule_detailed_status(
    OrganizationConfigRuleName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "GetOrganizationConfigRuleDetailedStatus",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "OrganizationConfigRuleName" => OrganizationConfigRuleName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_organization_conformance_pack_detailed_status(organization_conformance_pack_name)
    get_organization_conformance_pack_detailed_status(organization_conformance_pack_name, params::Dict{String,<:Any})

Returns detailed status for each member account within an organization for a given
organization conformance pack.

# Arguments
- `organization_conformance_pack_name`: The name of organization conformance pack for which
  you want status details for member accounts.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: An OrganizationResourceDetailedStatusFilters object.
- `"Limit"`: The maximum number of OrganizationConformancePackDetailedStatuses returned on
  each page. If you do not specify a number, Config uses the default. The default is 100.
- `"NextToken"`: The nextToken string returned on a previous page that you use to get the
  next page of results in a paginated response.
"""
function get_organization_conformance_pack_detailed_status(
    OrganizationConformancePackName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "GetOrganizationConformancePackDetailedStatus",
        Dict{String,Any}(
            "OrganizationConformancePackName" => OrganizationConformancePackName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_organization_conformance_pack_detailed_status(
    OrganizationConformancePackName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "GetOrganizationConformancePackDetailedStatus",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "OrganizationConformancePackName" => OrganizationConformancePackName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_organization_custom_rule_policy(organization_config_rule_name)
    get_organization_custom_rule_policy(organization_config_rule_name, params::Dict{String,<:Any})

Returns the policy definition containing the logic for your organization Config Custom
Policy rule.

# Arguments
- `organization_config_rule_name`: The name of your organization Config Custom Policy rule.

"""
function get_organization_custom_rule_policy(
    OrganizationConfigRuleName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "GetOrganizationCustomRulePolicy",
        Dict{String,Any}("OrganizationConfigRuleName" => OrganizationConfigRuleName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_organization_custom_rule_policy(
    OrganizationConfigRuleName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "GetOrganizationCustomRulePolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "OrganizationConfigRuleName" => OrganizationConfigRuleName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_resource_config_history(resource_id, resource_type)
    get_resource_config_history(resource_id, resource_type, params::Dict{String,<:Any})

 For accurate reporting on the compliance status, you must record the
AWS::Config::ResourceCompliance resource type. For more information, see Selecting Which
Resources Config Records.  Returns a list of ConfigurationItems for the specified resource.
The list contains details about each state of the resource during the specified time
interval. If you specified a retention period to retain your ConfigurationItems between a
minimum of 30 days and a maximum of 7 years (2557 days), Config returns the
ConfigurationItems for the specified retention period.  The response is paginated. By
default, Config returns a limit of 10 configuration items per page. You can customize this
number with the limit parameter. The response includes a nextToken string. To get the next
page of results, run the request again and specify the string for the nextToken parameter.
Each call to the API is limited to span a duration of seven days. It is likely that the
number of records returned is smaller than the specified limit. In such cases, you can make
another call, using the nextToken.

# Arguments
- `resource_id`: The ID of the resource (for example., sg-xxxxxx).
- `resource_type`: The resource type.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"chronologicalOrder"`: The chronological order for configuration items listed. By
  default, the results are listed in reverse chronological order.
- `"earlierTime"`: The chronologically earliest time in the time range for which the
  history requested. If not specified, the action returns paginated results that contain
  configuration items that start when the first configuration item was recorded.
- `"laterTime"`: The chronologically latest time in the time range for which the history
  requested. If not specified, current time is taken.
- `"limit"`: The maximum number of configuration items returned on each page. The default
  is 10. You cannot specify a number greater than 100. If you specify 0, Config uses the
  default.
- `"nextToken"`: The nextToken string returned on a previous page that you use to get the
  next page of results in a paginated response.
"""
function get_resource_config_history(
    resourceId, resourceType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "GetResourceConfigHistory",
        Dict{String,Any}("resourceId" => resourceId, "resourceType" => resourceType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_resource_config_history(
    resourceId,
    resourceType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "GetResourceConfigHistory",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "resourceId" => resourceId, "resourceType" => resourceType
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_resource_evaluation_summary(resource_evaluation_id)
    get_resource_evaluation_summary(resource_evaluation_id, params::Dict{String,<:Any})

Returns a summary of resource evaluation for the specified resource evaluation ID from the
proactive rules that were run. The results indicate which evaluation context was used to
evaluate the rules, which resource details were evaluated, the evaluation mode that was
run, and whether the resource details comply with the configuration of the proactive rules.
  To see additional information about the evaluation result, such as which rule flagged a
resource as NON_COMPLIANT, use the GetComplianceDetailsByResource API. For more
information, see the Examples section.

# Arguments
- `resource_evaluation_id`: The unique ResourceEvaluationId of Amazon Web Services resource
  execution for which you want to retrieve the evaluation summary.

"""
function get_resource_evaluation_summary(
    ResourceEvaluationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "GetResourceEvaluationSummary",
        Dict{String,Any}("ResourceEvaluationId" => ResourceEvaluationId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_resource_evaluation_summary(
    ResourceEvaluationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "GetResourceEvaluationSummary",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceEvaluationId" => ResourceEvaluationId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_stored_query(query_name)
    get_stored_query(query_name, params::Dict{String,<:Any})

Returns the details of a specific stored query.

# Arguments
- `query_name`: The name of the query.

"""
function get_stored_query(QueryName; aws_config::AbstractAWSConfig=current_aws_config())
    return config_service(
        "GetStoredQuery",
        Dict{String,Any}("QueryName" => QueryName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_stored_query(
    QueryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "GetStoredQuery",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("QueryName" => QueryName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_aggregate_discovered_resources(configuration_aggregator_name, resource_type)
    list_aggregate_discovered_resources(configuration_aggregator_name, resource_type, params::Dict{String,<:Any})

Accepts a resource type and returns a list of resource identifiers that are aggregated for
a specific resource type across accounts and regions. A resource identifier includes the
resource type, ID, (if available) the custom resource name, source account, and source
region. You can narrow the results to include only resources that have specific resource
IDs, or a resource name, or source account ID, or source region. For example, if the input
consists of accountID 12345678910 and the region is us-east-1 for resource type
AWS::EC2::Instance then the API returns all the EC2 instance identifiers of accountID
12345678910 and region us-east-1.

# Arguments
- `configuration_aggregator_name`: The name of the configuration aggregator.
- `resource_type`: The type of resources that you want Config to list in the response.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: Filters the results based on the ResourceFilters object.
- `"Limit"`: The maximum number of resource identifiers returned on each page. You cannot
  specify a number greater than 100. If you specify 0, Config uses the default.
- `"NextToken"`: The nextToken string returned on a previous page that you use to get the
  next page of results in a paginated response.
"""
function list_aggregate_discovered_resources(
    ConfigurationAggregatorName,
    ResourceType;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "ListAggregateDiscoveredResources",
        Dict{String,Any}(
            "ConfigurationAggregatorName" => ConfigurationAggregatorName,
            "ResourceType" => ResourceType,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_aggregate_discovered_resources(
    ConfigurationAggregatorName,
    ResourceType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "ListAggregateDiscoveredResources",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ConfigurationAggregatorName" => ConfigurationAggregatorName,
                    "ResourceType" => ResourceType,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_conformance_pack_compliance_scores()
    list_conformance_pack_compliance_scores(params::Dict{String,<:Any})

Returns a list of conformance pack compliance scores. A compliance score is the percentage
of the number of compliant rule-resource combinations in a conformance pack compared to the
number of total possible rule-resource combinations in the conformance pack. This metric
provides you with a high-level view of the compliance state of your conformance packs. You
can use it to identify, investigate, and understand the level of compliance in your
conformance packs.  Conformance packs with no evaluation results will have a compliance
score of INSUFFICIENT_DATA.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: Filters the results based on the ConformancePackComplianceScoresFilters.
- `"Limit"`: The maximum number of conformance pack compliance scores returned on each page.
- `"NextToken"`: The nextToken string in a prior request that you can use to get the
  paginated response for the next set of conformance pack compliance scores.
- `"SortBy"`: Sorts your conformance pack compliance scores in either ascending or
  descending order, depending on SortOrder. By default, conformance pack compliance scores
  are sorted in alphabetical order by name of the conformance pack. Enter SCORE, to sort
  conformance pack compliance scores by the numerical value of the compliance score.
- `"SortOrder"`: Determines the order in which conformance pack compliance scores are
  sorted. Either in ascending or descending order. By default, conformance pack compliance
  scores are sorted in alphabetical order by name of the conformance pack. Conformance pack
  compliance scores are sorted in reverse alphabetical order if you enter DESCENDING. You can
  sort conformance pack compliance scores by the numerical value of the compliance score by
  entering SCORE in the SortBy action. When compliance scores are sorted by SCORE,
  conformance packs with a compliance score of INSUFFICIENT_DATA will be last when sorting by
  ascending order and first when sorting by descending order.
"""
function list_conformance_pack_compliance_scores(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "ListConformancePackComplianceScores";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_conformance_pack_compliance_scores(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "ListConformancePackComplianceScores",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_discovered_resources(resource_type)
    list_discovered_resources(resource_type, params::Dict{String,<:Any})

Accepts a resource type and returns a list of resource identifiers for the resources of
that type. A resource identifier includes the resource type, ID, and (if available) the
custom resource name. The results consist of resources that Config has discovered,
including those that Config is not currently recording. You can narrow the results to
include only resources that have specific resource IDs or a resource name.  You can specify
either resource IDs or a resource name, but not both, in the same request.  The response is
paginated. By default, Config lists 100 resource identifiers on each page. You can
customize this number with the limit parameter. The response includes a nextToken string.
To get the next page of results, run the request again and specify the string for the
nextToken parameter.

# Arguments
- `resource_type`: The type of resources that you want Config to list in the response.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"includeDeletedResources"`: Specifies whether Config includes deleted resources in the
  results. By default, deleted resources are not included.
- `"limit"`: The maximum number of resource identifiers returned on each page. The default
  is 100. You cannot specify a number greater than 100. If you specify 0, Config uses the
  default.
- `"nextToken"`: The nextToken string returned on a previous page that you use to get the
  next page of results in a paginated response.
- `"resourceIds"`: The IDs of only those resources that you want Config to list in the
  response. If you do not specify this parameter, Config lists all resources of the specified
  type that it has discovered. You can list a minimum of 1 resourceID and a maximum of 20
  resourceIds.
- `"resourceName"`: The custom name of only those resources that you want Config to list in
  the response. If you do not specify this parameter, Config lists all resources of the
  specified type that it has discovered.
"""
function list_discovered_resources(
    resourceType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "ListDiscoveredResources",
        Dict{String,Any}("resourceType" => resourceType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_discovered_resources(
    resourceType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "ListDiscoveredResources",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("resourceType" => resourceType), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_resource_evaluations()
    list_resource_evaluations(params::Dict{String,<:Any})

Returns a list of proactive resource evaluations.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: Returns a ResourceEvaluationFilters object.
- `"Limit"`: The maximum number of evaluations returned on each page. The default is 10.
  You cannot specify a number greater than 100. If you specify 0, Config uses the default.
- `"NextToken"`: The nextToken string returned on a previous page that you use to get the
  next page of results in a paginated response.
"""
function list_resource_evaluations(; aws_config::AbstractAWSConfig=current_aws_config())
    return config_service(
        "ListResourceEvaluations"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_resource_evaluations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "ListResourceEvaluations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_stored_queries()
    list_stored_queries(params::Dict{String,<:Any})

Lists the stored queries for a single Amazon Web Services account and a single Amazon Web
Services Region. The default is 100.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of results to be returned with a single call.
- `"NextToken"`: The nextToken string returned in a previous request that you use to
  request the next page of results in a paginated response.
"""
function list_stored_queries(; aws_config::AbstractAWSConfig=current_aws_config())
    return config_service(
        "ListStoredQueries"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_stored_queries(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "ListStoredQueries", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

List the tags for Config resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) that identifies the resource for which to
  list the tags. Currently, the supported resources are ConfigRule, ConfigurationAggregator
  and AggregatorAuthorization.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Limit"`: The maximum number of tags returned on each page. The limit maximum is 50. You
  cannot specify a number greater than 50. If you specify 0, Config uses the default.
- `"NextToken"`: The nextToken string returned on a previous page that you use to get the
  next page of results in a paginated response.
"""
function list_tags_for_resource(
    ResourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "ListTagsForResource",
        Dict{String,Any}("ResourceArn" => ResourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    ResourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "ListTagsForResource",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceArn" => ResourceArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_aggregation_authorization(authorized_account_id, authorized_aws_region)
    put_aggregation_authorization(authorized_account_id, authorized_aws_region, params::Dict{String,<:Any})

Authorizes the aggregator account and region to collect data from the source account and
region.    PutAggregationAuthorization is an idempotent API. Subsequent requests won’t
create a duplicate resource if one was already created. If a following request has
different tags values, Config will ignore these differences and treat it as an idempotent
request of the previous. In this case, tags will not be updated, even if they are
different.

# Arguments
- `authorized_account_id`: The 12-digit account ID of the account authorized to aggregate
  data.
- `authorized_aws_region`: The region authorized to collect aggregated data.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Tags"`: An array of tag object.
"""
function put_aggregation_authorization(
    AuthorizedAccountId,
    AuthorizedAwsRegion;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "PutAggregationAuthorization",
        Dict{String,Any}(
            "AuthorizedAccountId" => AuthorizedAccountId,
            "AuthorizedAwsRegion" => AuthorizedAwsRegion,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_aggregation_authorization(
    AuthorizedAccountId,
    AuthorizedAwsRegion,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "PutAggregationAuthorization",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AuthorizedAccountId" => AuthorizedAccountId,
                    "AuthorizedAwsRegion" => AuthorizedAwsRegion,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_config_rule(config_rule)
    put_config_rule(config_rule, params::Dict{String,<:Any})

Adds or updates an Config rule to evaluate if your Amazon Web Services resources comply
with your desired configurations. For information on how many Config rules you can have per
account, see  Service Limits  in the Config Developer Guide. There are two types of rules:
Config Managed Rules and Config Custom Rules. You can use PutConfigRule to create both
Config Managed Rules and Config Custom Rules. Config Managed Rules are predefined,
customizable rules created by Config. For a list of managed rules, see List of Config
Managed Rules. If you are adding an Config managed rule, you must specify the rule's
identifier for the SourceIdentifier key. Config Custom Rules are rules that you create from
scratch. There are two ways to create Config custom rules: with Lambda functions ( Lambda
Developer Guide) and with Guard (Guard GitHub Repository), a policy-as-code language.
Config custom rules created with Lambda are called Config Custom Lambda Rules and Config
custom rules created with Guard are called Config Custom Policy Rules. If you are adding a
new Config Custom Lambda rule, you first need to create an Lambda function that the rule
invokes to evaluate your resources. When you use PutConfigRule to add a Custom Lambda rule
to Config, you must specify the Amazon Resource Name (ARN) that Lambda assigns to the
function. You specify the ARN in the SourceIdentifier key. This key is part of the Source
object, which is part of the ConfigRule object.  For any new Config rule that you add,
specify the ConfigRuleName in the ConfigRule object. Do not specify the ConfigRuleArn or
the ConfigRuleId. These values are generated by Config for new rules. If you are updating a
rule that you added previously, you can specify the rule by ConfigRuleName, ConfigRuleId,
or ConfigRuleArn in the ConfigRule data type that you use in this request. For more
information about developing and using Config rules, see Evaluating Resources with Config
Rules in the Config Developer Guide.   PutConfigRule is an idempotent API. Subsequent
requests won’t create a duplicate resource if one was already created. If a following
request has different tags values, Config will ignore these differences and treat it as an
idempotent request of the previous. In this case, tags will not be updated, even if they
are different.

# Arguments
- `config_rule`: The rule that you want to add to your account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Tags"`: An array of tag object.
"""
function put_config_rule(ConfigRule; aws_config::AbstractAWSConfig=current_aws_config())
    return config_service(
        "PutConfigRule",
        Dict{String,Any}("ConfigRule" => ConfigRule);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_config_rule(
    ConfigRule,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "PutConfigRule",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ConfigRule" => ConfigRule), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_configuration_aggregator(configuration_aggregator_name)
    put_configuration_aggregator(configuration_aggregator_name, params::Dict{String,<:Any})

Creates and updates the configuration aggregator with the selected source accounts and
regions. The source account can be individual account(s) or an organization.  accountIds
that are passed will be replaced with existing accounts. If you want to add additional
accounts into the aggregator, call DescribeConfigurationAggregators to get the previous
accounts and then append new ones.  Config should be enabled in source accounts and regions
you want to aggregate. If your source type is an organization, you must be signed in to the
management account or a registered delegated administrator and all the features must be
enabled in your organization. If the caller is a management account, Config calls
EnableAwsServiceAccess API to enable integration between Config and Organizations. If the
caller is a registered delegated administrator, Config calls ListDelegatedAdministrators
API to verify whether the caller is a valid delegated administrator. To register a
delegated administrator, see Register a Delegated Administrator in the Config developer
guide.     PutConfigurationAggregator is an idempotent API. Subsequent requests won’t
create a duplicate resource if one was already created. If a following request has
different tags values, Config will ignore these differences and treat it as an idempotent
request of the previous. In this case, tags will not be updated, even if they are
different.

# Arguments
- `configuration_aggregator_name`: The name of the configuration aggregator.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AccountAggregationSources"`: A list of AccountAggregationSource object.
- `"OrganizationAggregationSource"`: An OrganizationAggregationSource object.
- `"Tags"`: An array of tag object.
"""
function put_configuration_aggregator(
    ConfigurationAggregatorName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "PutConfigurationAggregator",
        Dict{String,Any}("ConfigurationAggregatorName" => ConfigurationAggregatorName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_configuration_aggregator(
    ConfigurationAggregatorName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "PutConfigurationAggregator",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ConfigurationAggregatorName" => ConfigurationAggregatorName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_configuration_recorder(configuration_recorder)
    put_configuration_recorder(configuration_recorder, params::Dict{String,<:Any})

Creates a new configuration recorder to record configuration changes for specified resource
types. You can also use this action to change the roleARN or the recordingGroup of an
existing recorder. For more information, see  Managing the Configuration Recorder  in the
Config Developer Guide.  You can specify only one configuration recorder for each Amazon
Web Services Region for each account. If the configuration recorder does not have the
recordingGroup field specified, the default is to record all supported resource types.

# Arguments
- `configuration_recorder`: An object for the configuration recorder to record
  configuration changes for specified resource types.

"""
function put_configuration_recorder(
    ConfigurationRecorder; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "PutConfigurationRecorder",
        Dict{String,Any}("ConfigurationRecorder" => ConfigurationRecorder);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_configuration_recorder(
    ConfigurationRecorder,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "PutConfigurationRecorder",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ConfigurationRecorder" => ConfigurationRecorder),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_conformance_pack(conformance_pack_name)
    put_conformance_pack(conformance_pack_name, params::Dict{String,<:Any})

Creates or updates a conformance pack. A conformance pack is a collection of Config rules
that can be easily deployed in an account and a region and across an organization. For
information on how many conformance packs you can have per account, see  Service Limits  in
the Config Developer Guide. This API creates a service-linked role
AWSServiceRoleForConfigConforms in your account. The service-linked role is created only
when the role does not exist in your account.   You must specify only one of the follow
parameters: TemplateS3Uri, TemplateBody or TemplateSSMDocumentDetails.

# Arguments
- `conformance_pack_name`: The unique name of the conformance pack you want to deploy.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ConformancePackInputParameters"`: A list of ConformancePackInputParameter objects.
- `"DeliveryS3Bucket"`: The name of the Amazon S3 bucket where Config stores conformance
  pack templates.  This field is optional.
- `"DeliveryS3KeyPrefix"`: The prefix for the Amazon S3 bucket.   This field is optional.
- `"TemplateBody"`: A string containing the full conformance pack template body. The
  structure containing the template body has a minimum length of 1 byte and a maximum length
  of 51,200 bytes.  You can use a YAML template with two resource types: Config rule
  (AWS::Config::ConfigRule) and remediation action (AWS::Config::RemediationConfiguration).
- `"TemplateS3Uri"`: The location of the file containing the template body
  (s3://bucketname/prefix). The uri must point to a conformance pack template (max size: 300
  KB) that is located in an Amazon S3 bucket in the same Region as the conformance pack.
  You must have access to read Amazon S3 bucket. In addition, in order to ensure a successful
  deployment, the template object must not be in an archived storage class if this parameter
  is passed.
- `"TemplateSSMDocumentDetails"`: An object of type TemplateSSMDocumentDetails, which
  contains the name or the Amazon Resource Name (ARN) of the Amazon Web Services Systems
  Manager document (SSM document) and the version of the SSM document that is used to create
  a conformance pack.
"""
function put_conformance_pack(
    ConformancePackName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "PutConformancePack",
        Dict{String,Any}("ConformancePackName" => ConformancePackName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_conformance_pack(
    ConformancePackName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "PutConformancePack",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ConformancePackName" => ConformancePackName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_delivery_channel(delivery_channel)
    put_delivery_channel(delivery_channel, params::Dict{String,<:Any})

Creates a delivery channel object to deliver configuration information and other compliance
information to an Amazon S3 bucket and Amazon SNS topic. For more information, see
Notifications that Config Sends to an Amazon SNS topic. Before you can create a delivery
channel, you must create a configuration recorder. You can use this action to change the
Amazon S3 bucket or an Amazon SNS topic of the existing delivery channel. To change the
Amazon S3 bucket or an Amazon SNS topic, call this action and specify the changed values
for the S3 bucket and the SNS topic. If you specify a different value for either the S3
bucket or the SNS topic, this action will keep the existing value for the parameter that is
not changed.  You can have only one delivery channel per region in your account.

# Arguments
- `delivery_channel`: The configuration delivery channel object that delivers the
  configuration information to an Amazon S3 bucket and to an Amazon SNS topic.

"""
function put_delivery_channel(
    DeliveryChannel; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "PutDeliveryChannel",
        Dict{String,Any}("DeliveryChannel" => DeliveryChannel);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_delivery_channel(
    DeliveryChannel,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "PutDeliveryChannel",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("DeliveryChannel" => DeliveryChannel), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_evaluations(result_token)
    put_evaluations(result_token, params::Dict{String,<:Any})

Used by an Lambda function to deliver evaluation results to Config. This action is required
in every Lambda function that is invoked by an Config rule.

# Arguments
- `result_token`: An encrypted token that associates an evaluation with an Config rule.
  Identifies the rule and the event that triggered the evaluation.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Evaluations"`: The assessments that the Lambda function performs. Each evaluation
  identifies an Amazon Web Services resource and indicates whether it complies with the
  Config rule that invokes the Lambda function.
- `"TestMode"`: Use this parameter to specify a test run for PutEvaluations. You can verify
  whether your Lambda function will deliver evaluation results to Config. No updates occur to
  your existing evaluations, and evaluation results are not sent to Config.  When TestMode is
  true, PutEvaluations doesn't require a valid value for the ResultToken parameter, but the
  value cannot be null.
"""
function put_evaluations(ResultToken; aws_config::AbstractAWSConfig=current_aws_config())
    return config_service(
        "PutEvaluations",
        Dict{String,Any}("ResultToken" => ResultToken);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_evaluations(
    ResultToken,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "PutEvaluations",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResultToken" => ResultToken), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_external_evaluation(config_rule_name, external_evaluation)
    put_external_evaluation(config_rule_name, external_evaluation, params::Dict{String,<:Any})

Add or updates the evaluations for process checks. This API checks if the rule is a process
check when the name of the Config rule is provided.

# Arguments
- `config_rule_name`: The name of the Config rule.
- `external_evaluation`: An ExternalEvaluation object that provides details about
  compliance.

"""
function put_external_evaluation(
    ConfigRuleName, ExternalEvaluation; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "PutExternalEvaluation",
        Dict{String,Any}(
            "ConfigRuleName" => ConfigRuleName, "ExternalEvaluation" => ExternalEvaluation
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_external_evaluation(
    ConfigRuleName,
    ExternalEvaluation,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "PutExternalEvaluation",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ConfigRuleName" => ConfigRuleName,
                    "ExternalEvaluation" => ExternalEvaluation,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_organization_config_rule(organization_config_rule_name)
    put_organization_config_rule(organization_config_rule_name, params::Dict{String,<:Any})

Adds or updates an Config rule for your entire organization to evaluate if your Amazon Web
Services resources comply with your desired configurations. For information on how many
organization Config rules you can have per account, see  Service Limits  in the Config
Developer Guide.  Only a management account and a delegated administrator can create or
update an organization Config rule. When calling this API with a delegated administrator,
you must ensure Organizations ListDelegatedAdministrator permissions are added. An
organization can have up to 3 delegated administrators. This API enables organization
service access through the EnableAWSServiceAccess action and creates a service-linked role
AWSServiceRoleForConfigMultiAccountSetup in the management or delegated administrator
account of your organization. The service-linked role is created only when the role does
not exist in the caller account. Config verifies the existence of role with GetRole action.
To use this API with delegated administrator, register a delegated administrator by calling
Amazon Web Services Organization register-delegated-administrator for
config-multiaccountsetup.amazonaws.com.  There are two types of rules: Config Managed Rules
and Config Custom Rules. You can use PutOrganizationConfigRule to create both Config
Managed Rules and Config Custom Rules. Config Managed Rules are predefined, customizable
rules created by Config. For a list of managed rules, see List of Config Managed Rules. If
you are adding an Config managed rule, you must specify the rule's identifier for the
RuleIdentifier key. Config Custom Rules are rules that you create from scratch. There are
two ways to create Config custom rules: with Lambda functions ( Lambda Developer Guide) and
with Guard (Guard GitHub Repository), a policy-as-code language. Config custom rules
created with Lambda are called Config Custom Lambda Rules and Config custom rules created
with Guard are called Config Custom Policy Rules. If you are adding a new Config Custom
Lambda rule, you first need to create an Lambda function in the management account or a
delegated administrator that the rule invokes to evaluate your resources. You also need to
create an IAM role in the managed account that can be assumed by the Lambda function. When
you use PutOrganizationConfigRule to add a Custom Lambda rule to Config, you must specify
the Amazon Resource Name (ARN) that Lambda assigns to the function.  Prerequisite: Ensure
you call EnableAllFeatures API to enable all features in an organization. Make sure to
specify one of either OrganizationCustomPolicyRuleMetadata for Custom Policy rules,
OrganizationCustomRuleMetadata for Custom Lambda rules, or OrganizationManagedRuleMetadata
for managed rules.

# Arguments
- `organization_config_rule_name`: The name that you assign to an organization Config rule.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ExcludedAccounts"`: A comma-separated list of accounts that you want to exclude from an
  organization Config rule.
- `"OrganizationCustomPolicyRuleMetadata"`: An OrganizationCustomPolicyRuleMetadata object.
  This object specifies metadata for your organization's Config Custom Policy rule. The
  metadata includes the runtime system in use, which accounts have debug logging enabled, and
  other custom rule metadata, such as resource type, resource ID of Amazon Web Services
  resource, and organization trigger types that initiate Config to evaluate Amazon Web
  Services resources against a rule.
- `"OrganizationCustomRuleMetadata"`: An OrganizationCustomRuleMetadata object. This object
  specifies organization custom rule metadata such as resource type, resource ID of Amazon
  Web Services resource, Lambda function ARN, and organization trigger types that trigger
  Config to evaluate your Amazon Web Services resources against a rule. It also provides the
  frequency with which you want Config to run evaluations for the rule if the trigger type is
  periodic.
- `"OrganizationManagedRuleMetadata"`: An OrganizationManagedRuleMetadata object. This
  object specifies organization managed rule metadata such as resource type and ID of Amazon
  Web Services resource along with the rule identifier. It also provides the frequency with
  which you want Config to run evaluations for the rule if the trigger type is periodic.
"""
function put_organization_config_rule(
    OrganizationConfigRuleName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "PutOrganizationConfigRule",
        Dict{String,Any}("OrganizationConfigRuleName" => OrganizationConfigRuleName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_organization_config_rule(
    OrganizationConfigRuleName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "PutOrganizationConfigRule",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "OrganizationConfigRuleName" => OrganizationConfigRuleName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_organization_conformance_pack(organization_conformance_pack_name)
    put_organization_conformance_pack(organization_conformance_pack_name, params::Dict{String,<:Any})

Deploys conformance packs across member accounts in an Amazon Web Services Organization.
For information on how many organization conformance packs and how many Config rules you
can have per account, see  Service Limits  in the Config Developer Guide. Only a management
account and a delegated administrator can call this API. When calling this API with a
delegated administrator, you must ensure Organizations ListDelegatedAdministrator
permissions are added. An organization can have up to 3 delegated administrators. This API
enables organization service access for config-multiaccountsetup.amazonaws.com through the
EnableAWSServiceAccess action and creates a service-linked role
AWSServiceRoleForConfigMultiAccountSetup in the management or delegated administrator
account of your organization. The service-linked role is created only when the role does
not exist in the caller account. To use this API with delegated administrator, register a
delegated administrator by calling Amazon Web Services Organization register-delegate-admin
for config-multiaccountsetup.amazonaws.com.  Prerequisite: Ensure you call
EnableAllFeatures API to enable all features in an organization. You must specify either
the TemplateS3Uri or the TemplateBody parameter, but not both. If you provide both Config
uses the TemplateS3Uri parameter and ignores the TemplateBody parameter. Config sets the
state of a conformance pack to CREATE_IN_PROGRESS and UPDATE_IN_PROGRESS until the
conformance pack is created or updated. You cannot update a conformance pack while it is in
this state.

# Arguments
- `organization_conformance_pack_name`: Name of the organization conformance pack you want
  to create.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ConformancePackInputParameters"`: A list of ConformancePackInputParameter objects.
- `"DeliveryS3Bucket"`: The name of the Amazon S3 bucket where Config stores conformance
  pack templates.  This field is optional. If used, it must be prefixed with
  awsconfigconforms.
- `"DeliveryS3KeyPrefix"`: The prefix for the Amazon S3 bucket.  This field is optional.
- `"ExcludedAccounts"`: A list of Amazon Web Services accounts to be excluded from an
  organization conformance pack while deploying a conformance pack.
- `"TemplateBody"`: A string containing full conformance pack template body. Structure
  containing the template body with a minimum length of 1 byte and a maximum length of 51,200
  bytes.
- `"TemplateS3Uri"`: Location of file containing the template body. The uri must point to
  the conformance pack template (max size: 300 KB).  You must have access to read Amazon S3
  bucket. In addition, in order to ensure a successful deployment, the template object must
  not be in an archived storage class if this parameter is passed.
"""
function put_organization_conformance_pack(
    OrganizationConformancePackName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "PutOrganizationConformancePack",
        Dict{String,Any}(
            "OrganizationConformancePackName" => OrganizationConformancePackName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_organization_conformance_pack(
    OrganizationConformancePackName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "PutOrganizationConformancePack",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "OrganizationConformancePackName" => OrganizationConformancePackName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_remediation_configurations(remediation_configurations)
    put_remediation_configurations(remediation_configurations, params::Dict{String,<:Any})

Adds or updates the remediation configuration with a specific Config rule with the selected
target or action. The API creates the RemediationConfiguration object for the Config rule.
The Config rule must already exist for you to add a remediation configuration. The target
(SSM document) must exist and have permissions to use the target.    Be aware of backward
incompatible changes  If you make backward incompatible changes to the SSM document, you
must call this again to ensure the remediations can run. This API does not support adding
remediation configurations for service-linked Config Rules such as Organization Config
rules, the rules deployed by conformance packs, and rules deployed by Amazon Web Services
Security Hub.    Required fields  For manual remediation configuration, you need to provide
a value for automationAssumeRole or use a value in the assumeRolefield to remediate your
resources. The SSM automation document can use either as long as it maps to a valid
parameter. However, for automatic remediation configuration, the only valid assumeRole
field value is AutomationAssumeRole and you need to provide a value for
AutomationAssumeRole to remediate your resources.    Auto remediation can be initiated even
for compliant resources  If you enable auto remediation for a specific Config rule using
the PutRemediationConfigurations API or the Config console, it initiates the remediation
process for all non-compliant resources for that specific rule. The auto remediation
process relies on the compliance data snapshot which is captured on a periodic basis. Any
non-compliant resource that is updated between the snapshot schedule will continue to be
remediated based on the last known compliance data snapshot. This means that in some cases
auto remediation can be initiated even for compliant resources, since the bootstrap
processor uses a database that can have stale evaluation results based on the last known
compliance data snapshot.

# Arguments
- `remediation_configurations`: A list of remediation configuration objects.

"""
function put_remediation_configurations(
    RemediationConfigurations; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "PutRemediationConfigurations",
        Dict{String,Any}("RemediationConfigurations" => RemediationConfigurations);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_remediation_configurations(
    RemediationConfigurations,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "PutRemediationConfigurations",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("RemediationConfigurations" => RemediationConfigurations),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_remediation_exceptions(config_rule_name, resource_keys)
    put_remediation_exceptions(config_rule_name, resource_keys, params::Dict{String,<:Any})

A remediation exception is when a specified resource is no longer considered for
auto-remediation. This API adds a new exception or updates an existing exception for a
specified resource with a specified Config rule.    Exceptions block auto remediation
Config generates a remediation exception when a problem occurs running a remediation action
for a specified resource. Remediation exceptions blocks auto-remediation until the
exception is cleared.    Manual remediation is recommended when placing an exception  When
placing an exception on an Amazon Web Services resource, it is recommended that remediation
is set as manual remediation until the given Config rule for the specified resource
evaluates the resource as NON_COMPLIANT. Once the resource has been evaluated as
NON_COMPLIANT, you can add remediation exceptions and change the remediation type back from
Manual to Auto if you want to use auto-remediation. Otherwise, using auto-remediation
before a NON_COMPLIANT evaluation result can delete resources before the exception is
applied.    Exceptions can only be performed on non-compliant resources  Placing an
exception can only be performed on resources that are NON_COMPLIANT. If you use this API
for COMPLIANT resources or resources that are NOT_APPLICABLE, a remediation exception will
not be generated. For more information on the conditions that initiate the possible Config
evaluation results, see Concepts | Config Rules in the Config Developer Guide.    Auto
remediation can be initiated even for compliant resources  If you enable auto remediation
for a specific Config rule using the PutRemediationConfigurations API or the Config
console, it initiates the remediation process for all non-compliant resources for that
specific rule. The auto remediation process relies on the compliance data snapshot which is
captured on a periodic basis. Any non-compliant resource that is updated between the
snapshot schedule will continue to be remediated based on the last known compliance data
snapshot. This means that in some cases auto remediation can be initiated even for
compliant resources, since the bootstrap processor uses a database that can have stale
evaluation results based on the last known compliance data snapshot.

# Arguments
- `config_rule_name`: The name of the Config rule for which you want to create remediation
  exception.
- `resource_keys`: An exception list of resource exception keys to be processed with the
  current request. Config adds exception for each resource key. For example, Config adds 3
  exceptions for 3 resource keys.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ExpirationTime"`: The exception is automatically deleted after the expiration date.
- `"Message"`: The message contains an explanation of the exception.
"""
function put_remediation_exceptions(
    ConfigRuleName, ResourceKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "PutRemediationExceptions",
        Dict{String,Any}(
            "ConfigRuleName" => ConfigRuleName, "ResourceKeys" => ResourceKeys
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_remediation_exceptions(
    ConfigRuleName,
    ResourceKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "PutRemediationExceptions",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ConfigRuleName" => ConfigRuleName, "ResourceKeys" => ResourceKeys
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_resource_config(configuration, resource_id, resource_type, schema_version_id)
    put_resource_config(configuration, resource_id, resource_type, schema_version_id, params::Dict{String,<:Any})

Records the configuration state for the resource provided in the request. The configuration
state of a resource is represented in Config as Configuration Items. Once this API records
the configuration item, you can retrieve the list of configuration items for the custom
resource type using existing Config APIs.   The custom resource type must be registered
with CloudFormation. This API accepts the configuration item registered with
CloudFormation. When you call this API, Config only stores configuration state of the
resource provided in the request. This API does not change or remediate the configuration
of the resource.  Write-only schema properites are not recorded as part of the published
configuration item.

# Arguments
- `configuration`: The configuration object of the resource in valid JSON format. It must
  match the schema registered with CloudFormation.  The configuration JSON must not exceed 64
  KB.
- `resource_id`: Unique identifier of the resource.
- `resource_type`: The type of the resource. The custom resource type must be registered
  with CloudFormation.   You cannot use the organization names “amzn”, “amazon”,
  “alexa”, “custom” with custom resource types. It is the first part of the
  ResourceType up to the first ::.
- `schema_version_id`: Version of the schema registered for the ResourceType in
  CloudFormation.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ResourceName"`: Name of the resource.
- `"Tags"`: Tags associated with the resource.  This field is not to be confused with the
  Amazon Web Services-wide tag feature for Amazon Web Services resources. Tags for
  PutResourceConfig are tags that you supply for the configuration items of your custom
  resources.
"""
function put_resource_config(
    Configuration,
    ResourceId,
    ResourceType,
    SchemaVersionId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "PutResourceConfig",
        Dict{String,Any}(
            "Configuration" => Configuration,
            "ResourceId" => ResourceId,
            "ResourceType" => ResourceType,
            "SchemaVersionId" => SchemaVersionId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_resource_config(
    Configuration,
    ResourceId,
    ResourceType,
    SchemaVersionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "PutResourceConfig",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Configuration" => Configuration,
                    "ResourceId" => ResourceId,
                    "ResourceType" => ResourceType,
                    "SchemaVersionId" => SchemaVersionId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_retention_configuration(retention_period_in_days)
    put_retention_configuration(retention_period_in_days, params::Dict{String,<:Any})

Creates and updates the retention configuration with details about retention period (number
of days) that Config stores your historical information. The API creates the
RetentionConfiguration object and names the object as default. When you have a
RetentionConfiguration object named default, calling the API modifies the default object.
Currently, Config supports only one retention configuration per region in your account.

# Arguments
- `retention_period_in_days`: Number of days Config stores your historical information.
  Currently, only applicable to the configuration item history.

"""
function put_retention_configuration(
    RetentionPeriodInDays; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "PutRetentionConfiguration",
        Dict{String,Any}("RetentionPeriodInDays" => RetentionPeriodInDays);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_retention_configuration(
    RetentionPeriodInDays,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "PutRetentionConfiguration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("RetentionPeriodInDays" => RetentionPeriodInDays),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_stored_query(stored_query)
    put_stored_query(stored_query, params::Dict{String,<:Any})

Saves a new query or updates an existing saved query. The QueryName must be unique for a
single Amazon Web Services account and a single Amazon Web Services Region. You can create
upto 300 queries in a single Amazon Web Services account and a single Amazon Web Services
Region.   PutStoredQuery is an idempotent API. Subsequent requests won’t create a
duplicate resource if one was already created. If a following request has different tags
values, Config will ignore these differences and treat it as an idempotent request of the
previous. In this case, tags will not be updated, even if they are different.

# Arguments
- `stored_query`: A list of StoredQuery objects. The mandatory fields are QueryName and
  Expression.  When you are creating a query, you must provide a query name and an
  expression. When you are updating a query, you must provide a query name but updating the
  description is optional.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Tags"`: A list of Tags object.
"""
function put_stored_query(StoredQuery; aws_config::AbstractAWSConfig=current_aws_config())
    return config_service(
        "PutStoredQuery",
        Dict{String,Any}("StoredQuery" => StoredQuery);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_stored_query(
    StoredQuery,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "PutStoredQuery",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("StoredQuery" => StoredQuery), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    select_aggregate_resource_config(configuration_aggregator_name, expression)
    select_aggregate_resource_config(configuration_aggregator_name, expression, params::Dict{String,<:Any})

Accepts a structured query language (SQL) SELECT command and an aggregator to query
configuration state of Amazon Web Services resources across multiple accounts and regions,
performs the corresponding search, and returns resource configurations matching the
properties. For more information about query components, see the  Query Components  section
in the Config Developer Guide.  If you run an aggregation query (i.e., using GROUP BY or
using aggregate functions such as COUNT; e.g., SELECT resourceId, COUNT(*) WHERE
resourceType = 'AWS::IAM::Role' GROUP BY resourceId) and do not specify the MaxResults or
the Limit query parameters, the default page size is set to 500. If you run a
non-aggregation query (i.e., not using GROUP BY or aggregate function; e.g., SELECT * WHERE
resourceType = 'AWS::IAM::Role') and do not specify the MaxResults or the Limit query
parameters, the default page size is set to 25.

# Arguments
- `configuration_aggregator_name`: The name of the configuration aggregator.
- `expression`: The SQL query SELECT command.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Limit"`: The maximum number of query results returned on each page.
- `"MaxResults"`: The maximum number of query results returned on each page. Config also
  allows the Limit request parameter.
- `"NextToken"`: The nextToken string returned in a previous request that you use to
  request the next page of results in a paginated response.
"""
function select_aggregate_resource_config(
    ConfigurationAggregatorName,
    Expression;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "SelectAggregateResourceConfig",
        Dict{String,Any}(
            "ConfigurationAggregatorName" => ConfigurationAggregatorName,
            "Expression" => Expression,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function select_aggregate_resource_config(
    ConfigurationAggregatorName,
    Expression,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "SelectAggregateResourceConfig",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ConfigurationAggregatorName" => ConfigurationAggregatorName,
                    "Expression" => Expression,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    select_resource_config(expression)
    select_resource_config(expression, params::Dict{String,<:Any})

Accepts a structured query language (SQL) SELECT command, performs the corresponding
search, and returns resource configurations matching the properties. For more information
about query components, see the  Query Components  section in the Config Developer Guide.

# Arguments
- `expression`: The SQL query SELECT command.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Limit"`: The maximum number of query results returned on each page.
- `"NextToken"`: The nextToken string returned in a previous request that you use to
  request the next page of results in a paginated response.
"""
function select_resource_config(
    Expression; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "SelectResourceConfig",
        Dict{String,Any}("Expression" => Expression);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function select_resource_config(
    Expression,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "SelectResourceConfig",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Expression" => Expression), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_config_rules_evaluation()
    start_config_rules_evaluation(params::Dict{String,<:Any})

Runs an on-demand evaluation for the specified Config rules against the last known
configuration state of the resources. Use StartConfigRulesEvaluation when you want to test
that a rule you updated is working as expected. StartConfigRulesEvaluation does not
re-record the latest configuration state for your resources. It re-runs an evaluation
against the last known state of your resources.  You can specify up to 25 Config rules per
request.  An existing StartConfigRulesEvaluation call for the specified rules must complete
before you can call the API again. If you chose to have Config stream to an Amazon SNS
topic, you will receive a ConfigRuleEvaluationStarted notification when the evaluation
starts.  You don't need to call the StartConfigRulesEvaluation API to run an evaluation for
a new rule. When you create a rule, Config evaluates your resources against the rule
automatically.   The StartConfigRulesEvaluation API is useful if you want to run on-demand
evaluations, such as the following example:   You have a custom rule that evaluates your
IAM resources every 24 hours.   You update your Lambda function to add additional
conditions to your rule.   Instead of waiting for the next periodic evaluation, you call
the StartConfigRulesEvaluation API.   Config invokes your Lambda function and evaluates
your IAM resources.   Your custom rule will still run periodic evaluations every 24 hours.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ConfigRuleNames"`: The list of names of Config rules that you want to run evaluations
  for.
"""
function start_config_rules_evaluation(; aws_config::AbstractAWSConfig=current_aws_config())
    return config_service(
        "StartConfigRulesEvaluation"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function start_config_rules_evaluation(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "StartConfigRulesEvaluation",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_configuration_recorder(configuration_recorder_name)
    start_configuration_recorder(configuration_recorder_name, params::Dict{String,<:Any})

Starts recording configurations of the Amazon Web Services resources you have selected to
record in your Amazon Web Services account. You must have created at least one delivery
channel to successfully start the configuration recorder.

# Arguments
- `configuration_recorder_name`: The name of the recorder object that records each
  configuration change made to the resources.

"""
function start_configuration_recorder(
    ConfigurationRecorderName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "StartConfigurationRecorder",
        Dict{String,Any}("ConfigurationRecorderName" => ConfigurationRecorderName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_configuration_recorder(
    ConfigurationRecorderName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "StartConfigurationRecorder",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ConfigurationRecorderName" => ConfigurationRecorderName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_remediation_execution(config_rule_name, resource_keys)
    start_remediation_execution(config_rule_name, resource_keys, params::Dict{String,<:Any})

Runs an on-demand remediation for the specified Config rules against the last known
remediation configuration. It runs an execution against the current state of your
resources. Remediation execution is asynchronous. You can specify up to 100 resource keys
per request. An existing StartRemediationExecution call for the specified resource keys
must complete before you can call the API again.

# Arguments
- `config_rule_name`: The list of names of Config rules that you want to run remediation
  execution for.
- `resource_keys`: A list of resource keys to be processed with the current request. Each
  element in the list consists of the resource type and resource ID.

"""
function start_remediation_execution(
    ConfigRuleName, ResourceKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "StartRemediationExecution",
        Dict{String,Any}(
            "ConfigRuleName" => ConfigRuleName, "ResourceKeys" => ResourceKeys
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_remediation_execution(
    ConfigRuleName,
    ResourceKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "StartRemediationExecution",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ConfigRuleName" => ConfigRuleName, "ResourceKeys" => ResourceKeys
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_resource_evaluation(evaluation_mode, resource_details)
    start_resource_evaluation(evaluation_mode, resource_details, params::Dict{String,<:Any})

Runs an on-demand evaluation for the specified resource to determine whether the resource
details will comply with configured Config rules. You can also use it for evaluation
purposes. Config recommends using an evaluation context. It runs an execution against the
resource details with all of the Config rules in your account that match with the specified
proactive mode and resource type.  Ensure you have the cloudformation:DescribeType role
setup to validate the resource type schema. You can find the Resource type schema in
\"Amazon Web Services public extensions\" within the CloudFormation registry or with the
following CLI commmand: aws cloudformation describe-type --type-name \"AWS::S3::Bucket\"
--type RESOURCE. For more information, see Managing extensions through the CloudFormation
registry and Amazon Web Services resource and property types reference in the
CloudFormation User Guide.

# Arguments
- `evaluation_mode`: The mode of an evaluation. The valid values for this API are DETECTIVE
  and PROACTIVE.
- `resource_details`: Returns a ResourceDetails object.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: A client token is a unique, case-sensitive string of up to 64 ASCII
  characters. To make an idempotent API request using one of these actions, specify a client
  token in the request.  Avoid reusing the same client token for other API requests. If you
  retry a request that completed successfully using the same client token and the same
  parameters, the retry succeeds without performing any further actions. If you retry a
  successful request using the same client token, but one or more of the parameters are
  different, other than the Region or Availability Zone, the retry fails with an
  IdempotentParameterMismatch error.
- `"EvaluationContext"`: Returns an EvaluationContext object.
- `"EvaluationTimeout"`: The timeout for an evaluation. The default is 900 seconds. You
  cannot specify a number greater than 3600. If you specify 0, Config uses the default.
"""
function start_resource_evaluation(
    EvaluationMode, ResourceDetails; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "StartResourceEvaluation",
        Dict{String,Any}(
            "EvaluationMode" => EvaluationMode, "ResourceDetails" => ResourceDetails
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_resource_evaluation(
    EvaluationMode,
    ResourceDetails,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "StartResourceEvaluation",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "EvaluationMode" => EvaluationMode, "ResourceDetails" => ResourceDetails
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    stop_configuration_recorder(configuration_recorder_name)
    stop_configuration_recorder(configuration_recorder_name, params::Dict{String,<:Any})

Stops recording configurations of the Amazon Web Services resources you have selected to
record in your Amazon Web Services account.

# Arguments
- `configuration_recorder_name`: The name of the recorder object that records each
  configuration change made to the resources.

"""
function stop_configuration_recorder(
    ConfigurationRecorderName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "StopConfigurationRecorder",
        Dict{String,Any}("ConfigurationRecorderName" => ConfigurationRecorderName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function stop_configuration_recorder(
    ConfigurationRecorderName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "StopConfigurationRecorder",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ConfigurationRecorderName" => ConfigurationRecorderName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Associates the specified tags to a resource with the specified resourceArn. If existing
tags on a resource are not specified in the request parameters, they are not changed. If
existing tags are specified, however, then their values will be updated. When a resource is
deleted, the tags associated with that resource are deleted as well.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) that identifies the resource for which to
  list the tags. Currently, the supported resources are ConfigRule, ConfigurationAggregator
  and AggregatorAuthorization.
- `tags`: An array of tag object.

"""
function tag_resource(ResourceArn, Tags; aws_config::AbstractAWSConfig=current_aws_config())
    return config_service(
        "TagResource",
        Dict{String,Any}("ResourceArn" => ResourceArn, "Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    ResourceArn,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "TagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceArn" => ResourceArn, "Tags" => Tags),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Deletes specified tags from a resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) that identifies the resource for which to
  list the tags. Currently, the supported resources are ConfigRule, ConfigurationAggregator
  and AggregatorAuthorization.
- `tag_keys`: The keys of the tags to be removed.

"""
function untag_resource(
    ResourceArn, TagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return config_service(
        "UntagResource",
        Dict{String,Any}("ResourceArn" => ResourceArn, "TagKeys" => TagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    ResourceArn,
    TagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return config_service(
        "UntagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceArn" => ResourceArn, "TagKeys" => TagKeys),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
