# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: marketplace_agreement
using AWS.Compat
using AWS.UUIDs

"""
    describe_agreement(agreement_id)
    describe_agreement(agreement_id, params::Dict{String,<:Any})

Provides details about an agreement, such as the proposer, acceptor, start date, and end
date.

# Arguments
- `agreement_id`: The unique identifier of the agreement.

"""
function describe_agreement(agreementId; aws_config::AbstractAWSConfig=current_aws_config())
    return marketplace_agreement(
        "DescribeAgreement",
        Dict{String,Any}("agreementId" => agreementId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_agreement(
    agreementId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return marketplace_agreement(
        "DescribeAgreement",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("agreementId" => agreementId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_agreement_terms(agreement_id)
    get_agreement_terms(agreement_id, params::Dict{String,<:Any})

Obtains details about the terms in an agreement that you participated in as proposer or
acceptor. The details include:    TermType – The type of term, such as LegalTerm,
RenewalTerm, or ConfigurableUpfrontPricingTerm.    TermID – The ID of the particular
term, which is common between offer and agreement.    TermPayload – The key information
contained in the term, such as the EULA for LegalTerm or pricing and dimensions for various
pricing terms, such as ConfigurableUpfrontPricingTerm or UsageBasedPricingTerm.
Configuration – The buyer/acceptor's selection at the time of agreement creation, such as
the number of units purchased for a dimension or setting the EnableAutoRenew flag.

# Arguments
- `agreement_id`: The unique identifier of the agreement.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of agreements to return in the response.
- `"nextToken"`: A token to specify where to start pagination
"""
function get_agreement_terms(
    agreementId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return marketplace_agreement(
        "GetAgreementTerms",
        Dict{String,Any}("agreementId" => agreementId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_agreement_terms(
    agreementId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return marketplace_agreement(
        "GetAgreementTerms",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("agreementId" => agreementId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    search_agreements()
    search_agreements(params::Dict{String,<:Any})

Searches across all agreements that a proposer or an acceptor has in AWS Marketplace. The
search returns a list of agreements with basic agreement information. The following filter
combinations are supported:    PartyType as Proposer + AgreementType + ResourceIdentifier
  PartyType as Proposer + AgreementType + OfferId     PartyType as Proposer + AgreementType
+ AcceptorAccountId     PartyType as Proposer + AgreementType + Status     PartyType as
Proposer + AgreementType + ResourceIdentifier + Status     PartyType as Proposer +
AgreementType + OfferId + Status     PartyType as Proposer + AgreementType +
AcceptorAccountId + Status     PartyType as Proposer + AgreementType + ResourceType +
Status     PartyType as Proposer + AgreementType + AcceptorAccountId + ResourceType +
Status     PartyType as Proposer + AgreementType + AcceptorAccountId + OfferId
PartyType as Proposer + AgreementType + AcceptorAccountId + OfferId + Status     PartyType
as Proposer + AgreementType + AcceptorAccountId + ResourceIdentifier     PartyType as
Proposer + AgreementType + AcceptorAccountId + ResourceIdentifier + Status     PartyType as
Proposer + AgreementType + AcceptorAccountId + ResourceType

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"catalog"`: The catalog in which the agreement was created.
- `"filters"`: The filter name and value pair used to return a specific list of results.
  The following filters are supported:    ResourceIdentifier – The unique identifier of the
  resource.    ResourceType – Type of the resource, which is the product (AmiProduct,
  ContainerProduct, or SaaSProduct).    PartyType – The party type (either Acceptor or
  Proposer) of the caller. For agreements where the caller is the proposer, use the Proposer
  filter. For agreements where the caller is the acceptor, use the Acceptor filter.
  AcceptorAccountId – The AWS account ID of the party accepting the agreement terms.
  OfferId – The unique identifier of the offer in which the terms are registered in the
  agreement token.    Status – The current status of the agreement. Values include ACTIVE,
  ARCHIVED, CANCELLED, EXPIRED, RENEWED, REPLACED, and TERMINATED.    BeforeEndTime – A
  date used to filter agreements with a date before the endTime of an agreement.
  AfterEndTime – A date used to filter agreements with a date after the endTime of an
  agreement.    AgreementType – The type of agreement. Values include PurchaseAgreement or
  VendorInsightsAgreement.
- `"maxResults"`: The maximum number of agreements to return in the response.
- `"nextToken"`: A token to specify where to start pagination.
- `"sort"`: An object that contains the SortBy and SortOrder attributes.
"""
function search_agreements(; aws_config::AbstractAWSConfig=current_aws_config())
    return marketplace_agreement(
        "SearchAgreements"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function search_agreements(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return marketplace_agreement(
        "SearchAgreements", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
