# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: personalize_events
using AWS.Compat
using AWS.UUIDs

"""
    put_action_interactions(action_interactions, tracking_id)
    put_action_interactions(action_interactions, tracking_id, params::Dict{String,<:Any})

Records action interaction event data. An action interaction event is an interaction
between a user and an action. For example, a user taking an action, such a enrolling in a
membership program or downloading your app.  For more information about recording action
interactions, see Recording action interaction events. For more information about actions
in an Actions dataset, see Actions dataset.

# Arguments
- `action_interactions`: A list of action interaction events from the session.
- `tracking_id`: The ID of your action interaction event tracker. When you create an Action
  interactions dataset, Amazon Personalize creates an action interaction event tracker for
  you. For more information, see Action interaction event tracker ID.

"""
function put_action_interactions(
    actionInteractions, trackingId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return personalize_events(
        "POST",
        "/action-interactions",
        Dict{String,Any}(
            "actionInteractions" => actionInteractions, "trackingId" => trackingId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_action_interactions(
    actionInteractions,
    trackingId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return personalize_events(
        "POST",
        "/action-interactions",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "actionInteractions" => actionInteractions, "trackingId" => trackingId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_actions(actions, dataset_arn)
    put_actions(actions, dataset_arn, params::Dict{String,<:Any})

Adds one or more actions to an Actions dataset. For more information see Importing actions
individually.

# Arguments
- `actions`: A list of action data.
- `dataset_arn`: The Amazon Resource Name (ARN) of the Actions dataset you are adding the
  action or actions to.

"""
function put_actions(
    actions, datasetArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return personalize_events(
        "POST",
        "/actions",
        Dict{String,Any}("actions" => actions, "datasetArn" => datasetArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_actions(
    actions,
    datasetArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return personalize_events(
        "POST",
        "/actions",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("actions" => actions, "datasetArn" => datasetArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_events(event_list, session_id, tracking_id)
    put_events(event_list, session_id, tracking_id, params::Dict{String,<:Any})

Records item interaction event data. For more information see Recording item interaction
events.

# Arguments
- `event_list`: A list of event data from the session.
- `session_id`: The session ID associated with the user's visit. Your application generates
  the sessionId when a user first visits your website or uses your application. Amazon
  Personalize uses the sessionId to associate events with the user before they log in. For
  more information, see Recording item interaction events.
- `tracking_id`: The tracking ID for the event. The ID is generated by a call to the
  CreateEventTracker API.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"userId"`: The user associated with the event.
"""
function put_events(
    eventList, sessionId, trackingId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return personalize_events(
        "POST",
        "/events",
        Dict{String,Any}(
            "eventList" => eventList, "sessionId" => sessionId, "trackingId" => trackingId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_events(
    eventList,
    sessionId,
    trackingId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return personalize_events(
        "POST",
        "/events",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "eventList" => eventList,
                    "sessionId" => sessionId,
                    "trackingId" => trackingId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_items(dataset_arn, items)
    put_items(dataset_arn, items, params::Dict{String,<:Any})

Adds one or more items to an Items dataset. For more information see Importing items
individually.

# Arguments
- `dataset_arn`: The Amazon Resource Name (ARN) of the Items dataset you are adding the
  item or items to.
- `items`: A list of item data.

"""
function put_items(datasetArn, items; aws_config::AbstractAWSConfig=current_aws_config())
    return personalize_events(
        "POST",
        "/items",
        Dict{String,Any}("datasetArn" => datasetArn, "items" => items);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_items(
    datasetArn,
    items,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return personalize_events(
        "POST",
        "/items",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("datasetArn" => datasetArn, "items" => items),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_users(dataset_arn, users)
    put_users(dataset_arn, users, params::Dict{String,<:Any})

Adds one or more users to a Users dataset. For more information see Importing users
individually.

# Arguments
- `dataset_arn`: The Amazon Resource Name (ARN) of the Users dataset you are adding the
  user or users to.
- `users`: A list of user data.

"""
function put_users(datasetArn, users; aws_config::AbstractAWSConfig=current_aws_config())
    return personalize_events(
        "POST",
        "/users",
        Dict{String,Any}("datasetArn" => datasetArn, "users" => users);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_users(
    datasetArn,
    users,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return personalize_events(
        "POST",
        "/users",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("datasetArn" => datasetArn, "users" => users),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
