# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: cloudwatch_logs
using AWS.Compat
using AWS.UUIDs

"""
    associate_kms_key(kms_key_id)
    associate_kms_key(kms_key_id, params::Dict{String,<:Any})

Associates the specified KMS key with either one log group in the account, or with all
stored CloudWatch Logs query insights results in the account. When you use AssociateKmsKey,
you specify either the logGroupName parameter or the resourceIdentifier parameter. You
can't specify both of those parameters in the same operation.   Specify the logGroupName
parameter to cause all log events stored in the log group to be encrypted with that key.
Only the log events ingested after the key is associated are encrypted with that key.
Associating a KMS key with a log group overrides any existing associations between the log
group and a KMS key. After a KMS key is associated with a log group, all newly ingested
data for the log group is encrypted using the KMS key. This association is stored as long
as the data encrypted with the KMS key is still within CloudWatch Logs. This enables
CloudWatch Logs to decrypt this data whenever it is requested. Associating a key with a log
group does not cause the results of queries of that log group to be encrypted with that
key. To have query results encrypted with a KMS key, you must use an AssociateKmsKey
operation with the resourceIdentifier parameter that specifies a query-result resource.
Specify the resourceIdentifier parameter with a query-result resource, to use that key to
encrypt the stored results of all future StartQuery operations in the account. The response
from a GetQueryResults operation will still return the query results in plain text. Even if
you have not associated a key with your query results, the query results are encrypted when
stored, using the default CloudWatch Logs method. If you run a query from a monitoring
account that queries logs in a source account, the query results key from the monitoring
account, if any, is used.    If you delete the key that is used to encrypt log events or
log group query results, then all the associated stored log events or query results that
were encrypted with that key will be unencryptable and unusable.   CloudWatch Logs supports
only symmetric KMS keys. Do not use an associate an asymmetric KMS key with your log group
or query results. For more information, see Using Symmetric and Asymmetric Keys.  It can
take up to 5 minutes for this operation to take effect. If you attempt to associate a KMS
key with a log group but the KMS key does not exist or the KMS key is disabled, you receive
an InvalidParameterException error.

# Arguments
- `kms_key_id`: The Amazon Resource Name (ARN) of the KMS key to use when encrypting log
  data. This must be a symmetric KMS key. For more information, see Amazon Resource Names and
  Using Symmetric and Asymmetric Keys.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"logGroupName"`: The name of the log group. In your AssociateKmsKey operation, you must
  specify either the resourceIdentifier parameter or the logGroup parameter, but you can't
  specify both.
- `"resourceIdentifier"`: Specifies the target for this operation. You must specify one of
  the following:   Specify the following ARN to have future GetQueryResults operations in
  this account encrypt the results with the specified KMS key. Replace REGION and ACCOUNT_ID
  with your Region and account ID.  arn:aws:logs:REGION:ACCOUNT_ID:query-result:*    Specify
  the ARN of a log group to have CloudWatch Logs use the KMS key to encrypt log events that
  are ingested and stored by that log group. The log group ARN must be in the following
  format. Replace REGION and ACCOUNT_ID with your Region and account ID.
  arn:aws:logs:REGION:ACCOUNT_ID:log-group:LOG_GROUP_NAME     In your AssociateKmsKey
  operation, you must specify either the resourceIdentifier parameter or the logGroup
  parameter, but you can't specify both.
"""
function associate_kms_key(kmsKeyId; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_logs(
        "AssociateKmsKey",
        Dict{String,Any}("kmsKeyId" => kmsKeyId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_kms_key(
    kmsKeyId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_logs(
        "AssociateKmsKey",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("kmsKeyId" => kmsKeyId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    cancel_export_task(task_id)
    cancel_export_task(task_id, params::Dict{String,<:Any})

Cancels the specified export task. The task must be in the PENDING or RUNNING state.

# Arguments
- `task_id`: The ID of the export task.

"""
function cancel_export_task(taskId; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_logs(
        "CancelExportTask",
        Dict{String,Any}("taskId" => taskId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function cancel_export_task(
    taskId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "CancelExportTask",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("taskId" => taskId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_delivery(delivery_destination_arn, delivery_source_name)
    create_delivery(delivery_destination_arn, delivery_source_name, params::Dict{String,<:Any})

Creates a delivery. A delivery is a connection between a logical delivery source and a
logical delivery destination that you have already created. Only some Amazon Web Services
services support being configured as a delivery source using this operation. These services
are listed as Supported [V2 Permissions] in the table at Enabling logging from Amazon Web
Services services.  A delivery destination can represent a log group in CloudWatch Logs, an
Amazon S3 bucket, or a delivery stream in Firehose. To configure logs delivery between a
supported Amazon Web Services service and a destination, you must do the following:
Create a delivery source, which is a logical object that represents the resource that is
actually sending the logs. For more information, see PutDeliverySource.   Create a delivery
destination, which is a logical object that represents the actual delivery destination. For
more information, see PutDeliveryDestination.   If you are delivering logs cross-account,
you must use PutDeliveryDestinationPolicy in the destination account to assign an IAM
policy to the destination. This policy allows delivery to that destination.    Use
CreateDelivery to create a delivery by pairing exactly one delivery source and one delivery
destination.    You can configure a single delivery source to send logs to multiple
destinations by creating multiple deliveries. You can also create multiple deliveries to
configure multiple delivery sources to send logs to the same delivery destination. You
can't update an existing delivery. You can only create and delete deliveries.

# Arguments
- `delivery_destination_arn`: The ARN of the delivery destination to use for this delivery.
- `delivery_source_name`: The name of the delivery source to use for this delivery.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"tags"`: An optional list of key-value pairs to associate with the resource. For more
  information about tagging, see Tagging Amazon Web Services resources
"""
function create_delivery(
    deliveryDestinationArn,
    deliverySourceName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_logs(
        "CreateDelivery",
        Dict{String,Any}(
            "deliveryDestinationArn" => deliveryDestinationArn,
            "deliverySourceName" => deliverySourceName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_delivery(
    deliveryDestinationArn,
    deliverySourceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_logs(
        "CreateDelivery",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "deliveryDestinationArn" => deliveryDestinationArn,
                    "deliverySourceName" => deliverySourceName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_export_task(destination, from, log_group_name, to)
    create_export_task(destination, from, log_group_name, to, params::Dict{String,<:Any})

Creates an export task so that you can efficiently export data from a log group to an
Amazon S3 bucket. When you perform a CreateExportTask operation, you must use credentials
that have permission to write to the S3 bucket that you specify as the destination.
Exporting log data to S3 buckets that are encrypted by KMS is supported. Exporting log data
to Amazon S3 buckets that have S3 Object Lock enabled with a retention period is also
supported. Exporting to S3 buckets that are encrypted with AES-256 is supported.  This is
an asynchronous call. If all the required information is provided, this operation initiates
an export task and responds with the ID of the task. After the task has started, you can
use DescribeExportTasks to get the status of the export task. Each account can only have
one active (RUNNING or PENDING) export task at a time. To cancel an export task, use
CancelExportTask. You can export logs from multiple log groups or multiple time ranges to
the same S3 bucket. To separate log data for each export task, specify a prefix to be used
as the Amazon S3 key prefix for all exported objects.  Time-based sorting on chunks of log
data inside an exported file is not guaranteed. You can sort the exported log field data by
using Linux utilities.

# Arguments
- `destination`: The name of S3 bucket for the exported log data. The bucket must be in the
  same Amazon Web Services Region.
- `from`: The start time of the range for the request, expressed as the number of
  milliseconds after Jan 1, 1970 00:00:00 UTC. Events with a timestamp earlier than this time
  are not exported.
- `log_group_name`: The name of the log group.
- `to`: The end time of the range for the request, expressed as the number of milliseconds
  after Jan 1, 1970 00:00:00 UTC. Events with a timestamp later than this time are not
  exported. You must specify a time that is not earlier than when this log group was created.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"destinationPrefix"`: The prefix used as the start of the key for every object exported.
  If you don't specify a value, the default is exportedlogs.
- `"logStreamNamePrefix"`: Export only log streams that match the provided prefix. If you
  don't specify a value, no prefix filter is applied.
- `"taskName"`: The name of the export task.
"""
function create_export_task(
    destination, from, logGroupName, to; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "CreateExportTask",
        Dict{String,Any}(
            "destination" => destination,
            "from" => from,
            "logGroupName" => logGroupName,
            "to" => to,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_export_task(
    destination,
    from,
    logGroupName,
    to,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_logs(
        "CreateExportTask",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "destination" => destination,
                    "from" => from,
                    "logGroupName" => logGroupName,
                    "to" => to,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_log_anomaly_detector(log_group_arn_list)
    create_log_anomaly_detector(log_group_arn_list, params::Dict{String,<:Any})

Creates an anomaly detector that regularly scans one or more log groups and look for
patterns and anomalies in the logs. An anomaly detector can help surface issues by
automatically discovering anomalies in your log event traffic. An anomaly detector uses
machine learning algorithms to scan log events and find patterns. A pattern is a shared
text structure that recurs among your log fields. Patterns provide a useful tool for
analyzing large sets of logs because a large number of log events can often be compressed
into a few patterns. The anomaly detector uses pattern recognition to find anomalies, which
are unusual log events. It uses the evaluationFrequency to compare current log events and
patterns with trained baselines.  Fields within a pattern are called tokens. Fields that
vary within a pattern, such as a request ID or timestamp, are referred to as dynamic tokens
and represented by &lt;*&gt;.  The following is an example of a pattern:  [INFO] Request
time: &lt;*&gt; ms  This pattern represents log events like [INFO] Request time: 327 ms and
other similar log events that differ only by the number, in this csse 327. When the pattern
is displayed, the different numbers are replaced by &lt;*&gt;   Any parts of log events
that are masked as sensitive data are not scanned for anomalies. For more information about
masking sensitive data, see Help protect sensitive log data with masking.

# Arguments
- `log_group_arn_list`: An array containing the ARN of the log group that this anomaly
  detector will watch. You can specify only one log group ARN.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"anomalyVisibilityTime"`: The number of days to have visibility on an anomaly. After
  this time period has elapsed for an anomaly, it will be automatically baselined and the
  anomaly detector will treat new occurrences of a similar anomaly as normal. Therefore, if
  you do not correct the cause of an anomaly during the time period specified in
  anomalyVisibilityTime, it will be considered normal going forward and will not be detected
  as an anomaly.
- `"detectorName"`: A name for this anomaly detector.
- `"evaluationFrequency"`: Specifies how often the anomaly detector is to run and look for
  anomalies. Set this value according to the frequency that the log group receives new logs.
  For example, if the log group receives new log events every 10 minutes, then 15 minutes
  might be a good setting for evaluationFrequency .
- `"filterPattern"`: You can use this parameter to limit the anomaly detection model to
  examine only log events that match the pattern you specify here. For more information, see
  Filter and Pattern Syntax.
- `"kmsKeyId"`: Optionally assigns a KMS key to secure this anomaly detector and its
  findings. If a key is assigned, the anomalies found and the model used by this detector are
  encrypted at rest with the key. If a key is assigned to an anomaly detector, a user must
  have permissions for both this key and for the anomaly detector to retrieve information
  about the anomalies that it finds. For more information about using a KMS key and to see
  the required IAM policy, see Use a KMS key with an anomaly detector.
- `"tags"`: An optional list of key-value pairs to associate with the resource. For more
  information about tagging, see Tagging Amazon Web Services resources
"""
function create_log_anomaly_detector(
    logGroupArnList; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "CreateLogAnomalyDetector",
        Dict{String,Any}("logGroupArnList" => logGroupArnList);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_log_anomaly_detector(
    logGroupArnList,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_logs(
        "CreateLogAnomalyDetector",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("logGroupArnList" => logGroupArnList), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_log_group(log_group_name)
    create_log_group(log_group_name, params::Dict{String,<:Any})

Creates a log group with the specified name. You can create up to 1,000,000 log groups per
Region per account. You must use the following guidelines when naming a log group:   Log
group names must be unique within a Region for an Amazon Web Services account.   Log group
names can be between 1 and 512 characters long.   Log group names consist of the following
characters: a-z, A-Z, 0-9, '_' (underscore), '-' (hyphen), '/' (forward slash), '.'
(period), and '#' (number sign)   Log group names can't start with the string aws/    When
you create a log group, by default the log events in the log group do not expire. To set a
retention policy so that events expire and are deleted after a specified time, use
PutRetentionPolicy. If you associate an KMS key with the log group, ingested data is
encrypted using the KMS key. This association is stored as long as the data encrypted with
the KMS key is still within CloudWatch Logs. This enables CloudWatch Logs to decrypt this
data whenever it is requested. If you attempt to associate a KMS key with the log group but
the KMS key does not exist or the KMS key is disabled, you receive an
InvalidParameterException error.   CloudWatch Logs supports only symmetric KMS keys. Do not
associate an asymmetric KMS key with your log group. For more information, see Using
Symmetric and Asymmetric Keys.

# Arguments
- `log_group_name`: A name for the log group.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"kmsKeyId"`: The Amazon Resource Name (ARN) of the KMS key to use when encrypting log
  data. For more information, see Amazon Resource Names.
- `"logGroupClass"`: Use this parameter to specify the log group class for this log group.
  There are two classes:   The Standard log class supports all CloudWatch Logs features.
  The Infrequent Access log class supports a subset of CloudWatch Logs features and incurs
  lower costs.   If you omit this parameter, the default of STANDARD is used.  The value of
  logGroupClass can't be changed after a log group is created.  For details about the
  features supported by each class, see Log classes
- `"tags"`: The key-value pairs to use for the tags. You can grant users access to certain
  log groups while preventing them from accessing other log groups. To do so, tag your groups
  and use IAM policies that refer to those tags. To assign tags when you create a log group,
  you must have either the logs:TagResource or logs:TagLogGroup permission. For more
  information about tagging, see Tagging Amazon Web Services resources. For more information
  about using tags to control access, see Controlling access to Amazon Web Services resources
  using tags.
"""
function create_log_group(logGroupName; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_logs(
        "CreateLogGroup",
        Dict{String,Any}("logGroupName" => logGroupName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_log_group(
    logGroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_logs(
        "CreateLogGroup",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("logGroupName" => logGroupName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_log_stream(log_group_name, log_stream_name)
    create_log_stream(log_group_name, log_stream_name, params::Dict{String,<:Any})

Creates a log stream for the specified log group. A log stream is a sequence of log events
that originate from a single source, such as an application instance or a resource that is
being monitored. There is no limit on the number of log streams that you can create for a
log group. There is a limit of 50 TPS on CreateLogStream operations, after which
transactions are throttled. You must use the following guidelines when naming a log stream:
  Log stream names must be unique within the log group.   Log stream names can be between 1
and 512 characters long.   Don't use ':' (colon) or '*' (asterisk) characters.

# Arguments
- `log_group_name`: The name of the log group.
- `log_stream_name`: The name of the log stream.

"""
function create_log_stream(
    logGroupName, logStreamName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "CreateLogStream",
        Dict{String,Any}("logGroupName" => logGroupName, "logStreamName" => logStreamName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_log_stream(
    logGroupName,
    logStreamName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_logs(
        "CreateLogStream",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "logGroupName" => logGroupName, "logStreamName" => logStreamName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_account_policy(policy_name, policy_type)
    delete_account_policy(policy_name, policy_type, params::Dict{String,<:Any})

Deletes a CloudWatch Logs account policy. This stops the policy from applying to all log
groups or a subset of log groups in the account. Log-group level policies will still be in
effect. To use this operation, you must be signed on with the correct permissions depending
on the type of policy that you are deleting.   To delete a data protection policy, you must
have the logs:DeleteDataProtectionPolicy and logs:DeleteAccountPolicy permissions.   To
delete a subscription filter policy, you must have the logs:DeleteSubscriptionFilter and
logs:DeleteAccountPolicy permissions.

# Arguments
- `policy_name`: The name of the policy to delete.
- `policy_type`: The type of policy to delete.

"""
function delete_account_policy(
    policyName, policyType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "DeleteAccountPolicy",
        Dict{String,Any}("policyName" => policyName, "policyType" => policyType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_account_policy(
    policyName,
    policyType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_logs(
        "DeleteAccountPolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("policyName" => policyName, "policyType" => policyType),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_data_protection_policy(log_group_identifier)
    delete_data_protection_policy(log_group_identifier, params::Dict{String,<:Any})

Deletes the data protection policy from the specified log group.  For more information
about data protection policies, see PutDataProtectionPolicy.

# Arguments
- `log_group_identifier`: The name or ARN of the log group that you want to delete the data
  protection policy for.

"""
function delete_data_protection_policy(
    logGroupIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "DeleteDataProtectionPolicy",
        Dict{String,Any}("logGroupIdentifier" => logGroupIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_data_protection_policy(
    logGroupIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_logs(
        "DeleteDataProtectionPolicy",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("logGroupIdentifier" => logGroupIdentifier), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_delivery(id)
    delete_delivery(id, params::Dict{String,<:Any})

Deletes s delivery. A delivery is a connection between a logical delivery source and a
logical delivery destination. Deleting a delivery only deletes the connection between the
delivery source and delivery destination. It does not delete the delivery destination or
the delivery source.

# Arguments
- `id`: The unique ID of the delivery to delete. You can find the ID of a delivery with the
  DescribeDeliveries operation.

"""
function delete_delivery(id; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_logs(
        "DeleteDelivery",
        Dict{String,Any}("id" => id);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_delivery(
    id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "DeleteDelivery",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("id" => id), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_delivery_destination(name)
    delete_delivery_destination(name, params::Dict{String,<:Any})

Deletes a delivery destination. A delivery is a connection between a logical delivery
source and a logical delivery destination. You can't delete a delivery destination if any
current deliveries are associated with it. To find whether any deliveries are associated
with this delivery destination, use the DescribeDeliveries operation and check the
deliveryDestinationArn field in the results.

# Arguments
- `name`: The name of the delivery destination that you want to delete. You can find a list
  of delivery destionation names by using the DescribeDeliveryDestinations operation.

"""
function delete_delivery_destination(
    name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "DeleteDeliveryDestination",
        Dict{String,Any}("name" => name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_delivery_destination(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "DeleteDeliveryDestination",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("name" => name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_delivery_destination_policy(delivery_destination_name)
    delete_delivery_destination_policy(delivery_destination_name, params::Dict{String,<:Any})

Deletes a delivery destination policy. For more information about these policies, see
PutDeliveryDestinationPolicy.

# Arguments
- `delivery_destination_name`: The name of the delivery destination that you want to delete
  the policy for.

"""
function delete_delivery_destination_policy(
    deliveryDestinationName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "DeleteDeliveryDestinationPolicy",
        Dict{String,Any}("deliveryDestinationName" => deliveryDestinationName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_delivery_destination_policy(
    deliveryDestinationName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_logs(
        "DeleteDeliveryDestinationPolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("deliveryDestinationName" => deliveryDestinationName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_delivery_source(name)
    delete_delivery_source(name, params::Dict{String,<:Any})

Deletes a delivery source. A delivery is a connection between a logical delivery source and
a logical delivery destination. You can't delete a delivery source if any current
deliveries are associated with it. To find whether any deliveries are associated with this
delivery source, use the DescribeDeliveries operation and check the deliverySourceName
field in the results.

# Arguments
- `name`: The name of the delivery source that you want to delete.

"""
function delete_delivery_source(name; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_logs(
        "DeleteDeliverySource",
        Dict{String,Any}("name" => name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_delivery_source(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "DeleteDeliverySource",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("name" => name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_destination(destination_name)
    delete_destination(destination_name, params::Dict{String,<:Any})

Deletes the specified destination, and eventually disables all the subscription filters
that publish to it. This operation does not delete the physical resource encapsulated by
the destination.

# Arguments
- `destination_name`: The name of the destination.

"""
function delete_destination(
    destinationName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "DeleteDestination",
        Dict{String,Any}("destinationName" => destinationName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_destination(
    destinationName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_logs(
        "DeleteDestination",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("destinationName" => destinationName), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_log_anomaly_detector(anomaly_detector_arn)
    delete_log_anomaly_detector(anomaly_detector_arn, params::Dict{String,<:Any})

Deletes the specified CloudWatch Logs anomaly detector.

# Arguments
- `anomaly_detector_arn`: The ARN of the anomaly detector to delete. You can find the ARNs
  of log anomaly detectors in your account by using the ListLogAnomalyDetectors operation.

"""
function delete_log_anomaly_detector(
    anomalyDetectorArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "DeleteLogAnomalyDetector",
        Dict{String,Any}("anomalyDetectorArn" => anomalyDetectorArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_log_anomaly_detector(
    anomalyDetectorArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_logs(
        "DeleteLogAnomalyDetector",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("anomalyDetectorArn" => anomalyDetectorArn), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_log_group(log_group_name)
    delete_log_group(log_group_name, params::Dict{String,<:Any})

Deletes the specified log group and permanently deletes all the archived log events
associated with the log group.

# Arguments
- `log_group_name`: The name of the log group.

"""
function delete_log_group(logGroupName; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_logs(
        "DeleteLogGroup",
        Dict{String,Any}("logGroupName" => logGroupName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_log_group(
    logGroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_logs(
        "DeleteLogGroup",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("logGroupName" => logGroupName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_log_stream(log_group_name, log_stream_name)
    delete_log_stream(log_group_name, log_stream_name, params::Dict{String,<:Any})

Deletes the specified log stream and permanently deletes all the archived log events
associated with the log stream.

# Arguments
- `log_group_name`: The name of the log group.
- `log_stream_name`: The name of the log stream.

"""
function delete_log_stream(
    logGroupName, logStreamName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "DeleteLogStream",
        Dict{String,Any}("logGroupName" => logGroupName, "logStreamName" => logStreamName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_log_stream(
    logGroupName,
    logStreamName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_logs(
        "DeleteLogStream",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "logGroupName" => logGroupName, "logStreamName" => logStreamName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_metric_filter(filter_name, log_group_name)
    delete_metric_filter(filter_name, log_group_name, params::Dict{String,<:Any})

Deletes the specified metric filter.

# Arguments
- `filter_name`: The name of the metric filter.
- `log_group_name`: The name of the log group.

"""
function delete_metric_filter(
    filterName, logGroupName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "DeleteMetricFilter",
        Dict{String,Any}("filterName" => filterName, "logGroupName" => logGroupName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_metric_filter(
    filterName,
    logGroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_logs(
        "DeleteMetricFilter",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "filterName" => filterName, "logGroupName" => logGroupName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_query_definition(query_definition_id)
    delete_query_definition(query_definition_id, params::Dict{String,<:Any})

Deletes a saved CloudWatch Logs Insights query definition. A query definition contains
details about a saved CloudWatch Logs Insights query. Each DeleteQueryDefinition operation
can delete one query definition. You must have the logs:DeleteQueryDefinition permission to
be able to perform this operation.

# Arguments
- `query_definition_id`: The ID of the query definition that you want to delete. You can
  use DescribeQueryDefinitions to retrieve the IDs of your saved query definitions.

"""
function delete_query_definition(
    queryDefinitionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "DeleteQueryDefinition",
        Dict{String,Any}("queryDefinitionId" => queryDefinitionId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_query_definition(
    queryDefinitionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_logs(
        "DeleteQueryDefinition",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("queryDefinitionId" => queryDefinitionId), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_resource_policy()
    delete_resource_policy(params::Dict{String,<:Any})

Deletes a resource policy from this account. This revokes the access of the identities in
that policy to put log events to this account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"policyName"`: The name of the policy to be revoked. This parameter is required.
"""
function delete_resource_policy(; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_logs(
        "DeleteResourcePolicy"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function delete_resource_policy(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "DeleteResourcePolicy",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_retention_policy(log_group_name)
    delete_retention_policy(log_group_name, params::Dict{String,<:Any})

Deletes the specified retention policy. Log events do not expire if they belong to log
groups without a retention policy.

# Arguments
- `log_group_name`: The name of the log group.

"""
function delete_retention_policy(
    logGroupName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "DeleteRetentionPolicy",
        Dict{String,Any}("logGroupName" => logGroupName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_retention_policy(
    logGroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_logs(
        "DeleteRetentionPolicy",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("logGroupName" => logGroupName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_subscription_filter(filter_name, log_group_name)
    delete_subscription_filter(filter_name, log_group_name, params::Dict{String,<:Any})

Deletes the specified subscription filter.

# Arguments
- `filter_name`: The name of the subscription filter.
- `log_group_name`: The name of the log group.

"""
function delete_subscription_filter(
    filterName, logGroupName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "DeleteSubscriptionFilter",
        Dict{String,Any}("filterName" => filterName, "logGroupName" => logGroupName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_subscription_filter(
    filterName,
    logGroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_logs(
        "DeleteSubscriptionFilter",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "filterName" => filterName, "logGroupName" => logGroupName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_account_policies(policy_type)
    describe_account_policies(policy_type, params::Dict{String,<:Any})

Returns a list of all CloudWatch Logs account policies in the account.

# Arguments
- `policy_type`: Use this parameter to limit the returned policies to only the policies
  that match the policy type that you specify.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountIdentifiers"`: If you are using an account that is set up as a monitoring
  account for CloudWatch unified cross-account observability, you can use this to specify the
  account ID of a source account. If you do, the operation returns the account policy for the
  specified account. Currently, you can specify only one account ID in this parameter. If you
  omit this parameter, only the policy in the current account is returned.
- `"policyName"`: Use this parameter to limit the returned policies to only the policy with
  the name that you specify.
"""
function describe_account_policies(
    policyType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "DescribeAccountPolicies",
        Dict{String,Any}("policyType" => policyType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_account_policies(
    policyType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_logs(
        "DescribeAccountPolicies",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("policyType" => policyType), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_deliveries()
    describe_deliveries(params::Dict{String,<:Any})

Retrieves a list of the deliveries that have been created in the account. A delivery is a
connection between a  delivery source  and a  delivery destination . A delivery source
represents an Amazon Web Services resource that sends logs to an logs delivery destination.
The destination can be CloudWatch Logs, Amazon S3, or Firehose. Only some Amazon Web
Services services support being configured as a delivery source. These services are listed
in Enable logging from Amazon Web Services services.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"limit"`: Optionally specify the maximum number of deliveries to return in the response.
- `"nextToken"`:
"""
function describe_deliveries(; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_logs(
        "DescribeDeliveries"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_deliveries(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "DescribeDeliveries", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_delivery_destinations()
    describe_delivery_destinations(params::Dict{String,<:Any})

Retrieves a list of the delivery destinations that have been created in the account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"limit"`: Optionally specify the maximum number of delivery destinations to return in
  the response.
- `"nextToken"`:
"""
function describe_delivery_destinations(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "DescribeDeliveryDestinations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_delivery_destinations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "DescribeDeliveryDestinations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_delivery_sources()
    describe_delivery_sources(params::Dict{String,<:Any})

Retrieves a list of the delivery sources that have been created in the account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"limit"`: Optionally specify the maximum number of delivery sources to return in the
  response.
- `"nextToken"`:
"""
function describe_delivery_sources(; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_logs(
        "DescribeDeliverySources"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_delivery_sources(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "DescribeDeliverySources",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_destinations()
    describe_destinations(params::Dict{String,<:Any})

Lists all your destinations. The results are ASCII-sorted by destination name.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DestinationNamePrefix"`: The prefix to match. If you don't specify a value, no prefix
  filter is applied.
- `"limit"`: The maximum number of items returned. If you don't specify a value, the
  default maximum value of 50 items is used.
- `"nextToken"`: The token for the next set of items to return. (You received this token
  from a previous call.)
"""
function describe_destinations(; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_logs(
        "DescribeDestinations"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_destinations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "DescribeDestinations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_export_tasks()
    describe_export_tasks(params::Dict{String,<:Any})

Lists the specified export tasks. You can list all your export tasks or filter the results
based on task ID or task status.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"limit"`: The maximum number of items returned. If you don't specify a value, the
  default is up to 50 items.
- `"nextToken"`: The token for the next set of items to return. (You received this token
  from a previous call.)
- `"statusCode"`: The status code of the export task. Specifying a status code filters the
  results to zero or more export tasks.
- `"taskId"`: The ID of the export task. Specifying a task ID filters the results to one or
  zero export tasks.
"""
function describe_export_tasks(; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_logs(
        "DescribeExportTasks"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_export_tasks(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "DescribeExportTasks",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_log_groups()
    describe_log_groups(params::Dict{String,<:Any})

Lists the specified log groups. You can list all your log groups or filter the results by
prefix. The results are ASCII-sorted by log group name. CloudWatch Logs doesn’t support
IAM policies that control access to the DescribeLogGroups action by using the
aws:ResourceTag/key-name  condition key. Other CloudWatch Logs actions do support the use
of the aws:ResourceTag/key-name  condition key to control access. For more information
about using tags to control access, see Controlling access to Amazon Web Services resources
using tags. If you are using CloudWatch cross-account observability, you can use this
operation in a monitoring account and view data from the linked source accounts. For more
information, see CloudWatch cross-account observability.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountIdentifiers"`: When includeLinkedAccounts is set to True, use this parameter to
  specify the list of accounts to search. You can specify as many as 20 account IDs in the
  array.
- `"includeLinkedAccounts"`: If you are using a monitoring account, set this to True to
  have the operation return log groups in the accounts listed in accountIdentifiers. If this
  parameter is set to true and accountIdentifiers contains a null value, the operation
  returns all log groups in the monitoring account and all log groups in all source accounts
  that are linked to the monitoring account.
- `"limit"`: The maximum number of items returned. If you don't specify a value, the
  default is up to 50 items.
- `"logGroupClass"`: Specifies the log group class for this log group. There are two
  classes:   The Standard log class supports all CloudWatch Logs features.   The Infrequent
  Access log class supports a subset of CloudWatch Logs features and incurs lower costs.
  For details about the features supported by each class, see Log classes
- `"logGroupNamePattern"`: If you specify a string for this parameter, the operation
  returns only log groups that have names that match the string based on a case-sensitive
  substring search. For example, if you specify Foo, log groups named FooBar, aws/Foo, and
  GroupFoo would match, but foo, F/o/o and Froo would not match. If you specify
  logGroupNamePattern in your request, then only arn, creationTime, and logGroupName are
  included in the response.    logGroupNamePattern and logGroupNamePrefix are mutually
  exclusive. Only one of these parameters can be passed.
- `"logGroupNamePrefix"`: The prefix to match.   logGroupNamePrefix and logGroupNamePattern
  are mutually exclusive. Only one of these parameters can be passed.
- `"nextToken"`: The token for the next set of items to return. (You received this token
  from a previous call.)
"""
function describe_log_groups(; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_logs(
        "DescribeLogGroups"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_log_groups(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "DescribeLogGroups", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_log_streams()
    describe_log_streams(params::Dict{String,<:Any})

Lists the log streams for the specified log group. You can list all the log streams or
filter the results by prefix. You can also control how the results are ordered. You can
specify the log group to search by using either logGroupIdentifier or logGroupName. You
must include one of these two parameters, but you can't include both.  This operation has a
limit of five transactions per second, after which transactions are throttled. If you are
using CloudWatch cross-account observability, you can use this operation in a monitoring
account and view data from the linked source accounts. For more information, see CloudWatch
cross-account observability.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"descending"`: If the value is true, results are returned in descending order. If the
  value is to false, results are returned in ascending order. The default value is false.
- `"limit"`: The maximum number of items returned. If you don't specify a value, the
  default is up to 50 items.
- `"logGroupIdentifier"`: Specify either the name or ARN of the log group to view. If the
  log group is in a source account and you are using a monitoring account, you must use the
  log group ARN.   You must include either logGroupIdentifier or logGroupName, but not both.
- `"logGroupName"`: The name of the log group.   You must include either logGroupIdentifier
  or logGroupName, but not both.
- `"logStreamNamePrefix"`: The prefix to match. If orderBy is LastEventTime, you cannot
  specify this parameter.
- `"nextToken"`: The token for the next set of items to return. (You received this token
  from a previous call.)
- `"orderBy"`: If the value is LogStreamName, the results are ordered by log stream name.
  If the value is LastEventTime, the results are ordered by the event time. The default value
  is LogStreamName. If you order the results by event time, you cannot specify the
  logStreamNamePrefix parameter.  lastEventTimestamp represents the time of the most recent
  log event in the log stream in CloudWatch Logs. This number is expressed as the number of
  milliseconds after Jan 1, 1970 00:00:00 UTC. lastEventTimestamp updates on an eventual
  consistency basis. It typically updates in less than an hour from ingestion, but in rare
  situations might take longer.
"""
function describe_log_streams(; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_logs(
        "DescribeLogStreams"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_log_streams(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "DescribeLogStreams", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_metric_filters()
    describe_metric_filters(params::Dict{String,<:Any})

Lists the specified metric filters. You can list all of the metric filters or filter the
results by log name, prefix, metric name, or metric namespace. The results are ASCII-sorted
by filter name.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"filterNamePrefix"`: The prefix to match. CloudWatch Logs uses the value that you set
  here only if you also include the logGroupName parameter in your request.
- `"limit"`: The maximum number of items returned. If you don't specify a value, the
  default is up to 50 items.
- `"logGroupName"`: The name of the log group.
- `"metricName"`: Filters results to include only those with the specified metric name. If
  you include this parameter in your request, you must also include the metricNamespace
  parameter.
- `"metricNamespace"`: Filters results to include only those in the specified namespace. If
  you include this parameter in your request, you must also include the metricName parameter.
- `"nextToken"`: The token for the next set of items to return. (You received this token
  from a previous call.)
"""
function describe_metric_filters(; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_logs(
        "DescribeMetricFilters"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_metric_filters(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "DescribeMetricFilters",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_queries()
    describe_queries(params::Dict{String,<:Any})

Returns a list of CloudWatch Logs Insights queries that are scheduled, running, or have
been run recently in this account. You can request all queries or limit it to queries of a
specific log group or queries with a certain status.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"logGroupName"`: Limits the returned queries to only those for the specified log group.
- `"maxResults"`: Limits the number of returned queries to the specified number.
- `"nextToken"`:
- `"status"`: Limits the returned queries to only those that have the specified status.
  Valid values are Cancelled, Complete, Failed, Running, and Scheduled.
"""
function describe_queries(; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_logs(
        "DescribeQueries"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_queries(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "DescribeQueries", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_query_definitions()
    describe_query_definitions(params::Dict{String,<:Any})

This operation returns a paginated list of your saved CloudWatch Logs Insights query
definitions. You can retrieve query definitions from the current account or from a source
account that is linked to the current account. You can use the queryDefinitionNamePrefix
parameter to limit the results to only the query definitions that have names that start
with a certain string.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: Limits the number of returned query definitions to the specified number.
- `"nextToken"`:
- `"queryDefinitionNamePrefix"`: Use this parameter to filter your results to only the
  query definitions that have names that start with the prefix you specify.
"""
function describe_query_definitions(; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_logs(
        "DescribeQueryDefinitions"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_query_definitions(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "DescribeQueryDefinitions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_resource_policies()
    describe_resource_policies(params::Dict{String,<:Any})

Lists the resource policies in this account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"limit"`: The maximum number of resource policies to be displayed with one call of this
  API.
- `"nextToken"`:
"""
function describe_resource_policies(; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_logs(
        "DescribeResourcePolicies"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_resource_policies(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "DescribeResourcePolicies",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_subscription_filters(log_group_name)
    describe_subscription_filters(log_group_name, params::Dict{String,<:Any})

Lists the subscription filters for the specified log group. You can list all the
subscription filters or filter the results by prefix. The results are ASCII-sorted by
filter name.

# Arguments
- `log_group_name`: The name of the log group.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"filterNamePrefix"`: The prefix to match. If you don't specify a value, no prefix filter
  is applied.
- `"limit"`: The maximum number of items returned. If you don't specify a value, the
  default is up to 50 items.
- `"nextToken"`: The token for the next set of items to return. (You received this token
  from a previous call.)
"""
function describe_subscription_filters(
    logGroupName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "DescribeSubscriptionFilters",
        Dict{String,Any}("logGroupName" => logGroupName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_subscription_filters(
    logGroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_logs(
        "DescribeSubscriptionFilters",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("logGroupName" => logGroupName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_kms_key()
    disassociate_kms_key(params::Dict{String,<:Any})

Disassociates the specified KMS key from the specified log group or from all CloudWatch
Logs Insights query results in the account. When you use DisassociateKmsKey, you specify
either the logGroupName parameter or the resourceIdentifier parameter. You can't specify
both of those parameters in the same operation.   Specify the logGroupName parameter to
stop using the KMS key to encrypt future log events ingested and stored in the log group.
Instead, they will be encrypted with the default CloudWatch Logs method. The log events
that were ingested while the key was associated with the log group are still encrypted with
that key. Therefore, CloudWatch Logs will need permissions for the key whenever that data
is accessed.   Specify the resourceIdentifier parameter with the query-result resource to
stop using the KMS key to encrypt the results of all future StartQuery operations in the
account. They will instead be encrypted with the default CloudWatch Logs method. The
results from queries that ran while the key was associated with the account are still
encrypted with that key. Therefore, CloudWatch Logs will need permissions for the key
whenever that data is accessed.   It can take up to 5 minutes for this operation to take
effect.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"logGroupName"`: The name of the log group. In your DisassociateKmsKey operation, you
  must specify either the resourceIdentifier parameter or the logGroup parameter, but you
  can't specify both.
- `"resourceIdentifier"`: Specifies the target for this operation. You must specify one of
  the following:   Specify the ARN of a log group to stop having CloudWatch Logs use the KMS
  key to encrypt log events that are ingested and stored by that log group. After you run
  this operation, CloudWatch Logs encrypts ingested log events with the default CloudWatch
  Logs method. The log group ARN must be in the following format. Replace REGION and
  ACCOUNT_ID with your Region and account ID.
  arn:aws:logs:REGION:ACCOUNT_ID:log-group:LOG_GROUP_NAME     Specify the following ARN to
  stop using this key to encrypt the results of future StartQuery operations in this account.
  Replace REGION and ACCOUNT_ID with your Region and account ID.
  arn:aws:logs:REGION:ACCOUNT_ID:query-result:*    In your DisssociateKmsKey operation, you
  must specify either the resourceIdentifier parameter or the logGroup parameter, but you
  can't specify both.
"""
function disassociate_kms_key(; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_logs(
        "DisassociateKmsKey"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function disassociate_kms_key(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "DisassociateKmsKey", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    filter_log_events()
    filter_log_events(params::Dict{String,<:Any})

Lists log events from the specified log group. You can list all the log events or filter
the results using a filter pattern, a time range, and the name of the log stream. You must
have the logs:FilterLogEvents permission to perform this operation. You can specify the log
group to search by using either logGroupIdentifier or logGroupName. You must include one of
these two parameters, but you can't include both.  By default, this operation returns as
many log events as can fit in 1 MB (up to 10,000 log events) or all the events found within
the specified time range. If the results include a token, that means there are more log
events available. You can get additional results by specifying the token in a subsequent
call. This operation can return empty results while there are more log events available
through the token. The returned log events are sorted by event timestamp, the timestamp
when the event was ingested by CloudWatch Logs, and the ID of the PutLogEvents request. If
you are using CloudWatch cross-account observability, you can use this operation in a
monitoring account and view data from the linked source accounts. For more information, see
CloudWatch cross-account observability.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"endTime"`: The end of the time range, expressed as the number of milliseconds after Jan
  1, 1970 00:00:00 UTC. Events with a timestamp later than this time are not returned.
- `"filterPattern"`: The filter pattern to use. For more information, see Filter and
  Pattern Syntax. If not provided, all the events are matched.
- `"interleaved"`: If the value is true, the operation attempts to provide responses that
  contain events from multiple log streams within the log group, interleaved in a single
  response. If the value is false, all the matched log events in the first log stream are
  searched first, then those in the next log stream, and so on.  Important As of June 17,
  2019, this parameter is ignored and the value is assumed to be true. The response from this
  operation always interleaves events from multiple log streams within a log group.
- `"limit"`: The maximum number of events to return. The default is 10,000 events.
- `"logGroupIdentifier"`: Specify either the name or ARN of the log group to view log
  events from. If the log group is in a source account and you are using a monitoring
  account, you must use the log group ARN.   You must include either logGroupIdentifier or
  logGroupName, but not both.
- `"logGroupName"`: The name of the log group to search.   You must include either
  logGroupIdentifier or logGroupName, but not both.
- `"logStreamNamePrefix"`: Filters the results to include only events from log streams that
  have names starting with this prefix. If you specify a value for both logStreamNamePrefix
  and logStreamNames, but the value for logStreamNamePrefix does not match any log stream
  names specified in logStreamNames, the action returns an InvalidParameterException error.
- `"logStreamNames"`: Filters the results to only logs from the log streams in this list.
  If you specify a value for both logStreamNamePrefix and logStreamNames, the action returns
  an InvalidParameterException error.
- `"nextToken"`: The token for the next set of events to return. (You received this token
  from a previous call.)
- `"startTime"`: The start of the time range, expressed as the number of milliseconds after
  Jan 1, 1970 00:00:00 UTC. Events with a timestamp before this time are not returned.
- `"unmask"`: Specify true to display the log event fields with all sensitive data unmasked
  and visible. The default is false. To use this operation with this parameter, you must be
  signed into an account with the logs:Unmask permission.
"""
function filter_log_events(; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_logs(
        "FilterLogEvents"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function filter_log_events(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "FilterLogEvents", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    get_data_protection_policy(log_group_identifier)
    get_data_protection_policy(log_group_identifier, params::Dict{String,<:Any})

Returns information about a log group data protection policy.

# Arguments
- `log_group_identifier`: The name or ARN of the log group that contains the data
  protection policy that you want to see.

"""
function get_data_protection_policy(
    logGroupIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "GetDataProtectionPolicy",
        Dict{String,Any}("logGroupIdentifier" => logGroupIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_data_protection_policy(
    logGroupIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_logs(
        "GetDataProtectionPolicy",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("logGroupIdentifier" => logGroupIdentifier), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_delivery(id)
    get_delivery(id, params::Dict{String,<:Any})

Returns complete information about one logical delivery. A delivery is a connection between
a  delivery source  and a  delivery destination . A delivery source represents an Amazon
Web Services resource that sends logs to an logs delivery destination. The destination can
be CloudWatch Logs, Amazon S3, or Firehose. Only some Amazon Web Services services support
being configured as a delivery source. These services are listed in Enable logging from
Amazon Web Services services.  You need to specify the delivery id in this operation. You
can find the IDs of the deliveries in your account with the DescribeDeliveries operation.

# Arguments
- `id`: The ID of the delivery that you want to retrieve.

"""
function get_delivery(id; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_logs(
        "GetDelivery",
        Dict{String,Any}("id" => id);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_delivery(
    id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "GetDelivery",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("id" => id), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_delivery_destination(name)
    get_delivery_destination(name, params::Dict{String,<:Any})

Retrieves complete information about one delivery destination.

# Arguments
- `name`: The name of the delivery destination that you want to retrieve.

"""
function get_delivery_destination(name; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_logs(
        "GetDeliveryDestination",
        Dict{String,Any}("name" => name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_delivery_destination(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "GetDeliveryDestination",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("name" => name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_delivery_destination_policy(delivery_destination_name)
    get_delivery_destination_policy(delivery_destination_name, params::Dict{String,<:Any})

Retrieves the delivery destination policy assigned to the delivery destination that you
specify. For more information about delivery destinations and their policies, see
PutDeliveryDestinationPolicy.

# Arguments
- `delivery_destination_name`: The name of the delivery destination that you want to
  retrieve the policy of.

"""
function get_delivery_destination_policy(
    deliveryDestinationName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "GetDeliveryDestinationPolicy",
        Dict{String,Any}("deliveryDestinationName" => deliveryDestinationName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_delivery_destination_policy(
    deliveryDestinationName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_logs(
        "GetDeliveryDestinationPolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("deliveryDestinationName" => deliveryDestinationName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_delivery_source(name)
    get_delivery_source(name, params::Dict{String,<:Any})

Retrieves complete information about one delivery source.

# Arguments
- `name`: The name of the delivery source that you want to retrieve.

"""
function get_delivery_source(name; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_logs(
        "GetDeliverySource",
        Dict{String,Any}("name" => name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_delivery_source(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "GetDeliverySource",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("name" => name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_log_anomaly_detector(anomaly_detector_arn)
    get_log_anomaly_detector(anomaly_detector_arn, params::Dict{String,<:Any})

Retrieves information about the log anomaly detector that you specify.

# Arguments
- `anomaly_detector_arn`: The ARN of the anomaly detector to retrieve information about.
  You can find the ARNs of log anomaly detectors in your account by using the
  ListLogAnomalyDetectors operation.

"""
function get_log_anomaly_detector(
    anomalyDetectorArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "GetLogAnomalyDetector",
        Dict{String,Any}("anomalyDetectorArn" => anomalyDetectorArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_log_anomaly_detector(
    anomalyDetectorArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_logs(
        "GetLogAnomalyDetector",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("anomalyDetectorArn" => anomalyDetectorArn), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_log_events(log_stream_name)
    get_log_events(log_stream_name, params::Dict{String,<:Any})

Lists log events from the specified log stream. You can list all of the log events or
filter using a time range. By default, this operation returns as many log events as can fit
in a response size of 1MB (up to 10,000 log events). You can get additional log events by
specifying one of the tokens in a subsequent call. This operation can return empty results
while there are more log events available through the token. If you are using CloudWatch
cross-account observability, you can use this operation in a monitoring account and view
data from the linked source accounts. For more information, see CloudWatch cross-account
observability. You can specify the log group to search by using either logGroupIdentifier
or logGroupName. You must include one of these two parameters, but you can't include both.

# Arguments
- `log_stream_name`: The name of the log stream.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"endTime"`: The end of the time range, expressed as the number of milliseconds after Jan
  1, 1970 00:00:00 UTC. Events with a timestamp equal to or later than this time are not
  included.
- `"limit"`: The maximum number of log events returned. If you don't specify a limit, the
  default is as many log events as can fit in a response size of 1 MB (up to 10,000 log
  events).
- `"logGroupIdentifier"`: Specify either the name or ARN of the log group to view events
  from. If the log group is in a source account and you are using a monitoring account, you
  must use the log group ARN.   You must include either logGroupIdentifier or logGroupName,
  but not both.
- `"logGroupName"`: The name of the log group.   You must include either logGroupIdentifier
  or logGroupName, but not both.
- `"nextToken"`: The token for the next set of items to return. (You received this token
  from a previous call.)
- `"startFromHead"`: If the value is true, the earliest log events are returned first. If
  the value is false, the latest log events are returned first. The default value is false.
  If you are using a previous nextForwardToken value as the nextToken in this operation, you
  must specify true for startFromHead.
- `"startTime"`: The start of the time range, expressed as the number of milliseconds after
  Jan 1, 1970 00:00:00 UTC. Events with a timestamp equal to this time or later than this
  time are included. Events with a timestamp earlier than this time are not included.
- `"unmask"`: Specify true to display the log event fields with all sensitive data unmasked
  and visible. The default is false. To use this operation with this parameter, you must be
  signed into an account with the logs:Unmask permission.
"""
function get_log_events(logStreamName; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_logs(
        "GetLogEvents",
        Dict{String,Any}("logStreamName" => logStreamName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_log_events(
    logStreamName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_logs(
        "GetLogEvents",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("logStreamName" => logStreamName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_log_group_fields()
    get_log_group_fields(params::Dict{String,<:Any})

Returns a list of the fields that are included in log events in the specified log group.
Includes the percentage of log events that contain each field. The search is limited to a
time period that you specify. You can specify the log group to search by using either
logGroupIdentifier or logGroupName. You must specify one of these parameters, but you can't
specify both.  In the results, fields that start with @ are fields generated by CloudWatch
Logs. For example, @timestamp is the timestamp of each log event. For more information
about the fields that are generated by CloudWatch logs, see Supported Logs and Discovered
Fields. The response results are sorted by the frequency percentage, starting with the
highest percentage. If you are using CloudWatch cross-account observability, you can use
this operation in a monitoring account and view data from the linked source accounts. For
more information, see CloudWatch cross-account observability.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"logGroupIdentifier"`: Specify either the name or ARN of the log group to view. If the
  log group is in a source account and you are using a monitoring account, you must specify
  the ARN.   You must include either logGroupIdentifier or logGroupName, but not both.
- `"logGroupName"`: The name of the log group to search.   You must include either
  logGroupIdentifier or logGroupName, but not both.
- `"time"`: The time to set as the center of the query. If you specify time, the 8 minutes
  before and 8 minutes after this time are searched. If you omit time, the most recent 15
  minutes up to the current time are searched. The time value is specified as epoch time,
  which is the number of seconds since January 1, 1970, 00:00:00 UTC.
"""
function get_log_group_fields(; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_logs(
        "GetLogGroupFields"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_log_group_fields(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "GetLogGroupFields", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    get_log_record(log_record_pointer)
    get_log_record(log_record_pointer, params::Dict{String,<:Any})

Retrieves all of the fields and values of a single log event. All fields are retrieved,
even if the original query that produced the logRecordPointer retrieved only a subset of
fields. Fields are returned as field name/field value pairs. The full unparsed log event is
returned within @message.

# Arguments
- `log_record_pointer`: The pointer corresponding to the log event record you want to
  retrieve. You get this from the response of a GetQueryResults operation. In that response,
  the value of the @ptr field for a log event is the value to use as logRecordPointer to
  retrieve that complete log event record.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"unmask"`: Specify true to display the log event fields with all sensitive data unmasked
  and visible. The default is false. To use this operation with this parameter, you must be
  signed into an account with the logs:Unmask permission.
"""
function get_log_record(
    logRecordPointer; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "GetLogRecord",
        Dict{String,Any}("logRecordPointer" => logRecordPointer);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_log_record(
    logRecordPointer,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_logs(
        "GetLogRecord",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("logRecordPointer" => logRecordPointer), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_query_results(query_id)
    get_query_results(query_id, params::Dict{String,<:Any})

Returns the results from the specified query. Only the fields requested in the query are
returned, along with a @ptr field, which is the identifier for the log record. You can use
the value of @ptr in a GetLogRecord operation to get the full log record.  GetQueryResults
does not start running a query. To run a query, use StartQuery. For more information about
how long results of previous queries are available, see CloudWatch Logs quotas. If the
value of the Status field in the output is Running, this operation returns only partial
results. If you see a value of Scheduled or Running for the status, you can retry the
operation later to see the final results.  If you are using CloudWatch cross-account
observability, you can use this operation in a monitoring account to start queries in
linked source accounts. For more information, see CloudWatch cross-account observability.

# Arguments
- `query_id`: The ID number of the query.

"""
function get_query_results(queryId; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_logs(
        "GetQueryResults",
        Dict{String,Any}("queryId" => queryId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_query_results(
    queryId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_logs(
        "GetQueryResults",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("queryId" => queryId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_anomalies()
    list_anomalies(params::Dict{String,<:Any})

Returns a list of anomalies that log anomaly detectors have found. For details about the
structure format of each anomaly object that is returned, see the example in this section.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"anomalyDetectorArn"`: Use this to optionally limit the results to only the anomalies
  found by a certain anomaly detector.
- `"limit"`: The maximum number of items to return. If you don't specify a value, the
  default maximum value of 50 items is used.
- `"nextToken"`:
- `"suppressionState"`: You can specify this parameter if you want to the operation to
  return only anomalies that are currently either suppressed or unsuppressed.
"""
function list_anomalies(; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_logs(
        "ListAnomalies"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_anomalies(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "ListAnomalies", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_log_anomaly_detectors()
    list_log_anomaly_detectors(params::Dict{String,<:Any})

Retrieves a list of the log anomaly detectors in the account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"filterLogGroupArn"`: Use this to optionally filter the results to only include anomaly
  detectors that are associated with the specified log group.
- `"limit"`: The maximum number of items to return. If you don't specify a value, the
  default maximum value of 50 items is used.
- `"nextToken"`:
"""
function list_log_anomaly_detectors(; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_logs(
        "ListLogAnomalyDetectors"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_log_anomaly_detectors(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "ListLogAnomalyDetectors",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Displays the tags associated with a CloudWatch Logs resource. Currently, log groups and
destinations support tagging.

# Arguments
- `resource_arn`: The ARN of the resource that you want to view tags for. The ARN format of
  a log group is arn:aws:logs:Region:account-id:log-group:log-group-name   The ARN format of
  a destination is arn:aws:logs:Region:account-id:destination:destination-name   For more
  information about ARN format, see CloudWatch Logs resources and operations.

"""
function list_tags_for_resource(
    resourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "ListTagsForResource",
        Dict{String,Any}("resourceArn" => resourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_logs(
        "ListTagsForResource",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("resourceArn" => resourceArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_log_group(log_group_name)
    list_tags_log_group(log_group_name, params::Dict{String,<:Any})

 The ListTagsLogGroup operation is on the path to deprecation. We recommend that you use
ListTagsForResource instead.  Lists the tags for the specified log group.

# Arguments
- `log_group_name`: The name of the log group.

"""
function list_tags_log_group(
    logGroupName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "ListTagsLogGroup",
        Dict{String,Any}("logGroupName" => logGroupName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_log_group(
    logGroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_logs(
        "ListTagsLogGroup",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("logGroupName" => logGroupName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_account_policy(policy_document, policy_name, policy_type)
    put_account_policy(policy_document, policy_name, policy_type, params::Dict{String,<:Any})

Creates an account-level data protection policy or subscription filter policy that applies
to all log groups or a subset of log groups in the account.  Data protection policy  A data
protection policy can help safeguard sensitive data that's ingested by your log groups by
auditing and masking the sensitive log data. Each account can have only one account-level
data protection policy.  Sensitive data is detected and masked when it is ingested into a
log group. When you set a data protection policy, log events ingested into the log groups
before that time are not masked.  If you use PutAccountPolicy to create a data protection
policy for your whole account, it applies to both existing log groups and all log groups
that are created later in this account. The account-level policy is applied to existing log
groups with eventual consistency. It might take up to 5 minutes before sensitive data in
existing log groups begins to be masked. By default, when a user views a log event that
includes masked data, the sensitive data is replaced by asterisks. A user who has the
logs:Unmask permission can use a GetLogEvents or FilterLogEvents operation with the unmask
parameter set to true to view the unmasked log events. Users with the logs:Unmask can also
view unmasked data in the CloudWatch Logs console by running a CloudWatch Logs Insights
query with the unmask query command. For more information, including a list of types of
data that can be audited and masked, see Protect sensitive log data with masking. To use
the PutAccountPolicy operation for a data protection policy, you must be signed on with the
logs:PutDataProtectionPolicy and logs:PutAccountPolicy permissions. The PutAccountPolicy
operation applies to all log groups in the account. You can use PutDataProtectionPolicy to
create a data protection policy that applies to just one log group. If a log group has its
own data protection policy and the account also has an account-level data protection
policy, then the two policies are cumulative. Any sensitive term specified in either policy
is masked.  Subscription filter policy  A subscription filter policy sets up a real-time
feed of log events from CloudWatch Logs to other Amazon Web Services services.
Account-level subscription filter policies apply to both existing log groups and log groups
that are created later in this account. Supported destinations are Kinesis Data Streams,
Firehose, and Lambda. When log events are sent to the receiving service, they are Base64
encoded and compressed with the GZIP format. The following destinations are supported for
subscription filters:   An Kinesis Data Streams data stream in the same account as the
subscription policy, for same-account delivery.   An Firehose data stream in the same
account as the subscription policy, for same-account delivery.   A Lambda function in the
same account as the subscription policy, for same-account delivery.   A logical destination
in a different account created with PutDestination, for cross-account delivery. Kinesis
Data Streams and Firehose are supported as logical destinations.   Each account can have
one account-level subscription filter policy. If you are updating an existing filter, you
must specify the correct name in PolicyName. To perform a PutAccountPolicy subscription
filter operation for any destination except a Lambda function, you must also have the
iam:PassRole permission.

# Arguments
- `policy_document`: Specify the policy, in JSON.  Data protection policy  A data
  protection policy must include two JSON blocks:   The first block must include both a
  DataIdentifer array and an Operation property with an Audit action. The DataIdentifer array
  lists the types of sensitive data that you want to mask. For more information about the
  available options, see Types of data that you can mask. The Operation property with an
  Audit action is required to find the sensitive data terms. This Audit action must contain a
  FindingsDestination object. You can optionally use that FindingsDestination object to list
  one or more destinations to send audit findings to. If you specify destinations such as log
  groups, Firehose streams, and S3 buckets, they must already exist.   The second block must
  include both a DataIdentifer array and an Operation property with an Deidentify action. The
  DataIdentifer array must exactly match the DataIdentifer array in the first block of the
  policy. The Operation property with the Deidentify action is what actually masks the data,
  and it must contain the  \"MaskConfig\": {} object. The  \"MaskConfig\": {} object must be
  empty.   For an example data protection policy, see the Examples section on this page.  The
  contents of the two DataIdentifer arrays must match exactly.  In addition to the two JSON
  blocks, the policyDocument can also include Name, Description, and Version fields. The Name
  is different than the operation's policyName parameter, and is used as a dimension when
  CloudWatch Logs reports audit findings metrics to CloudWatch. The JSON specified in
  policyDocument can be up to 30,720 characters long.  Subscription filter policy  A
  subscription filter policy can include the following attributes in a JSON block:
  DestinationArn The ARN of the destination to deliver log events to. Supported destinations
  are:   An Kinesis Data Streams data stream in the same account as the subscription policy,
  for same-account delivery.   An Firehose data stream in the same account as the
  subscription policy, for same-account delivery.   A Lambda function in the same account as
  the subscription policy, for same-account delivery.   A logical destination in a different
  account created with PutDestination, for cross-account delivery. Kinesis Data Streams and
  Firehose are supported as logical destinations.      RoleArn The ARN of an IAM role that
  grants CloudWatch Logs permissions to deliver ingested log events to the destination
  stream. You don't need to provide the ARN when you are working with a logical destination
  for cross-account delivery.    FilterPattern A filter pattern for subscribing to a filtered
  stream of log events.    DistributionThe method used to distribute log data to the
  destination. By default, log data is grouped by log stream, but the grouping can be set to
  Random for a more even distribution. This property is only applicable when the destination
  is an Kinesis Data Streams data stream.
- `policy_name`: A name for the policy. This must be unique within the account.
- `policy_type`: The type of policy that you're creating or updating.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"scope"`: Currently the only valid value for this parameter is ALL, which specifies that
  the data protection policy applies to all log groups in the account. If you omit this
  parameter, the default of ALL is used.
- `"selectionCriteria"`: Use this parameter to apply the subscription filter policy to a
  subset of log groups in the account. Currently, the only supported filter is LogGroupName
  NOT IN []. The selectionCriteria string can be up to 25KB in length. The length is
  determined by using its UTF-8 bytes. Using the selectionCriteria parameter is useful to
  help prevent infinite loops. For more information, see Log recursion prevention. Specifing
  selectionCriteria is valid only when you specify  SUBSCRIPTION_FILTER_POLICY for policyType.
"""
function put_account_policy(
    policyDocument,
    policyName,
    policyType;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_logs(
        "PutAccountPolicy",
        Dict{String,Any}(
            "policyDocument" => policyDocument,
            "policyName" => policyName,
            "policyType" => policyType,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_account_policy(
    policyDocument,
    policyName,
    policyType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_logs(
        "PutAccountPolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "policyDocument" => policyDocument,
                    "policyName" => policyName,
                    "policyType" => policyType,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_data_protection_policy(log_group_identifier, policy_document)
    put_data_protection_policy(log_group_identifier, policy_document, params::Dict{String,<:Any})

Creates a data protection policy for the specified log group. A data protection policy can
help safeguard sensitive data that's ingested by the log group by auditing and masking the
sensitive log data.  Sensitive data is detected and masked when it is ingested into the log
group. When you set a data protection policy, log events ingested into the log group before
that time are not masked.  By default, when a user views a log event that includes masked
data, the sensitive data is replaced by asterisks. A user who has the logs:Unmask
permission can use a GetLogEvents or FilterLogEvents operation with the unmask parameter
set to true to view the unmasked log events. Users with the logs:Unmask can also view
unmasked data in the CloudWatch Logs console by running a CloudWatch Logs Insights query
with the unmask query command. For more information, including a list of types of data that
can be audited and masked, see Protect sensitive log data with masking. The
PutDataProtectionPolicy operation applies to only the specified log group. You can also use
PutAccountPolicy to create an account-level data protection policy that applies to all log
groups in the account, including both existing log groups and log groups that are created
level. If a log group has its own data protection policy and the account also has an
account-level data protection policy, then the two policies are cumulative. Any sensitive
term specified in either policy is masked.

# Arguments
- `log_group_identifier`: Specify either the log group name or log group ARN.
- `policy_document`: Specify the data protection policy, in JSON. This policy must include
  two JSON blocks:   The first block must include both a DataIdentifer array and an Operation
  property with an Audit action. The DataIdentifer array lists the types of sensitive data
  that you want to mask. For more information about the available options, see Types of data
  that you can mask. The Operation property with an Audit action is required to find the
  sensitive data terms. This Audit action must contain a FindingsDestination object. You can
  optionally use that FindingsDestination object to list one or more destinations to send
  audit findings to. If you specify destinations such as log groups, Firehose streams, and S3
  buckets, they must already exist.   The second block must include both a DataIdentifer
  array and an Operation property with an Deidentify action. The DataIdentifer array must
  exactly match the DataIdentifer array in the first block of the policy. The Operation
  property with the Deidentify action is what actually masks the data, and it must contain
  the  \"MaskConfig\": {} object. The  \"MaskConfig\": {} object must be empty.   For an
  example data protection policy, see the Examples section on this page.  The contents of the
  two DataIdentifer arrays must match exactly.  In addition to the two JSON blocks, the
  policyDocument can also include Name, Description, and Version fields. The Name is used as
  a dimension when CloudWatch Logs reports audit findings metrics to CloudWatch. The JSON
  specified in policyDocument can be up to 30,720 characters.

"""
function put_data_protection_policy(
    logGroupIdentifier, policyDocument; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "PutDataProtectionPolicy",
        Dict{String,Any}(
            "logGroupIdentifier" => logGroupIdentifier, "policyDocument" => policyDocument
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_data_protection_policy(
    logGroupIdentifier,
    policyDocument,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_logs(
        "PutDataProtectionPolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "logGroupIdentifier" => logGroupIdentifier,
                    "policyDocument" => policyDocument,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_delivery_destination(delivery_destination_configuration, name)
    put_delivery_destination(delivery_destination_configuration, name, params::Dict{String,<:Any})

Creates or updates a logical delivery destination. A delivery destination is an Amazon Web
Services resource that represents an Amazon Web Services service that logs can be sent to.
CloudWatch Logs, Amazon S3, and Firehose are supported as logs delivery destinations. To
configure logs delivery between a supported Amazon Web Services service and a destination,
you must do the following:   Create a delivery source, which is a logical object that
represents the resource that is actually sending the logs. For more information, see
PutDeliverySource.   Use PutDeliveryDestination to create a delivery destination, which is
a logical object that represents the actual delivery destination.    If you are delivering
logs cross-account, you must use PutDeliveryDestinationPolicy in the destination account to
assign an IAM policy to the destination. This policy allows delivery to that destination.
 Use CreateDelivery to create a delivery by pairing exactly one delivery source and one
delivery destination. For more information, see CreateDelivery.    You can configure a
single delivery source to send logs to multiple destinations by creating multiple
deliveries. You can also create multiple deliveries to configure multiple delivery sources
to send logs to the same delivery destination. Only some Amazon Web Services services
support being configured as a delivery source. These services are listed as Supported [V2
Permissions] in the table at Enabling logging from Amazon Web Services services.  If you
use this operation to update an existing delivery destination, all the current delivery
destination parameters are overwritten with the new parameter values that you specify.

# Arguments
- `delivery_destination_configuration`: A structure that contains the ARN of the Amazon Web
  Services resource that will receive the logs.
- `name`: A name for this delivery destination. This name must be unique for all delivery
  destinations in your account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"outputFormat"`: The format for the logs that this delivery destination will receive.
- `"tags"`: An optional list of key-value pairs to associate with the resource. For more
  information about tagging, see Tagging Amazon Web Services resources
"""
function put_delivery_destination(
    deliveryDestinationConfiguration,
    name;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_logs(
        "PutDeliveryDestination",
        Dict{String,Any}(
            "deliveryDestinationConfiguration" => deliveryDestinationConfiguration,
            "name" => name,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_delivery_destination(
    deliveryDestinationConfiguration,
    name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_logs(
        "PutDeliveryDestination",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "deliveryDestinationConfiguration" => deliveryDestinationConfiguration,
                    "name" => name,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_delivery_destination_policy(delivery_destination_name, delivery_destination_policy)
    put_delivery_destination_policy(delivery_destination_name, delivery_destination_policy, params::Dict{String,<:Any})

Creates and assigns an IAM policy that grants permissions to CloudWatch Logs to deliver
logs cross-account to a specified destination in this account. To configure the delivery of
logs from an Amazon Web Services service in another account to a logs delivery destination
in the current account, you must do the following:   Create a delivery source, which is a
logical object that represents the resource that is actually sending the logs. For more
information, see PutDeliverySource.   Create a delivery destination, which is a logical
object that represents the actual delivery destination. For more information, see
PutDeliveryDestination.   Use this operation in the destination account to assign an IAM
policy to the destination. This policy allows delivery to that destination.    Create a
delivery by pairing exactly one delivery source and one delivery destination. For more
information, see CreateDelivery.   Only some Amazon Web Services services support being
configured as a delivery source. These services are listed as Supported [V2 Permissions] in
the table at Enabling logging from Amazon Web Services services.  The contents of the
policy must include two statements. One statement enables general logs delivery, and the
other allows delivery to the chosen destination. See the examples for the needed policies.

# Arguments
- `delivery_destination_name`: The name of the delivery destination to assign this policy
  to.
- `delivery_destination_policy`: The contents of the policy.

"""
function put_delivery_destination_policy(
    deliveryDestinationName,
    deliveryDestinationPolicy;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_logs(
        "PutDeliveryDestinationPolicy",
        Dict{String,Any}(
            "deliveryDestinationName" => deliveryDestinationName,
            "deliveryDestinationPolicy" => deliveryDestinationPolicy,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_delivery_destination_policy(
    deliveryDestinationName,
    deliveryDestinationPolicy,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_logs(
        "PutDeliveryDestinationPolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "deliveryDestinationName" => deliveryDestinationName,
                    "deliveryDestinationPolicy" => deliveryDestinationPolicy,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_delivery_source(log_type, name, resource_arn)
    put_delivery_source(log_type, name, resource_arn, params::Dict{String,<:Any})

Creates or updates a logical delivery source. A delivery source represents an Amazon Web
Services resource that sends logs to an logs delivery destination. The destination can be
CloudWatch Logs, Amazon S3, or Firehose. To configure logs delivery between a delivery
destination and an Amazon Web Services service that is supported as a delivery source, you
must do the following:   Use PutDeliverySource to create a delivery source, which is a
logical object that represents the resource that is actually sending the logs.    Use
PutDeliveryDestination to create a delivery destination, which is a logical object that
represents the actual delivery destination. For more information, see
PutDeliveryDestination.   If you are delivering logs cross-account, you must use
PutDeliveryDestinationPolicy in the destination account to assign an IAM policy to the
destination. This policy allows delivery to that destination.    Use CreateDelivery to
create a delivery by pairing exactly one delivery source and one delivery destination. For
more information, see CreateDelivery.    You can configure a single delivery source to send
logs to multiple destinations by creating multiple deliveries. You can also create multiple
deliveries to configure multiple delivery sources to send logs to the same delivery
destination. Only some Amazon Web Services services support being configured as a delivery
source. These services are listed as Supported [V2 Permissions] in the table at Enabling
logging from Amazon Web Services services.  If you use this operation to update an existing
delivery source, all the current delivery source parameters are overwritten with the new
parameter values that you specify.

# Arguments
- `log_type`: Defines the type of log that the source is sending.   For Amazon
  CodeWhisperer, the valid value is EVENT_LOGS.   For IAM Identity Centerr, the valid value
  is ERROR_LOGS.   For Amazon WorkMail, the valid values are ACCESS_CONTROL_LOGS,
  AUTHENTICATION_LOGS, WORKMAIL_AVAILABILITY_PROVIDER_LOGS, and WORKMAIL_MAILBOX_ACCESS_LOGS.
  
- `name`: A name for this delivery source. This name must be unique for all delivery
  sources in your account.
- `resource_arn`: The ARN of the Amazon Web Services resource that is generating and
  sending logs. For example,
  arn:aws:workmail:us-east-1:123456789012:organization/m-1234EXAMPLEabcd1234abcd1234abcd1234

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"tags"`: An optional list of key-value pairs to associate with the resource. For more
  information about tagging, see Tagging Amazon Web Services resources
"""
function put_delivery_source(
    logType, name, resourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "PutDeliverySource",
        Dict{String,Any}(
            "logType" => logType, "name" => name, "resourceArn" => resourceArn
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_delivery_source(
    logType,
    name,
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_logs(
        "PutDeliverySource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "logType" => logType, "name" => name, "resourceArn" => resourceArn
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_destination(destination_name, role_arn, target_arn)
    put_destination(destination_name, role_arn, target_arn, params::Dict{String,<:Any})

Creates or updates a destination. This operation is used only to create destinations for
cross-account subscriptions. A destination encapsulates a physical resource (such as an
Amazon Kinesis stream). With a destination, you can subscribe to a real-time stream of log
events for a different account, ingested using PutLogEvents. Through an access policy, a
destination controls what is written to it. By default, PutDestination does not set any
access policy with the destination, which means a cross-account user cannot call
PutSubscriptionFilter against this destination. To enable this, the destination owner must
call PutDestinationPolicy after PutDestination. To perform a PutDestination operation, you
must also have the iam:PassRole permission.

# Arguments
- `destination_name`: A name for the destination.
- `role_arn`: The ARN of an IAM role that grants CloudWatch Logs permissions to call the
  Amazon Kinesis PutRecord operation on the destination stream.
- `target_arn`: The ARN of an Amazon Kinesis stream to which to deliver matching log events.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"tags"`: An optional list of key-value pairs to associate with the resource. For more
  information about tagging, see Tagging Amazon Web Services resources
"""
function put_destination(
    destinationName, roleArn, targetArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "PutDestination",
        Dict{String,Any}(
            "destinationName" => destinationName,
            "roleArn" => roleArn,
            "targetArn" => targetArn,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_destination(
    destinationName,
    roleArn,
    targetArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_logs(
        "PutDestination",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "destinationName" => destinationName,
                    "roleArn" => roleArn,
                    "targetArn" => targetArn,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_destination_policy(access_policy, destination_name)
    put_destination_policy(access_policy, destination_name, params::Dict{String,<:Any})

Creates or updates an access policy associated with an existing destination. An access
policy is an IAM policy document that is used to authorize claims to register a
subscription filter against a given destination.

# Arguments
- `access_policy`: An IAM policy document that authorizes cross-account users to deliver
  their log events to the associated destination. This can be up to 5120 bytes.
- `destination_name`: A name for an existing destination.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"forceUpdate"`: Specify true if you are updating an existing destination policy to grant
  permission to an organization ID instead of granting permission to individual Amazon Web
  Services accounts. Before you update a destination policy this way, you must first update
  the subscription filters in the accounts that send logs to this destination. If you do not,
  the subscription filters might stop working. By specifying true for forceUpdate, you are
  affirming that you have already updated the subscription filters. For more information, see
   Updating an existing cross-account subscription  If you omit this parameter, the default
  of false is used.
"""
function put_destination_policy(
    accessPolicy, destinationName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "PutDestinationPolicy",
        Dict{String,Any}(
            "accessPolicy" => accessPolicy, "destinationName" => destinationName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_destination_policy(
    accessPolicy,
    destinationName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_logs(
        "PutDestinationPolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "accessPolicy" => accessPolicy, "destinationName" => destinationName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_log_events(log_events, log_group_name, log_stream_name)
    put_log_events(log_events, log_group_name, log_stream_name, params::Dict{String,<:Any})

Uploads a batch of log events to the specified log stream.  The sequence token is now
ignored in PutLogEvents actions. PutLogEvents actions are always accepted and never return
InvalidSequenceTokenException or DataAlreadyAcceptedException even if the sequence token is
not valid. You can use parallel PutLogEvents actions on the same log stream.   The batch of
events must satisfy the following constraints:   The maximum batch size is 1,048,576 bytes.
This size is calculated as the sum of all event messages in UTF-8, plus 26 bytes for each
log event.   None of the log events in the batch can be more than 2 hours in the future.
None of the log events in the batch can be more than 14 days in the past. Also, none of the
log events can be from earlier than the retention period of the log group.   The log events
in the batch must be in chronological order by their timestamp. The timestamp is the time
that the event occurred, expressed as the number of milliseconds after Jan 1, 1970 00:00:00
UTC. (In Amazon Web Services Tools for PowerShell and the Amazon Web Services SDK for .NET,
the timestamp is specified in .NET format: yyyy-mm-ddThh:mm:ss. For example,
2017-09-15T13:45:30.)    A batch of log events in a single request cannot span more than 24
hours. Otherwise, the operation fails.   Each log event can be no larger than 256 KB.   The
maximum number of log events in a batch is 10,000.    The quota of five requests per second
per log stream has been removed. Instead, PutLogEvents actions are throttled based on a
per-second per-account quota. You can request an increase to the per-second throttling
quota by using the Service Quotas service.    If a call to PutLogEvents returns
\"UnrecognizedClientException\" the most likely cause is a non-valid Amazon Web Services
access key ID or secret key.

# Arguments
- `log_events`: The log events.
- `log_group_name`: The name of the log group.
- `log_stream_name`: The name of the log stream.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"sequenceToken"`: The sequence token obtained from the response of the previous
  PutLogEvents call.  The sequenceToken parameter is now ignored in PutLogEvents actions.
  PutLogEvents actions are now accepted and never return InvalidSequenceTokenException or
  DataAlreadyAcceptedException even if the sequence token is not valid.
"""
function put_log_events(
    logEvents,
    logGroupName,
    logStreamName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_logs(
        "PutLogEvents",
        Dict{String,Any}(
            "logEvents" => logEvents,
            "logGroupName" => logGroupName,
            "logStreamName" => logStreamName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_log_events(
    logEvents,
    logGroupName,
    logStreamName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_logs(
        "PutLogEvents",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "logEvents" => logEvents,
                    "logGroupName" => logGroupName,
                    "logStreamName" => logStreamName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_metric_filter(filter_name, filter_pattern, log_group_name, metric_transformations)
    put_metric_filter(filter_name, filter_pattern, log_group_name, metric_transformations, params::Dict{String,<:Any})

Creates or updates a metric filter and associates it with the specified log group. With
metric filters, you can configure rules to extract metric data from log events ingested
through PutLogEvents. The maximum number of metric filters that can be associated with a
log group is 100. When you create a metric filter, you can also optionally assign a unit
and dimensions to the metric that is created.  Metrics extracted from log events are
charged as custom metrics. To prevent unexpected high charges, do not specify
high-cardinality fields such as IPAddress or requestID as dimensions. Each different value
found for a dimension is treated as a separate metric and accrues charges as a separate
custom metric.  CloudWatch Logs might disable a metric filter if it generates 1,000
different name/value pairs for your specified dimensions within one hour. You can also set
up a billing alarm to alert you if your charges are higher than expected. For more
information, see  Creating a Billing Alarm to Monitor Your Estimated Amazon Web Services
Charges.

# Arguments
- `filter_name`: A name for the metric filter.
- `filter_pattern`: A filter pattern for extracting metric data out of ingested log events.
- `log_group_name`: The name of the log group.
- `metric_transformations`: A collection of information that defines how metric data gets
  emitted.

"""
function put_metric_filter(
    filterName,
    filterPattern,
    logGroupName,
    metricTransformations;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_logs(
        "PutMetricFilter",
        Dict{String,Any}(
            "filterName" => filterName,
            "filterPattern" => filterPattern,
            "logGroupName" => logGroupName,
            "metricTransformations" => metricTransformations,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_metric_filter(
    filterName,
    filterPattern,
    logGroupName,
    metricTransformations,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_logs(
        "PutMetricFilter",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "filterName" => filterName,
                    "filterPattern" => filterPattern,
                    "logGroupName" => logGroupName,
                    "metricTransformations" => metricTransformations,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_query_definition(name, query_string)
    put_query_definition(name, query_string, params::Dict{String,<:Any})

Creates or updates a query definition for CloudWatch Logs Insights. For more information,
see Analyzing Log Data with CloudWatch Logs Insights. To update a query definition, specify
its queryDefinitionId in your request. The values of name, queryString, and logGroupNames
are changed to the values that you specify in your update operation. No current values are
retained from the current query definition. For example, imagine updating a current query
definition that includes log groups. If you don't specify the logGroupNames parameter in
your update operation, the query definition changes to contain no log groups. You must have
the logs:PutQueryDefinition permission to be able to perform this operation.

# Arguments
- `name`: A name for the query definition. If you are saving numerous query definitions, we
  recommend that you name them. This way, you can find the ones you want by using the first
  part of the name as a filter in the queryDefinitionNamePrefix parameter of
  DescribeQueryDefinitions.
- `query_string`: The query string to use for this definition. For more information, see
  CloudWatch Logs Insights Query Syntax.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: Used as an idempotency token, to avoid returning an exception if the
  service receives the same request twice because of a network error.
- `"logGroupNames"`: Use this parameter to include specific log groups as part of your
  query definition. If you are updating a query definition and you omit this parameter, then
  the updated definition will contain no log groups.
- `"queryDefinitionId"`: If you are updating a query definition, use this parameter to
  specify the ID of the query definition that you want to update. You can use
  DescribeQueryDefinitions to retrieve the IDs of your saved query definitions. If you are
  creating a query definition, do not specify this parameter. CloudWatch generates a unique
  ID for the new query definition and include it in the response to this operation.
"""
function put_query_definition(
    name, queryString; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "PutQueryDefinition",
        Dict{String,Any}(
            "name" => name, "queryString" => queryString, "clientToken" => string(uuid4())
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_query_definition(
    name,
    queryString,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_logs(
        "PutQueryDefinition",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "name" => name,
                    "queryString" => queryString,
                    "clientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_resource_policy()
    put_resource_policy(params::Dict{String,<:Any})

Creates or updates a resource policy allowing other Amazon Web Services services to put log
events to this account, such as Amazon Route 53. An account can have up to 10 resource
policies per Amazon Web Services Region.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"policyDocument"`: Details of the new policy, including the identity of the principal
  that is enabled to put logs to this account. This is formatted as a JSON string. This
  parameter is required. The following example creates a resource policy enabling the Route
  53 service to put DNS query logs in to the specified log group. Replace \"logArn\" with the
  ARN of your CloudWatch Logs resource, such as a log group or log stream. CloudWatch Logs
  also supports aws:SourceArn and aws:SourceAccount condition context keys. In the example
  resource policy, you would replace the value of SourceArn with the resource making the call
  from Route 53 to CloudWatch Logs. You would also replace the value of SourceAccount with
  the Amazon Web Services account ID making that call.   { \"Version\": \"2012-10-17\",
  \"Statement\": [ { \"Sid\": \"Route53LogsToCloudWatchLogs\", \"Effect\": \"Allow\",
  \"Principal\": { \"Service\": [ \"route53.amazonaws.com\" ] }, \"Action\":
  \"logs:PutLogEvents\", \"Resource\": \"logArn\", \"Condition\": { \"ArnLike\": {
  \"aws:SourceArn\": \"myRoute53ResourceArn\" }, \"StringEquals\": { \"aws:SourceAccount\":
  \"myAwsAccountId\" } } } ] }
- `"policyName"`: Name of the new policy. This parameter is required.
"""
function put_resource_policy(; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_logs(
        "PutResourcePolicy"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function put_resource_policy(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "PutResourcePolicy", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    put_retention_policy(log_group_name, retention_in_days)
    put_retention_policy(log_group_name, retention_in_days, params::Dict{String,<:Any})

Sets the retention of the specified log group. With a retention policy, you can configure
the number of days for which to retain log events in the specified log group.  CloudWatch
Logs doesn’t immediately delete log events when they reach their retention setting. It
typically takes up to 72 hours after that before log events are deleted, but in rare
situations might take longer. To illustrate, imagine that you change a log group to have a
longer retention setting when it contains log events that are past the expiration date, but
haven’t been deleted. Those log events will take up to 72 hours to be deleted after the
new retention date is reached. To make sure that log data is deleted permanently, keep a
log group at its lower retention setting until 72 hours after the previous retention period
ends. Alternatively, wait to change the retention setting until you confirm that the
earlier log events are deleted.  When log events reach their retention setting they are
marked for deletion. After they are marked for deletion, they do not add to your archival
storage costs anymore, even if they are not actually deleted until later. These log events
marked for deletion are also not included when you use an API to retrieve the storedBytes
value to see how many bytes a log group is storing.

# Arguments
- `log_group_name`: The name of the log group.
- `retention_in_days`:

"""
function put_retention_policy(
    logGroupName, retentionInDays; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "PutRetentionPolicy",
        Dict{String,Any}(
            "logGroupName" => logGroupName, "retentionInDays" => retentionInDays
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_retention_policy(
    logGroupName,
    retentionInDays,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_logs(
        "PutRetentionPolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "logGroupName" => logGroupName, "retentionInDays" => retentionInDays
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_subscription_filter(destination_arn, filter_name, filter_pattern, log_group_name)
    put_subscription_filter(destination_arn, filter_name, filter_pattern, log_group_name, params::Dict{String,<:Any})

Creates or updates a subscription filter and associates it with the specified log group.
With subscription filters, you can subscribe to a real-time stream of log events ingested
through PutLogEvents and have them delivered to a specific destination. When log events are
sent to the receiving service, they are Base64 encoded and compressed with the GZIP format.
The following destinations are supported for subscription filters:   An Amazon Kinesis data
stream belonging to the same account as the subscription filter, for same-account delivery.
  A logical destination created with PutDestination that belongs to a different account,
for cross-account delivery. We currently support Kinesis Data Streams and Firehose as
logical destinations.   An Amazon Kinesis Data Firehose delivery stream that belongs to the
same account as the subscription filter, for same-account delivery.   An Lambda function
that belongs to the same account as the subscription filter, for same-account delivery.
Each log group can have up to two subscription filters associated with it. If you are
updating an existing filter, you must specify the correct name in filterName.  To perform a
PutSubscriptionFilter operation for any destination except a Lambda function, you must also
have the iam:PassRole permission.

# Arguments
- `destination_arn`: The ARN of the destination to deliver matching log events to.
  Currently, the supported destinations are:   An Amazon Kinesis stream belonging to the same
  account as the subscription filter, for same-account delivery.   A logical destination
  (specified using an ARN) belonging to a different account, for cross-account delivery. If
  you're setting up a cross-account subscription, the destination must have an IAM policy
  associated with it. The IAM policy must allow the sender to send logs to the destination.
  For more information, see PutDestinationPolicy.   A Kinesis Data Firehose delivery stream
  belonging to the same account as the subscription filter, for same-account delivery.   A
  Lambda function belonging to the same account as the subscription filter, for same-account
  delivery.
- `filter_name`: A name for the subscription filter. If you are updating an existing
  filter, you must specify the correct name in filterName. To find the name of the filter
  currently associated with a log group, use DescribeSubscriptionFilters.
- `filter_pattern`: A filter pattern for subscribing to a filtered stream of log events.
- `log_group_name`: The name of the log group.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"distribution"`: The method used to distribute log data to the destination. By default,
  log data is grouped by log stream, but the grouping can be set to random for a more even
  distribution. This property is only applicable when the destination is an Amazon Kinesis
  data stream.
- `"roleArn"`: The ARN of an IAM role that grants CloudWatch Logs permissions to deliver
  ingested log events to the destination stream. You don't need to provide the ARN when you
  are working with a logical destination for cross-account delivery.
"""
function put_subscription_filter(
    destinationArn,
    filterName,
    filterPattern,
    logGroupName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_logs(
        "PutSubscriptionFilter",
        Dict{String,Any}(
            "destinationArn" => destinationArn,
            "filterName" => filterName,
            "filterPattern" => filterPattern,
            "logGroupName" => logGroupName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_subscription_filter(
    destinationArn,
    filterName,
    filterPattern,
    logGroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_logs(
        "PutSubscriptionFilter",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "destinationArn" => destinationArn,
                    "filterName" => filterName,
                    "filterPattern" => filterPattern,
                    "logGroupName" => logGroupName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_live_tail(log_group_identifiers)
    start_live_tail(log_group_identifiers, params::Dict{String,<:Any})

Starts a Live Tail streaming session for one or more log groups. A Live Tail session
returns a stream of log events that have been recently ingested in the log groups. For more
information, see Use Live Tail to view logs in near real time.  The response to this
operation is a response stream, over which the server sends live log events and the client
receives them. The following objects are sent over the stream:   A single
LiveTailSessionStart object is sent at the start of the session.   Every second, a
LiveTailSessionUpdate object is sent. Each of these objects contains an array of the actual
log events. If no new log events were ingested in the past second, the
LiveTailSessionUpdate object will contain an empty array. The array of log events contained
in a LiveTailSessionUpdate can include as many as 500 log events. If the number of log
events matching the request exceeds 500 per second, the log events are sampled down to 500
log events to be included in each LiveTailSessionUpdate object. If your client consumes the
log events slower than the server produces them, CloudWatch Logs buffers up to 10
LiveTailSessionUpdate events or 5000 log events, after which it starts dropping the oldest
events.   A SessionStreamingException object is returned if an unknown error occurs on the
server side.   A SessionTimeoutException object is returned when the session times out,
after it has been kept open for three hours.    You can end a session before it times out
by closing the session stream or by closing the client that is receiving the stream. The
session also ends if the established connection between the client and the server breaks.
For examples of using an SDK to start a Live Tail session, see  Start a Live Tail session
using an Amazon Web Services SDK.

# Arguments
- `log_group_identifiers`: An array where each item in the array is a log group to include
  in the Live Tail session. Specify each log group by its ARN.  If you specify an ARN, the
  ARN can't end with an asterisk (*).   You can include up to 10 log groups.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"logEventFilterPattern"`: An optional pattern to use to filter the results to include
  only log events that match the pattern. For example, a filter pattern of error 404 causes
  only log events that include both error and 404 to be included in the Live Tail stream.
  Regular expression filter patterns are supported. For more information about filter pattern
  syntax, see Filter and Pattern Syntax.
- `"logStreamNamePrefixes"`: If you specify this parameter, then only log events in the log
  streams that have names that start with the prefixes that you specify here are included in
  the Live Tail session. If you specify this field, you can't also specify the logStreamNames
  field.  You can specify this parameter only if you specify only one log group in
  logGroupIdentifiers.
- `"logStreamNames"`: If you specify this parameter, then only log events in the log
  streams that you specify here are included in the Live Tail session. If you specify this
  field, you can't also specify the logStreamNamePrefixes field.  You can specify this
  parameter only if you specify only one log group in logGroupIdentifiers.
"""
function start_live_tail(
    logGroupIdentifiers; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "StartLiveTail",
        Dict{String,Any}("logGroupIdentifiers" => logGroupIdentifiers);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_live_tail(
    logGroupIdentifiers,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_logs(
        "StartLiveTail",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("logGroupIdentifiers" => logGroupIdentifiers),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_query(end_time, query_string, start_time)
    start_query(end_time, query_string, start_time, params::Dict{String,<:Any})

Schedules a query of a log group using CloudWatch Logs Insights. You specify the log group
and time range to query and the query string to use. For more information, see CloudWatch
Logs Insights Query Syntax. After you run a query using StartQuery, the query results are
stored by CloudWatch Logs. You can use GetQueryResults to retrieve the results of a query,
using the queryId that StartQuery returns.  If you have associated a KMS key with the query
results in this account, then StartQuery uses that key to encrypt the results when it
stores them. If no key is associated with query results, the query results are encrypted
with the default CloudWatch Logs encryption method. Queries time out after 60 minutes of
runtime. If your queries are timing out, reduce the time range being searched or partition
your query into a number of queries. If you are using CloudWatch cross-account
observability, you can use this operation in a monitoring account to start a query in a
linked source account. For more information, see CloudWatch cross-account observability.
For a cross-account StartQuery operation, the query definition must be defined in the
monitoring account. You can have up to 30 concurrent CloudWatch Logs insights queries,
including queries that have been added to dashboards.

# Arguments
- `end_time`: The end of the time range to query. The range is inclusive, so the specified
  end time is included in the query. Specified as epoch time, the number of seconds since
  January 1, 1970, 00:00:00 UTC.
- `query_string`: The query string to use. For more information, see CloudWatch Logs
  Insights Query Syntax.
- `start_time`: The beginning of the time range to query. The range is inclusive, so the
  specified start time is included in the query. Specified as epoch time, the number of
  seconds since January 1, 1970, 00:00:00 UTC.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"limit"`: The maximum number of log events to return in the query. If the query string
  uses the fields command, only the specified fields and their values are returned. The
  default is 1000.
- `"logGroupIdentifiers"`: The list of log groups to query. You can include up to 50 log
  groups. You can specify them by the log group name or ARN. If a log group that you're
  querying is in a source account and you're using a monitoring account, you must specify the
  ARN of the log group here. The query definition must also be defined in the monitoring
  account. If you specify an ARN, the ARN can't end with an asterisk (*). A StartQuery
  operation must include exactly one of the following parameters: logGroupName,
  logGroupNames, or logGroupIdentifiers.
- `"logGroupName"`: The log group on which to perform the query.  A StartQuery operation
  must include exactly one of the following parameters: logGroupName, logGroupNames, or
  logGroupIdentifiers.
- `"logGroupNames"`: The list of log groups to be queried. You can include up to 50 log
  groups.  A StartQuery operation must include exactly one of the following parameters:
  logGroupName, logGroupNames, or logGroupIdentifiers.
"""
function start_query(
    endTime, queryString, startTime; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "StartQuery",
        Dict{String,Any}(
            "endTime" => endTime, "queryString" => queryString, "startTime" => startTime
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_query(
    endTime,
    queryString,
    startTime,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_logs(
        "StartQuery",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "endTime" => endTime,
                    "queryString" => queryString,
                    "startTime" => startTime,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    stop_query(query_id)
    stop_query(query_id, params::Dict{String,<:Any})

Stops a CloudWatch Logs Insights query that is in progress. If the query has already ended,
the operation returns an error indicating that the specified query is not running.

# Arguments
- `query_id`: The ID number of the query to stop. To find this ID number, use
  DescribeQueries.

"""
function stop_query(queryId; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_logs(
        "StopQuery",
        Dict{String,Any}("queryId" => queryId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function stop_query(
    queryId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_logs(
        "StopQuery",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("queryId" => queryId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_log_group(log_group_name, tags)
    tag_log_group(log_group_name, tags, params::Dict{String,<:Any})

 The TagLogGroup operation is on the path to deprecation. We recommend that you use
TagResource instead.  Adds or updates the specified tags for the specified log group. To
list the tags for a log group, use ListTagsForResource. To remove tags, use UntagResource.
For more information about tags, see Tag Log Groups in Amazon CloudWatch Logs in the Amazon
CloudWatch Logs User Guide. CloudWatch Logs doesn’t support IAM policies that prevent
users from assigning specified tags to log groups using the aws:Resource/key-name  or
aws:TagKeys condition keys. For more information about using tags to control access, see
Controlling access to Amazon Web Services resources using tags.

# Arguments
- `log_group_name`: The name of the log group.
- `tags`: The key-value pairs to use for the tags.

"""
function tag_log_group(
    logGroupName, tags; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "TagLogGroup",
        Dict{String,Any}("logGroupName" => logGroupName, "tags" => tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_log_group(
    logGroupName,
    tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_logs(
        "TagLogGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("logGroupName" => logGroupName, "tags" => tags),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Assigns one or more tags (key-value pairs) to the specified CloudWatch Logs resource.
Currently, the only CloudWatch Logs resources that can be tagged are log groups and
destinations.  Tags can help you organize and categorize your resources. You can also use
them to scope user permissions by granting a user permission to access or change only
resources with certain tag values. Tags don't have any semantic meaning to Amazon Web
Services and are interpreted strictly as strings of characters. You can use the TagResource
action with a resource that already has tags. If you specify a new tag key for the alarm,
this tag is appended to the list of tags associated with the alarm. If you specify a tag
key that is already associated with the alarm, the new tag value that you specify replaces
the previous value for that tag. You can associate as many as 50 tags with a CloudWatch
Logs resource.

# Arguments
- `resource_arn`: The ARN of the resource that you're adding tags to. The ARN format of a
  log group is arn:aws:logs:Region:account-id:log-group:log-group-name   The ARN format of a
  destination is arn:aws:logs:Region:account-id:destination:destination-name   For more
  information about ARN format, see CloudWatch Logs resources and operations.
- `tags`: The list of key-value pairs to associate with the resource.

"""
function tag_resource(resourceArn, tags; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_logs(
        "TagResource",
        Dict{String,Any}("resourceArn" => resourceArn, "tags" => tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    resourceArn,
    tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_logs(
        "TagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("resourceArn" => resourceArn, "tags" => tags),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    test_metric_filter(filter_pattern, log_event_messages)
    test_metric_filter(filter_pattern, log_event_messages, params::Dict{String,<:Any})

Tests the filter pattern of a metric filter against a sample of log event messages. You can
use this operation to validate the correctness of a metric filter pattern.

# Arguments
- `filter_pattern`:
- `log_event_messages`: The log event messages to test.

"""
function test_metric_filter(
    filterPattern, logEventMessages; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "TestMetricFilter",
        Dict{String,Any}(
            "filterPattern" => filterPattern, "logEventMessages" => logEventMessages
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function test_metric_filter(
    filterPattern,
    logEventMessages,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_logs(
        "TestMetricFilter",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "filterPattern" => filterPattern, "logEventMessages" => logEventMessages
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_log_group(log_group_name, tags)
    untag_log_group(log_group_name, tags, params::Dict{String,<:Any})

 The UntagLogGroup operation is on the path to deprecation. We recommend that you use
UntagResource instead.  Removes the specified tags from the specified log group. To list
the tags for a log group, use ListTagsForResource. To add tags, use TagResource. CloudWatch
Logs doesn’t support IAM policies that prevent users from assigning specified tags to log
groups using the aws:Resource/key-name  or aws:TagKeys condition keys.

# Arguments
- `log_group_name`: The name of the log group.
- `tags`: The tag keys. The corresponding tags are removed from the log group.

"""
function untag_log_group(
    logGroupName, tags; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "UntagLogGroup",
        Dict{String,Any}("logGroupName" => logGroupName, "tags" => tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_log_group(
    logGroupName,
    tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_logs(
        "UntagLogGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("logGroupName" => logGroupName, "tags" => tags),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Removes one or more tags from the specified resource.

# Arguments
- `resource_arn`: The ARN of the CloudWatch Logs resource that you're removing tags from.
  The ARN format of a log group is arn:aws:logs:Region:account-id:log-group:log-group-name
  The ARN format of a destination is
  arn:aws:logs:Region:account-id:destination:destination-name   For more information about
  ARN format, see CloudWatch Logs resources and operations.
- `tag_keys`: The list of tag keys to remove from the resource.

"""
function untag_resource(
    resourceArn, tagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "UntagResource",
        Dict{String,Any}("resourceArn" => resourceArn, "tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    resourceArn,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_logs(
        "UntagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("resourceArn" => resourceArn, "tagKeys" => tagKeys),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_anomaly(anomaly_detector_arn)
    update_anomaly(anomaly_detector_arn, params::Dict{String,<:Any})

Use this operation to suppress anomaly detection for a specified anomaly or pattern. If you
suppress an anomaly, CloudWatch Logs won’t report new occurrences of that anomaly and
won't update that anomaly with new data. If you suppress a pattern, CloudWatch Logs won’t
report any anomalies related to that pattern. You must specify either anomalyId or
patternId, but you can't specify both parameters in the same operation. If you have
previously used this operation to suppress detection of a pattern or anomaly, you can use
it again to cause CloudWatch Logs to end the suppression. To do this, use this operation
and specify the anomaly or pattern to stop suppressing, and omit the suppressionType and
suppressionPeriod parameters.

# Arguments
- `anomaly_detector_arn`: The ARN of the anomaly detector that this operation is to act on.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"anomalyId"`: If you are suppressing or unsuppressing an anomaly, specify its unique ID
  here. You can find anomaly IDs by using the ListAnomalies operation.
- `"patternId"`: If you are suppressing or unsuppressing an pattern, specify its unique ID
  here. You can find pattern IDs by using the ListAnomalies operation.
- `"suppressionPeriod"`: If you are temporarily suppressing an anomaly or pattern, use this
  structure to specify how long the suppression is to last.
- `"suppressionType"`: Use this to specify whether the suppression to be temporary or
  infinite. If you specify LIMITED, you must also specify a suppressionPeriod. If you specify
  INFINITE, any value for suppressionPeriod is ignored.
"""
function update_anomaly(
    anomalyDetectorArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "UpdateAnomaly",
        Dict{String,Any}("anomalyDetectorArn" => anomalyDetectorArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_anomaly(
    anomalyDetectorArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_logs(
        "UpdateAnomaly",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("anomalyDetectorArn" => anomalyDetectorArn), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_log_anomaly_detector(anomaly_detector_arn, enabled)
    update_log_anomaly_detector(anomaly_detector_arn, enabled, params::Dict{String,<:Any})

Updates an existing log anomaly detector.

# Arguments
- `anomaly_detector_arn`: The ARN of the anomaly detector that you want to update.
- `enabled`: Use this parameter to pause or restart the anomaly detector.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"anomalyVisibilityTime"`: The number of days to use as the life cycle of anomalies.
  After this time, anomalies are automatically baselined and the anomaly detector model will
  treat new occurrences of similar event as normal. Therefore, if you do not correct the
  cause of an anomaly during this time, it will be considered normal going forward and will
  not be detected.
- `"evaluationFrequency"`: Specifies how often the anomaly detector runs and look for
  anomalies. Set this value according to the frequency that the log group receives new logs.
  For example, if the log group receives new log events every 10 minutes, then setting
  evaluationFrequency to FIFTEEN_MIN might be appropriate.
- `"filterPattern"`:
"""
function update_log_anomaly_detector(
    anomalyDetectorArn, enabled; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_logs(
        "UpdateLogAnomalyDetector",
        Dict{String,Any}("anomalyDetectorArn" => anomalyDetectorArn, "enabled" => enabled);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_log_anomaly_detector(
    anomalyDetectorArn,
    enabled,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_logs(
        "UpdateLogAnomalyDetector",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "anomalyDetectorArn" => anomalyDetectorArn, "enabled" => enabled
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
