# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: iot_wireless
using AWS.Compat
using AWS.UUIDs

"""
    associate_aws_account_with_partner_account(sidewalk)
    associate_aws_account_with_partner_account(sidewalk, params::Dict{String,<:Any})

Associates a partner account with your AWS account.

# Arguments
- `sidewalk`: The Sidewalk account credentials.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientRequestToken"`: Each resource must have a unique client request token. The client
  token is used to implement idempotency. It ensures that the request completes no more than
  one time. If you retry a request with the same token and the same parameters, the request
  will complete successfully. However, if you try to create a new resource using the same
  token but different parameters, an HTTP 409 conflict occurs. If you omit this value, AWS
  SDKs will automatically generate a unique client request. For more information about
  idempotency, see Ensuring idempotency in Amazon EC2 API requests.
- `"Tags"`: The tags to attach to the specified resource. Tags are metadata that you can
  use to manage a resource.
"""
function associate_aws_account_with_partner_account(
    Sidewalk; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "POST",
        "/partner-accounts",
        Dict{String,Any}("Sidewalk" => Sidewalk, "ClientRequestToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_aws_account_with_partner_account(
    Sidewalk,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_wireless(
        "POST",
        "/partner-accounts",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Sidewalk" => Sidewalk, "ClientRequestToken" => string(uuid4())
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    associate_multicast_group_with_fuota_task(id, multicast_group_id)
    associate_multicast_group_with_fuota_task(id, multicast_group_id, params::Dict{String,<:Any})

Associate a multicast group with a FUOTA task.

# Arguments
- `id`:
- `multicast_group_id`:

"""
function associate_multicast_group_with_fuota_task(
    Id, MulticastGroupId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "PUT",
        "/fuota-tasks/$(Id)/multicast-group",
        Dict{String,Any}("MulticastGroupId" => MulticastGroupId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_multicast_group_with_fuota_task(
    Id,
    MulticastGroupId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_wireless(
        "PUT",
        "/fuota-tasks/$(Id)/multicast-group",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("MulticastGroupId" => MulticastGroupId), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    associate_wireless_device_with_fuota_task(id, wireless_device_id)
    associate_wireless_device_with_fuota_task(id, wireless_device_id, params::Dict{String,<:Any})

Associate a wireless device with a FUOTA task.

# Arguments
- `id`:
- `wireless_device_id`:

"""
function associate_wireless_device_with_fuota_task(
    Id, WirelessDeviceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "PUT",
        "/fuota-tasks/$(Id)/wireless-device",
        Dict{String,Any}("WirelessDeviceId" => WirelessDeviceId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_wireless_device_with_fuota_task(
    Id,
    WirelessDeviceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_wireless(
        "PUT",
        "/fuota-tasks/$(Id)/wireless-device",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("WirelessDeviceId" => WirelessDeviceId), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    associate_wireless_device_with_multicast_group(id, wireless_device_id)
    associate_wireless_device_with_multicast_group(id, wireless_device_id, params::Dict{String,<:Any})

Associates a wireless device with a multicast group.

# Arguments
- `id`:
- `wireless_device_id`:

"""
function associate_wireless_device_with_multicast_group(
    Id, WirelessDeviceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "PUT",
        "/multicast-groups/$(Id)/wireless-device",
        Dict{String,Any}("WirelessDeviceId" => WirelessDeviceId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_wireless_device_with_multicast_group(
    Id,
    WirelessDeviceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_wireless(
        "PUT",
        "/multicast-groups/$(Id)/wireless-device",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("WirelessDeviceId" => WirelessDeviceId), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    associate_wireless_device_with_thing(id, thing_arn)
    associate_wireless_device_with_thing(id, thing_arn, params::Dict{String,<:Any})

Associates a wireless device with a thing.

# Arguments
- `id`: The ID of the resource to update.
- `thing_arn`: The ARN of the thing to associate with the wireless device.

"""
function associate_wireless_device_with_thing(
    Id, ThingArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "PUT",
        "/wireless-devices/$(Id)/thing",
        Dict{String,Any}("ThingArn" => ThingArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_wireless_device_with_thing(
    Id,
    ThingArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_wireless(
        "PUT",
        "/wireless-devices/$(Id)/thing",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ThingArn" => ThingArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    associate_wireless_gateway_with_certificate(id, iot_certificate_id)
    associate_wireless_gateway_with_certificate(id, iot_certificate_id, params::Dict{String,<:Any})

Associates a wireless gateway with a certificate.

# Arguments
- `id`: The ID of the resource to update.
- `iot_certificate_id`: The ID of the certificate to associate with the wireless gateway.

"""
function associate_wireless_gateway_with_certificate(
    Id, IotCertificateId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "PUT",
        "/wireless-gateways/$(Id)/certificate",
        Dict{String,Any}("IotCertificateId" => IotCertificateId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_wireless_gateway_with_certificate(
    Id,
    IotCertificateId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_wireless(
        "PUT",
        "/wireless-gateways/$(Id)/certificate",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("IotCertificateId" => IotCertificateId), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    associate_wireless_gateway_with_thing(id, thing_arn)
    associate_wireless_gateway_with_thing(id, thing_arn, params::Dict{String,<:Any})

Associates a wireless gateway with a thing.

# Arguments
- `id`: The ID of the resource to update.
- `thing_arn`: The ARN of the thing to associate with the wireless gateway.

"""
function associate_wireless_gateway_with_thing(
    Id, ThingArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "PUT",
        "/wireless-gateways/$(Id)/thing",
        Dict{String,Any}("ThingArn" => ThingArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_wireless_gateway_with_thing(
    Id,
    ThingArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_wireless(
        "PUT",
        "/wireless-gateways/$(Id)/thing",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ThingArn" => ThingArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    cancel_multicast_group_session(id)
    cancel_multicast_group_session(id, params::Dict{String,<:Any})

Cancels an existing multicast group session.

# Arguments
- `id`:

"""
function cancel_multicast_group_session(
    Id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "DELETE",
        "/multicast-groups/$(Id)/session";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function cancel_multicast_group_session(
    Id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "DELETE",
        "/multicast-groups/$(Id)/session",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_destination(expression, expression_type, name, role_arn)
    create_destination(expression, expression_type, name, role_arn, params::Dict{String,<:Any})

Creates a new destination that maps a device message to an AWS IoT rule.

# Arguments
- `expression`: The rule name or topic rule to send messages to.
- `expression_type`: The type of value in Expression.
- `name`: The name of the new resource.
- `role_arn`: The ARN of the IAM Role that authorizes the destination.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientRequestToken"`: Each resource must have a unique client request token. The client
  token is used to implement idempotency. It ensures that the request completes no more than
  one time. If you retry a request with the same token and the same parameters, the request
  will complete successfully. However, if you try to create a new resource using the same
  token but different parameters, an HTTP 409 conflict occurs. If you omit this value, AWS
  SDKs will automatically generate a unique client request. For more information about
  idempotency, see Ensuring idempotency in Amazon EC2 API requests.
- `"Description"`: The description of the new resource.
- `"Tags"`: The tags to attach to the new destination. Tags are metadata that you can use
  to manage a resource.
"""
function create_destination(
    Expression,
    ExpressionType,
    Name,
    RoleArn;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_wireless(
        "POST",
        "/destinations",
        Dict{String,Any}(
            "Expression" => Expression,
            "ExpressionType" => ExpressionType,
            "Name" => Name,
            "RoleArn" => RoleArn,
            "ClientRequestToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_destination(
    Expression,
    ExpressionType,
    Name,
    RoleArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_wireless(
        "POST",
        "/destinations",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Expression" => Expression,
                    "ExpressionType" => ExpressionType,
                    "Name" => Name,
                    "RoleArn" => RoleArn,
                    "ClientRequestToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_device_profile()
    create_device_profile(params::Dict{String,<:Any})

Creates a new device profile.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientRequestToken"`: Each resource must have a unique client request token. The client
  token is used to implement idempotency. It ensures that the request completes no more than
  one time. If you retry a request with the same token and the same parameters, the request
  will complete successfully. However, if you try to create a new resource using the same
  token but different parameters, an HTTP 409 conflict occurs. If you omit this value, AWS
  SDKs will automatically generate a unique client request. For more information about
  idempotency, see Ensuring idempotency in Amazon EC2 API requests.
- `"LoRaWAN"`: The device profile information to use to create the device profile.
- `"Name"`: The name of the new resource.
- `"Sidewalk"`: The Sidewalk-related information for creating the Sidewalk device profile.
- `"Tags"`: The tags to attach to the new device profile. Tags are metadata that you can
  use to manage a resource.
"""
function create_device_profile(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot_wireless(
        "POST",
        "/device-profiles",
        Dict{String,Any}("ClientRequestToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_device_profile(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "POST",
        "/device-profiles",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ClientRequestToken" => string(uuid4())), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_fuota_task(firmware_update_image, firmware_update_role)
    create_fuota_task(firmware_update_image, firmware_update_role, params::Dict{String,<:Any})

Creates a FUOTA task.

# Arguments
- `firmware_update_image`:
- `firmware_update_role`:

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientRequestToken"`:
- `"Description"`:
- `"FragmentIntervalMS"`:
- `"FragmentSizeBytes"`:
- `"LoRaWAN"`:
- `"Name"`:
- `"RedundancyPercent"`:
- `"Tags"`:
"""
function create_fuota_task(
    FirmwareUpdateImage,
    FirmwareUpdateRole;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_wireless(
        "POST",
        "/fuota-tasks",
        Dict{String,Any}(
            "FirmwareUpdateImage" => FirmwareUpdateImage,
            "FirmwareUpdateRole" => FirmwareUpdateRole,
            "ClientRequestToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_fuota_task(
    FirmwareUpdateImage,
    FirmwareUpdateRole,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_wireless(
        "POST",
        "/fuota-tasks",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "FirmwareUpdateImage" => FirmwareUpdateImage,
                    "FirmwareUpdateRole" => FirmwareUpdateRole,
                    "ClientRequestToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_multicast_group(lo_ra_wan)
    create_multicast_group(lo_ra_wan, params::Dict{String,<:Any})

Creates a multicast group.

# Arguments
- `lo_ra_wan`:

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientRequestToken"`: Each resource must have a unique client request token. The client
  token is used to implement idempotency. It ensures that the request completes no more than
  one time. If you retry a request with the same token and the same parameters, the request
  will complete successfully. However, if you try to create a new resource using the same
  token but different parameters, an HTTP 409 conflict occurs. If you omit this value, AWS
  SDKs will automatically generate a unique client request. For more information about
  idempotency, see Ensuring idempotency in Amazon EC2 API requests.
- `"Description"`: The description of the multicast group.
- `"Name"`:
- `"Tags"`:
"""
function create_multicast_group(LoRaWAN; aws_config::AbstractAWSConfig=current_aws_config())
    return iot_wireless(
        "POST",
        "/multicast-groups",
        Dict{String,Any}("LoRaWAN" => LoRaWAN, "ClientRequestToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_multicast_group(
    LoRaWAN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_wireless(
        "POST",
        "/multicast-groups",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "LoRaWAN" => LoRaWAN, "ClientRequestToken" => string(uuid4())
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_network_analyzer_configuration(name)
    create_network_analyzer_configuration(name, params::Dict{String,<:Any})

Creates a new network analyzer configuration.

# Arguments
- `name`:

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientRequestToken"`:
- `"Description"`:
- `"MulticastGroups"`: Multicast Group resources to add to the network analyzer
  configruation. Provide the MulticastGroupId of the resource to add in the input array.
- `"Tags"`:
- `"TraceContent"`:
- `"WirelessDevices"`: Wireless device resources to add to the network analyzer
  configuration. Provide the WirelessDeviceId of the resource to add in the input array.
- `"WirelessGateways"`: Wireless gateway resources to add to the network analyzer
  configuration. Provide the WirelessGatewayId of the resource to add in the input array.
"""
function create_network_analyzer_configuration(
    Name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "POST",
        "/network-analyzer-configurations",
        Dict{String,Any}("Name" => Name, "ClientRequestToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_network_analyzer_configuration(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "POST",
        "/network-analyzer-configurations",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Name" => Name, "ClientRequestToken" => string(uuid4())),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_service_profile()
    create_service_profile(params::Dict{String,<:Any})

Creates a new service profile.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientRequestToken"`: Each resource must have a unique client request token. The client
  token is used to implement idempotency. It ensures that the request completes no more than
  one time. If you retry a request with the same token and the same parameters, the request
  will complete successfully. However, if you try to create a new resource using the same
  token but different parameters, an HTTP 409 conflict occurs. If you omit this value, AWS
  SDKs will automatically generate a unique client request. For more information about
  idempotency, see Ensuring idempotency in Amazon EC2 API requests.
- `"LoRaWAN"`: The service profile information to use to create the service profile.
- `"Name"`: The name of the new resource.
- `"Tags"`: The tags to attach to the new service profile. Tags are metadata that you can
  use to manage a resource.
"""
function create_service_profile(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot_wireless(
        "POST",
        "/service-profiles",
        Dict{String,Any}("ClientRequestToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_service_profile(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "POST",
        "/service-profiles",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ClientRequestToken" => string(uuid4())), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_wireless_device(destination_name, type)
    create_wireless_device(destination_name, type, params::Dict{String,<:Any})

Provisions a wireless device.

# Arguments
- `destination_name`: The name of the destination to assign to the new wireless device.
- `type`: The wireless device type.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientRequestToken"`: Each resource must have a unique client request token. The client
  token is used to implement idempotency. It ensures that the request completes no more than
  one time. If you retry a request with the same token and the same parameters, the request
  will complete successfully. However, if you try to create a new resource using the same
  token but different parameters, an HTTP 409 conflict occurs. If you omit this value, AWS
  SDKs will automatically generate a unique client request. For more information about
  idempotency, see Ensuring idempotency in Amazon EC2 API requests.
- `"Description"`: The description of the new resource.
- `"LoRaWAN"`: The device configuration information to use to create the wireless device.
- `"Name"`: The name of the new resource.
- `"Positioning"`: FPort values for the GNSS, stream, and ClockSync functions of the
  positioning information.
- `"Sidewalk"`: The device configuration information to use to create the Sidewalk device.
- `"Tags"`: The tags to attach to the new wireless device. Tags are metadata that you can
  use to manage a resource.
"""
function create_wireless_device(
    DestinationName, Type; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "POST",
        "/wireless-devices",
        Dict{String,Any}(
            "DestinationName" => DestinationName,
            "Type" => Type,
            "ClientRequestToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_wireless_device(
    DestinationName,
    Type,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_wireless(
        "POST",
        "/wireless-devices",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DestinationName" => DestinationName,
                    "Type" => Type,
                    "ClientRequestToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_wireless_gateway(lo_ra_wan)
    create_wireless_gateway(lo_ra_wan, params::Dict{String,<:Any})

Provisions a wireless gateway.  When provisioning a wireless gateway, you might run into
duplication errors for the following reasons.   If you specify a GatewayEui value that
already exists.   If you used a ClientRequestToken with the same parameters within the last
10 minutes.   To avoid this error, make sure that you use unique identifiers and parameters
for each request within the specified time period.

# Arguments
- `lo_ra_wan`: The gateway configuration information to use to create the wireless gateway.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientRequestToken"`: Each resource must have a unique client request token. The client
  token is used to implement idempotency. It ensures that the request completes no more than
  one time. If you retry a request with the same token and the same parameters, the request
  will complete successfully. However, if you try to create a new resource using the same
  token but different parameters, an HTTP 409 conflict occurs. If you omit this value, AWS
  SDKs will automatically generate a unique client request. For more information about
  idempotency, see Ensuring idempotency in Amazon EC2 API requests.
- `"Description"`: The description of the new resource.
- `"Name"`: The name of the new resource.
- `"Tags"`: The tags to attach to the new wireless gateway. Tags are metadata that you can
  use to manage a resource.
"""
function create_wireless_gateway(
    LoRaWAN; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "POST",
        "/wireless-gateways",
        Dict{String,Any}("LoRaWAN" => LoRaWAN, "ClientRequestToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_wireless_gateway(
    LoRaWAN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_wireless(
        "POST",
        "/wireless-gateways",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "LoRaWAN" => LoRaWAN, "ClientRequestToken" => string(uuid4())
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_wireless_gateway_task(id, wireless_gateway_task_definition_id)
    create_wireless_gateway_task(id, wireless_gateway_task_definition_id, params::Dict{String,<:Any})

Creates a task for a wireless gateway.

# Arguments
- `id`: The ID of the resource to update.
- `wireless_gateway_task_definition_id`: The ID of the WirelessGatewayTaskDefinition.

"""
function create_wireless_gateway_task(
    Id, WirelessGatewayTaskDefinitionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "POST",
        "/wireless-gateways/$(Id)/tasks",
        Dict{String,Any}(
            "WirelessGatewayTaskDefinitionId" => WirelessGatewayTaskDefinitionId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_wireless_gateway_task(
    Id,
    WirelessGatewayTaskDefinitionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_wireless(
        "POST",
        "/wireless-gateways/$(Id)/tasks",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "WirelessGatewayTaskDefinitionId" => WirelessGatewayTaskDefinitionId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_wireless_gateway_task_definition(auto_create_tasks)
    create_wireless_gateway_task_definition(auto_create_tasks, params::Dict{String,<:Any})

Creates a gateway task definition.

# Arguments
- `auto_create_tasks`: Whether to automatically create tasks using this task definition for
  all gateways with the specified current version. If false, the task must me created by
  calling CreateWirelessGatewayTask.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientRequestToken"`: Each resource must have a unique client request token. The client
  token is used to implement idempotency. It ensures that the request completes no more than
  one time. If you retry a request with the same token and the same parameters, the request
  will complete successfully. However, if you try to create a new resource using the same
  token but different parameters, an HTTP 409 conflict occurs. If you omit this value, AWS
  SDKs will automatically generate a unique client request. For more information about
  idempotency, see Ensuring idempotency in Amazon EC2 API requests.
- `"Name"`: The name of the new resource.
- `"Tags"`: The tags to attach to the specified resource. Tags are metadata that you can
  use to manage a resource.
- `"Update"`: Information about the gateways to update.
"""
function create_wireless_gateway_task_definition(
    AutoCreateTasks; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "POST",
        "/wireless-gateway-task-definitions",
        Dict{String,Any}(
            "AutoCreateTasks" => AutoCreateTasks, "ClientRequestToken" => string(uuid4())
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_wireless_gateway_task_definition(
    AutoCreateTasks,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_wireless(
        "POST",
        "/wireless-gateway-task-definitions",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AutoCreateTasks" => AutoCreateTasks,
                    "ClientRequestToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_destination(name)
    delete_destination(name, params::Dict{String,<:Any})

Deletes a destination.

# Arguments
- `name`: The name of the resource to delete.

"""
function delete_destination(Name; aws_config::AbstractAWSConfig=current_aws_config())
    return iot_wireless(
        "DELETE",
        "/destinations/$(Name)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_destination(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "DELETE",
        "/destinations/$(Name)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_device_profile(id)
    delete_device_profile(id, params::Dict{String,<:Any})

Deletes a device profile.

# Arguments
- `id`: The ID of the resource to delete.

"""
function delete_device_profile(Id; aws_config::AbstractAWSConfig=current_aws_config())
    return iot_wireless(
        "DELETE",
        "/device-profiles/$(Id)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_device_profile(
    Id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "DELETE",
        "/device-profiles/$(Id)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_fuota_task(id)
    delete_fuota_task(id, params::Dict{String,<:Any})

Deletes a FUOTA task.

# Arguments
- `id`:

"""
function delete_fuota_task(Id; aws_config::AbstractAWSConfig=current_aws_config())
    return iot_wireless(
        "DELETE",
        "/fuota-tasks/$(Id)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_fuota_task(
    Id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "DELETE",
        "/fuota-tasks/$(Id)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_multicast_group(id)
    delete_multicast_group(id, params::Dict{String,<:Any})

Deletes a multicast group if it is not in use by a fuota task.

# Arguments
- `id`:

"""
function delete_multicast_group(Id; aws_config::AbstractAWSConfig=current_aws_config())
    return iot_wireless(
        "DELETE",
        "/multicast-groups/$(Id)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_multicast_group(
    Id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "DELETE",
        "/multicast-groups/$(Id)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_network_analyzer_configuration(configuration_name)
    delete_network_analyzer_configuration(configuration_name, params::Dict{String,<:Any})

Deletes a network analyzer configuration.

# Arguments
- `configuration_name`:

"""
function delete_network_analyzer_configuration(
    ConfigurationName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "DELETE",
        "/network-analyzer-configurations/$(ConfigurationName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_network_analyzer_configuration(
    ConfigurationName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_wireless(
        "DELETE",
        "/network-analyzer-configurations/$(ConfigurationName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_queued_messages(id, message_id)
    delete_queued_messages(id, message_id, params::Dict{String,<:Any})

Remove queued messages from the downlink queue.

# Arguments
- `id`: The ID of a given wireless device for which downlink messages will be deleted.
- `message_id`: If message ID is \"*\", it cleares the entire downlink queue for a given
  device, specified by the wireless device ID. Otherwise, the downlink message with the
  specified message ID will be deleted.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"WirelessDeviceType"`: The wireless device type, which can be either Sidewalk or LoRaWAN.
"""
function delete_queued_messages(
    Id, messageId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "DELETE",
        "/wireless-devices/$(Id)/data",
        Dict{String,Any}("messageId" => messageId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_queued_messages(
    Id,
    messageId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_wireless(
        "DELETE",
        "/wireless-devices/$(Id)/data",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("messageId" => messageId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_service_profile(id)
    delete_service_profile(id, params::Dict{String,<:Any})

Deletes a service profile.

# Arguments
- `id`: The ID of the resource to delete.

"""
function delete_service_profile(Id; aws_config::AbstractAWSConfig=current_aws_config())
    return iot_wireless(
        "DELETE",
        "/service-profiles/$(Id)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_service_profile(
    Id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "DELETE",
        "/service-profiles/$(Id)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_wireless_device(id)
    delete_wireless_device(id, params::Dict{String,<:Any})

Deletes a wireless device.

# Arguments
- `id`: The ID of the resource to delete.

"""
function delete_wireless_device(Id; aws_config::AbstractAWSConfig=current_aws_config())
    return iot_wireless(
        "DELETE",
        "/wireless-devices/$(Id)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_wireless_device(
    Id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "DELETE",
        "/wireless-devices/$(Id)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_wireless_device_import_task(id)
    delete_wireless_device_import_task(id, params::Dict{String,<:Any})

Delete an import task.

# Arguments
- `id`: The unique identifier of the import task to be deleted.

"""
function delete_wireless_device_import_task(
    Id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "DELETE",
        "/wireless_device_import_task/$(Id)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_wireless_device_import_task(
    Id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "DELETE",
        "/wireless_device_import_task/$(Id)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_wireless_gateway(id)
    delete_wireless_gateway(id, params::Dict{String,<:Any})

Deletes a wireless gateway.  When deleting a wireless gateway, you might run into
duplication errors for the following reasons.   If you specify a GatewayEui value that
already exists.   If you used a ClientRequestToken with the same parameters within the last
10 minutes.   To avoid this error, make sure that you use unique identifiers and parameters
for each request within the specified time period.

# Arguments
- `id`: The ID of the resource to delete.

"""
function delete_wireless_gateway(Id; aws_config::AbstractAWSConfig=current_aws_config())
    return iot_wireless(
        "DELETE",
        "/wireless-gateways/$(Id)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_wireless_gateway(
    Id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "DELETE",
        "/wireless-gateways/$(Id)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_wireless_gateway_task(id)
    delete_wireless_gateway_task(id, params::Dict{String,<:Any})

Deletes a wireless gateway task.

# Arguments
- `id`: The ID of the resource to delete.

"""
function delete_wireless_gateway_task(
    Id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "DELETE",
        "/wireless-gateways/$(Id)/tasks";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_wireless_gateway_task(
    Id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "DELETE",
        "/wireless-gateways/$(Id)/tasks",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_wireless_gateway_task_definition(id)
    delete_wireless_gateway_task_definition(id, params::Dict{String,<:Any})

Deletes a wireless gateway task definition. Deleting this task definition does not affect
tasks that are currently in progress.

# Arguments
- `id`: The ID of the resource to delete.

"""
function delete_wireless_gateway_task_definition(
    Id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "DELETE",
        "/wireless-gateway-task-definitions/$(Id)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_wireless_gateway_task_definition(
    Id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "DELETE",
        "/wireless-gateway-task-definitions/$(Id)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    deregister_wireless_device(identifier)
    deregister_wireless_device(identifier, params::Dict{String,<:Any})

Deregister a wireless device from AWS IoT Wireless.

# Arguments
- `identifier`: The identifier of the wireless device to deregister from AWS IoT Wireless.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"WirelessDeviceType"`: The type of wireless device to deregister from AWS IoT Wireless,
  which can be LoRaWAN or Sidewalk.
"""
function deregister_wireless_device(
    Identifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "PATCH",
        "/wireless-devices/$(Identifier)/deregister";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function deregister_wireless_device(
    Identifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_wireless(
        "PATCH",
        "/wireless-devices/$(Identifier)/deregister",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_aws_account_from_partner_account(partner_account_id, partner_type)
    disassociate_aws_account_from_partner_account(partner_account_id, partner_type, params::Dict{String,<:Any})

Disassociates your AWS account from a partner account. If PartnerAccountId and PartnerType
are null, disassociates your AWS account from all partner accounts.

# Arguments
- `partner_account_id`: The partner account ID to disassociate from the AWS account.
- `partner_type`: The partner type.

"""
function disassociate_aws_account_from_partner_account(
    PartnerAccountId, partnerType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "DELETE",
        "/partner-accounts/$(PartnerAccountId)",
        Dict{String,Any}("partnerType" => partnerType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_aws_account_from_partner_account(
    PartnerAccountId,
    partnerType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_wireless(
        "DELETE",
        "/partner-accounts/$(PartnerAccountId)",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("partnerType" => partnerType), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_multicast_group_from_fuota_task(id, multicast_group_id)
    disassociate_multicast_group_from_fuota_task(id, multicast_group_id, params::Dict{String,<:Any})

Disassociates a multicast group from a fuota task.

# Arguments
- `id`:
- `multicast_group_id`:

"""
function disassociate_multicast_group_from_fuota_task(
    Id, MulticastGroupId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "DELETE",
        "/fuota-tasks/$(Id)/multicast-groups/$(MulticastGroupId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_multicast_group_from_fuota_task(
    Id,
    MulticastGroupId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_wireless(
        "DELETE",
        "/fuota-tasks/$(Id)/multicast-groups/$(MulticastGroupId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_wireless_device_from_fuota_task(id, wireless_device_id)
    disassociate_wireless_device_from_fuota_task(id, wireless_device_id, params::Dict{String,<:Any})

Disassociates a wireless device from a FUOTA task.

# Arguments
- `id`:
- `wireless_device_id`:

"""
function disassociate_wireless_device_from_fuota_task(
    Id, WirelessDeviceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "DELETE",
        "/fuota-tasks/$(Id)/wireless-devices/$(WirelessDeviceId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_wireless_device_from_fuota_task(
    Id,
    WirelessDeviceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_wireless(
        "DELETE",
        "/fuota-tasks/$(Id)/wireless-devices/$(WirelessDeviceId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_wireless_device_from_multicast_group(id, wireless_device_id)
    disassociate_wireless_device_from_multicast_group(id, wireless_device_id, params::Dict{String,<:Any})

Disassociates a wireless device from a multicast group.

# Arguments
- `id`:
- `wireless_device_id`:

"""
function disassociate_wireless_device_from_multicast_group(
    Id, WirelessDeviceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "DELETE",
        "/multicast-groups/$(Id)/wireless-devices/$(WirelessDeviceId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_wireless_device_from_multicast_group(
    Id,
    WirelessDeviceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_wireless(
        "DELETE",
        "/multicast-groups/$(Id)/wireless-devices/$(WirelessDeviceId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_wireless_device_from_thing(id)
    disassociate_wireless_device_from_thing(id, params::Dict{String,<:Any})

Disassociates a wireless device from its currently associated thing.

# Arguments
- `id`: The ID of the resource to update.

"""
function disassociate_wireless_device_from_thing(
    Id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "DELETE",
        "/wireless-devices/$(Id)/thing";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_wireless_device_from_thing(
    Id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "DELETE",
        "/wireless-devices/$(Id)/thing",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_wireless_gateway_from_certificate(id)
    disassociate_wireless_gateway_from_certificate(id, params::Dict{String,<:Any})

Disassociates a wireless gateway from its currently associated certificate.

# Arguments
- `id`: The ID of the resource to update.

"""
function disassociate_wireless_gateway_from_certificate(
    Id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "DELETE",
        "/wireless-gateways/$(Id)/certificate";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_wireless_gateway_from_certificate(
    Id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "DELETE",
        "/wireless-gateways/$(Id)/certificate",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_wireless_gateway_from_thing(id)
    disassociate_wireless_gateway_from_thing(id, params::Dict{String,<:Any})

Disassociates a wireless gateway from its currently associated thing.

# Arguments
- `id`: The ID of the resource to update.

"""
function disassociate_wireless_gateway_from_thing(
    Id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "DELETE",
        "/wireless-gateways/$(Id)/thing";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_wireless_gateway_from_thing(
    Id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "DELETE",
        "/wireless-gateways/$(Id)/thing",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_destination(name)
    get_destination(name, params::Dict{String,<:Any})

Gets information about a destination.

# Arguments
- `name`: The name of the resource to get.

"""
function get_destination(Name; aws_config::AbstractAWSConfig=current_aws_config())
    return iot_wireless(
        "GET",
        "/destinations/$(Name)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_destination(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "GET",
        "/destinations/$(Name)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_device_profile(id)
    get_device_profile(id, params::Dict{String,<:Any})

Gets information about a device profile.

# Arguments
- `id`: The ID of the resource to get.

"""
function get_device_profile(Id; aws_config::AbstractAWSConfig=current_aws_config())
    return iot_wireless(
        "GET",
        "/device-profiles/$(Id)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_device_profile(
    Id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "GET",
        "/device-profiles/$(Id)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_event_configuration_by_resource_types()
    get_event_configuration_by_resource_types(params::Dict{String,<:Any})

Get the event configuration based on resource types.

"""
function get_event_configuration_by_resource_types(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "GET",
        "/event-configurations-resource-types";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_event_configuration_by_resource_types(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "GET",
        "/event-configurations-resource-types",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_fuota_task(id)
    get_fuota_task(id, params::Dict{String,<:Any})

Gets information about a FUOTA task.

# Arguments
- `id`:

"""
function get_fuota_task(Id; aws_config::AbstractAWSConfig=current_aws_config())
    return iot_wireless(
        "GET", "/fuota-tasks/$(Id)"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_fuota_task(
    Id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "GET",
        "/fuota-tasks/$(Id)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_log_levels_by_resource_types()
    get_log_levels_by_resource_types(params::Dict{String,<:Any})

Returns current default log levels or log levels by resource types. Based on resource
types, log levels can be for wireless device log options or wireless gateway log options.

"""
function get_log_levels_by_resource_types(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "GET", "/log-levels"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_log_levels_by_resource_types(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "GET", "/log-levels", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    get_metric_configuration()
    get_metric_configuration(params::Dict{String,<:Any})

Get the metric configuration status for this AWS account.

"""
function get_metric_configuration(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot_wireless(
        "GET",
        "/metric-configuration";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_metric_configuration(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "GET",
        "/metric-configuration",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_metrics()
    get_metrics(params::Dict{String,<:Any})

Get the summary metrics for this AWS account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"SummaryMetricQueries"`: The list of queries to retrieve the summary metrics.
"""
function get_metrics(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot_wireless(
        "POST", "/metrics"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_metrics(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "POST", "/metrics", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    get_multicast_group(id)
    get_multicast_group(id, params::Dict{String,<:Any})

Gets information about a multicast group.

# Arguments
- `id`:

"""
function get_multicast_group(Id; aws_config::AbstractAWSConfig=current_aws_config())
    return iot_wireless(
        "GET",
        "/multicast-groups/$(Id)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_multicast_group(
    Id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "GET",
        "/multicast-groups/$(Id)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_multicast_group_session(id)
    get_multicast_group_session(id, params::Dict{String,<:Any})

Gets information about a multicast group session.

# Arguments
- `id`:

"""
function get_multicast_group_session(Id; aws_config::AbstractAWSConfig=current_aws_config())
    return iot_wireless(
        "GET",
        "/multicast-groups/$(Id)/session";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_multicast_group_session(
    Id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "GET",
        "/multicast-groups/$(Id)/session",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_network_analyzer_configuration(configuration_name)
    get_network_analyzer_configuration(configuration_name, params::Dict{String,<:Any})

Get network analyzer configuration.

# Arguments
- `configuration_name`:

"""
function get_network_analyzer_configuration(
    ConfigurationName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "GET",
        "/network-analyzer-configurations/$(ConfigurationName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_network_analyzer_configuration(
    ConfigurationName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_wireless(
        "GET",
        "/network-analyzer-configurations/$(ConfigurationName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_partner_account(partner_account_id, partner_type)
    get_partner_account(partner_account_id, partner_type, params::Dict{String,<:Any})

Gets information about a partner account. If PartnerAccountId and PartnerType are null,
returns all partner accounts.

# Arguments
- `partner_account_id`: The partner account ID to disassociate from the AWS account.
- `partner_type`: The partner type.

"""
function get_partner_account(
    PartnerAccountId, partnerType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "GET",
        "/partner-accounts/$(PartnerAccountId)",
        Dict{String,Any}("partnerType" => partnerType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_partner_account(
    PartnerAccountId,
    partnerType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_wireless(
        "GET",
        "/partner-accounts/$(PartnerAccountId)",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("partnerType" => partnerType), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_position(resource_identifier, resource_type)
    get_position(resource_identifier, resource_type, params::Dict{String,<:Any})

Get the position information for a given resource.  This action is no longer supported.
Calls to retrieve the position information should use the GetResourcePosition API operation
instead.

# Arguments
- `resource_identifier`: Resource identifier used to retrieve the position information.
- `resource_type`: Resource type of the resource for which position information is
  retrieved.

"""
function get_position(
    ResourceIdentifier, resourceType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "GET",
        "/positions/$(ResourceIdentifier)",
        Dict{String,Any}("resourceType" => resourceType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_position(
    ResourceIdentifier,
    resourceType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_wireless(
        "GET",
        "/positions/$(ResourceIdentifier)",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("resourceType" => resourceType), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_position_configuration(resource_identifier, resource_type)
    get_position_configuration(resource_identifier, resource_type, params::Dict{String,<:Any})

Get position configuration for a given resource.  This action is no longer supported. Calls
to retrieve the position configuration should use the GetResourcePosition API operation
instead.

# Arguments
- `resource_identifier`: Resource identifier used in a position configuration.
- `resource_type`: Resource type of the resource for which position configuration is
  retrieved.

"""
function get_position_configuration(
    ResourceIdentifier, resourceType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "GET",
        "/position-configurations/$(ResourceIdentifier)",
        Dict{String,Any}("resourceType" => resourceType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_position_configuration(
    ResourceIdentifier,
    resourceType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_wireless(
        "GET",
        "/position-configurations/$(ResourceIdentifier)",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("resourceType" => resourceType), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_position_estimate()
    get_position_estimate(params::Dict{String,<:Any})

Get estimated position information as a payload in GeoJSON format. The payload measurement
data is resolved using solvers that are provided by third-party vendors.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CellTowers"`: Retrieves an estimated device position by resolving measurement data from
  cellular radio towers. The position is resolved using HERE's cellular-based solver.
- `"Gnss"`: Retrieves an estimated device position by resolving the global navigation
  satellite system (GNSS) scan data. The position is resolved using the GNSS solver powered
  by LoRa Cloud.
- `"Ip"`: Retrieves an estimated device position by resolving the IP address information
  from the device. The position is resolved using MaxMind's IP-based solver.
- `"Timestamp"`: Optional information that specifies the time when the position information
  will be resolved. It uses the Unix timestamp format. If not specified, the time at which
  the request was received will be used.
- `"WiFiAccessPoints"`: Retrieves an estimated device position by resolving WLAN
  measurement data. The position is resolved using HERE's Wi-Fi based solver.
"""
function get_position_estimate(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot_wireless(
        "POST", "/position-estimate"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_position_estimate(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "POST",
        "/position-estimate",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_resource_event_configuration(identifier, identifier_type)
    get_resource_event_configuration(identifier, identifier_type, params::Dict{String,<:Any})

Get the event configuration for a particular resource identifier.

# Arguments
- `identifier`: Resource identifier to opt in for event messaging.
- `identifier_type`: Identifier type of the particular resource identifier for event
  configuration.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"partnerType"`: Partner type of the resource if the identifier type is PartnerAccountId.
"""
function get_resource_event_configuration(
    Identifier, identifierType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "GET",
        "/event-configurations/$(Identifier)",
        Dict{String,Any}("identifierType" => identifierType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_resource_event_configuration(
    Identifier,
    identifierType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_wireless(
        "GET",
        "/event-configurations/$(Identifier)",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("identifierType" => identifierType), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_resource_log_level(resource_identifier, resource_type)
    get_resource_log_level(resource_identifier, resource_type, params::Dict{String,<:Any})

Fetches the log-level override, if any, for a given resource-ID and resource-type. It can
be used for a wireless device or a wireless gateway.

# Arguments
- `resource_identifier`:
- `resource_type`: The type of the resource, which can be WirelessDevice or WirelessGateway.

"""
function get_resource_log_level(
    ResourceIdentifier, resourceType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "GET",
        "/log-levels/$(ResourceIdentifier)",
        Dict{String,Any}("resourceType" => resourceType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_resource_log_level(
    ResourceIdentifier,
    resourceType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_wireless(
        "GET",
        "/log-levels/$(ResourceIdentifier)",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("resourceType" => resourceType), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_resource_position(resource_identifier, resource_type)
    get_resource_position(resource_identifier, resource_type, params::Dict{String,<:Any})

Get the position information for a given wireless device or a wireless gateway resource.
The position information uses the  World Geodetic System (WGS84).

# Arguments
- `resource_identifier`: The identifier of the resource for which position information is
  retrieved. It can be the wireless device ID or the wireless gateway ID, depending on the
  resource type.
- `resource_type`: The type of resource for which position information is retrieved, which
  can be a wireless device or a wireless gateway.

"""
function get_resource_position(
    ResourceIdentifier, resourceType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "GET",
        "/resource-positions/$(ResourceIdentifier)",
        Dict{String,Any}("resourceType" => resourceType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_resource_position(
    ResourceIdentifier,
    resourceType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_wireless(
        "GET",
        "/resource-positions/$(ResourceIdentifier)",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("resourceType" => resourceType), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_service_endpoint()
    get_service_endpoint(params::Dict{String,<:Any})

Gets the account-specific endpoint for Configuration and Update Server (CUPS) protocol or
LoRaWAN Network Server (LNS) connections.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"serviceType"`: The service type for which to get endpoint information about. Can be
  CUPS for the Configuration and Update Server endpoint, or LNS for the LoRaWAN Network
  Server endpoint or CLAIM for the global endpoint.
"""
function get_service_endpoint(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot_wireless(
        "GET", "/service-endpoint"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_service_endpoint(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "GET",
        "/service-endpoint",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_service_profile(id)
    get_service_profile(id, params::Dict{String,<:Any})

Gets information about a service profile.

# Arguments
- `id`: The ID of the resource to get.

"""
function get_service_profile(Id; aws_config::AbstractAWSConfig=current_aws_config())
    return iot_wireless(
        "GET",
        "/service-profiles/$(Id)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_service_profile(
    Id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "GET",
        "/service-profiles/$(Id)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_wireless_device(identifier, identifier_type)
    get_wireless_device(identifier, identifier_type, params::Dict{String,<:Any})

Gets information about a wireless device.

# Arguments
- `identifier`: The identifier of the wireless device to get.
- `identifier_type`: The type of identifier used in identifier.

"""
function get_wireless_device(
    Identifier, identifierType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "GET",
        "/wireless-devices/$(Identifier)",
        Dict{String,Any}("identifierType" => identifierType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_wireless_device(
    Identifier,
    identifierType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_wireless(
        "GET",
        "/wireless-devices/$(Identifier)",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("identifierType" => identifierType), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_wireless_device_import_task(id)
    get_wireless_device_import_task(id, params::Dict{String,<:Any})

Get information about an import task and count of device onboarding summary information for
the import task.

# Arguments
- `id`: The identifier of the import task for which information is requested.

"""
function get_wireless_device_import_task(
    Id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "GET",
        "/wireless_device_import_task/$(Id)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_wireless_device_import_task(
    Id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "GET",
        "/wireless_device_import_task/$(Id)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_wireless_device_statistics(id)
    get_wireless_device_statistics(id, params::Dict{String,<:Any})

Gets operating information about a wireless device.

# Arguments
- `id`: The ID of the wireless device for which to get the data.

"""
function get_wireless_device_statistics(
    Id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "GET",
        "/wireless-devices/$(Id)/statistics";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_wireless_device_statistics(
    Id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "GET",
        "/wireless-devices/$(Id)/statistics",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_wireless_gateway(identifier, identifier_type)
    get_wireless_gateway(identifier, identifier_type, params::Dict{String,<:Any})

Gets information about a wireless gateway.

# Arguments
- `identifier`: The identifier of the wireless gateway to get.
- `identifier_type`: The type of identifier used in identifier.

"""
function get_wireless_gateway(
    Identifier, identifierType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "GET",
        "/wireless-gateways/$(Identifier)",
        Dict{String,Any}("identifierType" => identifierType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_wireless_gateway(
    Identifier,
    identifierType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_wireless(
        "GET",
        "/wireless-gateways/$(Identifier)",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("identifierType" => identifierType), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_wireless_gateway_certificate(id)
    get_wireless_gateway_certificate(id, params::Dict{String,<:Any})

Gets the ID of the certificate that is currently associated with a wireless gateway.

# Arguments
- `id`: The ID of the resource to get.

"""
function get_wireless_gateway_certificate(
    Id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "GET",
        "/wireless-gateways/$(Id)/certificate";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_wireless_gateway_certificate(
    Id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "GET",
        "/wireless-gateways/$(Id)/certificate",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_wireless_gateway_firmware_information(id)
    get_wireless_gateway_firmware_information(id, params::Dict{String,<:Any})

Gets the firmware version and other information about a wireless gateway.

# Arguments
- `id`: The ID of the resource to get.

"""
function get_wireless_gateway_firmware_information(
    Id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "GET",
        "/wireless-gateways/$(Id)/firmware-information";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_wireless_gateway_firmware_information(
    Id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "GET",
        "/wireless-gateways/$(Id)/firmware-information",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_wireless_gateway_statistics(id)
    get_wireless_gateway_statistics(id, params::Dict{String,<:Any})

Gets operating information about a wireless gateway.

# Arguments
- `id`: The ID of the wireless gateway for which to get the data.

"""
function get_wireless_gateway_statistics(
    Id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "GET",
        "/wireless-gateways/$(Id)/statistics";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_wireless_gateway_statistics(
    Id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "GET",
        "/wireless-gateways/$(Id)/statistics",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_wireless_gateway_task(id)
    get_wireless_gateway_task(id, params::Dict{String,<:Any})

Gets information about a wireless gateway task.

# Arguments
- `id`: The ID of the resource to get.

"""
function get_wireless_gateway_task(Id; aws_config::AbstractAWSConfig=current_aws_config())
    return iot_wireless(
        "GET",
        "/wireless-gateways/$(Id)/tasks";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_wireless_gateway_task(
    Id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "GET",
        "/wireless-gateways/$(Id)/tasks",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_wireless_gateway_task_definition(id)
    get_wireless_gateway_task_definition(id, params::Dict{String,<:Any})

Gets information about a wireless gateway task definition.

# Arguments
- `id`: The ID of the resource to get.

"""
function get_wireless_gateway_task_definition(
    Id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "GET",
        "/wireless-gateway-task-definitions/$(Id)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_wireless_gateway_task_definition(
    Id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "GET",
        "/wireless-gateway-task-definitions/$(Id)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_destinations()
    list_destinations(params::Dict{String,<:Any})

Lists the destinations registered to your AWS account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return in this operation.
- `"nextToken"`: To retrieve the next set of results, the nextToken value from a previous
  response; otherwise null to receive the first set of results.
"""
function list_destinations(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot_wireless(
        "GET", "/destinations"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_destinations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "GET",
        "/destinations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_device_profiles()
    list_device_profiles(params::Dict{String,<:Any})

Lists the device profiles registered to your AWS account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"deviceProfileType"`: A filter to list only device profiles that use this type, which
  can be LoRaWAN or Sidewalk.
- `"maxResults"`: The maximum number of results to return in this operation.
- `"nextToken"`: To retrieve the next set of results, the nextToken value from a previous
  response; otherwise null to receive the first set of results.
"""
function list_device_profiles(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot_wireless(
        "GET", "/device-profiles"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_device_profiles(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "GET",
        "/device-profiles",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_devices_for_wireless_device_import_task(id)
    list_devices_for_wireless_device_import_task(id, params::Dict{String,<:Any})

List the Sidewalk devices in an import task and their onboarding status.

# Arguments
- `id`: The identifier of the import task for which wireless devices are listed.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`:
- `"nextToken"`: To retrieve the next set of results, the nextToken value from a previous
  response; otherwise null to receive the first set of results.
- `"status"`: The status of the devices in the import task.
"""
function list_devices_for_wireless_device_import_task(
    id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "GET",
        "/wireless_device_import_task",
        Dict{String,Any}("id" => id);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_devices_for_wireless_device_import_task(
    id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "GET",
        "/wireless_device_import_task",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("id" => id), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_event_configurations(resource_type)
    list_event_configurations(resource_type, params::Dict{String,<:Any})

List event configurations where at least one event topic has been enabled.

# Arguments
- `resource_type`: Resource type to filter event configurations.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`:
- `"nextToken"`: To retrieve the next set of results, the nextToken value from a previous
  response; otherwise null to receive the first set of results.
"""
function list_event_configurations(
    resourceType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "GET",
        "/event-configurations",
        Dict{String,Any}("resourceType" => resourceType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_event_configurations(
    resourceType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_wireless(
        "GET",
        "/event-configurations",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("resourceType" => resourceType), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_fuota_tasks()
    list_fuota_tasks(params::Dict{String,<:Any})

Lists the FUOTA tasks registered to your AWS account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`:
- `"nextToken"`: To retrieve the next set of results, the nextToken value from a previous
  response; otherwise null to receive the first set of results.
"""
function list_fuota_tasks(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot_wireless(
        "GET", "/fuota-tasks"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_fuota_tasks(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "GET",
        "/fuota-tasks",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_multicast_groups()
    list_multicast_groups(params::Dict{String,<:Any})

Lists the multicast groups registered to your AWS account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`:
- `"nextToken"`: To retrieve the next set of results, the nextToken value from a previous
  response; otherwise null to receive the first set of results.
"""
function list_multicast_groups(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot_wireless(
        "GET", "/multicast-groups"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_multicast_groups(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "GET",
        "/multicast-groups",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_multicast_groups_by_fuota_task(id)
    list_multicast_groups_by_fuota_task(id, params::Dict{String,<:Any})

List all multicast groups associated with a fuota task.

# Arguments
- `id`:

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`:
- `"nextToken"`: To retrieve the next set of results, the nextToken value from a previous
  response; otherwise null to receive the first set of results.
"""
function list_multicast_groups_by_fuota_task(
    Id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "GET",
        "/fuota-tasks/$(Id)/multicast-groups";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_multicast_groups_by_fuota_task(
    Id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "GET",
        "/fuota-tasks/$(Id)/multicast-groups",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_network_analyzer_configurations()
    list_network_analyzer_configurations(params::Dict{String,<:Any})

Lists the network analyzer configurations.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`:
- `"nextToken"`: To retrieve the next set of results, the nextToken value from a previous
  response; otherwise null to receive the first set of results.
"""
function list_network_analyzer_configurations(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "GET",
        "/network-analyzer-configurations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_network_analyzer_configurations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "GET",
        "/network-analyzer-configurations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_partner_accounts()
    list_partner_accounts(params::Dict{String,<:Any})

Lists the partner accounts associated with your AWS account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return in this operation.
- `"nextToken"`: To retrieve the next set of results, the nextToken value from a previous
  response; otherwise null to receive the first set of results.
"""
function list_partner_accounts(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot_wireless(
        "GET", "/partner-accounts"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_partner_accounts(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "GET",
        "/partner-accounts",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_position_configurations()
    list_position_configurations(params::Dict{String,<:Any})

List position configurations for a given resource, such as positioning solvers.  This
action is no longer supported. Calls to retrieve position information should use the
GetResourcePosition API operation instead.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`:
- `"nextToken"`: To retrieve the next set of results, the nextToken value from a previous
  response; otherwise null to receive the first set of results.
- `"resourceType"`: Resource type for which position configurations are listed.
"""
function list_position_configurations(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot_wireless(
        "GET",
        "/position-configurations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_position_configurations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "GET",
        "/position-configurations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_queued_messages(id)
    list_queued_messages(id, params::Dict{String,<:Any})

List queued messages in the downlink queue.

# Arguments
- `id`: The ID of a given wireless device which the downlink message packets are being sent.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"WirelessDeviceType"`: The wireless device type, whic can be either Sidewalk or LoRaWAN.
- `"maxResults"`: The maximum number of results to return in this operation.
- `"nextToken"`: To retrieve the next set of results, the nextToken value from a previous
  response; otherwise null to receive the first set of results.
"""
function list_queued_messages(Id; aws_config::AbstractAWSConfig=current_aws_config())
    return iot_wireless(
        "GET",
        "/wireless-devices/$(Id)/data";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_queued_messages(
    Id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "GET",
        "/wireless-devices/$(Id)/data",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_service_profiles()
    list_service_profiles(params::Dict{String,<:Any})

Lists the service profiles registered to your AWS account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return in this operation.
- `"nextToken"`: To retrieve the next set of results, the nextToken value from a previous
  response; otherwise null to receive the first set of results.
"""
function list_service_profiles(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot_wireless(
        "GET", "/service-profiles"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_service_profiles(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "GET",
        "/service-profiles",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Lists the tags (metadata) you have assigned to the resource.

# Arguments
- `resource_arn`: The ARN of the resource for which you want to list tags.

"""
function list_tags_for_resource(
    resourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "GET",
        "/tags",
        Dict{String,Any}("resourceArn" => resourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_wireless(
        "GET",
        "/tags",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("resourceArn" => resourceArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_wireless_device_import_tasks()
    list_wireless_device_import_tasks(params::Dict{String,<:Any})

List wireless devices that have been added to an import task.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`:
- `"nextToken"`: To retrieve the next set of results, the nextToken value from a previous
  response; otherwise null to receive the first set of results.
"""
function list_wireless_device_import_tasks(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "GET",
        "/wireless_device_import_tasks";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_wireless_device_import_tasks(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "GET",
        "/wireless_device_import_tasks",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_wireless_devices()
    list_wireless_devices(params::Dict{String,<:Any})

Lists the wireless devices registered to your AWS account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"destinationName"`: A filter to list only the wireless devices that use this destination.
- `"deviceProfileId"`: A filter to list only the wireless devices that use this device
  profile.
- `"fuotaTaskId"`:
- `"maxResults"`: The maximum number of results to return in this operation.
- `"multicastGroupId"`:
- `"nextToken"`: To retrieve the next set of results, the nextToken value from a previous
  response; otherwise null to receive the first set of results.
- `"serviceProfileId"`: A filter to list only the wireless devices that use this service
  profile.
- `"wirelessDeviceType"`: A filter to list only the wireless devices that use this wireless
  device type.
"""
function list_wireless_devices(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot_wireless(
        "GET", "/wireless-devices"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_wireless_devices(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "GET",
        "/wireless-devices",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_wireless_gateway_task_definitions()
    list_wireless_gateway_task_definitions(params::Dict{String,<:Any})

List the wireless gateway tasks definitions registered to your AWS account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return in this operation.
- `"nextToken"`: To retrieve the next set of results, the nextToken value from a previous
  response; otherwise null to receive the first set of results.
- `"taskDefinitionType"`: A filter to list only the wireless gateway task definitions that
  use this task definition type.
"""
function list_wireless_gateway_task_definitions(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "GET",
        "/wireless-gateway-task-definitions";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_wireless_gateway_task_definitions(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "GET",
        "/wireless-gateway-task-definitions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_wireless_gateways()
    list_wireless_gateways(params::Dict{String,<:Any})

Lists the wireless gateways registered to your AWS account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return in this operation.
- `"nextToken"`: To retrieve the next set of results, the nextToken value from a previous
  response; otherwise null to receive the first set of results.
"""
function list_wireless_gateways(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot_wireless(
        "GET", "/wireless-gateways"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_wireless_gateways(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "GET",
        "/wireless-gateways",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_position_configuration(resource_identifier, resource_type)
    put_position_configuration(resource_identifier, resource_type, params::Dict{String,<:Any})

Put position configuration for a given resource.  This action is no longer supported. Calls
to update the position configuration should use the UpdateResourcePosition API operation
instead.

# Arguments
- `resource_identifier`: Resource identifier used to update the position configuration.
- `resource_type`: Resource type of the resource for which you want to update the position
  configuration.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Destination"`: The position data destination that describes the AWS IoT rule that
  processes the device's position data for use by AWS IoT Core for LoRaWAN.
- `"Solvers"`: The positioning solvers used to update the position configuration of the
  resource.
"""
function put_position_configuration(
    ResourceIdentifier, resourceType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "PUT",
        "/position-configurations/$(ResourceIdentifier)",
        Dict{String,Any}("resourceType" => resourceType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_position_configuration(
    ResourceIdentifier,
    resourceType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_wireless(
        "PUT",
        "/position-configurations/$(ResourceIdentifier)",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("resourceType" => resourceType), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_resource_log_level(log_level, resource_identifier, resource_type)
    put_resource_log_level(log_level, resource_identifier, resource_type, params::Dict{String,<:Any})

Sets the log-level override for a resource-ID and resource-type. This option can be
specified for a wireless gateway or a wireless device. A limit of 200 log level override
can be set per account.

# Arguments
- `log_level`:
- `resource_identifier`:
- `resource_type`: The type of the resource, which can be WirelessDevice or WirelessGateway.

"""
function put_resource_log_level(
    LogLevel,
    ResourceIdentifier,
    resourceType;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_wireless(
        "PUT",
        "/log-levels/$(ResourceIdentifier)",
        Dict{String,Any}("LogLevel" => LogLevel, "resourceType" => resourceType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_resource_log_level(
    LogLevel,
    ResourceIdentifier,
    resourceType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_wireless(
        "PUT",
        "/log-levels/$(ResourceIdentifier)",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("LogLevel" => LogLevel, "resourceType" => resourceType),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    reset_all_resource_log_levels()
    reset_all_resource_log_levels(params::Dict{String,<:Any})

Removes the log-level overrides for all resources; both wireless devices and wireless
gateways.

"""
function reset_all_resource_log_levels(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot_wireless(
        "DELETE", "/log-levels"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function reset_all_resource_log_levels(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "DELETE",
        "/log-levels",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    reset_resource_log_level(resource_identifier, resource_type)
    reset_resource_log_level(resource_identifier, resource_type, params::Dict{String,<:Any})

Removes the log-level override, if any, for a specific resource-ID and resource-type. It
can be used for a wireless device or a wireless gateway.

# Arguments
- `resource_identifier`:
- `resource_type`: The type of the resource, which can be WirelessDevice or WirelessGateway.

"""
function reset_resource_log_level(
    ResourceIdentifier, resourceType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "DELETE",
        "/log-levels/$(ResourceIdentifier)",
        Dict{String,Any}("resourceType" => resourceType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function reset_resource_log_level(
    ResourceIdentifier,
    resourceType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_wireless(
        "DELETE",
        "/log-levels/$(ResourceIdentifier)",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("resourceType" => resourceType), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    send_data_to_multicast_group(id, payload_data, wireless_metadata)
    send_data_to_multicast_group(id, payload_data, wireless_metadata, params::Dict{String,<:Any})

Sends the specified data to a multicast group.

# Arguments
- `id`:
- `payload_data`:
- `wireless_metadata`:

"""
function send_data_to_multicast_group(
    Id, PayloadData, WirelessMetadata; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "POST",
        "/multicast-groups/$(Id)/data",
        Dict{String,Any}(
            "PayloadData" => PayloadData, "WirelessMetadata" => WirelessMetadata
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function send_data_to_multicast_group(
    Id,
    PayloadData,
    WirelessMetadata,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_wireless(
        "POST",
        "/multicast-groups/$(Id)/data",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "PayloadData" => PayloadData, "WirelessMetadata" => WirelessMetadata
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    send_data_to_wireless_device(id, payload_data, transmit_mode)
    send_data_to_wireless_device(id, payload_data, transmit_mode, params::Dict{String,<:Any})

Sends a decrypted application data frame to a device.

# Arguments
- `id`: The ID of the wireless device to receive the data.
- `payload_data`:
- `transmit_mode`: The transmit mode to use to send data to the wireless device. Can be: 0
  for UM (unacknowledge mode) or 1 for AM (acknowledge mode).

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"WirelessMetadata"`: Metadata about the message request.
"""
function send_data_to_wireless_device(
    Id, PayloadData, TransmitMode; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "POST",
        "/wireless-devices/$(Id)/data",
        Dict{String,Any}("PayloadData" => PayloadData, "TransmitMode" => TransmitMode);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function send_data_to_wireless_device(
    Id,
    PayloadData,
    TransmitMode,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_wireless(
        "POST",
        "/wireless-devices/$(Id)/data",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "PayloadData" => PayloadData, "TransmitMode" => TransmitMode
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_bulk_associate_wireless_device_with_multicast_group(id)
    start_bulk_associate_wireless_device_with_multicast_group(id, params::Dict{String,<:Any})

Starts a bulk association of all qualifying wireless devices with a multicast group.

# Arguments
- `id`:

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"QueryString"`:
- `"Tags"`:
"""
function start_bulk_associate_wireless_device_with_multicast_group(
    Id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "PATCH",
        "/multicast-groups/$(Id)/bulk";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_bulk_associate_wireless_device_with_multicast_group(
    Id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "PATCH",
        "/multicast-groups/$(Id)/bulk",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_bulk_disassociate_wireless_device_from_multicast_group(id)
    start_bulk_disassociate_wireless_device_from_multicast_group(id, params::Dict{String,<:Any})

Starts a bulk disassociatin of all qualifying wireless devices from a multicast group.

# Arguments
- `id`:

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"QueryString"`:
- `"Tags"`:
"""
function start_bulk_disassociate_wireless_device_from_multicast_group(
    Id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "POST",
        "/multicast-groups/$(Id)/bulk";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_bulk_disassociate_wireless_device_from_multicast_group(
    Id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "POST",
        "/multicast-groups/$(Id)/bulk",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_fuota_task(id)
    start_fuota_task(id, params::Dict{String,<:Any})

Starts a FUOTA task.

# Arguments
- `id`:

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"LoRaWAN"`:
"""
function start_fuota_task(Id; aws_config::AbstractAWSConfig=current_aws_config())
    return iot_wireless(
        "PUT", "/fuota-tasks/$(Id)"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function start_fuota_task(
    Id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "PUT",
        "/fuota-tasks/$(Id)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_multicast_group_session(id, lo_ra_wan)
    start_multicast_group_session(id, lo_ra_wan, params::Dict{String,<:Any})

Starts a multicast group session.

# Arguments
- `id`:
- `lo_ra_wan`:

"""
function start_multicast_group_session(
    Id, LoRaWAN; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "PUT",
        "/multicast-groups/$(Id)/session",
        Dict{String,Any}("LoRaWAN" => LoRaWAN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_multicast_group_session(
    Id,
    LoRaWAN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_wireless(
        "PUT",
        "/multicast-groups/$(Id)/session",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("LoRaWAN" => LoRaWAN), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_single_wireless_device_import_task(destination_name, sidewalk)
    start_single_wireless_device_import_task(destination_name, sidewalk, params::Dict{String,<:Any})

Start import task for a single wireless device.

# Arguments
- `destination_name`: The name of the Sidewalk destination that describes the IoT rule to
  route messages from the device in the import task that will be onboarded to AWS IoT
  Wireless.
- `sidewalk`: The Sidewalk-related parameters for importing a single wireless device.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientRequestToken"`:
- `"DeviceName"`: The name of the wireless device for which an import task is being started.
- `"Tags"`:
"""
function start_single_wireless_device_import_task(
    DestinationName, Sidewalk; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "POST",
        "/wireless_single_device_import_task",
        Dict{String,Any}(
            "DestinationName" => DestinationName,
            "Sidewalk" => Sidewalk,
            "ClientRequestToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_single_wireless_device_import_task(
    DestinationName,
    Sidewalk,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_wireless(
        "POST",
        "/wireless_single_device_import_task",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DestinationName" => DestinationName,
                    "Sidewalk" => Sidewalk,
                    "ClientRequestToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_wireless_device_import_task(destination_name, sidewalk)
    start_wireless_device_import_task(destination_name, sidewalk, params::Dict{String,<:Any})

Start import task for provisioning Sidewalk devices in bulk using an S3 CSV file.

# Arguments
- `destination_name`: The name of the Sidewalk destination that describes the IoT rule to
  route messages from the devices in the import task that are onboarded to AWS IoT Wireless.
- `sidewalk`: The Sidewalk-related parameters for importing wireless devices that need to
  be provisioned in bulk.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientRequestToken"`:
- `"Tags"`:
"""
function start_wireless_device_import_task(
    DestinationName, Sidewalk; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "POST",
        "/wireless_device_import_task",
        Dict{String,Any}(
            "DestinationName" => DestinationName,
            "Sidewalk" => Sidewalk,
            "ClientRequestToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_wireless_device_import_task(
    DestinationName,
    Sidewalk,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_wireless(
        "POST",
        "/wireless_device_import_task",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DestinationName" => DestinationName,
                    "Sidewalk" => Sidewalk,
                    "ClientRequestToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(tags, resource_arn)
    tag_resource(tags, resource_arn, params::Dict{String,<:Any})

Adds a tag to a resource.

# Arguments
- `tags`: Adds to or modifies the tags of the given resource. Tags are metadata that you
  can use to manage a resource.
- `resource_arn`: The ARN of the resource to add tags to.

"""
function tag_resource(Tags, resourceArn; aws_config::AbstractAWSConfig=current_aws_config())
    return iot_wireless(
        "POST",
        "/tags",
        Dict{String,Any}("Tags" => Tags, "resourceArn" => resourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    Tags,
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_wireless(
        "POST",
        "/tags",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Tags" => Tags, "resourceArn" => resourceArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    test_wireless_device(id)
    test_wireless_device(id, params::Dict{String,<:Any})

Simulates a provisioned device by sending an uplink data payload of Hello.

# Arguments
- `id`: The ID of the wireless device to test.

"""
function test_wireless_device(Id; aws_config::AbstractAWSConfig=current_aws_config())
    return iot_wireless(
        "POST",
        "/wireless-devices/$(Id)/test";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function test_wireless_device(
    Id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "POST",
        "/wireless-devices/$(Id)/test",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Removes one or more tags from a resource.

# Arguments
- `resource_arn`: The ARN of the resource to remove tags from.
- `tag_keys`: A list of the keys of the tags to remove from the resource.

"""
function untag_resource(
    resourceArn, tagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "DELETE",
        "/tags",
        Dict{String,Any}("resourceArn" => resourceArn, "tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    resourceArn,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_wireless(
        "DELETE",
        "/tags",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("resourceArn" => resourceArn, "tagKeys" => tagKeys),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_destination(name)
    update_destination(name, params::Dict{String,<:Any})

Updates properties of a destination.

# Arguments
- `name`: The new name of the resource.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: A new description of the resource.
- `"Expression"`: The new rule name or topic rule to send messages to.
- `"ExpressionType"`: The type of value in Expression.
- `"RoleArn"`: The ARN of the IAM Role that authorizes the destination.
"""
function update_destination(Name; aws_config::AbstractAWSConfig=current_aws_config())
    return iot_wireless(
        "PATCH",
        "/destinations/$(Name)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_destination(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "PATCH",
        "/destinations/$(Name)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_event_configuration_by_resource_types()
    update_event_configuration_by_resource_types(params::Dict{String,<:Any})

Update the event configuration based on resource types.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ConnectionStatus"`: Connection status resource type event configuration object for
  enabling and disabling wireless gateway topic.
- `"DeviceRegistrationState"`: Device registration state resource type event configuration
  object for enabling and disabling wireless gateway topic.
- `"Join"`: Join resource type event configuration object for enabling and disabling
  wireless device topic.
- `"MessageDeliveryStatus"`: Message delivery status resource type event configuration
  object for enabling and disabling wireless device topic.
- `"Proximity"`: Proximity resource type event configuration object for enabling and
  disabling wireless gateway topic.
"""
function update_event_configuration_by_resource_types(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "PATCH",
        "/event-configurations-resource-types";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_event_configuration_by_resource_types(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "PATCH",
        "/event-configurations-resource-types",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_fuota_task(id)
    update_fuota_task(id, params::Dict{String,<:Any})

Updates properties of a FUOTA task.

# Arguments
- `id`:

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`:
- `"FirmwareUpdateImage"`:
- `"FirmwareUpdateRole"`:
- `"FragmentIntervalMS"`:
- `"FragmentSizeBytes"`:
- `"LoRaWAN"`:
- `"Name"`:
- `"RedundancyPercent"`:
"""
function update_fuota_task(Id; aws_config::AbstractAWSConfig=current_aws_config())
    return iot_wireless(
        "PATCH",
        "/fuota-tasks/$(Id)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_fuota_task(
    Id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "PATCH",
        "/fuota-tasks/$(Id)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_log_levels_by_resource_types()
    update_log_levels_by_resource_types(params::Dict{String,<:Any})

Set default log level, or log levels by resource types. This can be for wireless device log
options or wireless gateways log options and is used to control the log messages that'll be
displayed in CloudWatch.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DefaultLogLevel"`:
- `"WirelessDeviceLogOptions"`:
- `"WirelessGatewayLogOptions"`:
"""
function update_log_levels_by_resource_types(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "POST", "/log-levels"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function update_log_levels_by_resource_types(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "POST",
        "/log-levels",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_metric_configuration()
    update_metric_configuration(params::Dict{String,<:Any})

Update the summary metric configuration.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"SummaryMetric"`: The value to be used to set summary metric configuration.
"""
function update_metric_configuration(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot_wireless(
        "PUT",
        "/metric-configuration";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_metric_configuration(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "PUT",
        "/metric-configuration",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_multicast_group(id)
    update_multicast_group(id, params::Dict{String,<:Any})

Updates properties of a multicast group session.

# Arguments
- `id`:

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`:
- `"LoRaWAN"`:
- `"Name"`:
"""
function update_multicast_group(Id; aws_config::AbstractAWSConfig=current_aws_config())
    return iot_wireless(
        "PATCH",
        "/multicast-groups/$(Id)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_multicast_group(
    Id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "PATCH",
        "/multicast-groups/$(Id)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_network_analyzer_configuration(configuration_name)
    update_network_analyzer_configuration(configuration_name, params::Dict{String,<:Any})

Update network analyzer configuration.

# Arguments
- `configuration_name`:

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`:
- `"MulticastGroupsToAdd"`: Multicast group resources to add to the network analyzer
  configuration. Provide the MulticastGroupId of the resource to add in the input array.
- `"MulticastGroupsToRemove"`: Multicast group resources to remove from the network
  analyzer configuration. Provide the MulticastGroupId of the resources to remove in the
  input array.
- `"TraceContent"`:
- `"WirelessDevicesToAdd"`: Wireless device resources to add to the network analyzer
  configuration. Provide the WirelessDeviceId of the resource to add in the input array.
- `"WirelessDevicesToRemove"`: Wireless device resources to remove from the network
  analyzer configuration. Provide the WirelessDeviceId of the resources to remove in the
  input array.
- `"WirelessGatewaysToAdd"`: Wireless gateway resources to add to the network analyzer
  configuration. Provide the WirelessGatewayId of the resource to add in the input array.
- `"WirelessGatewaysToRemove"`: Wireless gateway resources to remove from the network
  analyzer configuration. Provide the WirelessGatewayId of the resources to remove in the
  input array.
"""
function update_network_analyzer_configuration(
    ConfigurationName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "PATCH",
        "/network-analyzer-configurations/$(ConfigurationName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_network_analyzer_configuration(
    ConfigurationName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_wireless(
        "PATCH",
        "/network-analyzer-configurations/$(ConfigurationName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_partner_account(partner_account_id, sidewalk, partner_type)
    update_partner_account(partner_account_id, sidewalk, partner_type, params::Dict{String,<:Any})

Updates properties of a partner account.

# Arguments
- `partner_account_id`: The ID of the partner account to update.
- `sidewalk`: The Sidewalk account credentials.
- `partner_type`: The partner type.

"""
function update_partner_account(
    PartnerAccountId,
    Sidewalk,
    partnerType;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_wireless(
        "PATCH",
        "/partner-accounts/$(PartnerAccountId)",
        Dict{String,Any}("Sidewalk" => Sidewalk, "partnerType" => partnerType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_partner_account(
    PartnerAccountId,
    Sidewalk,
    partnerType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_wireless(
        "PATCH",
        "/partner-accounts/$(PartnerAccountId)",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Sidewalk" => Sidewalk, "partnerType" => partnerType),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_position(position, resource_identifier, resource_type)
    update_position(position, resource_identifier, resource_type, params::Dict{String,<:Any})

Update the position information of a resource.  This action is no longer supported. Calls
to update the position information should use the UpdateResourcePosition API operation
instead.

# Arguments
- `position`: The position information of the resource.
- `resource_identifier`: Resource identifier of the resource for which position is updated.
- `resource_type`: Resource type of the resource for which position is updated.

"""
function update_position(
    Position,
    ResourceIdentifier,
    resourceType;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_wireless(
        "PATCH",
        "/positions/$(ResourceIdentifier)",
        Dict{String,Any}("Position" => Position, "resourceType" => resourceType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_position(
    Position,
    ResourceIdentifier,
    resourceType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_wireless(
        "PATCH",
        "/positions/$(ResourceIdentifier)",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Position" => Position, "resourceType" => resourceType),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_resource_event_configuration(identifier, identifier_type)
    update_resource_event_configuration(identifier, identifier_type, params::Dict{String,<:Any})

Update the event configuration for a particular resource identifier.

# Arguments
- `identifier`: Resource identifier to opt in for event messaging.
- `identifier_type`: Identifier type of the particular resource identifier for event
  configuration.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ConnectionStatus"`: Event configuration for the connection status event.
- `"DeviceRegistrationState"`: Event configuration for the device registration state event.
- `"Join"`: Event configuration for the join event.
- `"MessageDeliveryStatus"`: Event configuration for the message delivery status event.
- `"Proximity"`: Event configuration for the proximity event.
- `"partnerType"`: Partner type of the resource if the identifier type is PartnerAccountId
"""
function update_resource_event_configuration(
    Identifier, identifierType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "PATCH",
        "/event-configurations/$(Identifier)",
        Dict{String,Any}("identifierType" => identifierType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_resource_event_configuration(
    Identifier,
    identifierType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_wireless(
        "PATCH",
        "/event-configurations/$(Identifier)",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("identifierType" => identifierType), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_resource_position(resource_identifier, resource_type)
    update_resource_position(resource_identifier, resource_type, params::Dict{String,<:Any})

Update the position information of a given wireless device or a wireless gateway resource.
The position coordinates are based on the  World Geodetic System (WGS84).

# Arguments
- `resource_identifier`: The identifier of the resource for which position information is
  updated. It can be the wireless device ID or the wireless gateway ID, depending on the
  resource type.
- `resource_type`: The type of resource for which position information is updated, which
  can be a wireless device or a wireless gateway.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"GeoJsonPayload"`: The position information of the resource, displayed as a JSON
  payload. The payload uses the GeoJSON format, which a format that's used to encode
  geographic data structures. For more information, see GeoJSON.
"""
function update_resource_position(
    ResourceIdentifier, resourceType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "PATCH",
        "/resource-positions/$(ResourceIdentifier)",
        Dict{String,Any}("resourceType" => resourceType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_resource_position(
    ResourceIdentifier,
    resourceType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_wireless(
        "PATCH",
        "/resource-positions/$(ResourceIdentifier)",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("resourceType" => resourceType), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_wireless_device(id)
    update_wireless_device(id, params::Dict{String,<:Any})

Updates properties of a wireless device.

# Arguments
- `id`: The ID of the resource to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: A new description of the resource.
- `"DestinationName"`: The name of the new destination for the device.
- `"LoRaWAN"`: The updated wireless device's configuration.
- `"Name"`: The new name of the resource.
- `"Positioning"`: FPort values for the GNSS, stream, and ClockSync functions of the
  positioning information.
"""
function update_wireless_device(Id; aws_config::AbstractAWSConfig=current_aws_config())
    return iot_wireless(
        "PATCH",
        "/wireless-devices/$(Id)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_wireless_device(
    Id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "PATCH",
        "/wireless-devices/$(Id)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_wireless_device_import_task(id, sidewalk)
    update_wireless_device_import_task(id, sidewalk, params::Dict{String,<:Any})

Update an import task to add more devices to the task.

# Arguments
- `id`: The identifier of the import task to be updated.
- `sidewalk`: The Sidewalk-related parameters of the import task to be updated.

"""
function update_wireless_device_import_task(
    Id, Sidewalk; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "PATCH",
        "/wireless_device_import_task/$(Id)",
        Dict{String,Any}("Sidewalk" => Sidewalk);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_wireless_device_import_task(
    Id,
    Sidewalk,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot_wireless(
        "PATCH",
        "/wireless_device_import_task/$(Id)",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Sidewalk" => Sidewalk), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_wireless_gateway(id)
    update_wireless_gateway(id, params::Dict{String,<:Any})

Updates properties of a wireless gateway.

# Arguments
- `id`: The ID of the resource to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: A new description of the resource.
- `"JoinEuiFilters"`:
- `"MaxEirp"`: The MaxEIRP value.
- `"Name"`: The new name of the resource.
- `"NetIdFilters"`:
"""
function update_wireless_gateway(Id; aws_config::AbstractAWSConfig=current_aws_config())
    return iot_wireless(
        "PATCH",
        "/wireless-gateways/$(Id)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_wireless_gateway(
    Id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot_wireless(
        "PATCH",
        "/wireless-gateways/$(Id)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
