# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: mgn
using AWS.Compat
using AWS.UUIDs

"""
    archive_application(application_id)
    archive_application(application_id, params::Dict{String,<:Any})

Archive application.

# Arguments
- `application_id`: Application ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountID"`: Account ID.
"""
function archive_application(
    applicationID; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "POST",
        "/ArchiveApplication",
        Dict{String,Any}("applicationID" => applicationID);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function archive_application(
    applicationID,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mgn(
        "POST",
        "/ArchiveApplication",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("applicationID" => applicationID), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    archive_wave(wave_id)
    archive_wave(wave_id, params::Dict{String,<:Any})

Archive wave.

# Arguments
- `wave_id`: Wave ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountID"`: Account ID.
"""
function archive_wave(waveID; aws_config::AbstractAWSConfig=current_aws_config())
    return mgn(
        "POST",
        "/ArchiveWave",
        Dict{String,Any}("waveID" => waveID);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function archive_wave(
    waveID, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "POST",
        "/ArchiveWave",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("waveID" => waveID), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    associate_applications(application_ids, wave_id)
    associate_applications(application_ids, wave_id, params::Dict{String,<:Any})

Associate applications to wave.

# Arguments
- `application_ids`: Application IDs list.
- `wave_id`: Wave ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountID"`: Account ID.
"""
function associate_applications(
    applicationIDs, waveID; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "POST",
        "/AssociateApplications",
        Dict{String,Any}("applicationIDs" => applicationIDs, "waveID" => waveID);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_applications(
    applicationIDs,
    waveID,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mgn(
        "POST",
        "/AssociateApplications",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("applicationIDs" => applicationIDs, "waveID" => waveID),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    associate_source_servers(application_id, source_server_ids)
    associate_source_servers(application_id, source_server_ids, params::Dict{String,<:Any})

Associate source servers to application.

# Arguments
- `application_id`: Application ID.
- `source_server_ids`: Source server IDs list.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountID"`: Account ID.
"""
function associate_source_servers(
    applicationID, sourceServerIDs; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "POST",
        "/AssociateSourceServers",
        Dict{String,Any}(
            "applicationID" => applicationID, "sourceServerIDs" => sourceServerIDs
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_source_servers(
    applicationID,
    sourceServerIDs,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mgn(
        "POST",
        "/AssociateSourceServers",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "applicationID" => applicationID, "sourceServerIDs" => sourceServerIDs
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    change_server_life_cycle_state(life_cycle, source_server_id)
    change_server_life_cycle_state(life_cycle, source_server_id, params::Dict{String,<:Any})

Allows the user to set the SourceServer.LifeCycle.state property for specific Source Server
IDs to one of the following: READY_FOR_TEST or READY_FOR_CUTOVER. This command only works
if the Source Server is already launchable (dataReplicationInfo.lagDuration is not null.)

# Arguments
- `life_cycle`: The request to change the source server migration lifecycle state.
- `source_server_id`: The request to change the source server migration lifecycle state by
  source server ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountID"`: The request to change the source server migration account ID.
"""
function change_server_life_cycle_state(
    lifeCycle, sourceServerID; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "POST",
        "/ChangeServerLifeCycleState",
        Dict{String,Any}("lifeCycle" => lifeCycle, "sourceServerID" => sourceServerID);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function change_server_life_cycle_state(
    lifeCycle,
    sourceServerID,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mgn(
        "POST",
        "/ChangeServerLifeCycleState",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "lifeCycle" => lifeCycle, "sourceServerID" => sourceServerID
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_application(name)
    create_application(name, params::Dict{String,<:Any})

Create application.

# Arguments
- `name`: Application name.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountID"`: Account ID.
- `"description"`: Application description.
- `"tags"`: Application tags.
"""
function create_application(name; aws_config::AbstractAWSConfig=current_aws_config())
    return mgn(
        "POST",
        "/CreateApplication",
        Dict{String,Any}("name" => name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_application(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "POST",
        "/CreateApplication",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("name" => name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_connector(name, ssm_instance_id)
    create_connector(name, ssm_instance_id, params::Dict{String,<:Any})

Create Connector.

# Arguments
- `name`: Create Connector request name.
- `ssm_instance_id`: Create Connector request SSM instance ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ssmCommandConfig"`: Create Connector request SSM command config.
- `"tags"`: Create Connector request tags.
"""
function create_connector(
    name, ssmInstanceID; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "POST",
        "/CreateConnector",
        Dict{String,Any}("name" => name, "ssmInstanceID" => ssmInstanceID);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_connector(
    name,
    ssmInstanceID,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mgn(
        "POST",
        "/CreateConnector",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("name" => name, "ssmInstanceID" => ssmInstanceID),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_launch_configuration_template()
    create_launch_configuration_template(params::Dict{String,<:Any})

Creates a new Launch Configuration Template.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"associatePublicIpAddress"`: Associate public Ip address.
- `"bootMode"`: Launch configuration template boot mode.
- `"copyPrivateIp"`: Copy private Ip.
- `"copyTags"`: Copy tags.
- `"enableMapAutoTagging"`: Enable map auto tagging.
- `"largeVolumeConf"`: Large volume config.
- `"launchDisposition"`: Launch disposition.
- `"licensing"`:
- `"mapAutoTaggingMpeID"`: Launch configuration template map auto tagging MPE ID.
- `"postLaunchActions"`: Launch configuration template post launch actions.
- `"smallVolumeConf"`: Small volume config.
- `"smallVolumeMaxSize"`: Small volume maximum size.
- `"tags"`: Request to associate tags during creation of a Launch Configuration Template.
- `"targetInstanceTypeRightSizingMethod"`: Target instance type right-sizing method.
"""
function create_launch_configuration_template(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "POST",
        "/CreateLaunchConfigurationTemplate";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_launch_configuration_template(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "POST",
        "/CreateLaunchConfigurationTemplate",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_replication_configuration_template(associate_default_security_group, bandwidth_throttling, create_public_ip, data_plane_routing, default_large_staging_disk_type, ebs_encryption, replication_server_instance_type, replication_servers_security_groups_ids, staging_area_subnet_id, staging_area_tags, use_dedicated_replication_server)
    create_replication_configuration_template(associate_default_security_group, bandwidth_throttling, create_public_ip, data_plane_routing, default_large_staging_disk_type, ebs_encryption, replication_server_instance_type, replication_servers_security_groups_ids, staging_area_subnet_id, staging_area_tags, use_dedicated_replication_server, params::Dict{String,<:Any})

Creates a new ReplicationConfigurationTemplate.

# Arguments
- `associate_default_security_group`: Request to associate the default Application
  Migration Service Security group with the Replication Settings template.
- `bandwidth_throttling`: Request to configure bandwidth throttling during Replication
  Settings template creation.
- `create_public_ip`: Request to create Public IP during Replication Settings template
  creation.
- `data_plane_routing`: Request to configure data plane routing during Replication Settings
  template creation.
- `default_large_staging_disk_type`: Request to configure the default large staging disk
  EBS volume type during Replication Settings template creation.
- `ebs_encryption`: Request to configure EBS encryption during Replication Settings
  template creation.
- `replication_server_instance_type`: Request to configure the Replication Server instance
  type during Replication Settings template creation.
- `replication_servers_security_groups_ids`: Request to configure the Replication Server
  Security group ID during Replication Settings template creation.
- `staging_area_subnet_id`: Request to configure the Staging Area subnet ID during
  Replication Settings template creation.
- `staging_area_tags`: Request to configure Staging Area tags during Replication Settings
  template creation.
- `use_dedicated_replication_server`: Request to use Dedicated Replication Servers during
  Replication Settings template creation.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ebsEncryptionKeyArn"`: Request to configure an EBS encryption key during Replication
  Settings template creation.
- `"tags"`: Request to configure tags during Replication Settings template creation.
- `"useFipsEndpoint"`: Request to use Fips Endpoint during Replication Settings template
  creation.
"""
function create_replication_configuration_template(
    associateDefaultSecurityGroup,
    bandwidthThrottling,
    createPublicIP,
    dataPlaneRouting,
    defaultLargeStagingDiskType,
    ebsEncryption,
    replicationServerInstanceType,
    replicationServersSecurityGroupsIDs,
    stagingAreaSubnetId,
    stagingAreaTags,
    useDedicatedReplicationServer;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mgn(
        "POST",
        "/CreateReplicationConfigurationTemplate",
        Dict{String,Any}(
            "associateDefaultSecurityGroup" => associateDefaultSecurityGroup,
            "bandwidthThrottling" => bandwidthThrottling,
            "createPublicIP" => createPublicIP,
            "dataPlaneRouting" => dataPlaneRouting,
            "defaultLargeStagingDiskType" => defaultLargeStagingDiskType,
            "ebsEncryption" => ebsEncryption,
            "replicationServerInstanceType" => replicationServerInstanceType,
            "replicationServersSecurityGroupsIDs" => replicationServersSecurityGroupsIDs,
            "stagingAreaSubnetId" => stagingAreaSubnetId,
            "stagingAreaTags" => stagingAreaTags,
            "useDedicatedReplicationServer" => useDedicatedReplicationServer,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_replication_configuration_template(
    associateDefaultSecurityGroup,
    bandwidthThrottling,
    createPublicIP,
    dataPlaneRouting,
    defaultLargeStagingDiskType,
    ebsEncryption,
    replicationServerInstanceType,
    replicationServersSecurityGroupsIDs,
    stagingAreaSubnetId,
    stagingAreaTags,
    useDedicatedReplicationServer,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mgn(
        "POST",
        "/CreateReplicationConfigurationTemplate",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "associateDefaultSecurityGroup" => associateDefaultSecurityGroup,
                    "bandwidthThrottling" => bandwidthThrottling,
                    "createPublicIP" => createPublicIP,
                    "dataPlaneRouting" => dataPlaneRouting,
                    "defaultLargeStagingDiskType" => defaultLargeStagingDiskType,
                    "ebsEncryption" => ebsEncryption,
                    "replicationServerInstanceType" => replicationServerInstanceType,
                    "replicationServersSecurityGroupsIDs" =>
                        replicationServersSecurityGroupsIDs,
                    "stagingAreaSubnetId" => stagingAreaSubnetId,
                    "stagingAreaTags" => stagingAreaTags,
                    "useDedicatedReplicationServer" => useDedicatedReplicationServer,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_wave(name)
    create_wave(name, params::Dict{String,<:Any})

Create wave.

# Arguments
- `name`: Wave name.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountID"`: Account ID.
- `"description"`: Wave description.
- `"tags"`: Wave tags.
"""
function create_wave(name; aws_config::AbstractAWSConfig=current_aws_config())
    return mgn(
        "POST",
        "/CreateWave",
        Dict{String,Any}("name" => name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_wave(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "POST",
        "/CreateWave",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("name" => name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_application(application_id)
    delete_application(application_id, params::Dict{String,<:Any})

Delete application.

# Arguments
- `application_id`: Application ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountID"`: Account ID.
"""
function delete_application(
    applicationID; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "POST",
        "/DeleteApplication",
        Dict{String,Any}("applicationID" => applicationID);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_application(
    applicationID,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mgn(
        "POST",
        "/DeleteApplication",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("applicationID" => applicationID), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_connector(connector_id)
    delete_connector(connector_id, params::Dict{String,<:Any})

Delete Connector.

# Arguments
- `connector_id`: Delete Connector request connector ID.

"""
function delete_connector(connectorID; aws_config::AbstractAWSConfig=current_aws_config())
    return mgn(
        "POST",
        "/DeleteConnector",
        Dict{String,Any}("connectorID" => connectorID);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_connector(
    connectorID,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mgn(
        "POST",
        "/DeleteConnector",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("connectorID" => connectorID), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_job(job_id)
    delete_job(job_id, params::Dict{String,<:Any})

Deletes a single Job by ID.

# Arguments
- `job_id`: Request to delete Job from service by Job ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountID"`: Request to delete Job from service by Account ID.
"""
function delete_job(jobID; aws_config::AbstractAWSConfig=current_aws_config())
    return mgn(
        "POST",
        "/DeleteJob",
        Dict{String,Any}("jobID" => jobID);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_job(
    jobID, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "POST",
        "/DeleteJob",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("jobID" => jobID), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_launch_configuration_template(launch_configuration_template_id)
    delete_launch_configuration_template(launch_configuration_template_id, params::Dict{String,<:Any})

Deletes a single Launch Configuration Template by ID.

# Arguments
- `launch_configuration_template_id`: ID of resource to be deleted.

"""
function delete_launch_configuration_template(
    launchConfigurationTemplateID; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "POST",
        "/DeleteLaunchConfigurationTemplate",
        Dict{String,Any}("launchConfigurationTemplateID" => launchConfigurationTemplateID);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_launch_configuration_template(
    launchConfigurationTemplateID,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mgn(
        "POST",
        "/DeleteLaunchConfigurationTemplate",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "launchConfigurationTemplateID" => launchConfigurationTemplateID
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_replication_configuration_template(replication_configuration_template_id)
    delete_replication_configuration_template(replication_configuration_template_id, params::Dict{String,<:Any})

Deletes a single Replication Configuration Template by ID

# Arguments
- `replication_configuration_template_id`: Request to delete Replication Configuration
  Template from service by Replication Configuration Template ID.

"""
function delete_replication_configuration_template(
    replicationConfigurationTemplateID; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "POST",
        "/DeleteReplicationConfigurationTemplate",
        Dict{String,Any}(
            "replicationConfigurationTemplateID" => replicationConfigurationTemplateID
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_replication_configuration_template(
    replicationConfigurationTemplateID,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mgn(
        "POST",
        "/DeleteReplicationConfigurationTemplate",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "replicationConfigurationTemplateID" =>
                        replicationConfigurationTemplateID,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_source_server(source_server_id)
    delete_source_server(source_server_id, params::Dict{String,<:Any})

Deletes a single source server by ID.

# Arguments
- `source_server_id`: Request to delete Source Server from service by Server ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountID"`: Request to delete Source Server from service by Account ID.
"""
function delete_source_server(
    sourceServerID; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "POST",
        "/DeleteSourceServer",
        Dict{String,Any}("sourceServerID" => sourceServerID);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_source_server(
    sourceServerID,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mgn(
        "POST",
        "/DeleteSourceServer",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("sourceServerID" => sourceServerID), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_vcenter_client(vcenter_client_id)
    delete_vcenter_client(vcenter_client_id, params::Dict{String,<:Any})

Deletes a given vCenter client by ID.

# Arguments
- `vcenter_client_id`: ID of resource to be deleted.

"""
function delete_vcenter_client(
    vcenterClientID; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "POST",
        "/DeleteVcenterClient",
        Dict{String,Any}("vcenterClientID" => vcenterClientID);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_vcenter_client(
    vcenterClientID,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mgn(
        "POST",
        "/DeleteVcenterClient",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("vcenterClientID" => vcenterClientID), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_wave(wave_id)
    delete_wave(wave_id, params::Dict{String,<:Any})

Delete wave.

# Arguments
- `wave_id`: Wave ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountID"`: Account ID.
"""
function delete_wave(waveID; aws_config::AbstractAWSConfig=current_aws_config())
    return mgn(
        "POST",
        "/DeleteWave",
        Dict{String,Any}("waveID" => waveID);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_wave(
    waveID, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "POST",
        "/DeleteWave",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("waveID" => waveID), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_job_log_items(job_id)
    describe_job_log_items(job_id, params::Dict{String,<:Any})

Retrieves detailed job log items with paging.

# Arguments
- `job_id`: Request to describe Job log job ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountID"`: Request to describe Job log Account ID.
- `"maxResults"`: Request to describe Job log item maximum results.
- `"nextToken"`: Request to describe Job log next token.
"""
function describe_job_log_items(jobID; aws_config::AbstractAWSConfig=current_aws_config())
    return mgn(
        "POST",
        "/DescribeJobLogItems",
        Dict{String,Any}("jobID" => jobID);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_job_log_items(
    jobID, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "POST",
        "/DescribeJobLogItems",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("jobID" => jobID), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_jobs()
    describe_jobs(params::Dict{String,<:Any})

Returns a list of Jobs. Use the JobsID and fromDate and toData filters to limit which jobs
are returned. The response is sorted by creationDataTime - latest date first. Jobs are
normally created by the StartTest, StartCutover, and TerminateTargetInstances APIs. Jobs
are also created by DiagnosticLaunch and TerminateDiagnosticInstances, which are APIs
available only to *Support* and only used in response to relevant support tickets.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountID"`: Request to describe job log items by Account ID.
- `"filters"`: Request to describe Job log filters.
- `"maxResults"`: Request to describe job log items by max results.
- `"nextToken"`: Request to describe job log items by next token.
"""
function describe_jobs(; aws_config::AbstractAWSConfig=current_aws_config())
    return mgn(
        "POST", "/DescribeJobs"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_jobs(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "POST",
        "/DescribeJobs",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_launch_configuration_templates()
    describe_launch_configuration_templates(params::Dict{String,<:Any})

Lists all Launch Configuration Templates, filtered by Launch Configuration Template IDs

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"launchConfigurationTemplateIDs"`: Request to filter Launch Configuration Templates list
  by Launch Configuration Template ID.
- `"maxResults"`: Maximum results to be returned in DescribeLaunchConfigurationTemplates.
- `"nextToken"`: Next pagination token returned from DescribeLaunchConfigurationTemplates.
"""
function describe_launch_configuration_templates(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "POST",
        "/DescribeLaunchConfigurationTemplates";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_launch_configuration_templates(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "POST",
        "/DescribeLaunchConfigurationTemplates",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_replication_configuration_templates()
    describe_replication_configuration_templates(params::Dict{String,<:Any})

Lists all ReplicationConfigurationTemplates, filtered by Source Server IDs.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: Request to describe Replication Configuration template by max results.
- `"nextToken"`: Request to describe Replication Configuration template by next token.
- `"replicationConfigurationTemplateIDs"`: Request to describe Replication Configuration
  template by template IDs.
"""
function describe_replication_configuration_templates(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "POST",
        "/DescribeReplicationConfigurationTemplates";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_replication_configuration_templates(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "POST",
        "/DescribeReplicationConfigurationTemplates",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_source_servers()
    describe_source_servers(params::Dict{String,<:Any})

Retrieves all SourceServers or multiple SourceServers by ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountID"`: Request to filter Source Servers list by Accoun ID.
- `"filters"`: Request to filter Source Servers list.
- `"maxResults"`: Request to filter Source Servers list by maximum results.
- `"nextToken"`: Request to filter Source Servers list by next token.
"""
function describe_source_servers(; aws_config::AbstractAWSConfig=current_aws_config())
    return mgn(
        "POST",
        "/DescribeSourceServers";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_source_servers(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "POST",
        "/DescribeSourceServers",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_vcenter_clients()
    describe_vcenter_clients(params::Dict{String,<:Any})

Returns a list of the installed vCenter clients.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: Maximum results to be returned in DescribeVcenterClients.
- `"nextToken"`: Next pagination token to be provided for DescribeVcenterClients.
"""
function describe_vcenter_clients(; aws_config::AbstractAWSConfig=current_aws_config())
    return mgn(
        "GET",
        "/DescribeVcenterClients";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_vcenter_clients(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "GET",
        "/DescribeVcenterClients",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_applications(application_ids, wave_id)
    disassociate_applications(application_ids, wave_id, params::Dict{String,<:Any})

Disassociate applications from wave.

# Arguments
- `application_ids`: Application IDs list.
- `wave_id`: Wave ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountID"`: Account ID.
"""
function disassociate_applications(
    applicationIDs, waveID; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "POST",
        "/DisassociateApplications",
        Dict{String,Any}("applicationIDs" => applicationIDs, "waveID" => waveID);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_applications(
    applicationIDs,
    waveID,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mgn(
        "POST",
        "/DisassociateApplications",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("applicationIDs" => applicationIDs, "waveID" => waveID),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_source_servers(application_id, source_server_ids)
    disassociate_source_servers(application_id, source_server_ids, params::Dict{String,<:Any})

Disassociate source servers from application.

# Arguments
- `application_id`: Application ID.
- `source_server_ids`: Source server IDs list.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountID"`: Account ID.
"""
function disassociate_source_servers(
    applicationID, sourceServerIDs; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "POST",
        "/DisassociateSourceServers",
        Dict{String,Any}(
            "applicationID" => applicationID, "sourceServerIDs" => sourceServerIDs
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_source_servers(
    applicationID,
    sourceServerIDs,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mgn(
        "POST",
        "/DisassociateSourceServers",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "applicationID" => applicationID, "sourceServerIDs" => sourceServerIDs
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disconnect_from_service(source_server_id)
    disconnect_from_service(source_server_id, params::Dict{String,<:Any})

Disconnects specific Source Servers from Application Migration Service. Data replication is
stopped immediately. All AWS resources created by Application Migration Service for
enabling the replication of these source servers will be terminated / deleted within 90
minutes. Launched Test or Cutover instances will NOT be terminated. If the agent on the
source server has not been prevented from communicating with the Application Migration
Service service, then it will receive a command to uninstall itself (within approximately
10 minutes). The following properties of the SourceServer will be changed immediately:
dataReplicationInfo.dataReplicationState will be set to DISCONNECTED; The totalStorageBytes
property for each of dataReplicationInfo.replicatedDisks will be set to zero;
dataReplicationInfo.lagDuration and dataReplicationInfo.lagDuration will be nullified.

# Arguments
- `source_server_id`: Request to disconnect Source Server from service by Server ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountID"`: Request to disconnect Source Server from service by Account ID.
"""
function disconnect_from_service(
    sourceServerID; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "POST",
        "/DisconnectFromService",
        Dict{String,Any}("sourceServerID" => sourceServerID);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disconnect_from_service(
    sourceServerID,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mgn(
        "POST",
        "/DisconnectFromService",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("sourceServerID" => sourceServerID), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    finalize_cutover(source_server_id)
    finalize_cutover(source_server_id, params::Dict{String,<:Any})

Finalizes the cutover immediately for specific Source Servers. All AWS resources created by
Application Migration Service for enabling the replication of these source servers will be
terminated / deleted within 90 minutes. Launched Test or Cutover instances will NOT be
terminated. The AWS Replication Agent will receive a command to uninstall itself (within 10
minutes). The following properties of the SourceServer will be changed immediately:
dataReplicationInfo.dataReplicationState will be changed to DISCONNECTED; The
SourceServer.lifeCycle.state will be changed to CUTOVER; The totalStorageBytes property fo
each of dataReplicationInfo.replicatedDisks will be set to zero;
dataReplicationInfo.lagDuration and dataReplicationInfo.lagDuration will be nullified.

# Arguments
- `source_server_id`: Request to finalize Cutover by Source Server ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountID"`: Request to finalize Cutover by Source Account ID.
"""
function finalize_cutover(
    sourceServerID; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "POST",
        "/FinalizeCutover",
        Dict{String,Any}("sourceServerID" => sourceServerID);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function finalize_cutover(
    sourceServerID,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mgn(
        "POST",
        "/FinalizeCutover",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("sourceServerID" => sourceServerID), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_launch_configuration(source_server_id)
    get_launch_configuration(source_server_id, params::Dict{String,<:Any})

Lists all LaunchConfigurations available, filtered by Source Server IDs.

# Arguments
- `source_server_id`: Request to get Launch Configuration information by Source Server ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountID"`: Request to get Launch Configuration information by Account ID.
"""
function get_launch_configuration(
    sourceServerID; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "POST",
        "/GetLaunchConfiguration",
        Dict{String,Any}("sourceServerID" => sourceServerID);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_launch_configuration(
    sourceServerID,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mgn(
        "POST",
        "/GetLaunchConfiguration",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("sourceServerID" => sourceServerID), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_replication_configuration(source_server_id)
    get_replication_configuration(source_server_id, params::Dict{String,<:Any})

Lists all ReplicationConfigurations, filtered by Source Server ID.

# Arguments
- `source_server_id`: Request to get Replication Configuration by Source Server ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountID"`: Request to get Replication Configuration by Account ID.
"""
function get_replication_configuration(
    sourceServerID; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "POST",
        "/GetReplicationConfiguration",
        Dict{String,Any}("sourceServerID" => sourceServerID);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_replication_configuration(
    sourceServerID,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mgn(
        "POST",
        "/GetReplicationConfiguration",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("sourceServerID" => sourceServerID), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    initialize_service()
    initialize_service(params::Dict{String,<:Any})

Initialize Application Migration Service.

"""
function initialize_service(; aws_config::AbstractAWSConfig=current_aws_config())
    return mgn(
        "POST", "/InitializeService"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function initialize_service(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "POST",
        "/InitializeService",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_applications()
    list_applications(params::Dict{String,<:Any})

Retrieves all applications or multiple applications by ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountID"`: Applications list Account ID.
- `"filters"`: Applications list filters.
- `"maxResults"`: Maximum results to return when listing applications.
- `"nextToken"`: Request next token.
"""
function list_applications(; aws_config::AbstractAWSConfig=current_aws_config())
    return mgn(
        "POST", "/ListApplications"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_applications(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "POST",
        "/ListApplications",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_connectors()
    list_connectors(params::Dict{String,<:Any})

List Connectors.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"filters"`: List Connectors Request filters.
- `"maxResults"`: List Connectors Request max results.
- `"nextToken"`: List Connectors Request next token.
"""
function list_connectors(; aws_config::AbstractAWSConfig=current_aws_config())
    return mgn(
        "POST", "/ListConnectors"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_connectors(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "POST",
        "/ListConnectors",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_export_errors(export_id)
    list_export_errors(export_id, params::Dict{String,<:Any})

List export errors.

# Arguments
- `export_id`: List export errors request export id.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: List export errors request max results.
- `"nextToken"`: List export errors request next token.
"""
function list_export_errors(exportID; aws_config::AbstractAWSConfig=current_aws_config())
    return mgn(
        "POST",
        "/ListExportErrors",
        Dict{String,Any}("exportID" => exportID);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_export_errors(
    exportID,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mgn(
        "POST",
        "/ListExportErrors",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("exportID" => exportID), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_exports()
    list_exports(params::Dict{String,<:Any})

List exports.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"filters"`:
- `"maxResults"`: List export request max results.
- `"nextToken"`: List export request next token.
"""
function list_exports(; aws_config::AbstractAWSConfig=current_aws_config())
    return mgn(
        "POST", "/ListExports"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_exports(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "POST",
        "/ListExports",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_import_errors(import_id)
    list_import_errors(import_id, params::Dict{String,<:Any})

List import errors.

# Arguments
- `import_id`: List import errors request import id.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: List import errors request max results.
- `"nextToken"`: List import errors request next token.
"""
function list_import_errors(importID; aws_config::AbstractAWSConfig=current_aws_config())
    return mgn(
        "POST",
        "/ListImportErrors",
        Dict{String,Any}("importID" => importID);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_import_errors(
    importID,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mgn(
        "POST",
        "/ListImportErrors",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("importID" => importID), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_imports()
    list_imports(params::Dict{String,<:Any})

List imports.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"filters"`: List imports request filters.
- `"maxResults"`: List imports request max results.
- `"nextToken"`: List imports request next token.
"""
function list_imports(; aws_config::AbstractAWSConfig=current_aws_config())
    return mgn(
        "POST", "/ListImports"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_imports(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "POST",
        "/ListImports",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_managed_accounts()
    list_managed_accounts(params::Dict{String,<:Any})

List Managed Accounts.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: List managed accounts request max results.
- `"nextToken"`: List managed accounts request next token.
"""
function list_managed_accounts(; aws_config::AbstractAWSConfig=current_aws_config())
    return mgn(
        "POST",
        "/ListManagedAccounts";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_managed_accounts(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "POST",
        "/ListManagedAccounts",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_source_server_actions(source_server_id)
    list_source_server_actions(source_server_id, params::Dict{String,<:Any})

List source server post migration custom actions.

# Arguments
- `source_server_id`: Source server ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountID"`: Account ID to return when listing source server post migration custom
  actions.
- `"filters"`: Filters to apply when listing source server post migration custom actions.
- `"maxResults"`: Maximum amount of items to return when listing source server post
  migration custom actions.
- `"nextToken"`: Next token to use when listing source server post migration custom actions.
"""
function list_source_server_actions(
    sourceServerID; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "POST",
        "/ListSourceServerActions",
        Dict{String,Any}("sourceServerID" => sourceServerID);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_source_server_actions(
    sourceServerID,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mgn(
        "POST",
        "/ListSourceServerActions",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("sourceServerID" => sourceServerID), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

List all tags for your Application Migration Service resources.

# Arguments
- `resource_arn`: List tags for resource request by ARN.

"""
function list_tags_for_resource(
    resourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "GET",
        "/tags/$(resourceArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mgn(
        "GET",
        "/tags/$(resourceArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_template_actions(launch_configuration_template_id)
    list_template_actions(launch_configuration_template_id, params::Dict{String,<:Any})

List template post migration custom actions.

# Arguments
- `launch_configuration_template_id`: Launch configuration template ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"filters"`: Filters to apply when listing template post migration custom actions.
- `"maxResults"`: Maximum amount of items to return when listing template post migration
  custom actions.
- `"nextToken"`: Next token to use when listing template post migration custom actions.
"""
function list_template_actions(
    launchConfigurationTemplateID; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "POST",
        "/ListTemplateActions",
        Dict{String,Any}("launchConfigurationTemplateID" => launchConfigurationTemplateID);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_template_actions(
    launchConfigurationTemplateID,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mgn(
        "POST",
        "/ListTemplateActions",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "launchConfigurationTemplateID" => launchConfigurationTemplateID
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_waves()
    list_waves(params::Dict{String,<:Any})

Retrieves all waves or multiple waves by ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountID"`: Request account ID.
- `"filters"`: Waves list filters.
- `"maxResults"`: Maximum results to return when listing waves.
- `"nextToken"`: Request next token.
"""
function list_waves(; aws_config::AbstractAWSConfig=current_aws_config())
    return mgn("POST", "/ListWaves"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_waves(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "POST", "/ListWaves", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    mark_as_archived(source_server_id)
    mark_as_archived(source_server_id, params::Dict{String,<:Any})

Archives specific Source Servers by setting the SourceServer.isArchived property to true
for specified SourceServers by ID. This command only works for SourceServers with a
lifecycle. state which equals DISCONNECTED or CUTOVER.

# Arguments
- `source_server_id`: Mark as archived by Source Server ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountID"`: Mark as archived by Account ID.
"""
function mark_as_archived(
    sourceServerID; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "POST",
        "/MarkAsArchived",
        Dict{String,Any}("sourceServerID" => sourceServerID);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function mark_as_archived(
    sourceServerID,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mgn(
        "POST",
        "/MarkAsArchived",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("sourceServerID" => sourceServerID), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    pause_replication(source_server_id)
    pause_replication(source_server_id, params::Dict{String,<:Any})

Pause Replication.

# Arguments
- `source_server_id`: Pause Replication Request source server ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountID"`: Pause Replication Request account ID.
"""
function pause_replication(
    sourceServerID; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "POST",
        "/PauseReplication",
        Dict{String,Any}("sourceServerID" => sourceServerID);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function pause_replication(
    sourceServerID,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mgn(
        "POST",
        "/PauseReplication",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("sourceServerID" => sourceServerID), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_source_server_action(action_id, action_name, document_identifier, order, source_server_id)
    put_source_server_action(action_id, action_name, document_identifier, order, source_server_id, params::Dict{String,<:Any})

Put source server post migration custom action.

# Arguments
- `action_id`: Source server post migration custom action ID.
- `action_name`: Source server post migration custom action name.
- `document_identifier`: Source server post migration custom action document identifier.
- `order`: Source server post migration custom action order.
- `source_server_id`: Source server ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountID"`: Source server post migration custom account ID.
- `"active"`: Source server post migration custom action active status.
- `"category"`: Source server post migration custom action category.
- `"description"`: Source server post migration custom action description.
- `"documentVersion"`: Source server post migration custom action document version.
- `"externalParameters"`: Source server post migration custom action external parameters.
- `"mustSucceedForCutover"`: Source server post migration custom action must succeed for
  cutover.
- `"parameters"`: Source server post migration custom action parameters.
- `"timeoutSeconds"`: Source server post migration custom action timeout in seconds.
"""
function put_source_server_action(
    actionID,
    actionName,
    documentIdentifier,
    order,
    sourceServerID;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mgn(
        "POST",
        "/PutSourceServerAction",
        Dict{String,Any}(
            "actionID" => actionID,
            "actionName" => actionName,
            "documentIdentifier" => documentIdentifier,
            "order" => order,
            "sourceServerID" => sourceServerID,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_source_server_action(
    actionID,
    actionName,
    documentIdentifier,
    order,
    sourceServerID,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mgn(
        "POST",
        "/PutSourceServerAction",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "actionID" => actionID,
                    "actionName" => actionName,
                    "documentIdentifier" => documentIdentifier,
                    "order" => order,
                    "sourceServerID" => sourceServerID,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_template_action(action_id, action_name, document_identifier, launch_configuration_template_id, order)
    put_template_action(action_id, action_name, document_identifier, launch_configuration_template_id, order, params::Dict{String,<:Any})

Put template post migration custom action.

# Arguments
- `action_id`: Template post migration custom action ID.
- `action_name`: Template post migration custom action name.
- `document_identifier`: Template post migration custom action document identifier.
- `launch_configuration_template_id`: Launch configuration template ID.
- `order`: Template post migration custom action order.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"active"`: Template post migration custom action active status.
- `"category"`: Template post migration custom action category.
- `"description"`: Template post migration custom action description.
- `"documentVersion"`: Template post migration custom action document version.
- `"externalParameters"`: Template post migration custom action external parameters.
- `"mustSucceedForCutover"`: Template post migration custom action must succeed for cutover.
- `"operatingSystem"`: Operating system eligible for this template post migration custom
  action.
- `"parameters"`: Template post migration custom action parameters.
- `"timeoutSeconds"`: Template post migration custom action timeout in seconds.
"""
function put_template_action(
    actionID,
    actionName,
    documentIdentifier,
    launchConfigurationTemplateID,
    order;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mgn(
        "POST",
        "/PutTemplateAction",
        Dict{String,Any}(
            "actionID" => actionID,
            "actionName" => actionName,
            "documentIdentifier" => documentIdentifier,
            "launchConfigurationTemplateID" => launchConfigurationTemplateID,
            "order" => order,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_template_action(
    actionID,
    actionName,
    documentIdentifier,
    launchConfigurationTemplateID,
    order,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mgn(
        "POST",
        "/PutTemplateAction",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "actionID" => actionID,
                    "actionName" => actionName,
                    "documentIdentifier" => documentIdentifier,
                    "launchConfigurationTemplateID" => launchConfigurationTemplateID,
                    "order" => order,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    remove_source_server_action(action_id, source_server_id)
    remove_source_server_action(action_id, source_server_id, params::Dict{String,<:Any})

Remove source server post migration custom action.

# Arguments
- `action_id`: Source server post migration custom action ID to remove.
- `source_server_id`: Source server ID of the post migration custom action to remove.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountID"`: Source server post migration account ID.
"""
function remove_source_server_action(
    actionID, sourceServerID; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "POST",
        "/RemoveSourceServerAction",
        Dict{String,Any}("actionID" => actionID, "sourceServerID" => sourceServerID);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function remove_source_server_action(
    actionID,
    sourceServerID,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mgn(
        "POST",
        "/RemoveSourceServerAction",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "actionID" => actionID, "sourceServerID" => sourceServerID
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    remove_template_action(action_id, launch_configuration_template_id)
    remove_template_action(action_id, launch_configuration_template_id, params::Dict{String,<:Any})

Remove template post migration custom action.

# Arguments
- `action_id`: Template post migration custom action ID to remove.
- `launch_configuration_template_id`: Launch configuration template ID of the post
  migration custom action to remove.

"""
function remove_template_action(
    actionID,
    launchConfigurationTemplateID;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mgn(
        "POST",
        "/RemoveTemplateAction",
        Dict{String,Any}(
            "actionID" => actionID,
            "launchConfigurationTemplateID" => launchConfigurationTemplateID,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function remove_template_action(
    actionID,
    launchConfigurationTemplateID,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mgn(
        "POST",
        "/RemoveTemplateAction",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "actionID" => actionID,
                    "launchConfigurationTemplateID" => launchConfigurationTemplateID,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    resume_replication(source_server_id)
    resume_replication(source_server_id, params::Dict{String,<:Any})

Resume Replication.

# Arguments
- `source_server_id`: Resume Replication Request source server ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountID"`: Resume Replication Request account ID.
"""
function resume_replication(
    sourceServerID; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "POST",
        "/ResumeReplication",
        Dict{String,Any}("sourceServerID" => sourceServerID);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function resume_replication(
    sourceServerID,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mgn(
        "POST",
        "/ResumeReplication",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("sourceServerID" => sourceServerID), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    retry_data_replication(source_server_id)
    retry_data_replication(source_server_id, params::Dict{String,<:Any})

Causes the data replication initiation sequence to begin immediately upon next Handshake
for specified SourceServer IDs, regardless of when the previous initiation started. This
command will not work if the SourceServer is not stalled or is in a DISCONNECTED or STOPPED
state.

# Arguments
- `source_server_id`: Retry data replication for Source Server ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountID"`: Retry data replication for Account ID.
"""
function retry_data_replication(
    sourceServerID; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "POST",
        "/RetryDataReplication",
        Dict{String,Any}("sourceServerID" => sourceServerID);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function retry_data_replication(
    sourceServerID,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mgn(
        "POST",
        "/RetryDataReplication",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("sourceServerID" => sourceServerID), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_cutover(source_server_ids)
    start_cutover(source_server_ids, params::Dict{String,<:Any})

Launches a Cutover Instance for specific Source Servers. This command starts a LAUNCH job
whose initiatedBy property is StartCutover and changes the SourceServer.lifeCycle.state
property to CUTTING_OVER.

# Arguments
- `source_server_ids`: Start Cutover by Source Server IDs.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountID"`: Start Cutover by Account IDs
- `"tags"`: Start Cutover by Tags.
"""
function start_cutover(sourceServerIDs; aws_config::AbstractAWSConfig=current_aws_config())
    return mgn(
        "POST",
        "/StartCutover",
        Dict{String,Any}("sourceServerIDs" => sourceServerIDs);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_cutover(
    sourceServerIDs,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mgn(
        "POST",
        "/StartCutover",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("sourceServerIDs" => sourceServerIDs), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_export(s3_bucket, s3_key)
    start_export(s3_bucket, s3_key, params::Dict{String,<:Any})

Start export.

# Arguments
- `s3_bucket`: Start export request s3 bucket.
- `s3_key`: Start export request s3key.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"s3BucketOwner"`: Start export request s3 bucket owner.
"""
function start_export(s3Bucket, s3Key; aws_config::AbstractAWSConfig=current_aws_config())
    return mgn(
        "POST",
        "/StartExport",
        Dict{String,Any}("s3Bucket" => s3Bucket, "s3Key" => s3Key);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_export(
    s3Bucket,
    s3Key,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mgn(
        "POST",
        "/StartExport",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("s3Bucket" => s3Bucket, "s3Key" => s3Key), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_import(s3_bucket_source)
    start_import(s3_bucket_source, params::Dict{String,<:Any})

Start import.

# Arguments
- `s3_bucket_source`: Start import request s3 bucket source.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: Start import request client token.
"""
function start_import(s3BucketSource; aws_config::AbstractAWSConfig=current_aws_config())
    return mgn(
        "POST",
        "/StartImport",
        Dict{String,Any}(
            "s3BucketSource" => s3BucketSource, "clientToken" => string(uuid4())
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_import(
    s3BucketSource,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mgn(
        "POST",
        "/StartImport",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "s3BucketSource" => s3BucketSource, "clientToken" => string(uuid4())
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_replication(source_server_id)
    start_replication(source_server_id, params::Dict{String,<:Any})

Starts replication for SNAPSHOT_SHIPPING agents.

# Arguments
- `source_server_id`: ID of source server on which to start replication.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountID"`: Account ID on which to start replication.
"""
function start_replication(
    sourceServerID; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "POST",
        "/StartReplication",
        Dict{String,Any}("sourceServerID" => sourceServerID);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_replication(
    sourceServerID,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mgn(
        "POST",
        "/StartReplication",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("sourceServerID" => sourceServerID), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_test(source_server_ids)
    start_test(source_server_ids, params::Dict{String,<:Any})

Launches a Test Instance for specific Source Servers. This command starts a LAUNCH job
whose initiatedBy property is StartTest and changes the SourceServer.lifeCycle.state
property to TESTING.

# Arguments
- `source_server_ids`: Start Test for Source Server IDs.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountID"`: Start Test for Account ID.
- `"tags"`: Start Test by Tags.
"""
function start_test(sourceServerIDs; aws_config::AbstractAWSConfig=current_aws_config())
    return mgn(
        "POST",
        "/StartTest",
        Dict{String,Any}("sourceServerIDs" => sourceServerIDs);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_test(
    sourceServerIDs,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mgn(
        "POST",
        "/StartTest",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("sourceServerIDs" => sourceServerIDs), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    stop_replication(source_server_id)
    stop_replication(source_server_id, params::Dict{String,<:Any})

Stop Replication.

# Arguments
- `source_server_id`: Stop Replication Request source server ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountID"`: Stop Replication Request account ID.
"""
function stop_replication(
    sourceServerID; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "POST",
        "/StopReplication",
        Dict{String,Any}("sourceServerID" => sourceServerID);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function stop_replication(
    sourceServerID,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mgn(
        "POST",
        "/StopReplication",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("sourceServerID" => sourceServerID), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Adds or overwrites only the specified tags for the specified Application Migration Service
resource or resources. When you specify an existing tag key, the value is overwritten with
the new value. Each resource can have a maximum of 50 tags. Each tag consists of a key and
optional value.

# Arguments
- `resource_arn`: Tag resource by ARN.
- `tags`: Tag resource by Tags.

"""
function tag_resource(resourceArn, tags; aws_config::AbstractAWSConfig=current_aws_config())
    return mgn(
        "POST",
        "/tags/$(resourceArn)",
        Dict{String,Any}("tags" => tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    resourceArn,
    tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mgn(
        "POST",
        "/tags/$(resourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tags" => tags), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    terminate_target_instances(source_server_ids)
    terminate_target_instances(source_server_ids, params::Dict{String,<:Any})

Starts a job that terminates specific launched EC2 Test and Cutover instances. This command
will not work for any Source Server with a lifecycle.state of TESTING, CUTTING_OVER, or
CUTOVER.

# Arguments
- `source_server_ids`: Terminate Target instance by Source Server IDs.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountID"`: Terminate Target instance by Account ID
- `"tags"`: Terminate Target instance by Tags.
"""
function terminate_target_instances(
    sourceServerIDs; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "POST",
        "/TerminateTargetInstances",
        Dict{String,Any}("sourceServerIDs" => sourceServerIDs);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function terminate_target_instances(
    sourceServerIDs,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mgn(
        "POST",
        "/TerminateTargetInstances",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("sourceServerIDs" => sourceServerIDs), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    unarchive_application(application_id)
    unarchive_application(application_id, params::Dict{String,<:Any})

Unarchive application.

# Arguments
- `application_id`: Application ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountID"`: Account ID.
"""
function unarchive_application(
    applicationID; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "POST",
        "/UnarchiveApplication",
        Dict{String,Any}("applicationID" => applicationID);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function unarchive_application(
    applicationID,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mgn(
        "POST",
        "/UnarchiveApplication",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("applicationID" => applicationID), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    unarchive_wave(wave_id)
    unarchive_wave(wave_id, params::Dict{String,<:Any})

Unarchive wave.

# Arguments
- `wave_id`: Wave ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountID"`: Account ID.
"""
function unarchive_wave(waveID; aws_config::AbstractAWSConfig=current_aws_config())
    return mgn(
        "POST",
        "/UnarchiveWave",
        Dict{String,Any}("waveID" => waveID);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function unarchive_wave(
    waveID, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "POST",
        "/UnarchiveWave",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("waveID" => waveID), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Deletes the specified set of tags from the specified set of Application Migration Service
resources.

# Arguments
- `resource_arn`: Untag resource by ARN.
- `tag_keys`: Untag resource by Keys.

"""
function untag_resource(
    resourceArn, tagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "DELETE",
        "/tags/$(resourceArn)",
        Dict{String,Any}("tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    resourceArn,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mgn(
        "DELETE",
        "/tags/$(resourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tagKeys" => tagKeys), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_application(application_id)
    update_application(application_id, params::Dict{String,<:Any})

Update application.

# Arguments
- `application_id`: Application ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountID"`: Account ID.
- `"description"`: Application description.
- `"name"`: Application name.
"""
function update_application(
    applicationID; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "POST",
        "/UpdateApplication",
        Dict{String,Any}("applicationID" => applicationID);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_application(
    applicationID,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mgn(
        "POST",
        "/UpdateApplication",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("applicationID" => applicationID), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_connector(connector_id)
    update_connector(connector_id, params::Dict{String,<:Any})

Update Connector.

# Arguments
- `connector_id`: Update Connector request connector ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"name"`: Update Connector request name.
- `"ssmCommandConfig"`: Update Connector request SSM command config.
"""
function update_connector(connectorID; aws_config::AbstractAWSConfig=current_aws_config())
    return mgn(
        "POST",
        "/UpdateConnector",
        Dict{String,Any}("connectorID" => connectorID);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_connector(
    connectorID,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mgn(
        "POST",
        "/UpdateConnector",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("connectorID" => connectorID), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_launch_configuration(source_server_id)
    update_launch_configuration(source_server_id, params::Dict{String,<:Any})

Updates multiple LaunchConfigurations by Source Server ID.  bootMode valid values are
LEGACY_BIOS | UEFI

# Arguments
- `source_server_id`: Update Launch configuration by Source Server ID request.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountID"`: Update Launch configuration Account ID.
- `"bootMode"`: Update Launch configuration boot mode request.
- `"copyPrivateIp"`: Update Launch configuration copy Private IP request.
- `"copyTags"`: Update Launch configuration copy Tags request.
- `"enableMapAutoTagging"`: Enable map auto tagging.
- `"launchDisposition"`: Update Launch configuration launch disposition request.
- `"licensing"`: Update Launch configuration licensing request.
- `"mapAutoTaggingMpeID"`: Launch configuration map auto tagging MPE ID.
- `"name"`: Update Launch configuration name request.
- `"postLaunchActions"`:
- `"targetInstanceTypeRightSizingMethod"`: Update Launch configuration Target instance
  right sizing request.
"""
function update_launch_configuration(
    sourceServerID; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "POST",
        "/UpdateLaunchConfiguration",
        Dict{String,Any}("sourceServerID" => sourceServerID);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_launch_configuration(
    sourceServerID,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mgn(
        "POST",
        "/UpdateLaunchConfiguration",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("sourceServerID" => sourceServerID), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_launch_configuration_template(launch_configuration_template_id)
    update_launch_configuration_template(launch_configuration_template_id, params::Dict{String,<:Any})

Updates an existing Launch Configuration Template by ID.

# Arguments
- `launch_configuration_template_id`: Launch Configuration Template ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"associatePublicIpAddress"`: Associate public Ip address.
- `"bootMode"`: Launch configuration template boot mode.
- `"copyPrivateIp"`: Copy private Ip.
- `"copyTags"`: Copy tags.
- `"enableMapAutoTagging"`: Enable map auto tagging.
- `"largeVolumeConf"`: Large volume config.
- `"launchDisposition"`: Launch disposition.
- `"licensing"`:
- `"mapAutoTaggingMpeID"`: Launch configuration template map auto tagging MPE ID.
- `"postLaunchActions"`: Post Launch Action to execute on the Test or Cutover instance.
- `"smallVolumeConf"`: Small volume config.
- `"smallVolumeMaxSize"`: Small volume maximum size.
- `"targetInstanceTypeRightSizingMethod"`: Target instance type right-sizing method.
"""
function update_launch_configuration_template(
    launchConfigurationTemplateID; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "POST",
        "/UpdateLaunchConfigurationTemplate",
        Dict{String,Any}("launchConfigurationTemplateID" => launchConfigurationTemplateID);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_launch_configuration_template(
    launchConfigurationTemplateID,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mgn(
        "POST",
        "/UpdateLaunchConfigurationTemplate",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "launchConfigurationTemplateID" => launchConfigurationTemplateID
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_replication_configuration(source_server_id)
    update_replication_configuration(source_server_id, params::Dict{String,<:Any})

Allows you to update multiple ReplicationConfigurations by Source Server ID.

# Arguments
- `source_server_id`: Update replication configuration Source Server ID request.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountID"`: Update replication configuration Account ID request.
- `"associateDefaultSecurityGroup"`: Update replication configuration associate default
  Application Migration Service Security group request.
- `"bandwidthThrottling"`: Update replication configuration bandwidth throttling request.
- `"createPublicIP"`: Update replication configuration create Public IP request.
- `"dataPlaneRouting"`: Update replication configuration data plane routing request.
- `"defaultLargeStagingDiskType"`: Update replication configuration use default large
  Staging Disk type request.
- `"ebsEncryption"`: Update replication configuration EBS encryption request.
- `"ebsEncryptionKeyArn"`: Update replication configuration EBS encryption key ARN request.
- `"name"`: Update replication configuration name request.
- `"replicatedDisks"`: Update replication configuration replicated disks request.
- `"replicationServerInstanceType"`: Update replication configuration Replication Server
  instance type request.
- `"replicationServersSecurityGroupsIDs"`: Update replication configuration Replication
  Server Security Groups IDs request.
- `"stagingAreaSubnetId"`: Update replication configuration Staging Area subnet request.
- `"stagingAreaTags"`: Update replication configuration Staging Area Tags request.
- `"useDedicatedReplicationServer"`: Update replication configuration use dedicated
  Replication Server request.
- `"useFipsEndpoint"`: Update replication configuration use Fips Endpoint.
"""
function update_replication_configuration(
    sourceServerID; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "POST",
        "/UpdateReplicationConfiguration",
        Dict{String,Any}("sourceServerID" => sourceServerID);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_replication_configuration(
    sourceServerID,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mgn(
        "POST",
        "/UpdateReplicationConfiguration",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("sourceServerID" => sourceServerID), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_replication_configuration_template(replication_configuration_template_id)
    update_replication_configuration_template(replication_configuration_template_id, params::Dict{String,<:Any})

Updates multiple ReplicationConfigurationTemplates by ID.

# Arguments
- `replication_configuration_template_id`: Update replication configuration template
  template ID request.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"arn"`: Update replication configuration template ARN request.
- `"associateDefaultSecurityGroup"`: Update replication configuration template associate
  default Application Migration Service Security group request.
- `"bandwidthThrottling"`: Update replication configuration template bandwidth throttling
  request.
- `"createPublicIP"`: Update replication configuration template create Public IP request.
- `"dataPlaneRouting"`: Update replication configuration template data plane routing
  request.
- `"defaultLargeStagingDiskType"`: Update replication configuration template use default
  large Staging Disk type request.
- `"ebsEncryption"`: Update replication configuration template EBS encryption request.
- `"ebsEncryptionKeyArn"`: Update replication configuration template EBS encryption key ARN
  request.
- `"replicationServerInstanceType"`: Update replication configuration template Replication
  Server instance type request.
- `"replicationServersSecurityGroupsIDs"`: Update replication configuration template
  Replication Server Security groups IDs request.
- `"stagingAreaSubnetId"`: Update replication configuration template Staging Area subnet ID
  request.
- `"stagingAreaTags"`: Update replication configuration template Staging Area Tags request.
- `"useDedicatedReplicationServer"`: Update replication configuration template use
  dedicated Replication Server request.
- `"useFipsEndpoint"`: Update replication configuration template use Fips Endpoint request.
"""
function update_replication_configuration_template(
    replicationConfigurationTemplateID; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "POST",
        "/UpdateReplicationConfigurationTemplate",
        Dict{String,Any}(
            "replicationConfigurationTemplateID" => replicationConfigurationTemplateID
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_replication_configuration_template(
    replicationConfigurationTemplateID,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mgn(
        "POST",
        "/UpdateReplicationConfigurationTemplate",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "replicationConfigurationTemplateID" =>
                        replicationConfigurationTemplateID,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_source_server(source_server_id)
    update_source_server(source_server_id, params::Dict{String,<:Any})

Update Source Server.

# Arguments
- `source_server_id`: Update Source Server request source server ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountID"`: Update Source Server request account ID.
- `"connectorAction"`: Update Source Server request connector action.
"""
function update_source_server(
    sourceServerID; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "POST",
        "/UpdateSourceServer",
        Dict{String,Any}("sourceServerID" => sourceServerID);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_source_server(
    sourceServerID,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mgn(
        "POST",
        "/UpdateSourceServer",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("sourceServerID" => sourceServerID), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_source_server_replication_type(replication_type, source_server_id)
    update_source_server_replication_type(replication_type, source_server_id, params::Dict{String,<:Any})

Allows you to change between the AGENT_BASED replication type and the SNAPSHOT_SHIPPING
replication type.

# Arguments
- `replication_type`: Replication type to which to update source server.
- `source_server_id`: ID of source server on which to update replication type.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountID"`: Account ID on which to update replication type.
"""
function update_source_server_replication_type(
    replicationType, sourceServerID; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "POST",
        "/UpdateSourceServerReplicationType",
        Dict{String,Any}(
            "replicationType" => replicationType, "sourceServerID" => sourceServerID
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_source_server_replication_type(
    replicationType,
    sourceServerID,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mgn(
        "POST",
        "/UpdateSourceServerReplicationType",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "replicationType" => replicationType, "sourceServerID" => sourceServerID
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_wave(wave_id)
    update_wave(wave_id, params::Dict{String,<:Any})

Update wave.

# Arguments
- `wave_id`: Wave ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountID"`: Account ID.
- `"description"`: Wave description.
- `"name"`: Wave name.
"""
function update_wave(waveID; aws_config::AbstractAWSConfig=current_aws_config())
    return mgn(
        "POST",
        "/UpdateWave",
        Dict{String,Any}("waveID" => waveID);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_wave(
    waveID, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mgn(
        "POST",
        "/UpdateWave",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("waveID" => waveID), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
