# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: pca_connector_ad
using AWS.Compat
using AWS.UUIDs

"""
    create_connector(certificate_authority_arn, directory_id, vpc_information)
    create_connector(certificate_authority_arn, directory_id, vpc_information, params::Dict{String,<:Any})

Creates a connector between Amazon Web Services Private CA and an Active Directory. You
must specify the private CA, directory ID, and security groups.

# Arguments
- `certificate_authority_arn`:  The Amazon Resource Name (ARN) of the certificate authority
  being used.
- `directory_id`: The identifier of the Active Directory.
- `vpc_information`: Security group IDs that describe the inbound and outbound rules.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: Idempotency token.
- `"Tags"`: Metadata assigned to a connector consisting of a key-value pair.
"""
function create_connector(
    CertificateAuthorityArn,
    DirectoryId,
    VpcInformation;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pca_connector_ad(
        "POST",
        "/connectors",
        Dict{String,Any}(
            "CertificateAuthorityArn" => CertificateAuthorityArn,
            "DirectoryId" => DirectoryId,
            "VpcInformation" => VpcInformation,
            "ClientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_connector(
    CertificateAuthorityArn,
    DirectoryId,
    VpcInformation,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pca_connector_ad(
        "POST",
        "/connectors",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "CertificateAuthorityArn" => CertificateAuthorityArn,
                    "DirectoryId" => DirectoryId,
                    "VpcInformation" => VpcInformation,
                    "ClientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_directory_registration(directory_id)
    create_directory_registration(directory_id, params::Dict{String,<:Any})

Creates a directory registration that authorizes communication between Amazon Web Services
Private CA and an Active Directory

# Arguments
- `directory_id`:  The identifier of the Active Directory.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: Idempotency token.
- `"Tags"`: Metadata assigned to a directory registration consisting of a key-value pair.
"""
function create_directory_registration(
    DirectoryId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pca_connector_ad(
        "POST",
        "/directoryRegistrations",
        Dict{String,Any}("DirectoryId" => DirectoryId, "ClientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_directory_registration(
    DirectoryId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pca_connector_ad(
        "POST",
        "/directoryRegistrations",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DirectoryId" => DirectoryId, "ClientToken" => string(uuid4())
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_service_principal_name(connector_arn, directory_registration_arn)
    create_service_principal_name(connector_arn, directory_registration_arn, params::Dict{String,<:Any})

Creates a service principal name (SPN) for the service account in Active Directory.
Kerberos authentication uses SPNs to associate a service instance with a service sign-in
account.

# Arguments
- `connector_arn`:  The Amazon Resource Name (ARN) that was returned when you called
  CreateConnector.
- `directory_registration_arn`: The Amazon Resource Name (ARN) that was returned when you
  called CreateDirectoryRegistration.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: Idempotency token.
"""
function create_service_principal_name(
    ConnectorArn,
    DirectoryRegistrationArn;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pca_connector_ad(
        "POST",
        "/directoryRegistrations/$(DirectoryRegistrationArn)/servicePrincipalNames/$(ConnectorArn)",
        Dict{String,Any}("ClientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_service_principal_name(
    ConnectorArn,
    DirectoryRegistrationArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pca_connector_ad(
        "POST",
        "/directoryRegistrations/$(DirectoryRegistrationArn)/servicePrincipalNames/$(ConnectorArn)",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ClientToken" => string(uuid4())), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_template(connector_arn, definition, name)
    create_template(connector_arn, definition, name, params::Dict{String,<:Any})

Creates an Active Directory compatible certificate template. The connectors issues
certificates using these templates based on the requester’s Active Directory group
membership.

# Arguments
- `connector_arn`: The Amazon Resource Name (ARN) that was returned when you called
  CreateConnector.
- `definition`: Template configuration to define the information included in certificates.
  Define certificate validity and renewal periods, certificate request handling and
  enrollment options, key usage extensions, application policies, and cryptography settings.
- `name`: Name of the template. The template name must be unique.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: Idempotency token.
- `"Tags"`: Metadata assigned to a template consisting of a key-value pair.
"""
function create_template(
    ConnectorArn, Definition, Name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pca_connector_ad(
        "POST",
        "/templates",
        Dict{String,Any}(
            "ConnectorArn" => ConnectorArn,
            "Definition" => Definition,
            "Name" => Name,
            "ClientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_template(
    ConnectorArn,
    Definition,
    Name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pca_connector_ad(
        "POST",
        "/templates",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ConnectorArn" => ConnectorArn,
                    "Definition" => Definition,
                    "Name" => Name,
                    "ClientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_template_group_access_control_entry(access_rights, group_display_name, group_security_identifier, template_arn)
    create_template_group_access_control_entry(access_rights, group_display_name, group_security_identifier, template_arn, params::Dict{String,<:Any})

Create a group access control entry. Allow or deny Active Directory groups from enrolling
and/or autoenrolling with the template based on the group security identifiers (SIDs).

# Arguments
- `access_rights`:  Allow or deny permissions for an Active Directory group to enroll or
  autoenroll certificates for a template.
- `group_display_name`: Name of the Active Directory group. This name does not need to
  match the group name in Active Directory.
- `group_security_identifier`: Security identifier (SID) of the group object from Active
  Directory. The SID starts with \"S-\".
- `template_arn`: The Amazon Resource Name (ARN) that was returned when you called
  CreateTemplate.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: Idempotency token.
"""
function create_template_group_access_control_entry(
    AccessRights,
    GroupDisplayName,
    GroupSecurityIdentifier,
    TemplateArn;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pca_connector_ad(
        "POST",
        "/templates/$(TemplateArn)/accessControlEntries",
        Dict{String,Any}(
            "AccessRights" => AccessRights,
            "GroupDisplayName" => GroupDisplayName,
            "GroupSecurityIdentifier" => GroupSecurityIdentifier,
            "ClientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_template_group_access_control_entry(
    AccessRights,
    GroupDisplayName,
    GroupSecurityIdentifier,
    TemplateArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pca_connector_ad(
        "POST",
        "/templates/$(TemplateArn)/accessControlEntries",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AccessRights" => AccessRights,
                    "GroupDisplayName" => GroupDisplayName,
                    "GroupSecurityIdentifier" => GroupSecurityIdentifier,
                    "ClientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_connector(connector_arn)
    delete_connector(connector_arn, params::Dict{String,<:Any})

Deletes a connector for Active Directory. You must provide the Amazon Resource Name (ARN)
of the connector that you want to delete. You can find the ARN by calling the
https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_ListConnectors action.
Deleting a connector does not deregister your directory with Amazon Web Services Private
CA. You can deregister your directory by calling the
https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_DeleteDirectoryRegistra
tion action.

# Arguments
- `connector_arn`:  The Amazon Resource Name (ARN) that was returned when you called
  CreateConnector.

"""
function delete_connector(ConnectorArn; aws_config::AbstractAWSConfig=current_aws_config())
    return pca_connector_ad(
        "DELETE",
        "/connectors/$(ConnectorArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_connector(
    ConnectorArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pca_connector_ad(
        "DELETE",
        "/connectors/$(ConnectorArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_directory_registration(directory_registration_arn)
    delete_directory_registration(directory_registration_arn, params::Dict{String,<:Any})

Deletes a directory registration. Deleting a directory registration deauthorizes Amazon Web
Services Private CA with the directory.

# Arguments
- `directory_registration_arn`: The Amazon Resource Name (ARN) that was returned when you
  called CreateDirectoryRegistration.

"""
function delete_directory_registration(
    DirectoryRegistrationArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pca_connector_ad(
        "DELETE",
        "/directoryRegistrations/$(DirectoryRegistrationArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_directory_registration(
    DirectoryRegistrationArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pca_connector_ad(
        "DELETE",
        "/directoryRegistrations/$(DirectoryRegistrationArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_service_principal_name(connector_arn, directory_registration_arn)
    delete_service_principal_name(connector_arn, directory_registration_arn, params::Dict{String,<:Any})

Deletes the service principal name (SPN) used by a connector to authenticate with your
Active Directory.

# Arguments
- `connector_arn`:  The Amazon Resource Name (ARN) that was returned when you called
  CreateConnector.
- `directory_registration_arn`: The Amazon Resource Name (ARN) that was returned when you
  called CreateDirectoryRegistration.

"""
function delete_service_principal_name(
    ConnectorArn,
    DirectoryRegistrationArn;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pca_connector_ad(
        "DELETE",
        "/directoryRegistrations/$(DirectoryRegistrationArn)/servicePrincipalNames/$(ConnectorArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_service_principal_name(
    ConnectorArn,
    DirectoryRegistrationArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pca_connector_ad(
        "DELETE",
        "/directoryRegistrations/$(DirectoryRegistrationArn)/servicePrincipalNames/$(ConnectorArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_template(template_arn)
    delete_template(template_arn, params::Dict{String,<:Any})

Deletes a template. Certificates issued using the template are still valid until they are
revoked or expired.

# Arguments
- `template_arn`: The Amazon Resource Name (ARN) that was returned when you called
  CreateTemplate.

"""
function delete_template(TemplateArn; aws_config::AbstractAWSConfig=current_aws_config())
    return pca_connector_ad(
        "DELETE",
        "/templates/$(TemplateArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_template(
    TemplateArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pca_connector_ad(
        "DELETE",
        "/templates/$(TemplateArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_template_group_access_control_entry(group_security_identifier, template_arn)
    delete_template_group_access_control_entry(group_security_identifier, template_arn, params::Dict{String,<:Any})

Deletes a group access control entry.

# Arguments
- `group_security_identifier`: Security identifier (SID) of the group object from Active
  Directory. The SID starts with \"S-\".
- `template_arn`: The Amazon Resource Name (ARN) that was returned when you called
  CreateTemplate.

"""
function delete_template_group_access_control_entry(
    GroupSecurityIdentifier, TemplateArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pca_connector_ad(
        "DELETE",
        "/templates/$(TemplateArn)/accessControlEntries/$(GroupSecurityIdentifier)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_template_group_access_control_entry(
    GroupSecurityIdentifier,
    TemplateArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pca_connector_ad(
        "DELETE",
        "/templates/$(TemplateArn)/accessControlEntries/$(GroupSecurityIdentifier)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_connector(connector_arn)
    get_connector(connector_arn, params::Dict{String,<:Any})

Lists information about your connector. You specify the connector on input by its ARN
(Amazon Resource Name).

# Arguments
- `connector_arn`:  The Amazon Resource Name (ARN) that was returned when you called
  CreateConnector.

"""
function get_connector(ConnectorArn; aws_config::AbstractAWSConfig=current_aws_config())
    return pca_connector_ad(
        "GET",
        "/connectors/$(ConnectorArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_connector(
    ConnectorArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pca_connector_ad(
        "GET",
        "/connectors/$(ConnectorArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_directory_registration(directory_registration_arn)
    get_directory_registration(directory_registration_arn, params::Dict{String,<:Any})

A structure that contains information about your directory registration.

# Arguments
- `directory_registration_arn`: The Amazon Resource Name (ARN) that was returned when you
  called CreateDirectoryRegistration.

"""
function get_directory_registration(
    DirectoryRegistrationArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pca_connector_ad(
        "GET",
        "/directoryRegistrations/$(DirectoryRegistrationArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_directory_registration(
    DirectoryRegistrationArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pca_connector_ad(
        "GET",
        "/directoryRegistrations/$(DirectoryRegistrationArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_service_principal_name(connector_arn, directory_registration_arn)
    get_service_principal_name(connector_arn, directory_registration_arn, params::Dict{String,<:Any})

Lists the service principal name that the connector uses to authenticate with Active
Directory.

# Arguments
- `connector_arn`: The Amazon Resource Name (ARN) that was returned when you called
  CreateConnector.
- `directory_registration_arn`: The Amazon Resource Name (ARN) that was returned when you
  called CreateDirectoryRegistration.

"""
function get_service_principal_name(
    ConnectorArn,
    DirectoryRegistrationArn;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pca_connector_ad(
        "GET",
        "/directoryRegistrations/$(DirectoryRegistrationArn)/servicePrincipalNames/$(ConnectorArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_service_principal_name(
    ConnectorArn,
    DirectoryRegistrationArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pca_connector_ad(
        "GET",
        "/directoryRegistrations/$(DirectoryRegistrationArn)/servicePrincipalNames/$(ConnectorArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_template(template_arn)
    get_template(template_arn, params::Dict{String,<:Any})

Retrieves a certificate template that the connector uses to issue certificates from a
private CA.

# Arguments
- `template_arn`: The Amazon Resource Name (ARN) that was returned when you called
  CreateTemplate.

"""
function get_template(TemplateArn; aws_config::AbstractAWSConfig=current_aws_config())
    return pca_connector_ad(
        "GET",
        "/templates/$(TemplateArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_template(
    TemplateArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pca_connector_ad(
        "GET",
        "/templates/$(TemplateArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_template_group_access_control_entry(group_security_identifier, template_arn)
    get_template_group_access_control_entry(group_security_identifier, template_arn, params::Dict{String,<:Any})

Retrieves the group access control entries for a template.

# Arguments
- `group_security_identifier`: Security identifier (SID) of the group object from Active
  Directory. The SID starts with \"S-\".
- `template_arn`: The Amazon Resource Name (ARN) that was returned when you called
  CreateTemplate.

"""
function get_template_group_access_control_entry(
    GroupSecurityIdentifier, TemplateArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pca_connector_ad(
        "GET",
        "/templates/$(TemplateArn)/accessControlEntries/$(GroupSecurityIdentifier)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_template_group_access_control_entry(
    GroupSecurityIdentifier,
    TemplateArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pca_connector_ad(
        "GET",
        "/templates/$(TemplateArn)/accessControlEntries/$(GroupSecurityIdentifier)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_connectors()
    list_connectors(params::Dict{String,<:Any})

Lists the connectors that you created by using the
https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: Use this parameter when paginating results to specify the maximum number
  of items to return in the response on each page. If additional items exist beyond the
  number you specify, the NextToken element is sent in the response. Use this NextToken value
  in a subsequent request to retrieve additional items.
- `"NextToken"`: Use this parameter when paginating results in a subsequent request after
  you receive a response with truncated results. Set it to the value of the NextToken
  parameter from the response you just received.
"""
function list_connectors(; aws_config::AbstractAWSConfig=current_aws_config())
    return pca_connector_ad(
        "GET", "/connectors"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_connectors(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pca_connector_ad(
        "GET", "/connectors", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_directory_registrations()
    list_directory_registrations(params::Dict{String,<:Any})

Lists the directory registrations that you created by using the
https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateDirectoryRegistra
tion action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: Use this parameter when paginating results to specify the maximum number
  of items to return in the response on each page. If additional items exist beyond the
  number you specify, the NextToken element is sent in the response. Use this NextToken value
  in a subsequent request to retrieve additional items.
- `"NextToken"`: Use this parameter when paginating results in a subsequent request after
  you receive a response with truncated results. Set it to the value of the NextToken
  parameter from the response you just received.
"""
function list_directory_registrations(; aws_config::AbstractAWSConfig=current_aws_config())
    return pca_connector_ad(
        "GET",
        "/directoryRegistrations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_directory_registrations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pca_connector_ad(
        "GET",
        "/directoryRegistrations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_service_principal_names(directory_registration_arn)
    list_service_principal_names(directory_registration_arn, params::Dict{String,<:Any})

Lists the service principal names that the connector uses to authenticate with Active
Directory.

# Arguments
- `directory_registration_arn`: The Amazon Resource Name (ARN) that was returned when you
  called CreateDirectoryRegistration.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: Use this parameter when paginating results to specify the maximum number
  of items to return in the response on each page. If additional items exist beyond the
  number you specify, the NextToken element is sent in the response. Use this NextToken value
  in a subsequent request to retrieve additional items.
- `"NextToken"`: Use this parameter when paginating results in a subsequent request after
  you receive a response with truncated results. Set it to the value of the NextToken
  parameter from the response you just received.
"""
function list_service_principal_names(
    DirectoryRegistrationArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pca_connector_ad(
        "GET",
        "/directoryRegistrations/$(DirectoryRegistrationArn)/servicePrincipalNames";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_service_principal_names(
    DirectoryRegistrationArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pca_connector_ad(
        "GET",
        "/directoryRegistrations/$(DirectoryRegistrationArn)/servicePrincipalNames",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Lists the tags, if any, that are associated with your resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) that was returned when you created the
  resource.

"""
function list_tags_for_resource(
    ResourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pca_connector_ad(
        "GET",
        "/tags/$(ResourceArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    ResourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pca_connector_ad(
        "GET",
        "/tags/$(ResourceArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_template_group_access_control_entries(template_arn)
    list_template_group_access_control_entries(template_arn, params::Dict{String,<:Any})

Lists group access control entries you created.

# Arguments
- `template_arn`: The Amazon Resource Name (ARN) that was returned when you called
  CreateTemplate.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: Use this parameter when paginating results to specify the maximum number
  of items to return in the response on each page. If additional items exist beyond the
  number you specify, the NextToken element is sent in the response. Use this NextToken value
  in a subsequent request to retrieve additional items.
- `"NextToken"`: Use this parameter when paginating results in a subsequent request after
  you receive a response with truncated results. Set it to the value of the NextToken
  parameter from the response you just received.
"""
function list_template_group_access_control_entries(
    TemplateArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pca_connector_ad(
        "GET",
        "/templates/$(TemplateArn)/accessControlEntries";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_template_group_access_control_entries(
    TemplateArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pca_connector_ad(
        "GET",
        "/templates/$(TemplateArn)/accessControlEntries",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_templates(connector_arn)
    list_templates(connector_arn, params::Dict{String,<:Any})

Lists the templates, if any, that are associated with a connector.

# Arguments
- `connector_arn`: The Amazon Resource Name (ARN) that was returned when you called
  CreateConnector.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: Use this parameter when paginating results to specify the maximum number
  of items to return in the response on each page. If additional items exist beyond the
  number you specify, the NextToken element is sent in the response. Use this NextToken value
  in a subsequent request to retrieve additional items.
- `"NextToken"`: Use this parameter when paginating results in a subsequent request after
  you receive a response with truncated results. Set it to the value of the NextToken
  parameter from the response you just received.
"""
function list_templates(ConnectorArn; aws_config::AbstractAWSConfig=current_aws_config())
    return pca_connector_ad(
        "GET",
        "/templates",
        Dict{String,Any}("ConnectorArn" => ConnectorArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_templates(
    ConnectorArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pca_connector_ad(
        "GET",
        "/templates",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ConnectorArn" => ConnectorArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Adds one or more tags to your resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) that was returned when you created the
  resource.
- `tags`: Metadata assigned to a directory registration consisting of a key-value pair.

"""
function tag_resource(ResourceArn, Tags; aws_config::AbstractAWSConfig=current_aws_config())
    return pca_connector_ad(
        "POST",
        "/tags/$(ResourceArn)",
        Dict{String,Any}("Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    ResourceArn,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pca_connector_ad(
        "POST",
        "/tags/$(ResourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Tags" => Tags), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Removes one or more tags from your resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) that was returned when you created the
  resource.
- `tag_keys`: Specifies a list of tag keys that you want to remove from the specified
  resources.

"""
function untag_resource(
    ResourceArn, tagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pca_connector_ad(
        "DELETE",
        "/tags/$(ResourceArn)",
        Dict{String,Any}("tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    ResourceArn,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pca_connector_ad(
        "DELETE",
        "/tags/$(ResourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tagKeys" => tagKeys), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_template(template_arn)
    update_template(template_arn, params::Dict{String,<:Any})

Update template configuration to define the information included in certificates.

# Arguments
- `template_arn`: The Amazon Resource Name (ARN) that was returned when you called
  CreateTemplate.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Definition"`: Template configuration to define the information included in
  certificates. Define certificate validity and renewal periods, certificate request handling
  and enrollment options, key usage extensions, application policies, and cryptography
  settings.
- `"ReenrollAllCertificateHolders"`: This setting allows the major version of a template to
  be increased automatically. All members of Active Directory groups that are allowed to
  enroll with a template will receive a new certificate issued using that template.
"""
function update_template(TemplateArn; aws_config::AbstractAWSConfig=current_aws_config())
    return pca_connector_ad(
        "PATCH",
        "/templates/$(TemplateArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_template(
    TemplateArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pca_connector_ad(
        "PATCH",
        "/templates/$(TemplateArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_template_group_access_control_entry(group_security_identifier, template_arn)
    update_template_group_access_control_entry(group_security_identifier, template_arn, params::Dict{String,<:Any})

Update a group access control entry you created using
CreateTemplateGroupAccessControlEntry.

# Arguments
- `group_security_identifier`: Security identifier (SID) of the group object from Active
  Directory. The SID starts with \"S-\".
- `template_arn`: The Amazon Resource Name (ARN) that was returned when you called
  CreateTemplate.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AccessRights"`: Allow or deny permissions for an Active Directory group to enroll or
  autoenroll certificates for a template.
- `"GroupDisplayName"`: Name of the Active Directory group. This name does not need to
  match the group name in Active Directory.
"""
function update_template_group_access_control_entry(
    GroupSecurityIdentifier, TemplateArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pca_connector_ad(
        "PATCH",
        "/templates/$(TemplateArn)/accessControlEntries/$(GroupSecurityIdentifier)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_template_group_access_control_entry(
    GroupSecurityIdentifier,
    TemplateArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pca_connector_ad(
        "PATCH",
        "/templates/$(TemplateArn)/accessControlEntries/$(GroupSecurityIdentifier)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
