# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: resiliencehub
using AWS.Compat
using AWS.UUIDs

"""
    add_draft_app_version_resource_mappings(app_arn, resource_mappings)
    add_draft_app_version_resource_mappings(app_arn, resource_mappings, params::Dict{String,<:Any})

Adds the source of resource-maps to the draft version of an application. During assessment,
Resilience Hub will use these resource-maps to resolve the latest physical ID for each
resource in the application template. For more information about different types of
resources suported by Resilience Hub and how to add them in your application, see Step 2:
How is your application managed? in the Resilience Hub User Guide.

# Arguments
- `app_arn`: Amazon Resource Name (ARN) of the Resilience Hub application. The format for
  this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For more information
  about ARNs, see  Amazon Resource Names (ARNs) in the Amazon Web Services General Reference
  guide.
- `resource_mappings`: Mappings used to map logical resources from the template to physical
  resources. You can use the mapping type CFN_STACK if the application template uses a
  logical stack name. Or you can map individual resources by using the mapping type RESOURCE.
  We recommend using the mapping type CFN_STACK if the application is backed by a
  CloudFormation stack.

"""
function add_draft_app_version_resource_mappings(
    appArn, resourceMappings; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "POST",
        "/add-draft-app-version-resource-mappings",
        Dict{String,Any}("appArn" => appArn, "resourceMappings" => resourceMappings);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function add_draft_app_version_resource_mappings(
    appArn,
    resourceMappings,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return resiliencehub(
        "POST",
        "/add-draft-app-version-resource-mappings",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "appArn" => appArn, "resourceMappings" => resourceMappings
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_update_recommendation_status(app_arn, request_entries)
    batch_update_recommendation_status(app_arn, request_entries, params::Dict{String,<:Any})

Enables you to include or exclude one or more operational recommendations.

# Arguments
- `app_arn`: Amazon Resource Name (ARN) of the Resilience Hub application. The format for
  this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For more information
  about ARNs, see  Amazon Resource Names (ARNs) in the Amazon Web Services General Reference
  guide.
- `request_entries`: Defines the list of operational recommendations that need to be
  included or excluded.

"""
function batch_update_recommendation_status(
    appArn, requestEntries; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "POST",
        "/batch-update-recommendation-status",
        Dict{String,Any}("appArn" => appArn, "requestEntries" => requestEntries);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_update_recommendation_status(
    appArn,
    requestEntries,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return resiliencehub(
        "POST",
        "/batch-update-recommendation-status",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("appArn" => appArn, "requestEntries" => requestEntries),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_app(name)
    create_app(name, params::Dict{String,<:Any})

Creates an Resilience Hub application. An Resilience Hub application is a collection of
Amazon Web Services resources structured to prevent and recover Amazon Web Services
application disruptions. To describe a Resilience Hub application, you provide an
application name, resources from one or more CloudFormation stacks, Resource Groups,
Terraform state files, AppRegistry applications, and an appropriate resiliency policy. In
addition, you can also add resources that are located on Amazon Elastic Kubernetes Service
(Amazon EKS) clusters as optional resources. For more information about the number of
resources supported per application, see Service quotas. After you create an Resilience Hub
application, you publish it so that you can run a resiliency assessment on it. You can then
use recommendations from the assessment to improve resiliency by running another
assessment, comparing results, and then iterating the process until you achieve your goals
for recovery time objective (RTO) and recovery point objective (RPO).

# Arguments
- `name`: Name of the application.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"assessmentSchedule"`:  Assessment execution schedule with 'Daily' or 'Disabled' values.
- `"clientToken"`: Used for an idempotency token. A client token is a unique,
  case-sensitive string of up to 64 ASCII characters. You should not reuse the same client
  token for other API requests.
- `"description"`: The optional description for an app.
- `"eventSubscriptions"`: The list of events you would like to subscribe and get
  notification for. Currently, Resilience Hub supports only Drift detected and Scheduled
  assessment failure events notification.
- `"permissionModel"`: Defines the roles and credentials that Resilience Hub would use
  while creating the application, importing its resources, and running an assessment.
- `"policyArn"`: Amazon Resource Name (ARN) of the resiliency policy. The format for this
  ARN is: arn:partition:resiliencehub:region:account:resiliency-policy/policy-id. For more
  information about ARNs, see  Amazon Resource Names (ARNs) in the Amazon Web Services
  General Reference guide.
- `"tags"`: Tags assigned to the resource. A tag is a label that you assign to an Amazon
  Web Services resource. Each tag consists of a key/value pair.
"""
function create_app(name; aws_config::AbstractAWSConfig=current_aws_config())
    return resiliencehub(
        "POST",
        "/create-app",
        Dict{String,Any}("name" => name, "clientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_app(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "POST",
        "/create-app",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("name" => name, "clientToken" => string(uuid4())),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_app_version_app_component(app_arn, name, type)
    create_app_version_app_component(app_arn, name, type, params::Dict{String,<:Any})

Creates a new Application Component in the Resilience Hub application.  This API updates
the Resilience Hub application draft version. To use this Application Component for running
assessments, you must publish the Resilience Hub application using the PublishAppVersion
API.

# Arguments
- `app_arn`: Amazon Resource Name (ARN) of the Resilience Hub application. The format for
  this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For more information
  about ARNs, see  Amazon Resource Names (ARNs) in the Amazon Web Services General Reference
  guide.
- `name`: Name of the Application Component.
- `type`: Type of Application Component. For more information about the types of
  Application Component, see Grouping resources in an AppComponent.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"additionalInfo"`: Currently, there is no supported additional information for
  Application Components.
- `"clientToken"`: Used for an idempotency token. A client token is a unique,
  case-sensitive string of up to 64 ASCII characters. You should not reuse the same client
  token for other API requests.
- `"id"`: Identifier of the Application Component.
"""
function create_app_version_app_component(
    appArn, name, type; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "POST",
        "/create-app-version-app-component",
        Dict{String,Any}(
            "appArn" => appArn,
            "name" => name,
            "type" => type,
            "clientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_app_version_app_component(
    appArn,
    name,
    type,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return resiliencehub(
        "POST",
        "/create-app-version-app-component",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "appArn" => appArn,
                    "name" => name,
                    "type" => type,
                    "clientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_app_version_resource(app_arn, app_components, logical_resource_id, physical_resource_id, resource_type)
    create_app_version_resource(app_arn, app_components, logical_resource_id, physical_resource_id, resource_type, params::Dict{String,<:Any})

Adds a resource to the Resilience Hub application and assigns it to the specified
Application Components. If you specify a new Application Component, Resilience Hub will
automatically create the Application Component.    This action has no effect outside
Resilience Hub.   This API updates the Resilience Hub application draft version. To use
this resource for running resiliency assessments, you must publish the Resilience Hub
application using the PublishAppVersion API.   To update application version with new
physicalResourceID, you must call ResolveAppVersionResources API.

# Arguments
- `app_arn`: Amazon Resource Name (ARN) of the Resilience Hub application. The format for
  this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For more information
  about ARNs, see  Amazon Resource Names (ARNs) in the Amazon Web Services General Reference
  guide.
- `app_components`: List of Application Components that this resource belongs to. If an
  Application Component is not part of the Resilience Hub application, it will be added.
- `logical_resource_id`: Logical identifier of the resource.
- `physical_resource_id`: Physical identifier of the resource.
- `resource_type`: Type of resource.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"additionalInfo"`: Currently, there is no supported additional information for resources.
- `"awsAccountId"`: Amazon Web Services account that owns the physical resource.
- `"awsRegion"`: Amazon Web Services region that owns the physical resource.
- `"clientToken"`: Used for an idempotency token. A client token is a unique,
  case-sensitive string of up to 64 ASCII characters. You should not reuse the same client
  token for other API requests.
- `"resourceName"`: Name of the resource.
"""
function create_app_version_resource(
    appArn,
    appComponents,
    logicalResourceId,
    physicalResourceId,
    resourceType;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return resiliencehub(
        "POST",
        "/create-app-version-resource",
        Dict{String,Any}(
            "appArn" => appArn,
            "appComponents" => appComponents,
            "logicalResourceId" => logicalResourceId,
            "physicalResourceId" => physicalResourceId,
            "resourceType" => resourceType,
            "clientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_app_version_resource(
    appArn,
    appComponents,
    logicalResourceId,
    physicalResourceId,
    resourceType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return resiliencehub(
        "POST",
        "/create-app-version-resource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "appArn" => appArn,
                    "appComponents" => appComponents,
                    "logicalResourceId" => logicalResourceId,
                    "physicalResourceId" => physicalResourceId,
                    "resourceType" => resourceType,
                    "clientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_recommendation_template(assessment_arn, name)
    create_recommendation_template(assessment_arn, name, params::Dict{String,<:Any})

Creates a new recommendation template for the Resilience Hub application.

# Arguments
- `assessment_arn`: Amazon Resource Name (ARN) of the assessment. The format for this ARN
  is: arn:partition:resiliencehub:region:account:app-assessment/app-id. For more information
  about ARNs, see  Amazon Resource Names (ARNs) in the Amazon Web Services General Reference
  guide.
- `name`: The name for the recommendation template.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"bucketName"`: The name of the Amazon S3 bucket that will contain the recommendation
  template.
- `"clientToken"`: Used for an idempotency token. A client token is a unique,
  case-sensitive string of up to 64 ASCII characters. You should not reuse the same client
  token for other API requests.
- `"format"`: The format for the recommendation template.  CfnJson  The template is
  CloudFormation JSON.  CfnYaml  The template is CloudFormation YAML.
- `"recommendationIds"`: Identifiers for the recommendations used to create a
  recommendation template.
- `"recommendationTypes"`: An array of strings that specify the recommendation template
  type or types.  Alarm  The template is an AlarmRecommendation template.  Sop  The template
  is a SopRecommendation template.  Test  The template is a TestRecommendation template.
- `"tags"`: Tags assigned to the resource. A tag is a label that you assign to an Amazon
  Web Services resource. Each tag consists of a key/value pair.
"""
function create_recommendation_template(
    assessmentArn, name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "POST",
        "/create-recommendation-template",
        Dict{String,Any}(
            "assessmentArn" => assessmentArn,
            "name" => name,
            "clientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_recommendation_template(
    assessmentArn,
    name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return resiliencehub(
        "POST",
        "/create-recommendation-template",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "assessmentArn" => assessmentArn,
                    "name" => name,
                    "clientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_resiliency_policy(policy, policy_name, tier)
    create_resiliency_policy(policy, policy_name, tier, params::Dict{String,<:Any})

Creates a resiliency policy for an application.  Resilience Hub allows you to provide a
value of zero for rtoInSecs and rpoInSecs of your resiliency policy. But, while assessing
your application, the lowest possible assessment result is near zero. Hence, if you provide
value zero for rtoInSecs and rpoInSecs, the estimated workload RTO and estimated workload
RPO result will be near zero and the Compliance status for your application will be set to
Policy breached.

# Arguments
- `policy`: The type of resiliency policy to be created, including the recovery time
  objective (RTO) and recovery point objective (RPO) in seconds.
- `policy_name`: The name of the policy
- `tier`: The tier for this resiliency policy, ranging from the highest severity
  (MissionCritical) to lowest (NonCritical).

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: Used for an idempotency token. A client token is a unique,
  case-sensitive string of up to 64 ASCII characters. You should not reuse the same client
  token for other API requests.
- `"dataLocationConstraint"`: Specifies a high-level geographical location constraint for
  where your resilience policy data can be stored.
- `"policyDescription"`: The description for the policy.
- `"tags"`: Tags assigned to the resource. A tag is a label that you assign to an Amazon
  Web Services resource. Each tag consists of a key/value pair.
"""
function create_resiliency_policy(
    policy, policyName, tier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "POST",
        "/create-resiliency-policy",
        Dict{String,Any}(
            "policy" => policy,
            "policyName" => policyName,
            "tier" => tier,
            "clientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_resiliency_policy(
    policy,
    policyName,
    tier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return resiliencehub(
        "POST",
        "/create-resiliency-policy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "policy" => policy,
                    "policyName" => policyName,
                    "tier" => tier,
                    "clientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_app(app_arn)
    delete_app(app_arn, params::Dict{String,<:Any})

Deletes an Resilience Hub application. This is a destructive action that can't be undone.

# Arguments
- `app_arn`: Amazon Resource Name (ARN) of the Resilience Hub application. The format for
  this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For more information
  about ARNs, see  Amazon Resource Names (ARNs) in the Amazon Web Services General Reference
  guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: Used for an idempotency token. A client token is a unique,
  case-sensitive string of up to 64 ASCII characters. You should not reuse the same client
  token for other API requests.
- `"forceDelete"`: A boolean option to force the deletion of an Resilience Hub application.
"""
function delete_app(appArn; aws_config::AbstractAWSConfig=current_aws_config())
    return resiliencehub(
        "POST",
        "/delete-app",
        Dict{String,Any}("appArn" => appArn, "clientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_app(
    appArn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "POST",
        "/delete-app",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("appArn" => appArn, "clientToken" => string(uuid4())),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_app_assessment(assessment_arn)
    delete_app_assessment(assessment_arn, params::Dict{String,<:Any})

Deletes an Resilience Hub application assessment. This is a destructive action that can't
be undone.

# Arguments
- `assessment_arn`: Amazon Resource Name (ARN) of the assessment. The format for this ARN
  is: arn:partition:resiliencehub:region:account:app-assessment/app-id. For more information
  about ARNs, see  Amazon Resource Names (ARNs) in the Amazon Web Services General Reference
  guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: Used for an idempotency token. A client token is a unique,
  case-sensitive string of up to 64 ASCII characters. You should not reuse the same client
  token for other API requests.
"""
function delete_app_assessment(
    assessmentArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "POST",
        "/delete-app-assessment",
        Dict{String,Any}(
            "assessmentArn" => assessmentArn, "clientToken" => string(uuid4())
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_app_assessment(
    assessmentArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return resiliencehub(
        "POST",
        "/delete-app-assessment",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "assessmentArn" => assessmentArn, "clientToken" => string(uuid4())
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_app_input_source(app_arn)
    delete_app_input_source(app_arn, params::Dict{String,<:Any})

Deletes the input source and all of its imported resources from the Resilience Hub
application.

# Arguments
- `app_arn`: Amazon Resource Name (ARN) of the Resilience Hub application. The format for
  this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For more information
  about ARNs, see  Amazon Resource Names (ARNs) in the Amazon Web Services General Reference
  guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: Used for an idempotency token. A client token is a unique,
  case-sensitive string of up to 64 ASCII characters. You should not reuse the same client
  token for other API requests.
- `"eksSourceClusterNamespace"`: The namespace on your Amazon Elastic Kubernetes Service
  cluster that you want to delete from the Resilience Hub application.
- `"sourceArn"`: The Amazon Resource Name (ARN) of the imported resource you want to remove
  from the Resilience Hub application. For more information about ARNs, see  Amazon Resource
  Names (ARNs) in the Amazon Web Services General Reference guide.
- `"terraformSource"`: The imported Terraform s3 state ﬁle you want to remove from the
  Resilience Hub application.
"""
function delete_app_input_source(appArn; aws_config::AbstractAWSConfig=current_aws_config())
    return resiliencehub(
        "POST",
        "/delete-app-input-source",
        Dict{String,Any}("appArn" => appArn, "clientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_app_input_source(
    appArn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "POST",
        "/delete-app-input-source",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("appArn" => appArn, "clientToken" => string(uuid4())),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_app_version_app_component(app_arn, id)
    delete_app_version_app_component(app_arn, id, params::Dict{String,<:Any})

Deletes an Application Component from the Resilience Hub application.    This API updates
the Resilience Hub application draft version. To use this Application Component for running
assessments, you must publish the Resilience Hub application using the PublishAppVersion
API.   You will not be able to delete an Application Component if it has resources
associated with it.

# Arguments
- `app_arn`: Amazon Resource Name (ARN) of the Resilience Hub application. The format for
  this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For more information
  about ARNs, see  Amazon Resource Names (ARNs) in the Amazon Web Services General Reference
  guide.
- `id`: Identifier of the Application Component.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: Used for an idempotency token. A client token is a unique,
  case-sensitive string of up to 64 ASCII characters. You should not reuse the same client
  token for other API requests.
"""
function delete_app_version_app_component(
    appArn, id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "POST",
        "/delete-app-version-app-component",
        Dict{String,Any}("appArn" => appArn, "id" => id, "clientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_app_version_app_component(
    appArn,
    id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return resiliencehub(
        "POST",
        "/delete-app-version-app-component",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "appArn" => appArn, "id" => id, "clientToken" => string(uuid4())
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_app_version_resource(app_arn)
    delete_app_version_resource(app_arn, params::Dict{String,<:Any})

Deletes a resource from the Resilience Hub application.    You can only delete a manually
added resource. To exclude non-manually added resources, use the UpdateAppVersionResource
API.   This action has no effect outside Resilience Hub.   This API updates the Resilience
Hub application draft version. To use this resource for running resiliency assessments, you
must publish the Resilience Hub application using the PublishAppVersion API.

# Arguments
- `app_arn`: Amazon Resource Name (ARN) of the Resilience Hub application. The format for
  this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For more information
  about ARNs, see  Amazon Resource Names (ARNs) in the Amazon Web Services General Reference
  guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"awsAccountId"`: Amazon Web Services account that owns the physical resource.
- `"awsRegion"`: Amazon Web Services region that owns the physical resource.
- `"clientToken"`: Used for an idempotency token. A client token is a unique,
  case-sensitive string of up to 64 ASCII characters. You should not reuse the same client
  token for other API requests.
- `"logicalResourceId"`: Logical identifier of the resource.
- `"physicalResourceId"`: Physical identifier of the resource.
- `"resourceName"`: Name of the resource.
"""
function delete_app_version_resource(
    appArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "POST",
        "/delete-app-version-resource",
        Dict{String,Any}("appArn" => appArn, "clientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_app_version_resource(
    appArn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "POST",
        "/delete-app-version-resource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("appArn" => appArn, "clientToken" => string(uuid4())),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_recommendation_template(recommendation_template_arn)
    delete_recommendation_template(recommendation_template_arn, params::Dict{String,<:Any})

Deletes a recommendation template. This is a destructive action that can't be undone.

# Arguments
- `recommendation_template_arn`: The Amazon Resource Name (ARN) for a recommendation
  template.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: Used for an idempotency token. A client token is a unique,
  case-sensitive string of up to 64 ASCII characters. You should not reuse the same client
  token for other API requests.
"""
function delete_recommendation_template(
    recommendationTemplateArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "POST",
        "/delete-recommendation-template",
        Dict{String,Any}(
            "recommendationTemplateArn" => recommendationTemplateArn,
            "clientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_recommendation_template(
    recommendationTemplateArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return resiliencehub(
        "POST",
        "/delete-recommendation-template",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "recommendationTemplateArn" => recommendationTemplateArn,
                    "clientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_resiliency_policy(policy_arn)
    delete_resiliency_policy(policy_arn, params::Dict{String,<:Any})

Deletes a resiliency policy. This is a destructive action that can't be undone.

# Arguments
- `policy_arn`: Amazon Resource Name (ARN) of the resiliency policy. The format for this
  ARN is: arn:partition:resiliencehub:region:account:resiliency-policy/policy-id. For more
  information about ARNs, see  Amazon Resource Names (ARNs) in the Amazon Web Services
  General Reference guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: Used for an idempotency token. A client token is a unique,
  case-sensitive string of up to 64 ASCII characters. You should not reuse the same client
  token for other API requests.
"""
function delete_resiliency_policy(
    policyArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "POST",
        "/delete-resiliency-policy",
        Dict{String,Any}("policyArn" => policyArn, "clientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_resiliency_policy(
    policyArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return resiliencehub(
        "POST",
        "/delete-resiliency-policy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "policyArn" => policyArn, "clientToken" => string(uuid4())
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_app(app_arn)
    describe_app(app_arn, params::Dict{String,<:Any})

Describes an Resilience Hub application.

# Arguments
- `app_arn`: Amazon Resource Name (ARN) of the Resilience Hub application. The format for
  this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For more information
  about ARNs, see  Amazon Resource Names (ARNs) in the Amazon Web Services General Reference
  guide.

"""
function describe_app(appArn; aws_config::AbstractAWSConfig=current_aws_config())
    return resiliencehub(
        "POST",
        "/describe-app",
        Dict{String,Any}("appArn" => appArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_app(
    appArn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "POST",
        "/describe-app",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("appArn" => appArn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_app_assessment(assessment_arn)
    describe_app_assessment(assessment_arn, params::Dict{String,<:Any})

Describes an assessment for an Resilience Hub application.

# Arguments
- `assessment_arn`: Amazon Resource Name (ARN) of the assessment. The format for this ARN
  is: arn:partition:resiliencehub:region:account:app-assessment/app-id. For more information
  about ARNs, see  Amazon Resource Names (ARNs) in the Amazon Web Services General Reference
  guide.

"""
function describe_app_assessment(
    assessmentArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "POST",
        "/describe-app-assessment",
        Dict{String,Any}("assessmentArn" => assessmentArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_app_assessment(
    assessmentArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return resiliencehub(
        "POST",
        "/describe-app-assessment",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("assessmentArn" => assessmentArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_app_version(app_arn, app_version)
    describe_app_version(app_arn, app_version, params::Dict{String,<:Any})

Describes the Resilience Hub application version.

# Arguments
- `app_arn`: Amazon Resource Name (ARN) of the Resilience Hub application. The format for
  this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For more information
  about ARNs, see  Amazon Resource Names (ARNs) in the Amazon Web Services General Reference
  guide.
- `app_version`: Resilience Hub application version.

"""
function describe_app_version(
    appArn, appVersion; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "POST",
        "/describe-app-version",
        Dict{String,Any}("appArn" => appArn, "appVersion" => appVersion);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_app_version(
    appArn,
    appVersion,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return resiliencehub(
        "POST",
        "/describe-app-version",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("appArn" => appArn, "appVersion" => appVersion),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_app_version_app_component(app_arn, app_version, id)
    describe_app_version_app_component(app_arn, app_version, id, params::Dict{String,<:Any})

Describes an Application Component in the Resilience Hub application.

# Arguments
- `app_arn`: Amazon Resource Name (ARN) of the Resilience Hub application. The format for
  this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For more information
  about ARNs, see  Amazon Resource Names (ARNs) in the Amazon Web Services General Reference
  guide.
- `app_version`: Resilience Hub application version.
- `id`: Identifier of the Application Component.

"""
function describe_app_version_app_component(
    appArn, appVersion, id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "POST",
        "/describe-app-version-app-component",
        Dict{String,Any}("appArn" => appArn, "appVersion" => appVersion, "id" => id);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_app_version_app_component(
    appArn,
    appVersion,
    id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return resiliencehub(
        "POST",
        "/describe-app-version-app-component",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "appArn" => appArn, "appVersion" => appVersion, "id" => id
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_app_version_resource(app_arn, app_version)
    describe_app_version_resource(app_arn, app_version, params::Dict{String,<:Any})

Describes a resource of the Resilience Hub application.  This API accepts only one of the
following parameters to descibe the resource:    resourceName     logicalResourceId
physicalResourceId (Along with physicalResourceId, you can also provide awsAccountId, and
awsRegion)

# Arguments
- `app_arn`: Amazon Resource Name (ARN) of the Resilience Hub application. The format for
  this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For more information
  about ARNs, see  Amazon Resource Names (ARNs) in the Amazon Web Services General Reference
  guide.
- `app_version`: Resilience Hub application version.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"awsAccountId"`: Amazon Web Services account that owns the physical resource.
- `"awsRegion"`: Amazon Web Services region that owns the physical resource.
- `"logicalResourceId"`: Logical identifier of the resource.
- `"physicalResourceId"`: Physical identifier of the resource.
- `"resourceName"`: Name of the resource.
"""
function describe_app_version_resource(
    appArn, appVersion; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "POST",
        "/describe-app-version-resource",
        Dict{String,Any}("appArn" => appArn, "appVersion" => appVersion);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_app_version_resource(
    appArn,
    appVersion,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return resiliencehub(
        "POST",
        "/describe-app-version-resource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("appArn" => appArn, "appVersion" => appVersion),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_app_version_resources_resolution_status(app_arn, app_version)
    describe_app_version_resources_resolution_status(app_arn, app_version, params::Dict{String,<:Any})

Returns the resolution status for the specified resolution identifier for an application
version. If resolutionId is not specified, the current resolution status is returned.

# Arguments
- `app_arn`: Amazon Resource Name (ARN) of the Resilience Hub application. The format for
  this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For more information
  about ARNs, see  Amazon Resource Names (ARNs) in the Amazon Web Services General Reference
  guide.
- `app_version`: The version of the application.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"resolutionId"`: The identifier for a specific resolution.
"""
function describe_app_version_resources_resolution_status(
    appArn, appVersion; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "POST",
        "/describe-app-version-resources-resolution-status",
        Dict{String,Any}("appArn" => appArn, "appVersion" => appVersion);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_app_version_resources_resolution_status(
    appArn,
    appVersion,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return resiliencehub(
        "POST",
        "/describe-app-version-resources-resolution-status",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("appArn" => appArn, "appVersion" => appVersion),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_app_version_template(app_arn, app_version)
    describe_app_version_template(app_arn, app_version, params::Dict{String,<:Any})

Describes details about an Resilience Hub application.

# Arguments
- `app_arn`: Amazon Resource Name (ARN) of the Resilience Hub application. The format for
  this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For more information
  about ARNs, see  Amazon Resource Names (ARNs) in the Amazon Web Services General Reference
  guide.
- `app_version`: The version of the application.

"""
function describe_app_version_template(
    appArn, appVersion; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "POST",
        "/describe-app-version-template",
        Dict{String,Any}("appArn" => appArn, "appVersion" => appVersion);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_app_version_template(
    appArn,
    appVersion,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return resiliencehub(
        "POST",
        "/describe-app-version-template",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("appArn" => appArn, "appVersion" => appVersion),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_draft_app_version_resources_import_status(app_arn)
    describe_draft_app_version_resources_import_status(app_arn, params::Dict{String,<:Any})

Describes the status of importing resources to an application version.  If you get a 404
error with ResourceImportStatusNotFoundAppMetadataException, you must call
importResourcesToDraftAppVersion after creating the application and before calling
describeDraftAppVersionResourcesImportStatus to obtain the status.

# Arguments
- `app_arn`: Amazon Resource Name (ARN) of the Resilience Hub application. The format for
  this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For more information
  about ARNs, see  Amazon Resource Names (ARNs) in the Amazon Web Services General Reference
  guide.

"""
function describe_draft_app_version_resources_import_status(
    appArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "POST",
        "/describe-draft-app-version-resources-import-status",
        Dict{String,Any}("appArn" => appArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_draft_app_version_resources_import_status(
    appArn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "POST",
        "/describe-draft-app-version-resources-import-status",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("appArn" => appArn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_resiliency_policy(policy_arn)
    describe_resiliency_policy(policy_arn, params::Dict{String,<:Any})

Describes a specified resiliency policy for an Resilience Hub application. The returned
policy object includes creation time, data location constraints, the Amazon Resource Name
(ARN) for the policy, tags, tier, and more.

# Arguments
- `policy_arn`: Amazon Resource Name (ARN) of the resiliency policy. The format for this
  ARN is: arn:partition:resiliencehub:region:account:resiliency-policy/policy-id. For more
  information about ARNs, see  Amazon Resource Names (ARNs) in the Amazon Web Services
  General Reference guide.

"""
function describe_resiliency_policy(
    policyArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "POST",
        "/describe-resiliency-policy",
        Dict{String,Any}("policyArn" => policyArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_resiliency_policy(
    policyArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return resiliencehub(
        "POST",
        "/describe-resiliency-policy",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("policyArn" => policyArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    import_resources_to_draft_app_version(app_arn)
    import_resources_to_draft_app_version(app_arn, params::Dict{String,<:Any})

Imports resources to Resilience Hub application draft version from different input sources.
For more information about the input sources supported by Resilience Hub, see Discover the
structure and describe your Resilience Hub application.

# Arguments
- `app_arn`: Amazon Resource Name (ARN) of the Resilience Hub application. The format for
  this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For more information
  about ARNs, see  Amazon Resource Names (ARNs) in the Amazon Web Services General Reference
  guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"eksSources"`: The input sources of the Amazon Elastic Kubernetes Service resources you
  need to import.
- `"importStrategy"`: The import strategy you would like to set to import resources into
  Resilience Hub application.
- `"sourceArns"`: The Amazon Resource Names (ARNs) for the resources.
- `"terraformSources"`:  A list of terraform file s3 URLs you need to import.
"""
function import_resources_to_draft_app_version(
    appArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "POST",
        "/import-resources-to-draft-app-version",
        Dict{String,Any}("appArn" => appArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function import_resources_to_draft_app_version(
    appArn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "POST",
        "/import-resources-to-draft-app-version",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("appArn" => appArn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_alarm_recommendations(assessment_arn)
    list_alarm_recommendations(assessment_arn, params::Dict{String,<:Any})

Lists the alarm recommendations for an Resilience Hub application.

# Arguments
- `assessment_arn`: Amazon Resource Name (ARN) of the assessment. The format for this ARN
  is: arn:partition:resiliencehub:region:account:app-assessment/app-id. For more information
  about ARNs, see  Amazon Resource Names (ARNs) in the Amazon Web Services General Reference
  guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: Maximum number of results to include in the response. If more results
  exist than the specified MaxResults value, a token is included in the response so that the
  remaining results can be retrieved.
- `"nextToken"`: Null, or the token from a previous call to get the next set of results.
"""
function list_alarm_recommendations(
    assessmentArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "POST",
        "/list-alarm-recommendations",
        Dict{String,Any}("assessmentArn" => assessmentArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_alarm_recommendations(
    assessmentArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return resiliencehub(
        "POST",
        "/list-alarm-recommendations",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("assessmentArn" => assessmentArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_app_assessment_compliance_drifts(assessment_arn)
    list_app_assessment_compliance_drifts(assessment_arn, params::Dict{String,<:Any})

List of compliance drifts that were detected while running an assessment.

# Arguments
- `assessment_arn`: Amazon Resource Name (ARN) of the assessment. The format for this ARN
  is: arn:partition:resiliencehub:region:account:app-assessment/app-id. For more information
  about ARNs, see  Amazon Resource Names (ARNs) in the Amazon Web Services General Reference
  guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: Indicates the maximum number of applications requested.
- `"nextToken"`: Indicates the unique token number of the next application to be checked
  for compliance and regulatory requirements from the list of applications.
"""
function list_app_assessment_compliance_drifts(
    assessmentArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "POST",
        "/list-app-assessment-compliance-drifts",
        Dict{String,Any}("assessmentArn" => assessmentArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_app_assessment_compliance_drifts(
    assessmentArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return resiliencehub(
        "POST",
        "/list-app-assessment-compliance-drifts",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("assessmentArn" => assessmentArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_app_assessment_resource_drifts(assessment_arn)
    list_app_assessment_resource_drifts(assessment_arn, params::Dict{String,<:Any})

Indicates the list of resource drifts that were detected while running an assessment.

# Arguments
- `assessment_arn`: Amazon Resource Name (ARN) of the assessment. The format for this ARN
  is: arn:partition:resiliencehub:region:account:app-assessment/app-id. For more information
  about ARNs, see  Amazon Resource Names (ARNs) in the Amazon Web Services General Reference
  guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: Indicates the maximum number of drift results to include in the response.
  If more results exist than the specified MaxResults value, a token is included in the
  response so that the remaining results can be retrieved.
- `"nextToken"`: Null, or the token from a previous call to get the next set of results.
"""
function list_app_assessment_resource_drifts(
    assessmentArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "POST",
        "/list-app-assessment-resource-drifts",
        Dict{String,Any}("assessmentArn" => assessmentArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_app_assessment_resource_drifts(
    assessmentArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return resiliencehub(
        "POST",
        "/list-app-assessment-resource-drifts",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("assessmentArn" => assessmentArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_app_assessments()
    list_app_assessments(params::Dict{String,<:Any})

Lists the assessments for an Resilience Hub application. You can use request parameters to
refine the results for the response object.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"appArn"`: Amazon Resource Name (ARN) of the Resilience Hub application. The format for
  this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For more information
  about ARNs, see  Amazon Resource Names (ARNs) in the Amazon Web Services General Reference
  guide.
- `"assessmentName"`: The name for the assessment.
- `"assessmentStatus"`: The current status of the assessment for the resiliency policy.
- `"complianceStatus"`: The current status of compliance for the resiliency policy.
- `"invoker"`: Specifies the entity that invoked a specific assessment, either a User or
  the System.
- `"maxResults"`: Maximum number of results to include in the response. If more results
  exist than the specified MaxResults value, a token is included in the response so that the
  remaining results can be retrieved.
- `"nextToken"`: Null, or the token from a previous call to get the next set of results.
- `"reverseOrder"`: The default is to sort by ascending startTime. To sort by descending
  startTime, set reverseOrder to true.
"""
function list_app_assessments(; aws_config::AbstractAWSConfig=current_aws_config())
    return resiliencehub(
        "GET",
        "/list-app-assessments";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_app_assessments(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "GET",
        "/list-app-assessments",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_app_component_compliances(assessment_arn)
    list_app_component_compliances(assessment_arn, params::Dict{String,<:Any})

Lists the compliances for an Resilience Hub Application Component.

# Arguments
- `assessment_arn`: Amazon Resource Name (ARN) of the assessment. The format for this ARN
  is: arn:partition:resiliencehub:region:account:app-assessment/app-id. For more information
  about ARNs, see  Amazon Resource Names (ARNs) in the Amazon Web Services General Reference
  guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: Maximum number of results to include in the response. If more results
  exist than the specified MaxResults value, a token is included in the response so that the
  remaining results can be retrieved.
- `"nextToken"`: Null, or the token from a previous call to get the next set of results.
"""
function list_app_component_compliances(
    assessmentArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "POST",
        "/list-app-component-compliances",
        Dict{String,Any}("assessmentArn" => assessmentArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_app_component_compliances(
    assessmentArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return resiliencehub(
        "POST",
        "/list-app-component-compliances",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("assessmentArn" => assessmentArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_app_component_recommendations(assessment_arn)
    list_app_component_recommendations(assessment_arn, params::Dict{String,<:Any})

Lists the recommendations for an Resilience Hub Application Component.

# Arguments
- `assessment_arn`: Amazon Resource Name (ARN) of the assessment. The format for this ARN
  is: arn:partition:resiliencehub:region:account:app-assessment/app-id. For more information
  about ARNs, see  Amazon Resource Names (ARNs) in the Amazon Web Services General Reference
  guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: Maximum number of results to include in the response. If more results
  exist than the specified MaxResults value, a token is included in the response so that the
  remaining results can be retrieved.
- `"nextToken"`: Null, or the token from a previous call to get the next set of results.
"""
function list_app_component_recommendations(
    assessmentArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "POST",
        "/list-app-component-recommendations",
        Dict{String,Any}("assessmentArn" => assessmentArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_app_component_recommendations(
    assessmentArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return resiliencehub(
        "POST",
        "/list-app-component-recommendations",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("assessmentArn" => assessmentArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_app_input_sources(app_arn, app_version)
    list_app_input_sources(app_arn, app_version, params::Dict{String,<:Any})

Lists all the input sources of the Resilience Hub application. For more information about
the input sources supported by Resilience Hub, see Discover the structure and describe your
Resilience Hub application.

# Arguments
- `app_arn`: Amazon Resource Name (ARN) of the Resilience Hub application. The format for
  this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For more information
  about ARNs, see  Amazon Resource Names (ARNs) in the Amazon Web Services General Reference
  guide.
- `app_version`: Resilience Hub application version.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: Maximum number of input sources to be displayed per Resilience Hub
  application.
- `"nextToken"`: Null, or the token from a previous call to get the next set of results.
"""
function list_app_input_sources(
    appArn, appVersion; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "POST",
        "/list-app-input-sources",
        Dict{String,Any}("appArn" => appArn, "appVersion" => appVersion);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_app_input_sources(
    appArn,
    appVersion,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return resiliencehub(
        "POST",
        "/list-app-input-sources",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("appArn" => appArn, "appVersion" => appVersion),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_app_version_app_components(app_arn, app_version)
    list_app_version_app_components(app_arn, app_version, params::Dict{String,<:Any})

Lists all the Application Components in the Resilience Hub application.

# Arguments
- `app_arn`: Amazon Resource Name (ARN) of the Resilience Hub application. The format for
  this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For more information
  about ARNs, see  Amazon Resource Names (ARNs) in the Amazon Web Services General Reference
  guide.
- `app_version`: Version of the Application Component.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: Maximum number of Application Components to be displayed per Resilience
  Hub application version.
- `"nextToken"`: Null, or the token from a previous call to get the next set of results.
"""
function list_app_version_app_components(
    appArn, appVersion; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "POST",
        "/list-app-version-app-components",
        Dict{String,Any}("appArn" => appArn, "appVersion" => appVersion);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_app_version_app_components(
    appArn,
    appVersion,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return resiliencehub(
        "POST",
        "/list-app-version-app-components",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("appArn" => appArn, "appVersion" => appVersion),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_app_version_resource_mappings(app_arn, app_version)
    list_app_version_resource_mappings(app_arn, app_version, params::Dict{String,<:Any})

Lists how the resources in an application version are mapped/sourced from. Mappings can be
physical resource identifiers, CloudFormation stacks, resource-groups, or an application
registry app.

# Arguments
- `app_arn`: Amazon Resource Name (ARN) of the Resilience Hub application. The format for
  this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For more information
  about ARNs, see  Amazon Resource Names (ARNs) in the Amazon Web Services General Reference
  guide.
- `app_version`: The version of the application.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: Maximum number of results to include in the response. If more results
  exist than the specified MaxResults value, a token is included in the response so that the
  remaining results can be retrieved.
- `"nextToken"`: Null, or the token from a previous call to get the next set of results.
"""
function list_app_version_resource_mappings(
    appArn, appVersion; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "POST",
        "/list-app-version-resource-mappings",
        Dict{String,Any}("appArn" => appArn, "appVersion" => appVersion);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_app_version_resource_mappings(
    appArn,
    appVersion,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return resiliencehub(
        "POST",
        "/list-app-version-resource-mappings",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("appArn" => appArn, "appVersion" => appVersion),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_app_version_resources(app_arn, app_version)
    list_app_version_resources(app_arn, app_version, params::Dict{String,<:Any})

Lists all the resources in an Resilience Hub application.

# Arguments
- `app_arn`: Amazon Resource Name (ARN) of the Resilience Hub application. The format for
  this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For more information
  about ARNs, see  Amazon Resource Names (ARNs) in the Amazon Web Services General Reference
  guide.
- `app_version`: The version of the application.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: Maximum number of results to include in the response. If more results
  exist than the specified MaxResults value, a token is included in the response so that the
  remaining results can be retrieved.
- `"nextToken"`: Null, or the token from a previous call to get the next set of results.
- `"resolutionId"`: The identifier for a specific resolution.
"""
function list_app_version_resources(
    appArn, appVersion; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "POST",
        "/list-app-version-resources",
        Dict{String,Any}("appArn" => appArn, "appVersion" => appVersion);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_app_version_resources(
    appArn,
    appVersion,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return resiliencehub(
        "POST",
        "/list-app-version-resources",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("appArn" => appArn, "appVersion" => appVersion),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_app_versions(app_arn)
    list_app_versions(app_arn, params::Dict{String,<:Any})

Lists the different versions for the Resilience Hub applications.

# Arguments
- `app_arn`: Amazon Resource Name (ARN) of the Resilience Hub application. The format for
  this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For more information
  about ARNs, see  Amazon Resource Names (ARNs) in the Amazon Web Services General Reference
  guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"endTime"`: Upper limit of the time range to filter the application versions.
- `"maxResults"`: Maximum number of results to include in the response. If more results
  exist than the specified MaxResults value, a token is included in the response so that the
  remaining results can be retrieved.
- `"nextToken"`: Null, or the token from a previous call to get the next set of results.
- `"startTime"`: Lower limit of the time range to filter the application versions.
"""
function list_app_versions(appArn; aws_config::AbstractAWSConfig=current_aws_config())
    return resiliencehub(
        "POST",
        "/list-app-versions",
        Dict{String,Any}("appArn" => appArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_app_versions(
    appArn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "POST",
        "/list-app-versions",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("appArn" => appArn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_apps()
    list_apps(params::Dict{String,<:Any})

Lists your Resilience Hub applications.  You can filter applications using only one filter
at a time or without using any filter. If you try to filter applications using multiple
filters, you will get the following error:  An error occurred (ValidationException) when
calling the ListApps operation: Only one filter is supported for this operation.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"appArn"`: Amazon Resource Name (ARN) of the Resilience Hub application. The format for
  this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For more information
  about ARNs, see  Amazon Resource Names (ARNs) in the Amazon Web Services General Reference
  guide.
- `"fromLastAssessmentTime"`: Indicates the lower limit of the range that is used to filter
  applications based on their last assessment times.
- `"maxResults"`: Maximum number of results to include in the response. If more results
  exist than the specified MaxResults value, a token is included in the response so that the
  remaining results can be retrieved.
- `"name"`: The name for the one of the listed applications.
- `"nextToken"`: Null, or the token from a previous call to get the next set of results.
- `"reverseOrder"`: The application list is sorted based on the values of
  lastAppComplianceEvaluationTime field. By default, application list is sorted in ascending
  order. To sort the appliation list in descending order, set this field to True.
- `"toLastAssessmentTime"`: Indicates the upper limit of the range that is used to filter
  the applications based on their last assessment times.
"""
function list_apps(; aws_config::AbstractAWSConfig=current_aws_config())
    return resiliencehub(
        "GET", "/list-apps"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_apps(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "GET", "/list-apps", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_recommendation_templates()
    list_recommendation_templates(params::Dict{String,<:Any})

Lists the recommendation templates for the Resilience Hub applications.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"assessmentArn"`: Amazon Resource Name (ARN) of the assessment. The format for this ARN
  is: arn:partition:resiliencehub:region:account:app-assessment/app-id. For more information
  about ARNs, see  Amazon Resource Names (ARNs) in the Amazon Web Services General Reference
  guide.
- `"maxResults"`: Maximum number of results to include in the response. If more results
  exist than the specified MaxResults value, a token is included in the response so that the
  remaining results can be retrieved.
- `"name"`: The name for one of the listed recommendation templates.
- `"nextToken"`: Null, or the token from a previous call to get the next set of results.
- `"recommendationTemplateArn"`: The Amazon Resource Name (ARN) for a recommendation
  template.
- `"reverseOrder"`: The default is to sort by ascending startTime. To sort by descending
  startTime, set reverseOrder to true.
- `"status"`: Status of the action.
"""
function list_recommendation_templates(; aws_config::AbstractAWSConfig=current_aws_config())
    return resiliencehub(
        "GET",
        "/list-recommendation-templates";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_recommendation_templates(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "GET",
        "/list-recommendation-templates",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_resiliency_policies()
    list_resiliency_policies(params::Dict{String,<:Any})

Lists the resiliency policies for the Resilience Hub applications.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: Maximum number of results to include in the response. If more results
  exist than the specified MaxResults value, a token is included in the response so that the
  remaining results can be retrieved.
- `"nextToken"`: Null, or the token from a previous call to get the next set of results.
- `"policyName"`: The name of the policy
"""
function list_resiliency_policies(; aws_config::AbstractAWSConfig=current_aws_config())
    return resiliencehub(
        "GET",
        "/list-resiliency-policies";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_resiliency_policies(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "GET",
        "/list-resiliency-policies",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_sop_recommendations(assessment_arn)
    list_sop_recommendations(assessment_arn, params::Dict{String,<:Any})

Lists the standard operating procedure (SOP) recommendations for the Resilience Hub
applications.

# Arguments
- `assessment_arn`: Amazon Resource Name (ARN) of the assessment. The format for this ARN
  is: arn:partition:resiliencehub:region:account:app-assessment/app-id. For more information
  about ARNs, see  Amazon Resource Names (ARNs) in the Amazon Web Services General Reference
  guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: Maximum number of results to include in the response. If more results
  exist than the specified MaxResults value, a token is included in the response so that the
  remaining results can be retrieved.
- `"nextToken"`: Null, or the token from a previous call to get the next set of results.
"""
function list_sop_recommendations(
    assessmentArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "POST",
        "/list-sop-recommendations",
        Dict{String,Any}("assessmentArn" => assessmentArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_sop_recommendations(
    assessmentArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return resiliencehub(
        "POST",
        "/list-sop-recommendations",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("assessmentArn" => assessmentArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_suggested_resiliency_policies()
    list_suggested_resiliency_policies(params::Dict{String,<:Any})

Lists the suggested resiliency policies for the Resilience Hub applications.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: Maximum number of results to include in the response. If more results
  exist than the specified MaxResults value, a token is included in the response so that the
  remaining results can be retrieved.
- `"nextToken"`: Null, or the token from a previous call to get the next set of results.
"""
function list_suggested_resiliency_policies(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "GET",
        "/list-suggested-resiliency-policies";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_suggested_resiliency_policies(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "GET",
        "/list-suggested-resiliency-policies",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Lists the tags for your resources in your Resilience Hub applications.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) for a specific resource in your Resilience
  Hub application.

"""
function list_tags_for_resource(
    resourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "GET",
        "/tags/$(resourceArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return resiliencehub(
        "GET",
        "/tags/$(resourceArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_test_recommendations(assessment_arn)
    list_test_recommendations(assessment_arn, params::Dict{String,<:Any})

Lists the test recommendations for the Resilience Hub application.

# Arguments
- `assessment_arn`: Amazon Resource Name (ARN) of the assessment. The format for this ARN
  is: arn:partition:resiliencehub:region:account:app-assessment/app-id. For more information
  about ARNs, see  Amazon Resource Names (ARNs) in the Amazon Web Services General Reference
  guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: Maximum number of results to include in the response. If more results
  exist than the specified MaxResults value, a token is included in the response so that the
  remaining results can be retrieved.
- `"nextToken"`: Null, or the token from a previous call to get the next set of results.
"""
function list_test_recommendations(
    assessmentArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "POST",
        "/list-test-recommendations",
        Dict{String,Any}("assessmentArn" => assessmentArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_test_recommendations(
    assessmentArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return resiliencehub(
        "POST",
        "/list-test-recommendations",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("assessmentArn" => assessmentArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_unsupported_app_version_resources(app_arn, app_version)
    list_unsupported_app_version_resources(app_arn, app_version, params::Dict{String,<:Any})

Lists the resources that are not currently supported in Resilience Hub. An unsupported
resource is a resource that exists in the object that was used to create an app, but is not
supported by Resilience Hub.

# Arguments
- `app_arn`: Amazon Resource Name (ARN) of the Resilience Hub application. The format for
  this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For more information
  about ARNs, see  Amazon Resource Names (ARNs) in the Amazon Web Services General Reference
  guide.
- `app_version`: The version of the application.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: Maximum number of results to include in the response. If more results
  exist than the specified MaxResults value, a token is included in the response so that the
  remaining results can be retrieved.
- `"nextToken"`: Null, or the token from a previous call to get the next set of results.
- `"resolutionId"`: The identifier for a specific resolution.
"""
function list_unsupported_app_version_resources(
    appArn, appVersion; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "POST",
        "/list-unsupported-app-version-resources",
        Dict{String,Any}("appArn" => appArn, "appVersion" => appVersion);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_unsupported_app_version_resources(
    appArn,
    appVersion,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return resiliencehub(
        "POST",
        "/list-unsupported-app-version-resources",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("appArn" => appArn, "appVersion" => appVersion),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    publish_app_version(app_arn)
    publish_app_version(app_arn, params::Dict{String,<:Any})

Publishes a new version of a specific Resilience Hub application.

# Arguments
- `app_arn`: Amazon Resource Name (ARN) of the Resilience Hub application. The format for
  this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For more information
  about ARNs, see  Amazon Resource Names (ARNs) in the Amazon Web Services General Reference
  guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"versionName"`: Name of the application version.
"""
function publish_app_version(appArn; aws_config::AbstractAWSConfig=current_aws_config())
    return resiliencehub(
        "POST",
        "/publish-app-version",
        Dict{String,Any}("appArn" => appArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function publish_app_version(
    appArn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "POST",
        "/publish-app-version",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("appArn" => appArn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_draft_app_version_template(app_arn, app_template_body)
    put_draft_app_version_template(app_arn, app_template_body, params::Dict{String,<:Any})

Adds or updates the app template for an Resilience Hub application draft version.

# Arguments
- `app_arn`: Amazon Resource Name (ARN) of the Resilience Hub application. The format for
  this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For more information
  about ARNs, see  Amazon Resource Names (ARNs) in the Amazon Web Services General Reference
  guide.
- `app_template_body`: A JSON string that provides information about your application
  structure. To learn more about the appTemplateBody template, see the sample template
  provided in the Examples section. The appTemplateBody JSON string has the following
  structure:     resources   The list of logical resources that must be included in the
  Resilience Hub application. Type: Array  Don't add the resources that you want to exclude.
  Each resources array item includes the following fields:     logicalResourceId   Logical
  identifier of the resource. Type: Object Each logicalResourceId object includes the
  following fields:    identifier  Identifier of the resource. Type: String
  logicalStackName  The name of the CloudFormation stack this resource belongs to. Type:
  String    resourceGroupName  The name of the resource group this resource belongs to. Type:
  String    terraformSourceName  The name of the Terraform S3 state file this resource
  belongs to. Type: String    eksSourceName  Name of the Amazon Elastic Kubernetes Service
  cluster and namespace this resource belongs to.  This parameter accepts values in
  \"eks-cluster/namespace\" format.  Type: String       type   The type of resource. Type:
  string     name   The name of the resource. Type: String    additionalInfo  Additional
  configuration parameters for an Resilience Hub application. If you want to implement
  additionalInfo through the Resilience Hub console rather than using an API call, see
  Configure the application configuration parameters.  Currently, this parameter accepts a
  key-value mapping (in a string format) of only one failover region and one associated
  account. Key: \"failover-regions\"  Value: \"[{\"region\":\"&lt;REGION&gt;\",
  \"accounts\":[{\"id\":\"&lt;ACCOUNT_ID&gt;\"}]}]\"         appComponents   List of
  Application Components that this resource belongs to. If an Application Component is not
  part of the Resilience Hub application, it will be added. Type: Array Each appComponents
  array item includes the following fields:    name  Name of the Application Component. Type:
  String    type  Type of Application Component. For more information about the types of
  Application Component, see Grouping resources in an AppComponent. Type: String
  resourceNames  The list of included resources that are assigned to the Application
  Component. Type: Array of strings    additionalInfo  Additional configuration parameters
  for an Resilience Hub application. If you want to implement additionalInfo through the
  Resilience Hub console rather than using an API call, see Configure the application
  configuration parameters.  Currently, this parameter accepts a key-value mapping (in a
  string format) of only one failover region and one associated account. Key:
  \"failover-regions\"  Value: \"[{\"region\":\"&lt;REGION&gt;\",
  \"accounts\":[{\"id\":\"&lt;ACCOUNT_ID&gt;\"}]}]\"         excludedResources   The list of
  logical resource identifiers to be excluded from the application. Type: Array  Don't add
  the resources that you want to include.  Each excludedResources array item includes the
  following fields:     logicalResourceIds   Logical identifier of the resource. Type: Object
   You can configure only one of the following fields:    logicalStackName
  resourceGroupName     terraformSourceName     eksSourceName     Each logicalResourceIds
  object includes the following fields:    identifier  Identifier of the resource. Type:
  String    logicalStackName  The name of the CloudFormation stack this resource belongs to.
  Type: String    resourceGroupName  The name of the resource group this resource belongs to.
  Type: String    terraformSourceName  The name of the Terraform S3 state file this resource
  belongs to. Type: String    eksSourceName  Name of the Amazon Elastic Kubernetes Service
  cluster and namespace this resource belongs to.  This parameter accepts values in
  \"eks-cluster/namespace\" format.  Type: String         version   Resilience Hub
  application version.    additionalInfo  Additional configuration parameters for an
  Resilience Hub application. If you want to implement additionalInfo through the Resilience
  Hub console rather than using an API call, see Configure the application configuration
  parameters.  Currently, this parameter accepts a key-value mapping (in a string format) of
  only one failover region and one associated account. Key: \"failover-regions\"  Value:
  \"[{\"region\":\"&lt;REGION&gt;\", \"accounts\":[{\"id\":\"&lt;ACCOUNT_ID&gt;\"}]}]\"

"""
function put_draft_app_version_template(
    appArn, appTemplateBody; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "POST",
        "/put-draft-app-version-template",
        Dict{String,Any}("appArn" => appArn, "appTemplateBody" => appTemplateBody);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_draft_app_version_template(
    appArn,
    appTemplateBody,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return resiliencehub(
        "POST",
        "/put-draft-app-version-template",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("appArn" => appArn, "appTemplateBody" => appTemplateBody),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    remove_draft_app_version_resource_mappings(app_arn)
    remove_draft_app_version_resource_mappings(app_arn, params::Dict{String,<:Any})

Removes resource mappings from a draft application version.

# Arguments
- `app_arn`: Amazon Resource Name (ARN) of the Resilience Hub application. The format for
  this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For more information
  about ARNs, see  Amazon Resource Names (ARNs) in the Amazon Web Services General Reference
  guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"appRegistryAppNames"`: The names of the registered applications you want to remove from
  the resource mappings.
- `"eksSourceNames"`: The names of the Amazon Elastic Kubernetes Service clusters and
  namespaces you want to remove from the resource mappings.  This parameter accepts values in
  \"eks-cluster/namespace\" format.
- `"logicalStackNames"`: The names of the CloudFormation stacks you want to remove from the
  resource mappings.
- `"resourceGroupNames"`: The names of the resource groups you want to remove from the
  resource mappings.
- `"resourceNames"`: The names of the resources you want to remove from the resource
  mappings.
- `"terraformSourceNames"`: The names of the Terraform sources you want to remove from the
  resource mappings.
"""
function remove_draft_app_version_resource_mappings(
    appArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "POST",
        "/remove-draft-app-version-resource-mappings",
        Dict{String,Any}("appArn" => appArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function remove_draft_app_version_resource_mappings(
    appArn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "POST",
        "/remove-draft-app-version-resource-mappings",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("appArn" => appArn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    resolve_app_version_resources(app_arn, app_version)
    resolve_app_version_resources(app_arn, app_version, params::Dict{String,<:Any})

Resolves the resources for an application version.

# Arguments
- `app_arn`: Amazon Resource Name (ARN) of the Resilience Hub application. The format for
  this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For more information
  about ARNs, see  Amazon Resource Names (ARNs) in the Amazon Web Services General Reference
  guide.
- `app_version`: The version of the application.

"""
function resolve_app_version_resources(
    appArn, appVersion; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "POST",
        "/resolve-app-version-resources",
        Dict{String,Any}("appArn" => appArn, "appVersion" => appVersion);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function resolve_app_version_resources(
    appArn,
    appVersion,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return resiliencehub(
        "POST",
        "/resolve-app-version-resources",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("appArn" => appArn, "appVersion" => appVersion),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_app_assessment(app_arn, app_version, assessment_name)
    start_app_assessment(app_arn, app_version, assessment_name, params::Dict{String,<:Any})

Creates a new application assessment for an application.

# Arguments
- `app_arn`: Amazon Resource Name (ARN) of the Resilience Hub application. The format for
  this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For more information
  about ARNs, see  Amazon Resource Names (ARNs) in the Amazon Web Services General Reference
  guide.
- `app_version`: The version of the application.
- `assessment_name`: The name for the assessment.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: Used for an idempotency token. A client token is a unique,
  case-sensitive string of up to 64 ASCII characters. You should not reuse the same client
  token for other API requests.
- `"tags"`: Tags assigned to the resource. A tag is a label that you assign to an Amazon
  Web Services resource. Each tag consists of a key/value pair.
"""
function start_app_assessment(
    appArn, appVersion, assessmentName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "POST",
        "/start-app-assessment",
        Dict{String,Any}(
            "appArn" => appArn,
            "appVersion" => appVersion,
            "assessmentName" => assessmentName,
            "clientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_app_assessment(
    appArn,
    appVersion,
    assessmentName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return resiliencehub(
        "POST",
        "/start-app-assessment",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "appArn" => appArn,
                    "appVersion" => appVersion,
                    "assessmentName" => assessmentName,
                    "clientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Applies one or more tags to a resource.

# Arguments
- `resource_arn`: Amazon Resource Name (ARN) of the resource.
- `tags`: The tags to assign to the resource. Each tag consists of a key/value pair.

"""
function tag_resource(resourceArn, tags; aws_config::AbstractAWSConfig=current_aws_config())
    return resiliencehub(
        "POST",
        "/tags/$(resourceArn)",
        Dict{String,Any}("tags" => tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    resourceArn,
    tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return resiliencehub(
        "POST",
        "/tags/$(resourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tags" => tags), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Removes one or more tags from a resource.

# Arguments
- `resource_arn`: Amazon Resource Name (ARN) of the resource.
- `tag_keys`: The keys of the tags you want to remove.

"""
function untag_resource(
    resourceArn, tagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "DELETE",
        "/tags/$(resourceArn)",
        Dict{String,Any}("tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    resourceArn,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return resiliencehub(
        "DELETE",
        "/tags/$(resourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tagKeys" => tagKeys), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_app(app_arn)
    update_app(app_arn, params::Dict{String,<:Any})

Updates an application.

# Arguments
- `app_arn`: Amazon Resource Name (ARN) of the Resilience Hub application. The format for
  this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For more information
  about ARNs, see  Amazon Resource Names (ARNs) in the Amazon Web Services General Reference
  guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"assessmentSchedule"`:  Assessment execution schedule with 'Daily' or 'Disabled' values.
- `"clearResiliencyPolicyArn"`: Specifies if the resiliency policy ARN should be cleared.
- `"description"`: The optional description for an app.
- `"eventSubscriptions"`: The list of events you would like to subscribe and get
  notification for. Currently, Resilience Hub supports notifications only for Drift detected
  and Scheduled assessment failure events.
- `"permissionModel"`: Defines the roles and credentials that Resilience Hub would use
  while creating an application, importing its resources, and running an assessment.
- `"policyArn"`: Amazon Resource Name (ARN) of the resiliency policy. The format for this
  ARN is: arn:partition:resiliencehub:region:account:resiliency-policy/policy-id. For more
  information about ARNs, see  Amazon Resource Names (ARNs) in the Amazon Web Services
  General Reference guide.
"""
function update_app(appArn; aws_config::AbstractAWSConfig=current_aws_config())
    return resiliencehub(
        "POST",
        "/update-app",
        Dict{String,Any}("appArn" => appArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_app(
    appArn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "POST",
        "/update-app",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("appArn" => appArn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_app_version(app_arn)
    update_app_version(app_arn, params::Dict{String,<:Any})

Updates the Resilience Hub application version.  This API updates the Resilience Hub
application draft version. To use this information for running resiliency assessments, you
must publish the Resilience Hub application using the PublishAppVersion API.

# Arguments
- `app_arn`: Amazon Resource Name (ARN) of the Resilience Hub application. The format for
  this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For more information
  about ARNs, see  Amazon Resource Names (ARNs) in the Amazon Web Services General Reference
  guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"additionalInfo"`: Additional configuration parameters for an Resilience Hub
  application. If you want to implement additionalInfo through the Resilience Hub console
  rather than using an API call, see Configure the application configuration parameters.
  Currently, this parameter accepts a key-value mapping (in a string format) of only one
  failover region and one associated account. Key: \"failover-regions\"  Value:
  \"[{\"region\":\"&lt;REGION&gt;\", \"accounts\":[{\"id\":\"&lt;ACCOUNT_ID&gt;\"}]}]\"
"""
function update_app_version(appArn; aws_config::AbstractAWSConfig=current_aws_config())
    return resiliencehub(
        "POST",
        "/update-app-version",
        Dict{String,Any}("appArn" => appArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_app_version(
    appArn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "POST",
        "/update-app-version",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("appArn" => appArn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_app_version_app_component(app_arn, id)
    update_app_version_app_component(app_arn, id, params::Dict{String,<:Any})

Updates an existing Application Component in the Resilience Hub application.  This API
updates the Resilience Hub application draft version. To use this Application Component for
running assessments, you must publish the Resilience Hub application using the
PublishAppVersion API.

# Arguments
- `app_arn`: Amazon Resource Name (ARN) of the Resilience Hub application. The format for
  this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For more information
  about ARNs, see  Amazon Resource Names (ARNs) in the Amazon Web Services General Reference
  guide.
- `id`: Identifier of the Application Component.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"additionalInfo"`: Currently, there is no supported additional information for
  Application Components.
- `"name"`: Name of the Application Component.
- `"type"`: Type of Application Component. For more information about the types of
  Application Component, see Grouping resources in an AppComponent.
"""
function update_app_version_app_component(
    appArn, id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "POST",
        "/update-app-version-app-component",
        Dict{String,Any}("appArn" => appArn, "id" => id);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_app_version_app_component(
    appArn,
    id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return resiliencehub(
        "POST",
        "/update-app-version-app-component",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("appArn" => appArn, "id" => id), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_app_version_resource(app_arn)
    update_app_version_resource(app_arn, params::Dict{String,<:Any})

Updates the resource details in the Resilience Hub application.    This action has no
effect outside Resilience Hub.   This API updates the Resilience Hub application draft
version. To use this resource for running resiliency assessments, you must publish the
Resilience Hub application using the PublishAppVersion API.   To update application version
with new physicalResourceID, you must call ResolveAppVersionResources API.

# Arguments
- `app_arn`: Amazon Resource Name (ARN) of the Resilience Hub application. The format for
  this ARN is: arn:partition:resiliencehub:region:account:app/app-id. For more information
  about ARNs, see  Amazon Resource Names (ARNs) in the Amazon Web Services General Reference
  guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"additionalInfo"`: Currently, there is no supported additional information for resources.
- `"appComponents"`: List of Application Components that this resource belongs to. If an
  Application Component is not part of the Resilience Hub application, it will be added.
- `"awsAccountId"`: Amazon Web Services account that owns the physical resource.
- `"awsRegion"`: Amazon Web Services region that owns the physical resource.
- `"excluded"`: Indicates if a resource is excluded from an Resilience Hub application.
  You can exclude only imported resources from an Resilience Hub application.
- `"logicalResourceId"`: Logical identifier of the resource.
- `"physicalResourceId"`: Physical identifier of the resource.
- `"resourceName"`: Name of the resource.
- `"resourceType"`: Type of resource.
"""
function update_app_version_resource(
    appArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "POST",
        "/update-app-version-resource",
        Dict{String,Any}("appArn" => appArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_app_version_resource(
    appArn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "POST",
        "/update-app-version-resource",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("appArn" => appArn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_resiliency_policy(policy_arn)
    update_resiliency_policy(policy_arn, params::Dict{String,<:Any})

Updates a resiliency policy.  Resilience Hub allows you to provide a value of zero for
rtoInSecs and rpoInSecs of your resiliency policy. But, while assessing your application,
the lowest possible assessment result is near zero. Hence, if you provide value zero for
rtoInSecs and rpoInSecs, the estimated workload RTO and estimated workload RPO result will
be near zero and the Compliance status for your application will be set to Policy breached.

# Arguments
- `policy_arn`: Amazon Resource Name (ARN) of the resiliency policy. The format for this
  ARN is: arn:partition:resiliencehub:region:account:resiliency-policy/policy-id. For more
  information about ARNs, see  Amazon Resource Names (ARNs) in the Amazon Web Services
  General Reference guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dataLocationConstraint"`: Specifies a high-level geographical location constraint for
  where your resilience policy data can be stored.
- `"policy"`: The type of resiliency policy to be created, including the recovery time
  objective (RTO) and recovery point objective (RPO) in seconds.
- `"policyDescription"`: The description for the policy.
- `"policyName"`: The name of the policy
- `"tier"`: The tier for this resiliency policy, ranging from the highest severity
  (MissionCritical) to lowest (NonCritical).
"""
function update_resiliency_policy(
    policyArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resiliencehub(
        "POST",
        "/update-resiliency-policy",
        Dict{String,Any}("policyArn" => policyArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_resiliency_policy(
    policyArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return resiliencehub(
        "POST",
        "/update-resiliency-policy",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("policyArn" => policyArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
