# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: rolesanywhere
using AWS.Compat
using AWS.UUIDs

"""
    create_profile(name, role_arns)
    create_profile(name, role_arns, params::Dict{String,<:Any})

Creates a profile, a list of the roles that Roles Anywhere service is trusted to assume.
You use profiles to intersect permissions with IAM managed policies.  Required permissions:
 rolesanywhere:CreateProfile.

# Arguments
- `name`: The name of the profile.
- `role_arns`: A list of IAM roles that this profile can assume in a temporary credential
  request.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"durationSeconds"`:  Used to determine how long sessions vended using this profile are
  valid for. See the Expiration section of the CreateSession API documentation page for more
  details. In requests, if this value is not provided, the default value will be 3600.
- `"enabled"`: Specifies whether the profile is enabled.
- `"managedPolicyArns"`: A list of managed policy ARNs that apply to the vended session
  credentials.
- `"requireInstanceProperties"`: Specifies whether instance properties are required in
  temporary credential requests with this profile.
- `"sessionPolicy"`: A session policy that applies to the trust boundary of the vended
  session credentials.
- `"tags"`: The tags to attach to the profile.
"""
function create_profile(name, roleArns; aws_config::AbstractAWSConfig=current_aws_config())
    return rolesanywhere(
        "POST",
        "/profiles",
        Dict{String,Any}("name" => name, "roleArns" => roleArns);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_profile(
    name,
    roleArns,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rolesanywhere(
        "POST",
        "/profiles",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("name" => name, "roleArns" => roleArns), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_trust_anchor(name, source)
    create_trust_anchor(name, source, params::Dict{String,<:Any})

Creates a trust anchor to establish trust between IAM Roles Anywhere and your certificate
authority (CA). You can define a trust anchor as a reference to an Private Certificate
Authority (Private CA) or by uploading a CA certificate. Your Amazon Web Services workloads
can authenticate with the trust anchor using certificates issued by the CA in exchange for
temporary Amazon Web Services credentials.  Required permissions:
rolesanywhere:CreateTrustAnchor.

# Arguments
- `name`: The name of the trust anchor.
- `source`: The trust anchor type and its related certificate data.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"enabled"`: Specifies whether the trust anchor is enabled.
- `"notificationSettings"`: A list of notification settings to be associated to the trust
  anchor.
- `"tags"`: The tags to attach to the trust anchor.
"""
function create_trust_anchor(
    name, source; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rolesanywhere(
        "POST",
        "/trustanchors",
        Dict{String,Any}("name" => name, "source" => source);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_trust_anchor(
    name,
    source,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rolesanywhere(
        "POST",
        "/trustanchors",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("name" => name, "source" => source), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_attribute_mapping(certificate_field, profile_id)
    delete_attribute_mapping(certificate_field, profile_id, params::Dict{String,<:Any})

Delete an entry from the attribute mapping rules enforced by a given profile.

# Arguments
- `certificate_field`: Fields (x509Subject, x509Issuer and x509SAN) within X.509
  certificates.
- `profile_id`: The unique identifier of the profile.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"specifiers"`: A list of specifiers of a certificate field; for example, CN, OU, UID
  from a Subject.
"""
function delete_attribute_mapping(
    certificateField, profileId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rolesanywhere(
        "DELETE",
        "/profiles/$(profileId)/mappings",
        Dict{String,Any}("certificateField" => certificateField);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_attribute_mapping(
    certificateField,
    profileId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rolesanywhere(
        "DELETE",
        "/profiles/$(profileId)/mappings",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("certificateField" => certificateField), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_crl(crl_id)
    delete_crl(crl_id, params::Dict{String,<:Any})

Deletes a certificate revocation list (CRL).  Required permissions:
rolesanywhere:DeleteCrl.

# Arguments
- `crl_id`: The unique identifier of the certificate revocation list (CRL).

"""
function delete_crl(crlId; aws_config::AbstractAWSConfig=current_aws_config())
    return rolesanywhere(
        "DELETE", "/crl/$(crlId)"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function delete_crl(
    crlId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rolesanywhere(
        "DELETE",
        "/crl/$(crlId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_profile(profile_id)
    delete_profile(profile_id, params::Dict{String,<:Any})

Deletes a profile.  Required permissions:  rolesanywhere:DeleteProfile.

# Arguments
- `profile_id`: The unique identifier of the profile.

"""
function delete_profile(profileId; aws_config::AbstractAWSConfig=current_aws_config())
    return rolesanywhere(
        "DELETE",
        "/profile/$(profileId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_profile(
    profileId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rolesanywhere(
        "DELETE",
        "/profile/$(profileId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_trust_anchor(trust_anchor_id)
    delete_trust_anchor(trust_anchor_id, params::Dict{String,<:Any})

Deletes a trust anchor.  Required permissions:  rolesanywhere:DeleteTrustAnchor.

# Arguments
- `trust_anchor_id`: The unique identifier of the trust anchor.

"""
function delete_trust_anchor(
    trustAnchorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rolesanywhere(
        "DELETE",
        "/trustanchor/$(trustAnchorId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_trust_anchor(
    trustAnchorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rolesanywhere(
        "DELETE",
        "/trustanchor/$(trustAnchorId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disable_crl(crl_id)
    disable_crl(crl_id, params::Dict{String,<:Any})

Disables a certificate revocation list (CRL).  Required permissions:
rolesanywhere:DisableCrl.

# Arguments
- `crl_id`: The unique identifier of the certificate revocation list (CRL).

"""
function disable_crl(crlId; aws_config::AbstractAWSConfig=current_aws_config())
    return rolesanywhere(
        "POST",
        "/crl/$(crlId)/disable";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disable_crl(
    crlId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rolesanywhere(
        "POST",
        "/crl/$(crlId)/disable",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disable_profile(profile_id)
    disable_profile(profile_id, params::Dict{String,<:Any})

Disables a profile. When disabled, temporary credential requests with this profile fail.
Required permissions:  rolesanywhere:DisableProfile.

# Arguments
- `profile_id`: The unique identifier of the profile.

"""
function disable_profile(profileId; aws_config::AbstractAWSConfig=current_aws_config())
    return rolesanywhere(
        "POST",
        "/profile/$(profileId)/disable";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disable_profile(
    profileId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rolesanywhere(
        "POST",
        "/profile/$(profileId)/disable",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disable_trust_anchor(trust_anchor_id)
    disable_trust_anchor(trust_anchor_id, params::Dict{String,<:Any})

Disables a trust anchor. When disabled, temporary credential requests specifying this trust
anchor are unauthorized.  Required permissions:  rolesanywhere:DisableTrustAnchor.

# Arguments
- `trust_anchor_id`: The unique identifier of the trust anchor.

"""
function disable_trust_anchor(
    trustAnchorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rolesanywhere(
        "POST",
        "/trustanchor/$(trustAnchorId)/disable";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disable_trust_anchor(
    trustAnchorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rolesanywhere(
        "POST",
        "/trustanchor/$(trustAnchorId)/disable",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    enable_crl(crl_id)
    enable_crl(crl_id, params::Dict{String,<:Any})

Enables a certificate revocation list (CRL). When enabled, certificates stored in the CRL
are unauthorized to receive session credentials.  Required permissions:
rolesanywhere:EnableCrl.

# Arguments
- `crl_id`: The unique identifier of the certificate revocation list (CRL).

"""
function enable_crl(crlId; aws_config::AbstractAWSConfig=current_aws_config())
    return rolesanywhere(
        "POST",
        "/crl/$(crlId)/enable";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function enable_crl(
    crlId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rolesanywhere(
        "POST",
        "/crl/$(crlId)/enable",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    enable_profile(profile_id)
    enable_profile(profile_id, params::Dict{String,<:Any})

Enables temporary credential requests for a profile.   Required permissions:
rolesanywhere:EnableProfile.

# Arguments
- `profile_id`: The unique identifier of the profile.

"""
function enable_profile(profileId; aws_config::AbstractAWSConfig=current_aws_config())
    return rolesanywhere(
        "POST",
        "/profile/$(profileId)/enable";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function enable_profile(
    profileId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rolesanywhere(
        "POST",
        "/profile/$(profileId)/enable",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    enable_trust_anchor(trust_anchor_id)
    enable_trust_anchor(trust_anchor_id, params::Dict{String,<:Any})

Enables a trust anchor. When enabled, certificates in the trust anchor chain are authorized
for trust validation.   Required permissions:  rolesanywhere:EnableTrustAnchor.

# Arguments
- `trust_anchor_id`: The unique identifier of the trust anchor.

"""
function enable_trust_anchor(
    trustAnchorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rolesanywhere(
        "POST",
        "/trustanchor/$(trustAnchorId)/enable";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function enable_trust_anchor(
    trustAnchorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rolesanywhere(
        "POST",
        "/trustanchor/$(trustAnchorId)/enable",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_crl(crl_id)
    get_crl(crl_id, params::Dict{String,<:Any})

Gets a certificate revocation list (CRL).  Required permissions:  rolesanywhere:GetCrl.

# Arguments
- `crl_id`: The unique identifier of the certificate revocation list (CRL).

"""
function get_crl(crlId; aws_config::AbstractAWSConfig=current_aws_config())
    return rolesanywhere(
        "GET", "/crl/$(crlId)"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_crl(
    crlId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rolesanywhere(
        "GET",
        "/crl/$(crlId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_profile(profile_id)
    get_profile(profile_id, params::Dict{String,<:Any})

Gets a profile.  Required permissions:  rolesanywhere:GetProfile.

# Arguments
- `profile_id`: The unique identifier of the profile.

"""
function get_profile(profileId; aws_config::AbstractAWSConfig=current_aws_config())
    return rolesanywhere(
        "GET",
        "/profile/$(profileId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_profile(
    profileId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rolesanywhere(
        "GET",
        "/profile/$(profileId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_subject(subject_id)
    get_subject(subject_id, params::Dict{String,<:Any})

Gets a subject, which associates a certificate identity with authentication attempts. The
subject stores auditing information such as the status of the last authentication attempt,
the certificate data used in the attempt, and the last time the associated identity
attempted authentication.   Required permissions:  rolesanywhere:GetSubject.

# Arguments
- `subject_id`: The unique identifier of the subject.

"""
function get_subject(subjectId; aws_config::AbstractAWSConfig=current_aws_config())
    return rolesanywhere(
        "GET",
        "/subject/$(subjectId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_subject(
    subjectId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rolesanywhere(
        "GET",
        "/subject/$(subjectId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_trust_anchor(trust_anchor_id)
    get_trust_anchor(trust_anchor_id, params::Dict{String,<:Any})

Gets a trust anchor.  Required permissions:  rolesanywhere:GetTrustAnchor.

# Arguments
- `trust_anchor_id`: The unique identifier of the trust anchor.

"""
function get_trust_anchor(trustAnchorId; aws_config::AbstractAWSConfig=current_aws_config())
    return rolesanywhere(
        "GET",
        "/trustanchor/$(trustAnchorId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_trust_anchor(
    trustAnchorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rolesanywhere(
        "GET",
        "/trustanchor/$(trustAnchorId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    import_crl(crl_data, name, trust_anchor_arn)
    import_crl(crl_data, name, trust_anchor_arn, params::Dict{String,<:Any})

Imports the certificate revocation list (CRL). A CRL is a list of certificates that have
been revoked by the issuing certificate Authority (CA).In order to be properly imported, a
CRL must be in PEM format. IAM Roles Anywhere validates against the CRL before issuing
credentials.   Required permissions:  rolesanywhere:ImportCrl.

# Arguments
- `crl_data`: The x509 v3 specified certificate revocation list (CRL).
- `name`: The name of the certificate revocation list (CRL).
- `trust_anchor_arn`: The ARN of the TrustAnchor the certificate revocation list (CRL) will
  provide revocation for.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"enabled"`: Specifies whether the certificate revocation list (CRL) is enabled.
- `"tags"`: A list of tags to attach to the certificate revocation list (CRL).
"""
function import_crl(
    crlData, name, trustAnchorArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rolesanywhere(
        "POST",
        "/crls",
        Dict{String,Any}(
            "crlData" => crlData, "name" => name, "trustAnchorArn" => trustAnchorArn
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function import_crl(
    crlData,
    name,
    trustAnchorArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rolesanywhere(
        "POST",
        "/crls",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "crlData" => crlData, "name" => name, "trustAnchorArn" => trustAnchorArn
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_crls()
    list_crls(params::Dict{String,<:Any})

Lists all certificate revocation lists (CRL) in the authenticated account and Amazon Web
Services Region.  Required permissions:  rolesanywhere:ListCrls.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"nextToken"`: A token that indicates where the output should continue from, if a
  previous request did not show all results. To get the next results, make the request again
  with this value.
- `"pageSize"`: The number of resources in the paginated list.
"""
function list_crls(; aws_config::AbstractAWSConfig=current_aws_config())
    return rolesanywhere(
        "GET", "/crls"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_crls(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rolesanywhere(
        "GET", "/crls", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_profiles()
    list_profiles(params::Dict{String,<:Any})

Lists all profiles in the authenticated account and Amazon Web Services Region.  Required
permissions:  rolesanywhere:ListProfiles.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"nextToken"`: A token that indicates where the output should continue from, if a
  previous request did not show all results. To get the next results, make the request again
  with this value.
- `"pageSize"`: The number of resources in the paginated list.
"""
function list_profiles(; aws_config::AbstractAWSConfig=current_aws_config())
    return rolesanywhere(
        "GET", "/profiles"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_profiles(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rolesanywhere(
        "GET", "/profiles", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_subjects()
    list_subjects(params::Dict{String,<:Any})

Lists the subjects in the authenticated account and Amazon Web Services Region.  Required
permissions:  rolesanywhere:ListSubjects.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"nextToken"`: A token that indicates where the output should continue from, if a
  previous request did not show all results. To get the next results, make the request again
  with this value.
- `"pageSize"`: The number of resources in the paginated list.
"""
function list_subjects(; aws_config::AbstractAWSConfig=current_aws_config())
    return rolesanywhere(
        "GET", "/subjects"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_subjects(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rolesanywhere(
        "GET", "/subjects", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Lists the tags attached to the resource.  Required permissions:
rolesanywhere:ListTagsForResource.

# Arguments
- `resource_arn`: The ARN of the resource.

"""
function list_tags_for_resource(
    resourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rolesanywhere(
        "GET",
        "/ListTagsForResource",
        Dict{String,Any}("resourceArn" => resourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rolesanywhere(
        "GET",
        "/ListTagsForResource",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("resourceArn" => resourceArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_trust_anchors()
    list_trust_anchors(params::Dict{String,<:Any})

Lists the trust anchors in the authenticated account and Amazon Web Services Region.
Required permissions:  rolesanywhere:ListTrustAnchors.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"nextToken"`: A token that indicates where the output should continue from, if a
  previous request did not show all results. To get the next results, make the request again
  with this value.
- `"pageSize"`: The number of resources in the paginated list.
"""
function list_trust_anchors(; aws_config::AbstractAWSConfig=current_aws_config())
    return rolesanywhere(
        "GET", "/trustanchors"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_trust_anchors(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rolesanywhere(
        "GET",
        "/trustanchors",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_attribute_mapping(certificate_field, mapping_rules, profile_id)
    put_attribute_mapping(certificate_field, mapping_rules, profile_id, params::Dict{String,<:Any})

Put an entry in the attribute mapping rules that will be enforced by a given profile. A
mapping specifies a certificate field and one or more specifiers that have contextual
meanings.

# Arguments
- `certificate_field`: Fields (x509Subject, x509Issuer and x509SAN) within X.509
  certificates.
- `mapping_rules`: A list of mapping entries for every supported specifier or sub-field.
- `profile_id`: The unique identifier of the profile.

"""
function put_attribute_mapping(
    certificateField,
    mappingRules,
    profileId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rolesanywhere(
        "PUT",
        "/profiles/$(profileId)/mappings",
        Dict{String,Any}(
            "certificateField" => certificateField, "mappingRules" => mappingRules
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_attribute_mapping(
    certificateField,
    mappingRules,
    profileId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rolesanywhere(
        "PUT",
        "/profiles/$(profileId)/mappings",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "certificateField" => certificateField, "mappingRules" => mappingRules
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_notification_settings(notification_settings, trust_anchor_id)
    put_notification_settings(notification_settings, trust_anchor_id, params::Dict{String,<:Any})

Attaches a list of notification settings to a trust anchor. A notification setting includes
information such as event name, threshold, status of the notification setting, and the
channel to notify.  Required permissions:  rolesanywhere:PutNotificationSettings.

# Arguments
- `notification_settings`: A list of notification settings to be associated to the trust
  anchor.
- `trust_anchor_id`: The unique identifier of the trust anchor.

"""
function put_notification_settings(
    notificationSettings, trustAnchorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rolesanywhere(
        "PATCH",
        "/put-notifications-settings",
        Dict{String,Any}(
            "notificationSettings" => notificationSettings, "trustAnchorId" => trustAnchorId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_notification_settings(
    notificationSettings,
    trustAnchorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rolesanywhere(
        "PATCH",
        "/put-notifications-settings",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "notificationSettings" => notificationSettings,
                    "trustAnchorId" => trustAnchorId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    reset_notification_settings(notification_setting_keys, trust_anchor_id)
    reset_notification_settings(notification_setting_keys, trust_anchor_id, params::Dict{String,<:Any})

Resets the custom notification setting to IAM Roles Anywhere default setting.   Required
permissions:  rolesanywhere:ResetNotificationSettings.

# Arguments
- `notification_setting_keys`: A list of notification setting keys to reset. A notification
  setting key includes the event and the channel.
- `trust_anchor_id`: The unique identifier of the trust anchor.

"""
function reset_notification_settings(
    notificationSettingKeys,
    trustAnchorId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rolesanywhere(
        "PATCH",
        "/reset-notifications-settings",
        Dict{String,Any}(
            "notificationSettingKeys" => notificationSettingKeys,
            "trustAnchorId" => trustAnchorId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function reset_notification_settings(
    notificationSettingKeys,
    trustAnchorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rolesanywhere(
        "PATCH",
        "/reset-notifications-settings",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "notificationSettingKeys" => notificationSettingKeys,
                    "trustAnchorId" => trustAnchorId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Attaches tags to a resource.  Required permissions:  rolesanywhere:TagResource.

# Arguments
- `resource_arn`: The ARN of the resource.
- `tags`: The tags to attach to the resource.

"""
function tag_resource(resourceArn, tags; aws_config::AbstractAWSConfig=current_aws_config())
    return rolesanywhere(
        "POST",
        "/TagResource",
        Dict{String,Any}("resourceArn" => resourceArn, "tags" => tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    resourceArn,
    tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rolesanywhere(
        "POST",
        "/TagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("resourceArn" => resourceArn, "tags" => tags),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Removes tags from the resource.  Required permissions:  rolesanywhere:UntagResource.

# Arguments
- `resource_arn`: The ARN of the resource.
- `tag_keys`: A list of keys. Tag keys are the unique identifiers of tags.

"""
function untag_resource(
    resourceArn, tagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rolesanywhere(
        "POST",
        "/UntagResource",
        Dict{String,Any}("resourceArn" => resourceArn, "tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    resourceArn,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rolesanywhere(
        "POST",
        "/UntagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("resourceArn" => resourceArn, "tagKeys" => tagKeys),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_crl(crl_id)
    update_crl(crl_id, params::Dict{String,<:Any})

Updates the certificate revocation list (CRL). A CRL is a list of certificates that have
been revoked by the issuing certificate authority (CA). IAM Roles Anywhere validates
against the CRL before issuing credentials.  Required permissions:
rolesanywhere:UpdateCrl.

# Arguments
- `crl_id`: The unique identifier of the certificate revocation list (CRL).

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"crlData"`: The x509 v3 specified certificate revocation list (CRL).
- `"name"`: The name of the Crl.
"""
function update_crl(crlId; aws_config::AbstractAWSConfig=current_aws_config())
    return rolesanywhere(
        "PATCH", "/crl/$(crlId)"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function update_crl(
    crlId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rolesanywhere(
        "PATCH",
        "/crl/$(crlId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_profile(profile_id)
    update_profile(profile_id, params::Dict{String,<:Any})

Updates a profile, a list of the roles that IAM Roles Anywhere service is trusted to
assume. You use profiles to intersect permissions with IAM managed policies.  Required
permissions:  rolesanywhere:UpdateProfile.

# Arguments
- `profile_id`: The unique identifier of the profile.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"durationSeconds"`:  Used to determine how long sessions vended using this profile are
  valid for. See the Expiration section of the CreateSession API documentation page for more
  details. In requests, if this value is not provided, the default value will be 3600.
- `"managedPolicyArns"`: A list of managed policy ARNs that apply to the vended session
  credentials.
- `"name"`: The name of the profile.
- `"roleArns"`: A list of IAM roles that this profile can assume in a temporary credential
  request.
- `"sessionPolicy"`: A session policy that applies to the trust boundary of the vended
  session credentials.
"""
function update_profile(profileId; aws_config::AbstractAWSConfig=current_aws_config())
    return rolesanywhere(
        "PATCH",
        "/profile/$(profileId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_profile(
    profileId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rolesanywhere(
        "PATCH",
        "/profile/$(profileId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_trust_anchor(trust_anchor_id)
    update_trust_anchor(trust_anchor_id, params::Dict{String,<:Any})

Updates a trust anchor. You establish trust between IAM Roles Anywhere and your certificate
authority (CA) by configuring a trust anchor. You can define a trust anchor as a reference
to an Private Certificate Authority (Private CA) or by uploading a CA certificate. Your
Amazon Web Services workloads can authenticate with the trust anchor using certificates
issued by the CA in exchange for temporary Amazon Web Services credentials.  Required
permissions:  rolesanywhere:UpdateTrustAnchor.

# Arguments
- `trust_anchor_id`: The unique identifier of the trust anchor.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"name"`: The name of the trust anchor.
- `"source"`: The trust anchor type and its related certificate data.
"""
function update_trust_anchor(
    trustAnchorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rolesanywhere(
        "PATCH",
        "/trustanchor/$(trustAnchorId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_trust_anchor(
    trustAnchorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rolesanywhere(
        "PATCH",
        "/trustanchor/$(trustAnchorId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
