# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: worklink
using AWS.Compat
using AWS.UUIDs

"""
    associate_domain(acm_certificate_arn, domain_name, fleet_arn)
    associate_domain(acm_certificate_arn, domain_name, fleet_arn, params::Dict{String,<:Any})

Specifies a domain to be associated to Amazon WorkLink.

# Arguments
- `acm_certificate_arn`: The ARN of an issued ACM certificate that is valid for the domain
  being associated.
- `domain_name`: The fully qualified domain name (FQDN).
- `fleet_arn`: The Amazon Resource Name (ARN) of the fleet.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DisplayName"`: The name to display.
"""
function associate_domain(
    AcmCertificateArn,
    DomainName,
    FleetArn;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return worklink(
        "POST",
        "/associateDomain",
        Dict{String,Any}(
            "AcmCertificateArn" => AcmCertificateArn,
            "DomainName" => DomainName,
            "FleetArn" => FleetArn,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_domain(
    AcmCertificateArn,
    DomainName,
    FleetArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return worklink(
        "POST",
        "/associateDomain",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AcmCertificateArn" => AcmCertificateArn,
                    "DomainName" => DomainName,
                    "FleetArn" => FleetArn,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    associate_website_authorization_provider(authorization_provider_type, fleet_arn)
    associate_website_authorization_provider(authorization_provider_type, fleet_arn, params::Dict{String,<:Any})

Associates a website authorization provider with a specified fleet. This is used to
authorize users against associated websites in the company network.

# Arguments
- `authorization_provider_type`: The authorization provider type.
- `fleet_arn`: The ARN of the fleet.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DomainName"`: The domain name of the authorization provider. This applies only to
  SAML-based authorization providers.
"""
function associate_website_authorization_provider(
    AuthorizationProviderType, FleetArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return worklink(
        "POST",
        "/associateWebsiteAuthorizationProvider",
        Dict{String,Any}(
            "AuthorizationProviderType" => AuthorizationProviderType, "FleetArn" => FleetArn
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_website_authorization_provider(
    AuthorizationProviderType,
    FleetArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return worklink(
        "POST",
        "/associateWebsiteAuthorizationProvider",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AuthorizationProviderType" => AuthorizationProviderType,
                    "FleetArn" => FleetArn,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    associate_website_certificate_authority(certificate, fleet_arn)
    associate_website_certificate_authority(certificate, fleet_arn, params::Dict{String,<:Any})

Imports the root certificate of a certificate authority (CA) used to obtain TLS
certificates used by associated websites within the company network.

# Arguments
- `certificate`: The root certificate of the CA.
- `fleet_arn`: The ARN of the fleet.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DisplayName"`: The certificate name to display.
"""
function associate_website_certificate_authority(
    Certificate, FleetArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return worklink(
        "POST",
        "/associateWebsiteCertificateAuthority",
        Dict{String,Any}("Certificate" => Certificate, "FleetArn" => FleetArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_website_certificate_authority(
    Certificate,
    FleetArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return worklink(
        "POST",
        "/associateWebsiteCertificateAuthority",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Certificate" => Certificate, "FleetArn" => FleetArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_fleet(fleet_name)
    create_fleet(fleet_name, params::Dict{String,<:Any})

Creates a fleet. A fleet consists of resources and the configuration that delivers
associated websites to authorized users who download and set up the Amazon WorkLink app.

# Arguments
- `fleet_name`: A unique name for the fleet.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DisplayName"`: The fleet name to display.
- `"OptimizeForEndUserLocation"`: The option to optimize for better performance by routing
  traffic through the closest AWS Region to users, which may be outside of your home Region.
- `"Tags"`:  The tags to add to the resource. A tag is a key-value pair.
"""
function create_fleet(FleetName; aws_config::AbstractAWSConfig=current_aws_config())
    return worklink(
        "POST",
        "/createFleet",
        Dict{String,Any}("FleetName" => FleetName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_fleet(
    FleetName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return worklink(
        "POST",
        "/createFleet",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("FleetName" => FleetName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_fleet(fleet_arn)
    delete_fleet(fleet_arn, params::Dict{String,<:Any})

Deletes a fleet. Prevents users from accessing previously associated websites.

# Arguments
- `fleet_arn`: The ARN of the fleet.

"""
function delete_fleet(FleetArn; aws_config::AbstractAWSConfig=current_aws_config())
    return worklink(
        "POST",
        "/deleteFleet",
        Dict{String,Any}("FleetArn" => FleetArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_fleet(
    FleetArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return worklink(
        "POST",
        "/deleteFleet",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("FleetArn" => FleetArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_audit_stream_configuration(fleet_arn)
    describe_audit_stream_configuration(fleet_arn, params::Dict{String,<:Any})

Describes the configuration for delivering audit streams to the customer account.

# Arguments
- `fleet_arn`: The ARN of the fleet.

"""
function describe_audit_stream_configuration(
    FleetArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return worklink(
        "POST",
        "/describeAuditStreamConfiguration",
        Dict{String,Any}("FleetArn" => FleetArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_audit_stream_configuration(
    FleetArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return worklink(
        "POST",
        "/describeAuditStreamConfiguration",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("FleetArn" => FleetArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_company_network_configuration(fleet_arn)
    describe_company_network_configuration(fleet_arn, params::Dict{String,<:Any})

Describes the networking configuration to access the internal websites associated with the
specified fleet.

# Arguments
- `fleet_arn`: The ARN of the fleet.

"""
function describe_company_network_configuration(
    FleetArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return worklink(
        "POST",
        "/describeCompanyNetworkConfiguration",
        Dict{String,Any}("FleetArn" => FleetArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_company_network_configuration(
    FleetArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return worklink(
        "POST",
        "/describeCompanyNetworkConfiguration",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("FleetArn" => FleetArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_device(device_id, fleet_arn)
    describe_device(device_id, fleet_arn, params::Dict{String,<:Any})

Provides information about a user's device.

# Arguments
- `device_id`: A unique identifier for a registered user's device.
- `fleet_arn`: The ARN of the fleet.

"""
function describe_device(
    DeviceId, FleetArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return worklink(
        "POST",
        "/describeDevice",
        Dict{String,Any}("DeviceId" => DeviceId, "FleetArn" => FleetArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_device(
    DeviceId,
    FleetArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return worklink(
        "POST",
        "/describeDevice",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DeviceId" => DeviceId, "FleetArn" => FleetArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_device_policy_configuration(fleet_arn)
    describe_device_policy_configuration(fleet_arn, params::Dict{String,<:Any})

Describes the device policy configuration for the specified fleet.

# Arguments
- `fleet_arn`: The ARN of the fleet.

"""
function describe_device_policy_configuration(
    FleetArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return worklink(
        "POST",
        "/describeDevicePolicyConfiguration",
        Dict{String,Any}("FleetArn" => FleetArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_device_policy_configuration(
    FleetArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return worklink(
        "POST",
        "/describeDevicePolicyConfiguration",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("FleetArn" => FleetArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_domain(domain_name, fleet_arn)
    describe_domain(domain_name, fleet_arn, params::Dict{String,<:Any})

Provides information about the domain.

# Arguments
- `domain_name`: The name of the domain.
- `fleet_arn`: The ARN of the fleet.

"""
function describe_domain(
    DomainName, FleetArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return worklink(
        "POST",
        "/describeDomain",
        Dict{String,Any}("DomainName" => DomainName, "FleetArn" => FleetArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_domain(
    DomainName,
    FleetArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return worklink(
        "POST",
        "/describeDomain",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DomainName" => DomainName, "FleetArn" => FleetArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_fleet_metadata(fleet_arn)
    describe_fleet_metadata(fleet_arn, params::Dict{String,<:Any})

Provides basic information for the specified fleet, excluding identity provider,
networking, and device configuration details.

# Arguments
- `fleet_arn`: The Amazon Resource Name (ARN) of the fleet.

"""
function describe_fleet_metadata(
    FleetArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return worklink(
        "POST",
        "/describeFleetMetadata",
        Dict{String,Any}("FleetArn" => FleetArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_fleet_metadata(
    FleetArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return worklink(
        "POST",
        "/describeFleetMetadata",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("FleetArn" => FleetArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_identity_provider_configuration(fleet_arn)
    describe_identity_provider_configuration(fleet_arn, params::Dict{String,<:Any})

Describes the identity provider configuration of the specified fleet.

# Arguments
- `fleet_arn`: The ARN of the fleet.

"""
function describe_identity_provider_configuration(
    FleetArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return worklink(
        "POST",
        "/describeIdentityProviderConfiguration",
        Dict{String,Any}("FleetArn" => FleetArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_identity_provider_configuration(
    FleetArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return worklink(
        "POST",
        "/describeIdentityProviderConfiguration",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("FleetArn" => FleetArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_website_certificate_authority(fleet_arn, website_ca_id)
    describe_website_certificate_authority(fleet_arn, website_ca_id, params::Dict{String,<:Any})

Provides information about the certificate authority.

# Arguments
- `fleet_arn`: The ARN of the fleet.
- `website_ca_id`: A unique identifier for the certificate authority.

"""
function describe_website_certificate_authority(
    FleetArn, WebsiteCaId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return worklink(
        "POST",
        "/describeWebsiteCertificateAuthority",
        Dict{String,Any}("FleetArn" => FleetArn, "WebsiteCaId" => WebsiteCaId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_website_certificate_authority(
    FleetArn,
    WebsiteCaId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return worklink(
        "POST",
        "/describeWebsiteCertificateAuthority",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("FleetArn" => FleetArn, "WebsiteCaId" => WebsiteCaId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_domain(domain_name, fleet_arn)
    disassociate_domain(domain_name, fleet_arn, params::Dict{String,<:Any})

Disassociates a domain from Amazon WorkLink. End users lose the ability to access the
domain with Amazon WorkLink.

# Arguments
- `domain_name`: The name of the domain.
- `fleet_arn`: The ARN of the fleet.

"""
function disassociate_domain(
    DomainName, FleetArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return worklink(
        "POST",
        "/disassociateDomain",
        Dict{String,Any}("DomainName" => DomainName, "FleetArn" => FleetArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_domain(
    DomainName,
    FleetArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return worklink(
        "POST",
        "/disassociateDomain",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DomainName" => DomainName, "FleetArn" => FleetArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_website_authorization_provider(authorization_provider_id, fleet_arn)
    disassociate_website_authorization_provider(authorization_provider_id, fleet_arn, params::Dict{String,<:Any})

Disassociates a website authorization provider from a specified fleet. After the
disassociation, users can't load any associated websites that require this authorization
provider.

# Arguments
- `authorization_provider_id`: A unique identifier for the authorization provider.
- `fleet_arn`: The ARN of the fleet.

"""
function disassociate_website_authorization_provider(
    AuthorizationProviderId, FleetArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return worklink(
        "POST",
        "/disassociateWebsiteAuthorizationProvider",
        Dict{String,Any}(
            "AuthorizationProviderId" => AuthorizationProviderId, "FleetArn" => FleetArn
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_website_authorization_provider(
    AuthorizationProviderId,
    FleetArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return worklink(
        "POST",
        "/disassociateWebsiteAuthorizationProvider",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AuthorizationProviderId" => AuthorizationProviderId,
                    "FleetArn" => FleetArn,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_website_certificate_authority(fleet_arn, website_ca_id)
    disassociate_website_certificate_authority(fleet_arn, website_ca_id, params::Dict{String,<:Any})

Removes a certificate authority (CA).

# Arguments
- `fleet_arn`: The ARN of the fleet.
- `website_ca_id`: A unique identifier for the CA.

"""
function disassociate_website_certificate_authority(
    FleetArn, WebsiteCaId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return worklink(
        "POST",
        "/disassociateWebsiteCertificateAuthority",
        Dict{String,Any}("FleetArn" => FleetArn, "WebsiteCaId" => WebsiteCaId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_website_certificate_authority(
    FleetArn,
    WebsiteCaId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return worklink(
        "POST",
        "/disassociateWebsiteCertificateAuthority",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("FleetArn" => FleetArn, "WebsiteCaId" => WebsiteCaId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_devices(fleet_arn)
    list_devices(fleet_arn, params::Dict{String,<:Any})

Retrieves a list of devices registered with the specified fleet.

# Arguments
- `fleet_arn`: The ARN of the fleet.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of results to be included in the next page.
- `"NextToken"`: The pagination token used to retrieve the next page of results for this
  operation. If this value is null, it retrieves the first page.
"""
function list_devices(FleetArn; aws_config::AbstractAWSConfig=current_aws_config())
    return worklink(
        "POST",
        "/listDevices",
        Dict{String,Any}("FleetArn" => FleetArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_devices(
    FleetArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return worklink(
        "POST",
        "/listDevices",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("FleetArn" => FleetArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_domains(fleet_arn)
    list_domains(fleet_arn, params::Dict{String,<:Any})

Retrieves a list of domains associated to a specified fleet.

# Arguments
- `fleet_arn`: The ARN of the fleet.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of results to be included in the next page.
- `"NextToken"`: The pagination token used to retrieve the next page of results for this
  operation. If this value is null, it retrieves the first page.
"""
function list_domains(FleetArn; aws_config::AbstractAWSConfig=current_aws_config())
    return worklink(
        "POST",
        "/listDomains",
        Dict{String,Any}("FleetArn" => FleetArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_domains(
    FleetArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return worklink(
        "POST",
        "/listDomains",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("FleetArn" => FleetArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_fleets()
    list_fleets(params::Dict{String,<:Any})

Retrieves a list of fleets for the current account and Region.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of results to be included in the next page.
- `"NextToken"`: The pagination token used to retrieve the next page of results for this
  operation. If this value is null, it retrieves the first page.
"""
function list_fleets(; aws_config::AbstractAWSConfig=current_aws_config())
    return worklink(
        "POST", "/listFleets"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_fleets(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return worklink(
        "POST",
        "/listFleets",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Retrieves a list of tags for the specified resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the fleet.

"""
function list_tags_for_resource(
    ResourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return worklink(
        "GET",
        "/tags/$(ResourceArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    ResourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return worklink(
        "GET",
        "/tags/$(ResourceArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_website_authorization_providers(fleet_arn)
    list_website_authorization_providers(fleet_arn, params::Dict{String,<:Any})

Retrieves a list of website authorization providers associated with a specified fleet.

# Arguments
- `fleet_arn`: The ARN of the fleet.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of results to be included in the next page.
- `"NextToken"`: The pagination token to use to retrieve the next page of results for this
  operation. If this value is null, it retrieves the first page.
"""
function list_website_authorization_providers(
    FleetArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return worklink(
        "POST",
        "/listWebsiteAuthorizationProviders",
        Dict{String,Any}("FleetArn" => FleetArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_website_authorization_providers(
    FleetArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return worklink(
        "POST",
        "/listWebsiteAuthorizationProviders",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("FleetArn" => FleetArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_website_certificate_authorities(fleet_arn)
    list_website_certificate_authorities(fleet_arn, params::Dict{String,<:Any})

Retrieves a list of certificate authorities added for the current account and Region.

# Arguments
- `fleet_arn`: The ARN of the fleet.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of results to be included in the next page.
- `"NextToken"`: The pagination token used to retrieve the next page of results for this
  operation. If this value is null, it retrieves the first page.
"""
function list_website_certificate_authorities(
    FleetArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return worklink(
        "POST",
        "/listWebsiteCertificateAuthorities",
        Dict{String,Any}("FleetArn" => FleetArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_website_certificate_authorities(
    FleetArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return worklink(
        "POST",
        "/listWebsiteCertificateAuthorities",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("FleetArn" => FleetArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    restore_domain_access(domain_name, fleet_arn)
    restore_domain_access(domain_name, fleet_arn, params::Dict{String,<:Any})

Moves a domain to ACTIVE status if it was in the INACTIVE status.

# Arguments
- `domain_name`: The name of the domain.
- `fleet_arn`: The ARN of the fleet.

"""
function restore_domain_access(
    DomainName, FleetArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return worklink(
        "POST",
        "/restoreDomainAccess",
        Dict{String,Any}("DomainName" => DomainName, "FleetArn" => FleetArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function restore_domain_access(
    DomainName,
    FleetArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return worklink(
        "POST",
        "/restoreDomainAccess",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DomainName" => DomainName, "FleetArn" => FleetArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    revoke_domain_access(domain_name, fleet_arn)
    revoke_domain_access(domain_name, fleet_arn, params::Dict{String,<:Any})

Moves a domain to INACTIVE status if it was in the ACTIVE status.

# Arguments
- `domain_name`: The name of the domain.
- `fleet_arn`: The ARN of the fleet.

"""
function revoke_domain_access(
    DomainName, FleetArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return worklink(
        "POST",
        "/revokeDomainAccess",
        Dict{String,Any}("DomainName" => DomainName, "FleetArn" => FleetArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function revoke_domain_access(
    DomainName,
    FleetArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return worklink(
        "POST",
        "/revokeDomainAccess",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DomainName" => DomainName, "FleetArn" => FleetArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    sign_out_user(fleet_arn, username)
    sign_out_user(fleet_arn, username, params::Dict{String,<:Any})

Signs the user out from all of their devices. The user can sign in again if they have valid
credentials.

# Arguments
- `fleet_arn`: The ARN of the fleet.
- `username`: The name of the user.

"""
function sign_out_user(
    FleetArn, Username; aws_config::AbstractAWSConfig=current_aws_config()
)
    return worklink(
        "POST",
        "/signOutUser",
        Dict{String,Any}("FleetArn" => FleetArn, "Username" => Username);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function sign_out_user(
    FleetArn,
    Username,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return worklink(
        "POST",
        "/signOutUser",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("FleetArn" => FleetArn, "Username" => Username),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Adds or overwrites one or more tags for the specified resource, such as a fleet. Each tag
consists of a key and an optional value. If a resource already has a tag with the same key,
this operation updates its value.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the fleet.
- `tags`: The tags to add to the resource. A tag is a key-value pair.

"""
function tag_resource(ResourceArn, Tags; aws_config::AbstractAWSConfig=current_aws_config())
    return worklink(
        "POST",
        "/tags/$(ResourceArn)",
        Dict{String,Any}("Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    ResourceArn,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return worklink(
        "POST",
        "/tags/$(ResourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Tags" => Tags), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Removes one or more tags from the specified resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the fleet.
- `tag_keys`: The list of tag keys to remove from the resource.

"""
function untag_resource(
    ResourceArn, tagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return worklink(
        "DELETE",
        "/tags/$(ResourceArn)",
        Dict{String,Any}("tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    ResourceArn,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return worklink(
        "DELETE",
        "/tags/$(ResourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tagKeys" => tagKeys), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_audit_stream_configuration(fleet_arn)
    update_audit_stream_configuration(fleet_arn, params::Dict{String,<:Any})

Updates the audit stream configuration for the fleet.

# Arguments
- `fleet_arn`: The ARN of the fleet.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AuditStreamArn"`: The ARN of the Amazon Kinesis data stream that receives the audit
  events.
"""
function update_audit_stream_configuration(
    FleetArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return worklink(
        "POST",
        "/updateAuditStreamConfiguration",
        Dict{String,Any}("FleetArn" => FleetArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_audit_stream_configuration(
    FleetArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return worklink(
        "POST",
        "/updateAuditStreamConfiguration",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("FleetArn" => FleetArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_company_network_configuration(fleet_arn, security_group_ids, subnet_ids, vpc_id)
    update_company_network_configuration(fleet_arn, security_group_ids, subnet_ids, vpc_id, params::Dict{String,<:Any})

Updates the company network configuration for the fleet.

# Arguments
- `fleet_arn`: The ARN of the fleet.
- `security_group_ids`: The security groups associated with access to the provided subnets.
- `subnet_ids`: The subnets used for X-ENI connections from Amazon WorkLink rendering
  containers.
- `vpc_id`: The VPC with connectivity to associated websites.

"""
function update_company_network_configuration(
    FleetArn,
    SecurityGroupIds,
    SubnetIds,
    VpcId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return worklink(
        "POST",
        "/updateCompanyNetworkConfiguration",
        Dict{String,Any}(
            "FleetArn" => FleetArn,
            "SecurityGroupIds" => SecurityGroupIds,
            "SubnetIds" => SubnetIds,
            "VpcId" => VpcId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_company_network_configuration(
    FleetArn,
    SecurityGroupIds,
    SubnetIds,
    VpcId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return worklink(
        "POST",
        "/updateCompanyNetworkConfiguration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "FleetArn" => FleetArn,
                    "SecurityGroupIds" => SecurityGroupIds,
                    "SubnetIds" => SubnetIds,
                    "VpcId" => VpcId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_device_policy_configuration(fleet_arn)
    update_device_policy_configuration(fleet_arn, params::Dict{String,<:Any})

Updates the device policy configuration for the fleet.

# Arguments
- `fleet_arn`: The ARN of the fleet.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DeviceCaCertificate"`: The certificate chain, including intermediate certificates and
  the root certificate authority certificate used to issue device certificates.
"""
function update_device_policy_configuration(
    FleetArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return worklink(
        "POST",
        "/updateDevicePolicyConfiguration",
        Dict{String,Any}("FleetArn" => FleetArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_device_policy_configuration(
    FleetArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return worklink(
        "POST",
        "/updateDevicePolicyConfiguration",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("FleetArn" => FleetArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_domain_metadata(domain_name, fleet_arn)
    update_domain_metadata(domain_name, fleet_arn, params::Dict{String,<:Any})

Updates domain metadata, such as DisplayName.

# Arguments
- `domain_name`: The name of the domain.
- `fleet_arn`: The ARN of the fleet.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DisplayName"`: The name to display.
"""
function update_domain_metadata(
    DomainName, FleetArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return worklink(
        "POST",
        "/updateDomainMetadata",
        Dict{String,Any}("DomainName" => DomainName, "FleetArn" => FleetArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_domain_metadata(
    DomainName,
    FleetArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return worklink(
        "POST",
        "/updateDomainMetadata",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DomainName" => DomainName, "FleetArn" => FleetArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_fleet_metadata(fleet_arn)
    update_fleet_metadata(fleet_arn, params::Dict{String,<:Any})

Updates fleet metadata, such as DisplayName.

# Arguments
- `fleet_arn`: The ARN of the fleet.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DisplayName"`: The fleet name to display. The existing DisplayName is unset if null is
  passed.
- `"OptimizeForEndUserLocation"`: The option to optimize for better performance by routing
  traffic through the closest AWS Region to users, which may be outside of your home Region.
"""
function update_fleet_metadata(FleetArn; aws_config::AbstractAWSConfig=current_aws_config())
    return worklink(
        "POST",
        "/UpdateFleetMetadata",
        Dict{String,Any}("FleetArn" => FleetArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_fleet_metadata(
    FleetArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return worklink(
        "POST",
        "/UpdateFleetMetadata",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("FleetArn" => FleetArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_identity_provider_configuration(fleet_arn, identity_provider_type)
    update_identity_provider_configuration(fleet_arn, identity_provider_type, params::Dict{String,<:Any})

Updates the identity provider configuration for the fleet.

# Arguments
- `fleet_arn`: The ARN of the fleet.
- `identity_provider_type`: The type of identity provider.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"IdentityProviderSamlMetadata"`: The SAML metadata document provided by the customer’s
  identity provider. The existing IdentityProviderSamlMetadata is unset if null is passed.
"""
function update_identity_provider_configuration(
    FleetArn, IdentityProviderType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return worklink(
        "POST",
        "/updateIdentityProviderConfiguration",
        Dict{String,Any}(
            "FleetArn" => FleetArn, "IdentityProviderType" => IdentityProviderType
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_identity_provider_configuration(
    FleetArn,
    IdentityProviderType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return worklink(
        "POST",
        "/updateIdentityProviderConfiguration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "FleetArn" => FleetArn, "IdentityProviderType" => IdentityProviderType
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
