import Polyhedra
const polyhedra_test = joinpath(dirname(dirname(pathof(Polyhedra))), "test")

include(joinpath(polyhedra_test, "utils.jl"))
include(joinpath(polyhedra_test, "polyhedra.jl"))
@testset "Polyhedra tests with $arith arithmetic" for arith in [:float, :exact]
    polyhedratest(CDDLib.Library(arith))
end

@testset "Issue_65" begin
    A = [
        -0.5458700320410754 -0.43028245741634163 -0.32949085078374596 -2.0178905562651726 1.0 0.0 0.0
        -0.001696359345425646 -0.5944052771561518 -0.14259145370038157 -0.5715464802979783 0.0 1.0 0.0
        0.11176371186473642 0.16920950931092318 -0.6603345932930139 -0.11228115664803578 0.0 0.0 1.0
        0.5458700320410754 0.43028245741634163 0.32949085078374596 2.0178905562651726 -1.0 0.0 0.0
        0.001696359345425646 0.5944052771561518 0.14259145370038157 0.5715464802979783 0.0 -1.0 0.0
        -0.11176371186473642 -0.16920950931092318 0.6603345932930139 0.11228115664803578 0.0 0.0 -1.0
        -1.0 0.10091143255328394 3.4102811211934987 -6.813065334385856 0.0 0.0 0.0
        1.0 -0.8932312066317769 0.7730763460460294 2.524023981062126 0.0 0.0 0.0
        1.0 -0.0930882189983393 1.7475328342666678 4.495570410302662 0.0 0.0 0.0
        -1.0 -0.05182954771533831 -1.1189515717142475 -3.9532525226843815 0.0 0.0 0.0
        1.0 4.239841226638941 -8.774257911319019 -2.2499336877985545 0.0 0.0 0.0
        -1.0 1.0414219678515158 1.033883503426593 -0.9840648095304564 0.0 0.0 0.0
        1.0 -0.001284573155440541 -1.6845061382720732 -1.0153065939984884 0.0 0.0 0.0
        1.0 -4.299428761845123 -3.940453969462597 6.702373679526568 0.0 0.0 0.0
        -1.0 0.0 0.0 0.0 0.0 0.0 0.0; 0.0 1.0 0.0 0.0 0.0 0.0 0.0
    ]
    b = [0.3653256599471767, 0.4574210313524346, 0.35534066564751254, -0.3653256599471767, -0.4574210313524346, -0.35534066564751254, -2.9769531018983972, 0.8613646098710365, 3.3649667529429204, -2.093853811646953, 8.893608931702863, 0.7565246179371888, 1.433621499051063, -3.9487728883626625, -1.0, 2.0]
    poly_in = polyhedron(hrep(A, b), CDDLib.Library(:float))
    @test_throws(
        ErrorException,
        eliminate(poly_in, collect(1:4), BlockElimination()),
    )
end
