using HypothesisTests, Test
using HypothesisTests: default_tail

@testset "Breusch-Godfrey" begin
# data simulated under H_1
data_h1 = [
    -2.1844072302156263 1 -0.02187576598418861 1.4250842322231618 -2.0224314101114222
    -3.8237365225754556 1 -2.1844072302156263 -0.3986195023723653 -0.725318617093708
    -4.692622964314854 1 -3.8237365225754556 0.865359034508392 -0.9716762048860438
    -9.465165251695765 1 -4.692622964314854 -1.5248868209889381 -1.8178664695259354
    -3.784086411104036 1 -9.465165251695765 -0.018434833227298542 0.8719091772543835
    -7.682951955540945 1 -3.784086411104036 -0.6298048032223702 -1.6804917747830277
    -8.068822143998775 1 -7.682951955540945 0.3994394061296323 -0.5382489016869288
    -8.558608055778492 1 -8.068822143998775 -0.34662848289604303 -1.0915556882219897
    -10.905266364277344 1 -8.558608055778492 0.13174261149628444 -2.373156801968529
    -3.7593874757578343 1 -10.905266364277344 1.2873446803519781 1.3193356146665325
    -0.4071004208759922 1 -3.7593874757578343 0.6312912597626849 0.2928588585051935
    -0.21264428099357685 1 -0.4071004208759922 -1.2337261440146907 0.6677002797481758
    -0.2566792446386543 1 -0.21264428099357685 -0.8585845030636355 0.21112095190111557
    1.4652422469376796 1 -0.2566792446386543 0.2582660780400912 0.3254542082853489
    -0.03370549493934421 1 1.4652422469376796 -1.4599892950591262 0.3142665708225735
    -3.6655187094551787 1 -0.03370549493934421 0.5095274347206296 -1.2436129408018743
    -3.67007844594898 1 -3.6655187094551787 -1.2459007156231243 0.8724432818783148
    -4.269483828240617 1 -3.67007844594898 -1.3316534960103243 0.402333915295087
    -9.072321453339633 1 -4.269483828240617 -1.360732996599522 -0.918403552104298
    -6.298475056265913 1 -9.072321453339633 0.5429237557639659 0.564993224895932
    -8.851275959789886 1 -6.298475056265913 -2.63399370777994 -0.8745409882369648
    -7.240409805869097 1 -8.851275959789886 0.1499014406502077 -0.487019467609227
    -8.742193488440103 1 -7.240409805869097 -1.6587759684101517 -0.5287577864433531
    -8.085128207595446 1 -8.742193488440103 -2.748600587280482 0.6442930345934977
    -4.595734505262792 1 -8.085128207595446 -0.4180662233306449 0.909924517665989
    -8.876081007098774 1 -4.595734505262792 -1.4313262030289144 -1.3628300743751958
    -6.097510119608872 1 -8.876081007098774 1.1540597669111703 0.8739856083349014
    -8.187395934761742 1 -6.097510119608872 -0.4855284875097715 -0.8548933573000406
    -4.630296021087888 1 -8.187395934761742 0.7754380459705584 0.7550975795526141
    -6.678197570842665 1 -4.630296021087888 0.7560596380052317 -0.8436185092902743
    -8.454654098952108 1 -6.678197570842665 -1.626729284162485 0.27766300810348893
    -8.87315711823648 1 -8.454654098952108 -0.944684415100926 -0.9030356944859604
    -8.299137304666294 1 -8.87315711823648 0.658322671059814 -1.513350928595663
    -7.66583122908761 1 -8.299137304666294 -0.4489512342884181 -0.6593759619410697
    -5.544754187110598 1 -7.66583122908761 1.1851174294240252 -0.7403475629601508
    -0.2346062802414116 1 -5.544754187110598 1.9716204287413468 1.1351529072038815
    -2.7080211703552033 1 -0.2346062802414116 -0.0740194597978335 -0.8957439911719416
    -4.405304542289478 1 -2.7080211703552033 -0.20212227601885754 0.02136996876872505
    -10.874421844205603 1 -4.405304542289478 -1.458002434697322 -1.5544394018554584
    -7.980300798148038 1 -10.874421844205603 1.797342002330958 0.193735930526397
    -6.092985977023801 1 -7.980300798148038 -0.9064866353733989 0.9206450790295183
    -5.429540806278794 1 -6.092985977023801 -0.9702203522809195 0.16364495372354845
    -2.8135611982312048 1 -5.429540806278794 -0.7689287953327062 0.2606593892993496
    -5.233993628762067 1 -2.8135611982312048 -0.3959933139142994 -2.620564252102542
    -4.636500469478656 1 -5.233993628762067 0.4751826349484905 -1.0562153109753674
    -3.951599322839157 1 -4.636500469478656 0.6386323305899096 -0.0903512992302431
    -4.5338888862750215 1 -3.951599322839157 -0.3987477530370317 0.27865272355818926
    -3.27448245549044 1 -4.5338888862750215 -0.0803466446475703 -0.06596847546469198
    -2.116669048507199 1 -3.27448245549044 1.0018399414103412 -0.1569479584427068
    -5.632636058340474 1 -2.116669048507199 -0.7048446599977012 -1.8390689017857673
    -6.612580447433536 1 -5.632636058340474 -1.4340505462257125 -0.5674519382746356
    -6.047621290327909 1 -6.612580447433536 0.4347509475695458 -0.9192186367107573
    -12.316195547709809 1 -6.047621290327909 -0.09220577556331351 -3.8819978594268876
    -9.790653346165218 1 -12.316195547709809 -0.46408289171823325 0.8665458026221579
    -7.081636830140645 1 -9.790653346165218 2.187832361106393 0.432306709021104
    -7.798466676804453 1 -7.081636830140645 0.5791414166174949 -0.3229959302497174
    -8.48368570601047 1 -7.798466676804453 -0.9147242711971281 0.3402161710448687
    -6.844741808358232 1 -8.48368570601047 -0.1550598509968508 -0.29961787965293785
    -1.9143881179353244 1 -6.844741808358232 0.060717820312243403 1.9136035721789713
    -6.350825197915615 1 -1.9143881179353244 -0.27085887966353506 -1.6190985435203415
    -5.386740290175477 1 -6.350825197915615 0.11104289827811374 0.5169712744781768
    -8.201462522665064 1 -5.386740290175477 0.6427956685597893 -1.2825811121125588
    -6.86037895816535 1 -8.201462522665064 -1.0932960849422242 1.0840840119878734
    -7.681177025769711 1 -6.86037895816535 0.0867583435648074 -0.7944197379913668
    -8.700601165824938 1 -7.681177025769711 -0.07077890859801883 -0.025668064894330093
    -6.737037436370262 1 -8.700601165824938 1.2497099131508578 -0.011462506736218826
    -3.6689503491552253 1 -6.737037436370262 0.1512033860208509 1.4678868411216563
    -1.249607364746875 1 -3.6689503491552253 0.35515785025036173 1.315845372889509
    -1.9479972265280567 1 -1.249607364746875 -0.9253434974479612 0.27236940715678176
    0.06459657520168782 1 -1.9479972265280567 -0.233103327838231 0.44237536440754566
    1.6736047640968876 1 0.06459657520168782 1.3606109850208474 -1.1966483101519632
    3.3481475962652025 1 1.6736047640968876 0.7311973736313007 0.48457993854995624
    4.395242135786573 1 3.3481475962652025 0.4787377009574211 1.4147590837932418
    5.718254592907931 1 4.395242135786573 0.6051343777576946 1.0451679003902126
    7.701764680294246 1 5.718254592907931 1.276972611856289 -0.1978660512585745
    8.761139787455583 1 7.701764680294246 -1.3961992590989196 0.32892107972067225
    8.130728492876539 1 8.761139787455583 0.11709983671299977 -1.7983067508193347
    12.0528015874146 1 8.130728492876539 0.6266845348314155 1.44050014454746
    11.188183563801353 1 12.0528015874146 0.3133823643278484 -0.5232908450257276
    12.92107497611711 1 11.188183563801353 0.9862522782876494 0.43490251042216804
    12.271768495692909 1 12.92107497611711 0.5066085599761962 0.07774415899993356
    14.189399733550822 1 12.271768495692909 0.8718155606585614 0.14324697267944667
    15.088143644678663 1 14.189399733550822 0.6995645399732705 -0.43422769970595093
    17.365142073656695 1 15.088143644678663 2.0096551932105817 0.24387704638876334
    15.474852839205559 1 17.365142073656695 0.15269868152330113 -0.12389276233418343
    14.228935730675236 1 15.474852839205559 -0.7879019375423509 0.42889110309176043
    17.394434630323023 1 14.228935730675236 0.9986772266084378 1.189248289168407
    16.54384322429009 1 17.394434630323023 -0.4953901743665539 0.2059465326047665
    18.353069936157006 1 16.54384322429009 0.3638388194911837 1.0218854109275881
    16.07119383937772 1 18.353069936157006 0.6753443406355725 -1.1990648633034413
    20.977942062323052 1 16.07119383937772 0.6008899714463747 2.3805130457880845
    23.626966845968067 1 20.977942062323052 -1.5021368491168559 2.1896086828053907
    27.902989083231745 1 23.626966845968067 -0.3727356407152467 2.1299921566412503
    24.021974044852822 1 27.902989083231745 -1.2766407160812419 -0.3876601960862665
    22.470178938207653 1 24.021974044852822 0.6451054034379425 -0.23211025519653547
    22.71778230013325 1 22.470178938207653 1.9058844942684128 0.20626950528981075
    18.975581322758284 1 22.71778230013325 -1.5881288112102452 1.107610369079468
    19.971416875068105 1 18.975581322758284 0.29738396177383514 0.8667513992731141
    23.11402529567158 1 19.971416875068105 0.3028824231221631 1.6776251628069427
    17.780386660161668 1 23.11402529567158 -0.10176910274960058 -1.4298441320561919
]

coeff_vec = data_h1[:,2:end]\data_h1[:,1]
res_vec = data_h1[:,1] - data_h1[:,2:end]*coeff_vec

t = BreuschGodfreyTest(data_h1[:,2:end],res_vec,4)

@test t.n == 100
@test t.lag == 4
@test t.BG ≈ 31.39810637185552
@test pvalue(t) ≈ 2.5390992557054064e-6
@test default_tail(t) == :right
show(IOBuffer(), t)

t = BreuschGodfreyTest(data_h1[:,2:end],res_vec,2,false)

@test t.n == 98
@test t.lag == 2
@test t.BG ≈ 27.71445552148237
@test pvalue(t) ≈ 9.591409846298036e-7
show(IOBuffer(), t)

coeff_vec = data_h1[:,3:end]\data_h1[:,1] # no constant
res_vec = data_h1[:,1] - data_h1[:,3:end]*coeff_vec

t = BreuschGodfreyTest(data_h1[:,3:end],res_vec,10)

@test t.n == 100
@test t.lag == 10
@test t.BG ≈ 34.562955523063515
@test pvalue(t) ≈ 0.0001482189344859451
show(IOBuffer(), t)

# data simulated under H_0
data_h0 = [
    -2.6393758379263925 1 -0.22997735515901174 1.4250842322231618 -2.0224314101114222
    -3.8148641358053834 1 -2.6393758379263925 -0.3986195023723653 -0.725318617093708
    -4.677326144975626 1 -3.8148641358053834 0.865359034508392 -0.9716762048860438
    -8.864079316218326 1 -4.677326144975626 -1.5248868209889381 -1.8178664695259354
    -3.460887006123175 1 -8.864079316218326 -0.018434833227298542 0.8719091772543835
    -8.998633967744288 1 -3.460887006123175 -0.6298048032223702 -1.6804917747830277
    -7.665975510821412 1 -8.998633967744288 0.3994394061296323 -0.5382489016869288
    -8.56702198923559 1 -7.665975510821412 -0.34662848289604303 -1.0915556882219897
    -11.214833972884769 1 -8.56702198923559 0.13174261149628444 -2.373156801968529
    -4.446594124802662 1 -11.214833972884769 1.2873446803519781 1.3193356146665325
    -1.6998765285430706 1 -4.446594124802662 0.6312912597626849 0.2928588585051935
    -1.6972964464315492 1 -1.6998765285430706 -1.2337261440146907 0.6677002797481758
    -1.2272304633377735 1 -1.6972964464315492 -0.8585845030636355 0.21112095190111557
    0.30586906328114577 1 -1.2272304633377735 0.2582660780400912 0.3254542082853489
    -1.041825499276659 1 0.30586906328114577 -1.4599892950591262 0.3142665708225735
    -4.0872691626960425 1 -1.041825499276659 0.5095274347206296 -1.2436129408018743
    -2.8079705764801184 1 -4.0872691626960425 -1.2459007156231243 0.8724432818783148
    -3.5781229211748493 1 -2.8079705764801184 -1.3316534960103243 0.402333915295087
    -7.919753510576073 1 -3.5781229211748493 -1.360732996599522 -0.918403552104298
    -4.050334580805227 1 -7.919753510576073 0.5429237557639659 0.564993224895932
    -7.385113567278499 1 -4.050334580805227 -2.63399370777994 -0.8745409882369648
    -6.389907039488093 1 -7.385113567278499 0.1499014406502077 -0.487019467609227
    -8.362337662947732 1 -6.389907039488093 -1.6587759684101517 -0.5287577864433531
    -7.698895749951619 1 -8.362337662947732 -2.748600587280482 0.6442930345934977
    -5.183985240958993 1 -7.698895749951619 -0.4180662233306449 0.909924517665989
    -9.354302625888938 1 -5.183985240958993 -1.4313262030289144 -1.3628300743751958
    -6.0060845548714905 1 -9.354302625888938 1.1540597669111703 0.8739856083349014
    -7.251074336523842 1 -6.0060845548714905 -0.4855284875097715 -0.8548933573000406
    -3.750382446404393 1 -7.251074336523842 0.7754380459705584 0.7550975795526141
    -5.770679903165536 1 -3.750382446404393 0.7560596380052317 -0.8436185092902743
    -6.1571290241435745 1 -5.770679903165536 -1.626729284162485 0.27766300810348893
    -6.758646960354187 1 -6.1571290241435745 -0.944684415100926 -0.9030356944859604
    -7.251801456499875 1 -6.758646960354187 0.658322671059814 -1.513350928595663
    -7.120615787554741 1 -7.251801456499875 -0.4489512342884181 -0.6593759619410697
    -5.588509539557388 1 -7.120615787554741 1.1851174294240252 -0.7403475629601508
    -0.5390053133408673 1 -5.588509539557388 1.9716204287413468 1.1351529072038815
    -2.5300623604990955 1 -0.5390053133408673 -0.0740194597978335 -0.8957439911719416
    -3.7798892423452592 1 -2.5300623604990955 -0.20212227601885754 0.02136996876872505
    -9.04942964730818 1 -3.7798892423452592 -1.458002434697322 -1.5544394018554584
    -5.4354744982455365 1 -9.04942964730818 1.797342002330958 0.193735930526397
    -3.5679532514488668 1 -5.4354744982455365 -0.9064866353733989 0.9206450790295183
    -3.2063386742141633 1 -3.5679532514488668 -0.9702203522809195 0.16364495372354845
    -1.051934916538913 1 -3.2063386742141633 -0.7689287953327062 0.2606593892993496
    -4.863145941477073 1 -1.051934916538913 -0.3959933139142994 -2.620564252102542
    -5.212678725939295 1 -4.863145941477073 0.4751826349484905 -1.0562153109753674
    -4.614614610635563 1 -5.212678725939295 0.6386323305899096 -0.0903512992302431
    -4.424400676415464 1 -4.614614610635563 -0.3987477530370317 0.27865272355818926
    -2.5809040973960595 1 -4.424400676415464 -0.0803466446475703 -0.06596847546469198
    -2.283035131341285 1 -2.5809040973960595 1.0018399414103412 -0.1569479584427068
    -4.838392113346874 1 -2.283035131341285 -0.7048446599977012 -1.8390689017857673
    -6.765964527239637 1 -4.838392113346874 -1.4340505462257125 -0.5674519382746356
    -6.146713996908273 1 -6.765964527239637 0.4347509475695458 -0.9192186367107573
    -12.93695213339396 1 -6.146713996908273 -0.09220577556331351 -3.8819978594268876
    -10.328147452628222 1 -12.93695213339396 -0.46408289171823325 0.8665458026221579
    -7.312623658528083 1 -10.328147452628222 2.187832361106393 0.432306709021104
    -6.601242580580354 1 -7.312623658528083 0.5791414166174949 -0.3229959302497174
    -7.007982630266133 1 -6.601242580580354 -0.9147242711971281 0.3402161710448687
    -4.711869773110432 1 -7.007982630266133 -0.1550598509968508 -0.29961787965293785
    -1.3112388084541342 1 -4.711869773110432 0.060717820312243403 1.9136035721789713
    -4.778553640411378 1 -1.3112388084541342 -0.27085887966353506 -1.6190985435203415
    -3.597048209305651 1 -4.778553640411378 0.11104289827811374 0.5169712744781768
    -5.91625887800437 1 -3.597048209305651 0.6427956685597893 -1.2825811121125588
    -3.8341200305975844 1 -5.91625887800437 -1.0932960849422242 1.0840840119878734
    -5.05155415725161 1 -3.8341200305975844 0.0867583435648074 -0.7944197379913668
    -5.902658917952474 1 -5.05155415725161 -0.07077890859801883 -0.025668064894330093
    -3.0148968638612246 1 -5.902658917952474 1.2497099131508578 -0.011462506736218826
    -0.5435623298882797 1 -3.0148968638612246 0.1512033860208509 1.4678868411216563
    2.576402881110434 1 -0.5435623298882797 0.35515785025036173 1.315845372889509
    1.840001826392218 1 2.576402881110434 -0.9253434974479612 0.27236940715678176
    3.7629568916181633 1 1.840001826392218 -0.233103327838231 0.44237536440754566
    4.300779090152549 1 3.7629568916181633 1.3606109850208474 -1.1966483101519632
    4.890327561532721 1 4.300779090152549 0.7311973736313007 0.48457993854995624
    6.712083346070772 1 4.890327561532721 0.4787377009574211 1.4147590837932418
    8.918662089794555 1 6.712083346070772 0.6051343777576946 1.0451679003902126
    10.889228410523366 1 8.918662089794555 1.276972611856289 -0.1978660512585745
    10.771798896063286 1 10.889228410523366 -1.3961992590989196 0.32892107972067225
    8.897958495974741 1 10.771798896063286 0.11709983671299977 -1.7983067508193347
    11.231705359232382 1 8.897958495974741 0.6266845348314155 1.44050014454746
    11.085832271063609 1 11.231705359232382 0.3133823643278484 -0.5232908450257276
    12.02548460222439 1 11.085832271063609 0.9862522782876494 0.43490251042216804
    11.819287696755126 1 12.02548460222439 0.5066085599761962 0.07774415899993356
    13.96911393915951 1 11.819287696755126 0.8718155606585614 0.14324697267944667
    13.840528753974972 1 13.96911393915951 0.6995645399732705 -0.43422769970595093
    15.684175759900603 1 13.840528753974972 2.0096551932105817 0.24387704638876334
    14.08213146714004 1 15.684175759900603 0.15269868152330113 -0.12389276233418343
    13.303842222767337 1 14.08213146714004 -0.7879019375423509 0.42889110309176043
    16.40951365835989 1 13.303842222767337 0.9986772266084378 1.189248289168407
    15.406011864201629 1 16.40951365835989 -0.4953901743665539 0.2059465326047665
    17.105004411081747 1 15.406011864201629 0.3638388194911837 1.0218854109275881
    14.766483437171006 1 17.105004411081747 0.6753443406355725 -1.1990648633034413
    19.48191551080787 1 14.766483437171006 0.6008899714463747 2.3805130457880845
    22.133552497574904 1 19.48191551080787 -1.5021368491168559 2.1896086828053907
    25.492693395853813 1 22.133552497574904 -0.3727356407152467 2.1299921566412503
    20.970851703684147 1 25.492693395853813 -1.2766407160812419 -0.3876601960862665
    19.83986700193583 1 20.970851703684147 0.6451054034379425 -0.23211025519653547
    20.241165411067264 1 19.83986700193583 1.9058844942684128 0.20626950528981075
    17.31664682866259 1 20.241165411067264 -1.5881288112102452 1.107610369079468
    19.675283574585194 1 17.31664682866259 0.29738396177383514 0.8667513992731141
    21.79754881195714 1 19.675283574585194 0.3028824231221631 1.6776251628069427
    16.68579877178968 1 21.79754881195714 -0.10176910274960058 -1.4298441320561919
]

coeff_vec = data_h0[:,2:end]\data_h0[:,1]
res_vec = data_h0[:,1] - data_h0[:,2:end]*coeff_vec

t = BreuschGodfreyTest(data_h0[:,2:end],res_vec,4)

@test t.n == 100
@test t.lag == 4
@test t.BG ≈ 1.9781996740849623
@test pvalue(t) ≈ 0.7397687483602012
show(IOBuffer(), t)

t = BreuschGodfreyTest(data_h0[:,2:end],res_vec,2,false)

@test t.n == 98
@test t.lag == 2
@test t.BG ≈ 0.03720525092311448
@test pvalue(t) ≈ 0.9815693354165801
show(IOBuffer(), t)

coeff_vec = data_h0[:,3:end]\data_h0[:,1] # no constant
res_vec = data_h0[:,1] - data_h0[:,3:end]*coeff_vec

t = BreuschGodfreyTest(data_h0[:,3:end],res_vec,10)

@test t.n == 100
@test t.lag == 10
@test t.BG ≈ 11.156984521656943
@test pvalue(t) ≈ 0.3454190353708124
show(IOBuffer(), t)
end
