/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.codegen;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.jvm.JvmBackendErrors;
import org.jetbrains.kotlin.backend.jvm.codegen.ClassCodegen;
import org.jetbrains.kotlin.backend.jvm.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.backend.jvm.codegen.IrCodegenUtilsKt;
import org.jetbrains.kotlin.backend.jvm.codegen.JvmIrIntrinsicExtension;
import org.jetbrains.kotlin.backend.jvm.intrinsics.SignatureString;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.builtins.jvm.JavaToKotlinClassMap;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.inline.ReifiedTypeInliner;
import org.jetbrains.kotlin.codegen.state.JvmBackendConfig;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReporterWithContext;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.descriptors.IrBasedDescriptorsKt;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.model.TypeParameterMarker;
import shadow.org.jetbrains.org.objectweb.asm.Type;
import shadow.org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import shadow.org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import shadow.org.jetbrains.org.objectweb.asm.tree.FieldInsnNode;
import shadow.org.jetbrains.org.objectweb.asm.tree.InsnList;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0016J\u0018\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J0\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020#2\u0006\u0010\u0013\u001a\u00020\u0002H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u0013\u001a\u00020\u0002H\u0016J\u0012\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010\u0013\u001a\u00020\u0002H\u0016J\b\u0010)\u001a\u00020\u0010H\u0016J\u0010\u0010*\u001a\u00020\u00102\u0006\u0010+\u001a\u00020,H\u0016J(\u0010-\u001a\u00020#2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u0010\u0013\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/codegen/IrInlineIntrinsicsSupport;", "Lorg/jetbrains/kotlin/codegen/inline/ReifiedTypeInliner$IntrinsicsSupport;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "classCodegen", "Lorg/jetbrains/kotlin/backend/jvm/codegen/ClassCodegen;", "reportErrorsOn", "Lorg/jetbrains/kotlin/ir/IrElement;", "containingFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/codegen/ClassCodegen;Lorg/jetbrains/kotlin/ir/IrElement;Lorg/jetbrains/kotlin/ir/declarations/IrFile;)V", "config", "Lorg/jetbrains/kotlin/codegen/state/JvmBackendConfig;", "getConfig", "()Lorg/jetbrains/kotlin/codegen/state/JvmBackendConfig;", "putClassInstance", "", "v", "Lshadow/org/jetbrains/org/objectweb/asm/commons/InstructionAdapter;", "type", "generateTypeParameterContainer", "typeParameter", "Lorg/jetbrains/kotlin/types/model/TypeParameterMarker;", "generateFunctionReference", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "generatePropertyReference", "property", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "generateCallableReference", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "implClass", "Lshadow/org/jetbrains/org/objectweb/asm/Type;", "withArity", "", "isMutableCollectionType", "toKotlinType", "Lorg/jetbrains/kotlin/types/KotlinType;", "generateExternalEntriesForEnumTypeIfNeeded", "Lshadow/org/jetbrains/org/objectweb/asm/tree/FieldInsnNode;", "reportSuspendTypeUnsupported", "reportNonReifiedTypeParameterWithRecursiveBoundUnsupported", "typeParameterName", "Lorg/jetbrains/kotlin/name/Name;", "rewritePluginDefinedOperationMarker", "reifiedInsn", "Lshadow/org/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "instructions", "Lshadow/org/jetbrains/org/objectweb/asm/tree/InsnList;", "backend.jvm.codegen"})
@SourceDebugExtension(value={"SMAP\nIrInlineIntrinsicsSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrInlineIntrinsicsSupport.kt\norg/jetbrains/kotlin/backend/jvm/codegen/IrInlineIntrinsicsSupport\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,133:1\n1#2:134\n37#3,2:135\n1761#4,3:137\n*S KotlinDebug\n*F\n+ 1 IrInlineIntrinsicsSupport.kt\norg/jetbrains/kotlin/backend/jvm/codegen/IrInlineIntrinsicsSupport\n*L\n100#1:135,2\n130#1:137,3\n*E\n"})
public final class IrInlineIntrinsicsSupport
implements ReifiedTypeInliner.IntrinsicsSupport<IrType> {
    @NotNull
    private final ClassCodegen classCodegen;
    @NotNull
    private final IrElement reportErrorsOn;
    @NotNull
    private final IrFile containingFile;

    public IrInlineIntrinsicsSupport(@NotNull ClassCodegen classCodegen, @NotNull IrElement reportErrorsOn, @NotNull IrFile containingFile) {
        Intrinsics.checkNotNullParameter(classCodegen, "classCodegen");
        Intrinsics.checkNotNullParameter(reportErrorsOn, "reportErrorsOn");
        Intrinsics.checkNotNullParameter(containingFile, "containingFile");
        this.classCodegen = classCodegen;
        this.reportErrorsOn = reportErrorsOn;
        this.containingFile = containingFile;
    }

    @Override
    @NotNull
    public JvmBackendConfig getConfig() {
        return this.classCodegen.getContext().getConfig();
    }

    @Override
    public void putClassInstance(@NotNull InstructionAdapter v2, @NotNull IrType type2) {
        Intrinsics.checkNotNullParameter(v2, "v");
        Intrinsics.checkNotNullParameter(type2, "type");
        ExpressionCodegen.Companion.generateClassInstance$backend_jvm_codegen(v2, type2, this.classCodegen.getTypeMapper(), false);
    }

    @Override
    public void generateTypeParameterContainer(@NotNull InstructionAdapter v2, @NotNull TypeParameterMarker typeParameter) {
        Intrinsics.checkNotNullParameter(v2, "v");
        Intrinsics.checkNotNullParameter(typeParameter, "typeParameter");
        if (!(typeParameter instanceof IrTypeParameterSymbol)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        IrDeclarationParent parent2 = ((IrTypeParameter)((IrTypeParameterSymbol)typeParameter).getOwner()).getParent();
        if (parent2 instanceof IrClass) {
            Unit unit;
            this.putClassInstance(v2, IrUtilsKt.getDefaultType((IrClass)parent2));
            Unit it = unit = Unit.INSTANCE;
            boolean bl = false;
            AsmUtil.wrapJavaClassIntoKClass(v2);
        } else if (parent2 instanceof IrSimpleFunction) {
            IrPropertySymbol property2 = ((IrSimpleFunction)parent2).getCorrespondingPropertySymbol();
            if (property2 != null) {
                this.generatePropertyReference(v2, (IrProperty)property2.getOwner());
            } else {
                this.generateFunctionReference(v2, (IrFunction)parent2);
            }
        } else {
            throw new IllegalStateException(("Unknown parent of type parameter: " + RenderIrElementKt.render$default(parent2, null, 1, null) + ' ' + ((IrTypeParameter)((IrTypeParameterSymbol)typeParameter).getOwner()).getName() + ')').toString());
        }
    }

    private final void generateFunctionReference(InstructionAdapter v2, IrFunction function2) {
        IrDeclarationWithName irDeclarationWithName = function2;
        Type type2 = AsmTypes.FUNCTION_REFERENCE_IMPL;
        Intrinsics.checkNotNullExpressionValue(type2, "FUNCTION_REFERENCE_IMPL");
        this.generateCallableReference(v2, irDeclarationWithName, function2, type2, true);
    }

    private final void generatePropertyReference(InstructionAdapter v2, IrProperty property2) {
        IrSimpleFunction irSimpleFunction = property2.getGetter();
        if (irSimpleFunction == null) {
            throw new IllegalStateException(("Property without getter: " + RenderIrElementKt.render$default(property2, null, 1, null)).toString());
        }
        IrSimpleFunction getter2 = irSimpleFunction;
        int arity = getter2.getParameters().size();
        Type[] typeArray = property2.isVar() ? AsmTypes.MUTABLE_PROPERTY_REFERENCE_IMPL : AsmTypes.PROPERTY_REFERENCE_IMPL;
        Intrinsics.checkNotNull(typeArray);
        Type type2 = (Type)ArraysKt.getOrNull((Object[])typeArray, arity);
        if (type2 == null) {
            throw new IllegalStateException(("No property reference impl class with arity " + arity + " (" + RenderIrElementKt.render$default(property2, null, 1, null)).toString());
        }
        Type implClass = type2;
        this.generateCallableReference(v2, property2, getter2, implClass, false);
    }

    private final void generateCallableReference(InstructionAdapter v2, IrDeclarationWithName declaration, IrFunction function2, Type implClass, boolean withArity) {
        v2.anew(implClass);
        v2.dup();
        if (withArity) {
            v2.iconst(function2.getParameters().size());
        }
        this.putClassInstance(v2, JvmIrUtilsKt.getCallableReferenceOwnerKClassType(declaration.getParent(), this.classCodegen.getContext()));
        v2.aconst(declaration.getName().asString());
        SignatureString.INSTANCE.generateSignatureString$backend_jvm_codegen(v2, function2, this.classCodegen);
        v2.iconst(JvmIrUtilsKt.getCallableReferenceTopLevelFlag(declaration));
        Type[] typeArray = new Type[]{AsmTypes.JAVA_CLASS_TYPE, AsmTypes.JAVA_STRING_TYPE, AsmTypes.JAVA_STRING_TYPE, Type.INT_TYPE};
        List parameterTypes = CollectionsKt.plus((Collection)(withArity ? CollectionsKt.listOf(Type.INT_TYPE) : CollectionsKt.emptyList()), (Iterable)CollectionsKt.listOf(typeArray));
        Collection $this$toTypedArray$iv = parameterTypes;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        typeArray = thisCollection$iv.toArray(new Type[0]);
        v2.invokespecial(implClass.getInternalName(), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, Arrays.copyOf(typeArray, typeArray.length)), false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isMutableCollectionType(@NotNull IrType type2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        IrClassSymbol classifier2 = IrTypesKt.getClassOrNull(type2);
        if (classifier2 == null) return false;
        FqName fqName2 = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)classifier2.getOwner());
        if (!JavaToKotlinClassMap.INSTANCE.isMutable(fqName2 != null ? fqName2.toUnsafe() : null)) return false;
        return true;
    }

    @Override
    @NotNull
    public KotlinType toKotlinType(@NotNull IrType type2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        return IrBasedDescriptorsKt.toIrBasedKotlinType$default(type2, null, 1, null);
    }

    @Override
    @Nullable
    public FieldInsnNode generateExternalEntriesForEnumTypeIfNeeded(@NotNull IrType type2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        return IrCodegenUtilsKt.generateExternalEntriesForEnumTypeIfNeeded(type2, this.classCodegen);
    }

    @Override
    public void reportSuspendTypeUnsupported() {
        this.classCodegen.getContext().getKtDiagnosticReporter().at(this.reportErrorsOn, this.containingFile).report(JvmBackendErrors.INSTANCE.getTYPEOF_SUSPEND_TYPE());
    }

    @Override
    public void reportNonReifiedTypeParameterWithRecursiveBoundUnsupported(@NotNull Name typeParameterName) {
        Intrinsics.checkNotNullParameter(typeParameterName, "typeParameterName");
        KtDiagnosticReporterWithContext.DiagnosticContextImpl diagnosticContextImpl = this.classCodegen.getContext().getKtDiagnosticReporter().at(this.reportErrorsOn, this.containingFile);
        KtDiagnosticFactory1<String> ktDiagnosticFactory1 = JvmBackendErrors.INSTANCE.getTYPEOF_NON_REIFIED_TYPE_PARAMETER_WITH_RECURSIVE_BOUND();
        String string = typeParameterName.asString();
        Intrinsics.checkNotNullExpressionValue(string, "asString(...)");
        diagnosticContextImpl.report(ktDiagnosticFactory1, string);
    }

    @Override
    public boolean rewritePluginDefinedOperationMarker(@NotNull InstructionAdapter v2, @NotNull AbstractInsnNode reifiedInsn, @NotNull InsnList instructions, @NotNull IrType type2) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(v2, "v");
            Intrinsics.checkNotNullParameter(reifiedInsn, "reifiedInsn");
            Intrinsics.checkNotNullParameter(instructions, "instructions");
            Intrinsics.checkNotNullParameter(type2, "type");
            Iterable $this$any$iv = this.classCodegen.getIntrinsicExtensions();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    JvmIrIntrinsicExtension it = (JvmIrIntrinsicExtension)element$iv;
                    boolean bl2 = false;
                    if (!it.rewritePluginDefinedOperationMarker(v2, reifiedInsn, instructions, type2)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }
}

