/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.checkers.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableSet;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.error.ErrorUtils;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/checkers/utils/DebugInfoUtil;", "", "<init>", "()V", "MAY_BE_UNRESOLVED", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "EXCLUDED", "markDebugAnnotations", "", "root", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "debugInfoReporter", "Lorg/jetbrains/kotlin/checkers/utils/DebugInfoUtil$DebugInfoReporter;", "reportIfDynamic", "", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "declarationDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "DebugInfoReporter", "frontend"})
public final class DebugInfoUtil {
    @NotNull
    public static final DebugInfoUtil INSTANCE = new DebugInfoUtil();
    @NotNull
    private static final TokenSet MAY_BE_UNRESOLVED;
    @NotNull
    private static final TokenSet EXCLUDED;

    private DebugInfoUtil() {
    }

    public final void markDebugAnnotations(@NotNull PsiElement root, @NotNull BindingContext bindingContext, @NotNull DebugInfoReporter debugInfoReporter) {
        Intrinsics.checkNotNullParameter(root, "root");
        Intrinsics.checkNotNullParameter(bindingContext, "bindingContext");
        Intrinsics.checkNotNullParameter(debugInfoReporter, "debugInfoReporter");
        Map markedWithErrorElements = new HashMap();
        for (Diagnostic diagnostic : bindingContext.getDiagnostics()) {
            Object object;
            DiagnosticFactory<?> factory = diagnostic.getFactory();
            ImmutableSet<? extends DiagnosticFactory<?>> immutableSet = Errors.UNRESOLVED_REFERENCE_DIAGNOSTICS;
            Intrinsics.checkNotNullExpressionValue(immutableSet, "UNRESOLVED_REFERENCE_DIAGNOSTICS");
            if (CollectionsKt.contains((Iterable)immutableSet, diagnostic.getFactory())) {
                object = markedWithErrorElements;
                PsiElement psiElement = diagnostic.getPsiElement();
                Intrinsics.checkNotNull(psiElement, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtReferenceExpression");
                object.put((KtReferenceExpression)psiElement, factory);
                continue;
            }
            if (factory == Errors.SUPER_IS_NOT_AN_EXPRESSION || factory == Errors.SUPER_NOT_AVAILABLE) {
                PsiElement psiElement = diagnostic.getPsiElement();
                Intrinsics.checkNotNull(psiElement, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtSuperExpression");
                KtSuperExpression superExpression = (KtSuperExpression)psiElement;
                markedWithErrorElements.put(superExpression.getInstanceReference(), factory);
                continue;
            }
            if (factory == Errors.EXPRESSION_EXPECTED_PACKAGE_FOUND) {
                object = markedWithErrorElements;
                PsiElement psiElement = diagnostic.getPsiElement();
                Intrinsics.checkNotNull(psiElement, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtSimpleNameExpression");
                KtSimpleNameExpression ktSimpleNameExpression = (KtSimpleNameExpression)psiElement;
                DiagnosticFactory<?> diagnosticFactory = factory;
                object.put(ktSimpleNameExpression, diagnosticFactory);
                continue;
            }
            if (factory != Errors.UNSUPPORTED && factory != Errors.UNSUPPORTED_FEATURE) continue;
            for (KtReferenceExpression reference2 : PsiTreeUtil.findChildrenOfType(diagnostic.getPsiElement(), KtReferenceExpression.class)) {
                markedWithErrorElements.put(reference2, factory);
            }
        }
        root.acceptChildren(new KtTreeVisitorVoid(bindingContext, debugInfoReporter, markedWithErrorElements){
            final /* synthetic */ BindingContext $bindingContext;
            final /* synthetic */ DebugInfoReporter $debugInfoReporter;
            final /* synthetic */ Map<KtReferenceExpression, DiagnosticFactory<?>> $markedWithErrorElements;
            {
                this.$bindingContext = $bindingContext;
                this.$debugInfoReporter = $debugInfoReporter;
                this.$markedWithErrorElements = $markedWithErrorElements;
            }

            public void visitForExpression(KtForExpression expression2) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                KtExpression range = expression2.getLoopRange();
                if (range != null) {
                    KtElement ktElement = range;
                    WritableSlice<KtExpression, ResolvedCall<FunctionDescriptor>> writableSlice = BindingContext.LOOP_RANGE_ITERATOR_RESOLVED_CALL;
                    Intrinsics.checkNotNullExpressionValue(writableSlice, "LOOP_RANGE_ITERATOR_RESOLVED_CALL");
                    this.reportIfDynamicCall(ktElement, range, writableSlice);
                    KtElement ktElement2 = range;
                    WritableSlice<KtExpression, ResolvedCall<FunctionDescriptor>> writableSlice2 = BindingContext.LOOP_RANGE_HAS_NEXT_RESOLVED_CALL;
                    Intrinsics.checkNotNullExpressionValue(writableSlice2, "LOOP_RANGE_HAS_NEXT_RESOLVED_CALL");
                    this.reportIfDynamicCall(ktElement2, range, writableSlice2);
                    KtElement ktElement3 = range;
                    WritableSlice<KtExpression, ResolvedCall<FunctionDescriptor>> writableSlice3 = BindingContext.LOOP_RANGE_NEXT_RESOLVED_CALL;
                    Intrinsics.checkNotNullExpressionValue(writableSlice3, "LOOP_RANGE_NEXT_RESOLVED_CALL");
                    this.reportIfDynamicCall(ktElement3, range, writableSlice3);
                }
                super.visitForExpression(expression2);
            }

            public void visitDestructuringDeclaration(KtDestructuringDeclaration destructuringDeclaration) {
                Intrinsics.checkNotNullParameter(destructuringDeclaration, "destructuringDeclaration");
                for (KtDestructuringDeclarationEntry entry : destructuringDeclaration.getEntries()) {
                    Intrinsics.checkNotNull(entry);
                    KtElement ktElement = entry;
                    WritableSlice<KtDestructuringDeclarationEntry, ResolvedCall<FunctionDescriptor>> writableSlice = BindingContext.COMPONENT_RESOLVED_CALL;
                    Intrinsics.checkNotNullExpressionValue(writableSlice, "COMPONENT_RESOLVED_CALL");
                    this.reportIfDynamicCall(ktElement, entry, writableSlice);
                }
                super.visitDestructuringDeclaration(destructuringDeclaration);
            }

            public void visitProperty(KtProperty property2) {
                Intrinsics.checkNotNullParameter(property2, "property");
                VariableDescriptor descriptor2 = (VariableDescriptor)this.$bindingContext.get(BindingContext.VARIABLE, property2);
                KtPropertyDelegate delegate = property2.getDelegate();
                if (descriptor2 instanceof PropertyDescriptor && delegate != null) {
                    KtElement ktElement = delegate;
                    WritableSlice<VariableDescriptorWithAccessors, ResolvedCall<FunctionDescriptor>> writableSlice = BindingContext.PROVIDE_DELEGATE_RESOLVED_CALL;
                    Intrinsics.checkNotNullExpressionValue(writableSlice, "PROVIDE_DELEGATE_RESOLVED_CALL");
                    this.reportIfDynamicCall(ktElement, descriptor2, writableSlice);
                    KtElement ktElement2 = delegate;
                    PropertyGetterDescriptor propertyGetterDescriptor = ((PropertyDescriptor)descriptor2).getGetter();
                    WritableSlice<VariableAccessorDescriptor, ResolvedCall<FunctionDescriptor>> writableSlice2 = BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL;
                    Intrinsics.checkNotNullExpressionValue(writableSlice2, "DELEGATED_PROPERTY_RESOLVED_CALL");
                    this.reportIfDynamicCall(ktElement2, propertyGetterDescriptor, writableSlice2);
                    KtElement ktElement3 = delegate;
                    PropertySetterDescriptor propertySetterDescriptor = ((PropertyDescriptor)descriptor2).getSetter();
                    WritableSlice<VariableAccessorDescriptor, ResolvedCall<FunctionDescriptor>> writableSlice3 = BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL;
                    Intrinsics.checkNotNullExpressionValue(writableSlice3, "DELEGATED_PROPERTY_RESOLVED_CALL");
                    this.reportIfDynamicCall(ktElement3, propertySetterDescriptor, writableSlice3);
                }
                super.visitProperty(property2);
            }

            public void visitThisExpression(KtThisExpression expression2) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(expression2, this.$bindingContext);
                if (resolvedCall2 != null) {
                    DebugInfoUtil.access$reportIfDynamic(DebugInfoUtil.INSTANCE, expression2, resolvedCall2.getResultingDescriptor(), this.$debugInfoReporter);
                }
                super.visitThisExpression(expression2);
            }

            public void visitReferenceExpression(KtReferenceExpression expression2) {
                Collection labelTargets;
                Collection declarationDescriptors;
                PsiElement labelTarget;
                Intrinsics.checkNotNullParameter(expression2, "expression");
                super.visitReferenceExpression(expression2);
                if (!BindingContextUtils.isExpressionWithValidReference(expression2, this.$bindingContext)) {
                    return;
                }
                IElementType referencedNameElementType = null;
                if (expression2 instanceof KtSimpleNameExpression) {
                    IElementType iElementType = expression2.getNode().getElementType();
                    Intrinsics.checkNotNullExpressionValue(iElementType, "getElementType(...)");
                    IElementType elementType = iElementType;
                    if (elementType == KtNodeTypes.OPERATION_REFERENCE) {
                        referencedNameElementType = ((KtSimpleNameExpression)expression2).getReferencedNameElementType();
                        if (DebugInfoUtil.access$getEXCLUDED$p().contains(referencedNameElementType)) {
                            return;
                        }
                    }
                    if (elementType == KtNodeTypes.LABEL || ((KtSimpleNameExpression)expression2).getReferencedNameElementType() == KtTokens.THIS_KEYWORD) {
                        return;
                    }
                }
                this.$debugInfoReporter.preProcessReference(expression2);
                String target = null;
                DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)this.$bindingContext.get(BindingContext.REFERENCE_TARGET, expression2);
                if (declarationDescriptor != null) {
                    target = declarationDescriptor.toString();
                    DebugInfoUtil.access$reportIfDynamic(DebugInfoUtil.INSTANCE, expression2, declarationDescriptor, this.$debugInfoReporter);
                }
                if (target == null && (labelTarget = (PsiElement)this.$bindingContext.get(BindingContext.LABEL_TARGET, expression2)) != null) {
                    target = labelTarget.getText();
                }
                if (target == null && (declarationDescriptors = (Collection)this.$bindingContext.get(BindingContext.AMBIGUOUS_REFERENCE_TARGET, expression2)) != null) {
                    target = "" + '[' + declarationDescriptors.size() + " descriptors]";
                }
                if (target == null && (labelTargets = (Collection)this.$bindingContext.get(BindingContext.AMBIGUOUS_LABEL_TARGET, expression2)) != null) {
                    target = "" + '[' + labelTargets.size() + " elements]";
                }
                if (DebugInfoUtil.access$getMAY_BE_UNRESOLVED$p().contains(referencedNameElementType) || expression2 instanceof KtNameReferenceExpression && ((KtNameReferenceExpression)expression2).isPlaceholder()) {
                    return;
                }
                boolean resolved = target != null;
                boolean markedWithError = this.$markedWithErrorElements.containsKey(expression2);
                if (expression2 instanceof KtArrayAccessExpression && this.$markedWithErrorElements.containsKey(((KtArrayAccessExpression)expression2).getArrayExpression())) {
                    markedWithError = true;
                }
                KotlinType expressionType = this.$bindingContext.getType(expression2);
                DiagnosticFactory<?> factory = this.$markedWithErrorElements.get(expression2);
                if (declarationDescriptor != null && (ErrorUtils.isError(declarationDescriptor) || ErrorUtils.INSTANCE.containsErrorType(expressionType)) && factory != Errors.EXPRESSION_EXPECTED_PACKAGE_FOUND) {
                    this.$debugInfoReporter.reportElementWithErrorType(expression2);
                }
                if (resolved && markedWithError) {
                    ImmutableSet<? extends DiagnosticFactory<?>> immutableSet = Errors.UNRESOLVED_REFERENCE_DIAGNOSTICS;
                    Intrinsics.checkNotNullExpressionValue(immutableSet, "UNRESOLVED_REFERENCE_DIAGNOSTICS");
                    if (CollectionsKt.contains((Iterable)immutableSet, factory)) {
                        String string = target;
                        Intrinsics.checkNotNull(string);
                        this.$debugInfoReporter.reportUnresolvedWithTarget(expression2, string);
                    }
                } else if (!resolved && !markedWithError) {
                    this.$debugInfoReporter.reportMissingUnresolved(expression2);
                }
            }

            private final <E extends KtElement, K, D extends CallableDescriptor> boolean reportIfDynamicCall(E element, K key, WritableSlice<K, ResolvedCall<D>> slice) {
                ResolvedCall resolvedCall2 = (ResolvedCall)this.$bindingContext.get(slice, key);
                return resolvedCall2 != null ? DebugInfoUtil.access$reportIfDynamic(DebugInfoUtil.INSTANCE, element, (DeclarationDescriptor)resolvedCall2.getResultingDescriptor(), this.$debugInfoReporter) : false;
            }
        });
    }

    private final boolean reportIfDynamic(KtElement element, DeclarationDescriptor declarationDescriptor, DebugInfoReporter debugInfoReporter) {
        if (declarationDescriptor != null && DynamicCallsKt.isDynamic(declarationDescriptor)) {
            debugInfoReporter.reportDynamicCall(element, declarationDescriptor);
            return true;
        }
        return false;
    }

    public static final /* synthetic */ boolean access$reportIfDynamic(DebugInfoUtil $this, KtElement element, DeclarationDescriptor declarationDescriptor, DebugInfoReporter debugInfoReporter) {
        return $this.reportIfDynamic(element, declarationDescriptor, debugInfoReporter);
    }

    public static final /* synthetic */ TokenSet access$getEXCLUDED$p() {
        return EXCLUDED;
    }

    public static final /* synthetic */ TokenSet access$getMAY_BE_UNRESOLVED$p() {
        return MAY_BE_UNRESOLVED;
    }

    static {
        IElementType[] iElementTypeArray = new IElementType[]{KtTokens.IN_KEYWORD, KtTokens.NOT_IN};
        TokenSet tokenSet = TokenSet.create(iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue(tokenSet, "create(...)");
        MAY_BE_UNRESOLVED = tokenSet;
        iElementTypeArray = new IElementType[]{KtTokens.COLON, KtTokens.AS_KEYWORD, KtTokens.AS_SAFE, KtTokens.IS_KEYWORD, KtTokens.NOT_IS, KtTokens.OROR, KtTokens.ANDAND, KtTokens.EQ, KtTokens.EQEQEQ, KtTokens.EXCLEQEQEQ, KtTokens.ELVIS, KtTokens.EXCLEXCL};
        TokenSet tokenSet2 = TokenSet.create(iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue(tokenSet2, "create(...)");
        EXCLUDED = tokenSet2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH&J\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/checkers/utils/DebugInfoUtil$DebugInfoReporter;", "", "<init>", "()V", "preProcessReference", "", "expression", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "reportElementWithErrorType", "reportMissingUnresolved", "reportUnresolvedWithTarget", "target", "", "reportDynamicCall", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "declarationDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "frontend"})
    public static abstract class DebugInfoReporter {
        public final void preProcessReference(@NotNull KtReferenceExpression expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
        }

        public abstract void reportElementWithErrorType(@NotNull KtReferenceExpression var1);

        public abstract void reportMissingUnresolved(@NotNull KtReferenceExpression var1);

        public abstract void reportUnresolvedWithTarget(@NotNull KtReferenceExpression var1, @NotNull String var2);

        public void reportDynamicCall(@NotNull KtElement element, @NotNull DeclarationDescriptor declarationDescriptor) {
            Intrinsics.checkNotNullParameter(element, "element");
            Intrinsics.checkNotNullParameter(declarationDescriptor, "declarationDescriptor");
        }
    }
}

