/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.transformers.irToJs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CompilationExceptionKt;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.JsStatementOrigins;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.BaseIrElementToJsNodeTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrElementToJsExpressionTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrFunctionToJsTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsAstUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsCallTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.TranslatedCallArgument;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.JsGenerationContext;
import org.jetbrains.kotlin.ir.backend.js.utils.Namer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperator;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrExpressionsKt;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBigIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsDoubleLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsPostfixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsSuperRef;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperator;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SideEffectKind;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.utils.MemoryOptimizedCollectionUtilKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\u00020\u0007*\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0002J\u001c\u0010\n\u001a\u00020\u00022\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0018\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0018\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0018\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0018\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0018\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u001f2\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0018\u0010 \u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020!2\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0018\u0010\"\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020#2\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0018\u0010$\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020%2\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0018\u0010&\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020'2\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0018\u0010(\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020)2\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0018\u0010*\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020+2\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0018\u0010,\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020-2\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0018\u0010.\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020/2\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0018\u00100\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u0002012\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0018\u00102\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u0002032\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0018\u00104\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u0002052\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0018\u00106\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u0002072\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0018\u00108\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u0002092\u0006\u0010\r\u001a\u00020\u0003H\u0016J \u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=2\u0006\u0010\u000b\u001a\u0002072\u0006\u0010\r\u001a\u00020\u0003H\u0002J \u0010>\u001a\u00020?2\u0006\u0010<\u001a\u00020=2\u0006\u0010\u000b\u001a\u0002072\u0006\u0010\r\u001a\u00020\u0003H\u0002J \u0010@\u001a\u00020A2\u0006\u0010<\u001a\u00020B2\u0006\u0010\u000b\u001a\u0002072\u0006\u0010\r\u001a\u00020\u0003H\u0002J\f\u0010C\u001a\u00020\u0007*\u00020DH\u0002\u00a8\u0006E"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/IrElementToJsExpressionTransformer;", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/BaseIrElementToJsNodeTransformer;", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;", "<init>", "()V", "isClassInlineLike", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "visitMemberAccess", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "data", "visitComposite", "Lorg/jetbrains/kotlin/ir/expressions/IrComposite;", "visitVararg", "Lorg/jetbrains/kotlin/ir/expressions/IrVararg;", "context", "visitExpressionBody", "body", "Lorg/jetbrains/kotlin/ir/expressions/IrExpressionBody;", "visitFunctionExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionExpression;", "visitConst", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "toDoubleConst", "", "f", "", "visitStringConcatenation", "Lorg/jetbrains/kotlin/ir/expressions/IrStringConcatenation;", "visitGetField", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "visitGetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "visitGetObjectValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetObjectValue;", "visitSetField", "Lorg/jetbrains/kotlin/ir/expressions/IrSetField;", "visitSetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrSetValue;", "visitDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "visitConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitWhen", "Lorg/jetbrains/kotlin/ir/expressions/IrWhen;", "visitTypeOperator", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "visitDynamicMemberExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrDynamicMemberExpression;", "visitDynamicOperatorExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrDynamicOperatorExpression;", "visitRawFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrRawFunctionReference;", "prefixOperation", "Lorg/jetbrains/kotlin/js/backend/ast/JsPrefixOperation;", "operator", "Lorg/jetbrains/kotlin/js/backend/ast/JsUnaryOperator;", "postfixOperation", "Lorg/jetbrains/kotlin/js/backend/ast/JsPostfixOperation;", "binaryOperation", "Lorg/jetbrains/kotlin/js/backend/ast/JsBinaryOperation;", "Lorg/jetbrains/kotlin/js/backend/ast/JsBinaryOperator;", "isThisReceiver", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "backend.js"})
@SourceDebugExtension(value={"SMAP\nIrElementToJsExpressionTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrElementToJsExpressionTransformer.kt\norg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/IrElementToJsExpressionTransformer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 MemoryOptimizedCollectionUtil.kt\norg/jetbrains/kotlin/utils/MemoryOptimizedCollectionUtilKt\n*L\n1#1,362:1\n1803#2,3:363\n2746#2,3:366\n1563#2:369\n1634#2,3:370\n1563#2:377\n1634#2,3:378\n2746#2,3:381\n1634#2,3:385\n1634#2,3:389\n1634#2,3:393\n1292#3,3:373\n1#4:376\n16#5:384\n16#5:388\n16#5:392\n*S KotlinDebug\n*F\n+ 1 IrElementToJsExpressionTransformer.kt\norg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/IrElementToJsExpressionTransformer\n*L\n45#1:363,3\n51#1:366,3\n52#1:369\n52#1:370,3\n180#1:377\n180#1:378,3\n212#1:381,3\n213#1:385,3\n228#1:389,3\n325#1:393,3\n99#1:373,3\n213#1:384\n228#1:388\n325#1:392\n*E\n"})
public final class IrElementToJsExpressionTransformer
extends BaseIrElementToJsNodeTransformer<JsExpression, JsGenerationContext> {
    private final boolean isClassInlineLike(JsGenerationContext $this$isClassInlineLike, IrClass irClass) {
        return $this$isClassInlineLike.getStaticContext().getBackendContext().getInlineClassesUtils().isClassInlineLike(irClass);
    }

    @Override
    @NotNull
    public JsExpression visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @NotNull JsGenerationContext data2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data2, "data");
        Object r2 = super.visitMemberAccess(expression2, data2);
        JsExpression $this$visitMemberAccess_u24lambda_u240 = (JsExpression)r2;
        boolean bl = false;
        MetadataProperties.setSynthetic($this$visitMemberAccess_u24lambda_u240, Intrinsics.areEqual(expression2.getOrigin(), JsStatementOrigins.INSTANCE.getSYNTHESIZED_STATEMENT()));
        return (JsExpression)r2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JsExpression visitComposite(@NotNull IrComposite expression2, @NotNull JsGenerationContext data2) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data2, "data");
        int size = expression2.getStatements().size();
        if (size == 0) {
            String string = "Empty IrComposite is not supported";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }
        JsExpression first2 = (JsExpression)expression2.getStatements().get(0).accept(this, data2);
        if (size == 1) {
            return first2;
        }
        Iterable iterable = expression2.getStatements();
        JsExpression initial$iv = first2;
        boolean $i$f$fold = false;
        JsExpression accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void right;
            IrStatement irStatement = (IrStatement)element$iv;
            JsExpression left = accumulator$iv;
            boolean bl = false;
            accumulator$iv = new JsBinaryOperation(JsBinaryOperator.COMMA, left, (JsExpression)right.accept(this, data2));
        }
        return accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JsExpression visitVararg(@NotNull IrVararg expression2, @NotNull JsGenerationContext context2) {
        void $this$mapTo$iv$iv;
        boolean $this$none$iv2;
        block5: {
            boolean bl;
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(context2, "context");
            Iterable $this$none$iv2 = expression2.getElements();
            boolean $i$f$none = false;
            if ($this$none$iv2 instanceof Collection && ((Collection)$this$none$iv2).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv2) {
                    IrVarargElement it = (IrVarargElement)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof IrSpreadElement)) continue;
                    bl = false;
                    break block5;
                }
                bl = $this$none$iv2 = true;
            }
        }
        if (_Assertions.ENABLED && !$this$none$iv2) {
            String $i$f$none = "Assertion failed";
            throw new AssertionError((Object)$i$f$none);
        }
        Iterable $this$map$iv = expression2.getElements();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrVarargElement irVarargElement = (IrVarargElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((JsExpression)it.accept(this, context2));
        }
        List<JsExpression> list = MemoryOptimizedCollectionUtilKt.toSmartList((List)destination$iv$iv);
        return (JsExpression)JsAstUtilsKt.withSource$default(new JsArrayLiteral(list), expression2, context2, null, null, 12, null);
    }

    @Override
    @NotNull
    public JsExpression visitExpressionBody(@NotNull IrExpressionBody body, @NotNull JsGenerationContext context2) {
        Intrinsics.checkNotNullParameter(body, "body");
        Intrinsics.checkNotNullParameter(context2, "context");
        return (JsExpression)body.getExpression().accept(this, context2);
    }

    @Override
    @NotNull
    public JsExpression visitFunctionExpression(@NotNull IrFunctionExpression expression2, @NotNull JsGenerationContext context2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        IrSimpleFunction irFunction = expression2.getFunction();
        Object r2 = irFunction.accept(new IrFunctionToJsTransformer(), context2);
        JsFunction $this$visitFunctionExpression_u24lambda_u240 = (JsFunction)r2;
        boolean bl = false;
        $this$visitFunctionExpression_u24lambda_u240.setName(null);
        if (context2.getStaticContext().getBackendContext().getConfiguration().getBoolean(JSConfigurationKeys.COMPILE_LAMBDAS_AS_ES6_ARROW_FUNCTIONS)) {
            $this$visitFunctionExpression_u24lambda_u240.setEs6Arrow(true);
        }
        return (JsExpression)r2;
    }

    @Override
    @NotNull
    public JsExpression visitConst(@NotNull IrConst expression2, @NotNull JsGenerationContext context2) {
        JsLiteral.JsValueLiteral jsValueLiteral;
        IrConstKind kind;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        IrConstKind irConstKind = kind = expression2.getKind();
        if (irConstKind instanceof IrConstKind.String) {
            Object object = expression2.getValue();
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.String");
            jsValueLiteral = new JsStringLiteral((String)object);
        } else if (irConstKind instanceof IrConstKind.Null) {
            jsValueLiteral = new JsNullLiteral();
        } else if (irConstKind instanceof IrConstKind.Boolean) {
            Object object = expression2.getValue();
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Boolean");
            jsValueLiteral = new JsBooleanLiteral((Boolean)object);
        } else if (irConstKind instanceof IrConstKind.Byte) {
            Object object = expression2.getValue();
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Byte");
            jsValueLiteral = new JsIntLiteral(((Byte)object).byteValue());
        } else if (irConstKind instanceof IrConstKind.Short) {
            Object object = expression2.getValue();
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Short");
            jsValueLiteral = new JsIntLiteral(((Short)object).shortValue());
        } else if (irConstKind instanceof IrConstKind.Int) {
            Object object = expression2.getValue();
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Int");
            jsValueLiteral = new JsIntLiteral((Integer)object);
        } else if (irConstKind instanceof IrConstKind.Long) {
            Object object = expression2.getValue();
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Long");
            jsValueLiteral = new JsBigIntLiteral((Long)object);
        } else {
            if (irConstKind instanceof IrConstKind.Char) {
                CompilationExceptionKt.compilationException("Char const should have been lowered at this point", expression2);
                throw new KotlinNothingValueException();
            }
            if (irConstKind instanceof IrConstKind.Float) {
                Object object = expression2.getValue();
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Float");
                jsValueLiteral = new JsDoubleLiteral(this.toDoubleConst(((Float)object).floatValue()));
            } else if (irConstKind instanceof IrConstKind.Double) {
                Object object = expression2.getValue();
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Double");
                jsValueLiteral = new JsDoubleLiteral((Double)object);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return (JsExpression)JsAstUtilsKt.withSource$default(jsValueLiteral, expression2, context2, null, null, 12, null);
    }

    private final double toDoubleConst(float f2) {
        return Float.isInfinite(f2) || Float.isNaN(f2) ? (double)f2 : Double.parseDouble(String.valueOf(f2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JsExpression visitStringConcatenation(@NotNull IrStringConcatenation expression2, @NotNull JsGenerationContext context2) {
        void $this$fold$iv;
        Sequence tail;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        IrExpression firstArgument = CollectionsKt.firstOrNull(expression2.getArguments());
        Object object = firstArgument;
        Pair pair = (object != null && (object = ((IrExpression)object).getType()) != null ? IrTypePredicatesKt.isString((IrType)object) : false) ? new Pair(firstArgument.accept(this, context2), SequencesKt.drop(CollectionsKt.asSequence((Iterable)expression2.getArguments()), 1)) : new Pair(new JsStringLiteral(""), CollectionsKt.asSequence((Iterable)expression2.getArguments()));
        JsExpression head = (JsExpression)pair.component1();
        Sequence sequence2 = tail = pair.component2();
        JsExpression initial$iv = head;
        boolean $i$f$fold = false;
        JsExpression accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void irExpr;
            IrExpression irExpression = (IrExpression)element$iv;
            JsExpression jsExpr = accumulator$iv;
            boolean bl = false;
            accumulator$iv = new JsBinaryOperation(JsBinaryOperator.ADD, jsExpr, (JsExpression)irExpr.accept(this, context2));
        }
        return accumulator$iv;
    }

    @Override
    @NotNull
    public JsExpression visitGetField(@NotNull IrGetField expression2, @NotNull JsGenerationContext context2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        IrFieldSymbol symbol = expression2.getSymbol();
        IrField field = (IrField)symbol.getOwner();
        IrDeclarationParent fieldParent = field.getParent();
        if (fieldParent instanceof IrClass && IrUtilsKt.isEffectivelyExternal(field)) {
            boolean bl = IrUtilsKt.isEnumClass((IrClass)fieldParent);
            if (_Assertions.ENABLED && !bl) {
                boolean bl2 = false;
                String string = RenderIrElementKt.render$default(field, null, 1, null) + " in non-external class " + RenderIrElementKt.render$default(fieldParent, null, 1, null);
                throw new AssertionError((Object)string);
            }
            Object object = expression2.getReceiver();
            if (object == null || (object = (JsExpression)object.accept(this, context2)) == null) {
                CompilationExceptionKt.compilationException("Expect expression.receiver to not be null", expression2);
                throw new KotlinNothingValueException();
            }
            Object receiver = object;
            return (JsExpression)JsAstUtilsKt.withSource$default(new JsNameRef(AnnotationUtilsKt.getJsNameOrKotlinName(field).getIdentifier(), (JsExpression)receiver), expression2, context2, null, null, 12, null);
        }
        if (fieldParent instanceof IrClass && this.isClassInlineLike(context2, (IrClass)fieldParent)) {
            IrExpression irExpression = expression2.getReceiver();
            Intrinsics.checkNotNull(irExpression);
            return (JsExpression)JsAstUtilsKt.withSource$default((JsNode)irExpression.accept(this, context2), expression2, context2, null, null, 12, null);
        }
        JsName fieldName = context2.getNameForField(field);
        IrExpression irExpression = expression2.getReceiver();
        JsNode jsNode = JsAstUtilsKt.withSource$default(JsAstUtilsKt.jsElementAccess(fieldName, irExpression != null ? (JsExpression)irExpression.accept(this, context2) : null), expression2, context2, null, null, 12, null);
        JsExpression $this$visitGetField_u24lambda_u241 = (JsExpression)jsNode;
        boolean bl = false;
        if (Intrinsics.areEqual(field.getOrigin(), IrDeclarationOrigin.Companion.getFIELD_FOR_OBJECT_INSTANCE()) && Intrinsics.areEqual(expression2.getOrigin(), JsStatementOrigins.INSTANCE.getSYNTHESIZED_STATEMENT())) {
            MetadataProperties.setSynthetic($this$visitGetField_u24lambda_u241, true);
            MetadataProperties.setSideEffects($this$visitGetField_u24lambda_u241, SideEffectKind.PURE);
        }
        return (JsExpression)jsNode;
    }

    @Override
    @NotNull
    public JsExpression visitGetValue(@NotNull IrGetValue expression2, @NotNull JsGenerationContext context2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        IrValueDeclaration owner = expression2.getSymbol().getOwner();
        if (this.isThisReceiver(owner)) {
            return (JsExpression)JsAstUtilsKt.withSource$default(new JsThisRef(), expression2, context2, null, null, 12, null);
        }
        JsNode jsNode = JsAstUtilsKt.withSource$default(context2.getNameForValueDeclaration(owner).makeRef(), expression2, context2, null, null, 12, null);
        Intrinsics.checkNotNull(jsNode);
        return (JsExpression)jsNode;
    }

    @Override
    @NotNull
    public JsExpression visitGetObjectValue(@NotNull IrGetObjectValue expression2, @NotNull JsGenerationContext context2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        IrClass obj = (IrClass)expression2.getSymbol().getOwner();
        boolean bl2 = bl = obj.getKind() == ClassKind.OBJECT;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        bl = IrUtilsKt.isEffectivelyExternal(obj);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-IrElementToJsExpressionTransformer$visitGetObjectValue$22 = false;
            String $i$a$-assert-IrElementToJsExpressionTransformer$visitGetObjectValue$22 = "Non external IrGetObjectValue must be lowered";
            throw new AssertionError((Object)$i$a$-assert-IrElementToJsExpressionTransformer$visitGetObjectValue$22);
        }
        JsNode jsNode = JsAstUtilsKt.withSource$default(context2.getRefForExternalClass(obj), expression2, context2, null, null, 12, null);
        JsNameRef $this$visitGetObjectValue_u24lambda_u241 = (JsNameRef)jsNode;
        boolean bl3 = false;
        MetadataProperties.setSideEffects($this$visitGetObjectValue_u24lambda_u241, SideEffectKind.PURE);
        return (JsExpression)jsNode;
    }

    @Override
    @NotNull
    public JsExpression visitSetField(@NotNull IrSetField expression2, @NotNull JsGenerationContext context2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        IrField field = (IrField)expression2.getSymbol().getOwner();
        JsName fieldName = context2.getNameForField(field);
        String string = fieldName.getIdent();
        Intrinsics.checkNotNullExpressionValue(string, "getIdent(...)");
        IrExpression irExpression = expression2.getReceiver();
        JsExpression dest = JsAstUtilsKt.jsElementAccess(string, irExpression != null ? (JsExpression)irExpression.accept(this, context2) : null);
        JsExpression source = (JsExpression)expression2.getValue().accept(this, context2);
        return (JsExpression)JsAstUtilsKt.withSource$default(JsAstUtilsKt.jsAssignment(dest, source), expression2, context2, null, null, 12, null);
    }

    @Override
    @NotNull
    public JsExpression visitSetValue(@NotNull IrSetValue expression2, @NotNull JsGenerationContext context2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        IrValueDeclaration field = expression2.getSymbol().getOwner();
        JsNameRef ref = new JsNameRef(context2.getNameForValueDeclaration(field));
        JsExpression value2 = (JsExpression)expression2.getValue().accept(this, context2);
        return (JsExpression)JsAstUtilsKt.withSource$default(new JsBinaryOperation(JsBinaryOperator.ASG, ref, value2), expression2, context2, null, null, 12, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JsExpression visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @NotNull JsGenerationContext context2) {
        void $this$mapTo$iv$iv;
        JsExpression jsExpression;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        JsExpression classNameRef = IrTypeUtilsKt.getConstructorRef((IrConstructor)expression2.getSymbol().getOwner(), context2.getStaticContext());
        JsNameRef callFuncRef = new JsNameRef(Namer.INSTANCE.getCALL_FUNCTION(), classNameRef);
        boolean fromPrimary = context2.getCurrentFunction() instanceof IrConstructor;
        if (fromPrimary) {
            jsExpression = new JsThisRef();
        } else {
            IrFunction irFunction = context2.getCurrentFunction();
            Intrinsics.checkNotNull(irFunction);
            JsNameRef jsNameRef = context2.getNameForValueDeclaration(CollectionsKt.last(irFunction.getParameters())).makeRef();
            Intrinsics.checkNotNullExpressionValue(jsNameRef, "makeRef(...)");
            jsExpression = jsNameRef;
        }
        JsExpression thisRef = jsExpression;
        Iterable $this$map$iv = JsAstUtilsKt.translateNonDispatchCallArguments$default(expression2, context2, this, false, 8, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TranslatedCallArgument translatedCallArgument = (TranslatedCallArgument)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getJsArgument());
        }
        List arguments2 = (List)destination$iv$iv;
        IrConstructor constructor = (IrConstructor)expression2.getSymbol().getOwner();
        if (this.isClassInlineLike(context2, IrUtilsKt.getParentAsClass(constructor))) {
            boolean bl = constructor.isPrimary();
            if (_Assertions.ENABLED && !bl) {
                boolean bl2 = false;
                String string = "Delegation to secondary inline constructors must be lowered into simple function calls";
                throw new AssertionError((Object)string);
            }
            return (JsExpression)JsAstUtilsKt.withSource$default(new JsBinaryOperation(JsBinaryOperator.ASG, thisRef, (JsExpression)CollectionsKt.single(arguments2)), expression2, context2, null, null, 12, null);
        }
        return (JsExpression)JsAstUtilsKt.withSource$default(context2.getStaticContext().getBackendContext().getEs6mode() ? new JsInvocation((JsExpression)new JsSuperRef(), arguments2) : new JsInvocation((JsExpression)callFuncRef, MemoryOptimizedCollectionUtilKt.memoryOptimizedPlus(CollectionsKt.listOf(thisRef), arguments2)), expression2, context2, null, null, 12, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JsExpression visitConstructorCall(@NotNull IrConstructorCall expression2, @NotNull JsGenerationContext context2) {
        JsNew jsNew;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        Function2<IrConstructorCall, JsGenerationContext, JsExpression> function2 = context2.getStaticContext().getIntrinsics().get(expression2.getSymbol());
        if (function2 != null) {
            Function2<IrConstructorCall, JsGenerationContext, JsExpression> it = function2;
            boolean bl = false;
            return it.invoke(expression2, context2);
        }
        IrConstructor function3 = (IrConstructor)expression2.getSymbol().getOwner();
        List arguments2 = JsAstUtilsKt.translateNonDispatchCallArguments$default(expression2, context2, this, false, 8, null);
        IrClass klass = IrUtilsKt.getParentAsClass(function3);
        if (!(!this.isClassInlineLike(context2, klass))) {
            boolean $i$a$-require-IrElementToJsExpressionTransformer$visitConstructorCall$332 = false;
            String $i$a$-require-IrElementToJsExpressionTransformer$visitConstructorCall$332 = "All inline class constructor calls must be lowered to static function calls";
            throw new IllegalArgumentException($i$a$-require-IrElementToJsExpressionTransformer$visitConstructorCall$332.toString());
        }
        if (IrUtilsKt.isEffectivelyExternal(klass)) {
            JsExpression[] $this$mapTo$iv$iv;
            boolean bl;
            Iterable $this$none$iv;
            JsExpression refForExternalClass;
            block11: {
                refForExternalClass = IrTypeUtilsKt.getClassRef(klass, context2.getStaticContext());
                $this$none$iv = ((IrConstructor)expression2.getSymbol().getOwner()).getParameters();
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        IrValueParameter it = (IrValueParameter)element$iv;
                        boolean bl2 = false;
                        if (!AdditionalIrUtilsKt.isVararg(it)) continue;
                        bl = false;
                        break block11;
                    }
                    bl = true;
                }
            }
            if (bl) {
                void $this$memoryOptimizedMap$iv;
                $this$none$iv = arguments2;
                JsExpression jsExpression = refForExternalClass;
                boolean $i$f$memoryOptimizedMap = false;
                Iterable iterable = (Iterable)$this$memoryOptimizedMap$iv;
                Collection destination$iv$iv = new ArrayList($this$memoryOptimizedMap$iv.size());
                boolean $i$f$mapTo = false;
                for (Object t2 : $this$mapTo$iv$iv) {
                    void it;
                    TranslatedCallArgument translatedCallArgument = (TranslatedCallArgument)t2;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(it.getJsArgument());
                }
                List list = org.jetbrains.kotlin.utils.CollectionsKt.compactIfPossible((List)destination$iv$iv);
                JsExpression jsExpression2 = jsExpression;
                jsNew = new JsNew(jsExpression2, list);
            } else {
                IrValueParameter irValueParameter = klass.getThisReceiver();
                Intrinsics.checkNotNull(irValueParameter);
                TranslatedCallArgument dummyThisArg = new TranslatedCallArgument(irValueParameter, null, new JsNullLiteral());
                JsExpression argumentsAsSingleArray = JsAstUtilsKt.argumentsWithVarargAsSingleArray(CollectionsKt.plus((Collection)CollectionsKt.listOf(dummyThisArg), (Iterable)arguments2), context2);
                $this$mapTo$iv$iv = new JsExpression[]{refForExternalClass, argumentsAsSingleArray};
                JsNew jsNew2 = new JsNew((JsExpression)new JsInvocation((JsExpression)new JsNameRef("apply", (JsExpression)new JsNameRef("bind", (JsExpression)new JsNameRef("Function"))), $this$mapTo$iv$iv), CollectionsKt.emptyList());
                jsNew = jsNew2;
            }
        } else {
            void $this$mapTo$iv$iv;
            void $this$memoryOptimizedMap$iv;
            Collection refForExternalClass = arguments2;
            JsExpression jsExpression = IrTypeUtilsKt.getClassRef(klass, context2.getStaticContext());
            boolean $i$f$memoryOptimizedMap = false;
            Iterable argumentsAsSingleArray = (Iterable)$this$memoryOptimizedMap$iv;
            Collection destination$iv$iv = new ArrayList($this$memoryOptimizedMap$iv.size());
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                TranslatedCallArgument translatedCallArgument = (TranslatedCallArgument)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(translatedCallArgument.getJsArgument());
            }
            List list = org.jetbrains.kotlin.utils.CollectionsKt.compactIfPossible((List)destination$iv$iv);
            JsExpression jsExpression3 = jsExpression;
            jsNew = new JsNew(jsExpression3, list);
        }
        return (JsExpression)JsAstUtilsKt.withSource$default(jsNew, expression2, context2, null, null, 12, null);
    }

    @Override
    @NotNull
    public JsExpression visitCall(@NotNull IrCall expression2, @NotNull JsGenerationContext context2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        if (context2.checkIfJsCode(expression2.getSymbol()) || context2.checkIfHasAssociatedJsCode(expression2.getSymbol())) {
            return new JsCallTransformer(expression2, context2).generateExpression();
        }
        return (JsExpression)JsAstUtilsKt.withSource$default(JsAstUtilsKt.translateCall(expression2, context2, this), expression2, context2, null, null, 12, null);
    }

    @Override
    @NotNull
    public JsExpression visitWhen(@NotNull IrWhen expression2, @NotNull JsGenerationContext context2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        if (Intrinsics.areEqual(expression2.getOrigin(), IrStatementOrigin.Companion.getANDAND())) {
            return new JsBinaryOperation(JsBinaryOperator.AND, (JsExpression)expression2.getBranches().get(0).getCondition().accept(this, context2), (JsExpression)expression2.getBranches().get(0).getResult().accept(this, context2));
        }
        if (Intrinsics.areEqual(expression2.getOrigin(), IrStatementOrigin.Companion.getOROR())) {
            return new JsBinaryOperation(JsBinaryOperator.OR, (JsExpression)expression2.getBranches().get(0).getCondition().accept(this, context2), (JsExpression)expression2.getBranches().get(1).getResult().accept(this, context2));
        }
        IrBranch lastBranch = CollectionsKt.lastOrNull(expression2.getBranches());
        JsPrefixOperation implicitElse = lastBranch == null || !IrUtilsKt.isElseBranch(lastBranch) ? new JsPrefixOperation(JsUnaryOperator.VOID, new JsIntLiteral(0)) : null;
        boolean bl2 = bl = implicitElse == null || IrTypePredicatesKt.isUnit(expression2.getType());
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Non unit when-expression must have else branch";
            throw new AssertionError((Object)string);
        }
        JsNode jsNode = JsAstUtilsKt.toJsNode(expression2, this, context2, visitWhen.2.INSTANCE, (JsNode)implicitElse);
        Intrinsics.checkNotNull(jsNode);
        return (JsExpression)jsNode;
    }

    @Override
    @NotNull
    public JsExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @NotNull JsGenerationContext data2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data2, "data");
        if (WhenMappings.$EnumSwitchMapping$0[expression2.getOperator().ordinal()] != 1) {
            CompilationExceptionKt.compilationException("All type operator calls except REINTERPRET_CAST should be lowered at this point", expression2);
            throw new KotlinNothingValueException();
        }
        return (JsExpression)JsAstUtilsKt.withSource$default((JsExpression)expression2.getArgument().accept(this, data2), expression2, data2, null, null, 12, null);
    }

    @Override
    @NotNull
    public JsExpression visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @NotNull JsGenerationContext data2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data2, "data");
        return (JsExpression)JsAstUtilsKt.withSource$default(JsAstUtilsKt.jsElementAccess(expression2.getMemberName(), (JsExpression)expression2.getReceiver().accept(this, data2)), expression2, data2, null, null, 12, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JsExpression visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @NotNull JsGenerationContext data2) {
        JsExpression jsExpression;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data2, "data");
        switch (WhenMappings.$EnumSwitchMapping$1[expression2.getOperator().ordinal()]) {
            case 1: {
                jsExpression = this.prefixOperation(JsUnaryOperator.POS, expression2, data2);
                break;
            }
            case 2: {
                jsExpression = this.prefixOperation(JsUnaryOperator.NEG, expression2, data2);
                break;
            }
            case 3: {
                jsExpression = this.prefixOperation(JsUnaryOperator.NOT, expression2, data2);
                break;
            }
            case 4: {
                jsExpression = this.prefixOperation(JsUnaryOperator.INC, expression2, data2);
                break;
            }
            case 5: {
                jsExpression = this.prefixOperation(JsUnaryOperator.DEC, expression2, data2);
                break;
            }
            case 6: {
                jsExpression = this.postfixOperation(JsUnaryOperator.INC, expression2, data2);
                break;
            }
            case 7: {
                jsExpression = this.postfixOperation(JsUnaryOperator.DEC, expression2, data2);
                break;
            }
            case 8: {
                jsExpression = this.binaryOperation(JsBinaryOperator.ADD, expression2, data2);
                break;
            }
            case 9: {
                jsExpression = this.binaryOperation(JsBinaryOperator.SUB, expression2, data2);
                break;
            }
            case 10: {
                jsExpression = this.binaryOperation(JsBinaryOperator.MUL, expression2, data2);
                break;
            }
            case 11: {
                jsExpression = this.binaryOperation(JsBinaryOperator.DIV, expression2, data2);
                break;
            }
            case 12: {
                jsExpression = this.binaryOperation(JsBinaryOperator.MOD, expression2, data2);
                break;
            }
            case 13: {
                jsExpression = this.binaryOperation(JsBinaryOperator.GT, expression2, data2);
                break;
            }
            case 14: {
                jsExpression = this.binaryOperation(JsBinaryOperator.LT, expression2, data2);
                break;
            }
            case 15: {
                jsExpression = this.binaryOperation(JsBinaryOperator.GTE, expression2, data2);
                break;
            }
            case 16: {
                jsExpression = this.binaryOperation(JsBinaryOperator.LTE, expression2, data2);
                break;
            }
            case 17: {
                jsExpression = this.binaryOperation(JsBinaryOperator.EQ, expression2, data2);
                break;
            }
            case 18: {
                jsExpression = this.binaryOperation(JsBinaryOperator.NEQ, expression2, data2);
                break;
            }
            case 19: {
                jsExpression = this.binaryOperation(JsBinaryOperator.REF_EQ, expression2, data2);
                break;
            }
            case 20: {
                jsExpression = this.binaryOperation(JsBinaryOperator.REF_NEQ, expression2, data2);
                break;
            }
            case 21: {
                jsExpression = this.binaryOperation(JsBinaryOperator.AND, expression2, data2);
                break;
            }
            case 22: {
                jsExpression = this.binaryOperation(JsBinaryOperator.OR, expression2, data2);
                break;
            }
            case 23: {
                jsExpression = this.binaryOperation(JsBinaryOperator.ASG, expression2, data2);
                break;
            }
            case 24: {
                jsExpression = this.binaryOperation(JsBinaryOperator.ASG_ADD, expression2, data2);
                break;
            }
            case 25: {
                jsExpression = this.binaryOperation(JsBinaryOperator.ASG_SUB, expression2, data2);
                break;
            }
            case 26: {
                jsExpression = this.binaryOperation(JsBinaryOperator.ASG_MUL, expression2, data2);
                break;
            }
            case 27: {
                jsExpression = this.binaryOperation(JsBinaryOperator.ASG_DIV, expression2, data2);
                break;
            }
            case 28: {
                jsExpression = this.binaryOperation(JsBinaryOperator.ASG_MOD, expression2, data2);
                break;
            }
            case 29: {
                jsExpression = new JsArrayAccess((JsExpression)IrExpressionsKt.getLeft(expression2).accept(this, data2), (JsExpression)IrExpressionsKt.getRight(expression2).accept(this, data2));
                break;
            }
            case 30: {
                void $this$mapTo$iv$iv;
                void $this$memoryOptimizedMap$iv;
                Collection collection = expression2.getArguments();
                JsExpression jsExpression2 = (JsExpression)expression2.getReceiver().accept(this, data2);
                boolean $i$f$memoryOptimizedMap = false;
                Iterable iterable = (Iterable)$this$memoryOptimizedMap$iv;
                Collection destination$iv$iv = new ArrayList($this$memoryOptimizedMap$iv.size());
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    IrExpression irExpression = (IrExpression)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    collection2.add((JsExpression)it.accept(this, data2));
                }
                List list = org.jetbrains.kotlin.utils.CollectionsKt.compactIfPossible((List)destination$iv$iv);
                JsExpression jsExpression3 = jsExpression2;
                jsExpression = new JsInvocation(jsExpression3, list);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return (JsExpression)JsAstUtilsKt.withSource$default(jsExpression, expression2, data2, null, null, 12, null);
    }

    @Override
    @NotNull
    public JsExpression visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @NotNull JsGenerationContext data2) {
        JsExpression jsExpression;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data2, "data");
        IrFunction function2 = expression2.getSymbol().getOwner();
        if (function2 instanceof IrConstructor) {
            jsExpression = IrTypeUtilsKt.getConstructorRef((IrConstructor)function2, data2.getStaticContext());
        } else if (function2 instanceof IrSimpleFunction) {
            JsNameRef jsNameRef = data2.getNameForStaticFunction((IrSimpleFunction)function2).makeRef();
            Intrinsics.checkNotNullExpressionValue(jsNameRef, "makeRef(...)");
            jsExpression = jsNameRef;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        JsExpression name2 = jsExpression;
        return (JsExpression)JsAstUtilsKt.withSource$default(name2, expression2, data2, null, null, 12, null);
    }

    private final JsPrefixOperation prefixOperation(JsUnaryOperator operator, IrDynamicOperatorExpression expression2, JsGenerationContext data2) {
        return new JsPrefixOperation(operator, (JsExpression)expression2.getReceiver().accept(this, data2));
    }

    private final JsPostfixOperation postfixOperation(JsUnaryOperator operator, IrDynamicOperatorExpression expression2, JsGenerationContext data2) {
        return new JsPostfixOperation(operator, (JsExpression)expression2.getReceiver().accept(this, data2));
    }

    private final JsBinaryOperation binaryOperation(JsBinaryOperator operator, IrDynamicOperatorExpression expression2, JsGenerationContext data2) {
        return new JsBinaryOperation(operator, (JsExpression)IrExpressionsKt.getLeft(expression2).accept(this, data2), (JsExpression)IrExpressionsKt.getRight(expression2).accept(this, data2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isThisReceiver(IrValueDeclaration $this$isThisReceiver) {
        if ($this$isThisReceiver instanceof IrVariable) return false;
        IrDeclarationParent p2 = $this$isThisReceiver.getParent();
        if (p2 instanceof IrSimpleFunction) {
            if ($this$isThisReceiver != ((IrSimpleFunction)p2).getDispatchReceiverParameter()) return false;
            return true;
        }
        if (!(p2 instanceof IrClass)) return false;
        if ($this$isThisReceiver != ((IrClass)p2).getThisReceiver()) return false;
        return true;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[IrTypeOperator.values().length];
            try {
                nArray[IrTypeOperator.REINTERPRET_CAST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[IrDynamicOperator.values().length];
            try {
                nArray[IrDynamicOperator.UNARY_PLUS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDynamicOperator.UNARY_MINUS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDynamicOperator.EXCL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDynamicOperator.PREFIX_INCREMENT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDynamicOperator.PREFIX_DECREMENT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDynamicOperator.POSTFIX_INCREMENT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDynamicOperator.POSTFIX_DECREMENT.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDynamicOperator.BINARY_PLUS.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDynamicOperator.BINARY_MINUS.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDynamicOperator.MUL.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDynamicOperator.DIV.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDynamicOperator.MOD.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDynamicOperator.GT.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDynamicOperator.LT.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDynamicOperator.GE.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDynamicOperator.LE.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDynamicOperator.EQEQ.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDynamicOperator.EXCLEQ.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDynamicOperator.EQEQEQ.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDynamicOperator.EXCLEQEQ.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDynamicOperator.ANDAND.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDynamicOperator.OROR.ordinal()] = 22;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDynamicOperator.EQ.ordinal()] = 23;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDynamicOperator.PLUSEQ.ordinal()] = 24;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDynamicOperator.MINUSEQ.ordinal()] = 25;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDynamicOperator.MULEQ.ordinal()] = 26;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDynamicOperator.DIVEQ.ordinal()] = 27;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDynamicOperator.MODEQ.ordinal()] = 28;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDynamicOperator.ARRAY_ACCESS.ordinal()] = 29;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDynamicOperator.INVOKE.ordinal()] = 30;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

