/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.js.naming.NameSuggestion;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.IdentifierChecker;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsIdentifierChecker;", "Lorg/jetbrains/kotlin/resolve/IdentifierChecker;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "<init>", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "checkIdentifier", "", "simpleNameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "checkDeclaration", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "js.frontend"})
@SourceDebugExtension(value={"SMAP\nJsIdentifierChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsIdentifierChecker.kt\norg/jetbrains/kotlin/js/resolve/diagnostics/JsIdentifierChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,44:1\n1761#2,3:45\n*S KotlinDebug\n*F\n+ 1 JsIdentifierChecker.kt\norg/jetbrains/kotlin/js/resolve/diagnostics/JsIdentifierChecker\n*L\n35#1:45,3\n*E\n"})
public final class JsIdentifierChecker
implements IdentifierChecker {
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;

    public JsIdentifierChecker(@NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        this.languageVersionSettings = languageVersionSettings;
    }

    @Override
    public void checkIdentifier(@NotNull KtSimpleNameExpression simpleNameExpression, @NotNull DiagnosticSink diagnosticHolder) {
        boolean hasIllegalChars;
        block6: {
            boolean bl;
            Intrinsics.checkNotNullParameter(simpleNameExpression, "simpleNameExpression");
            Intrinsics.checkNotNullParameter(diagnosticHolder, "diagnosticHolder");
            if (this.languageVersionSettings.supportsFeature(LanguageFeature.JsAllowInvalidCharsIdentifiersEscaping)) {
                return;
            }
            String simpleName2 = simpleNameExpression.getReferencedName();
            char[] cArray = new char[]{'.'};
            Iterable $this$any$iv = StringsKt.split$default((CharSequence)simpleName2, cArray, false, 0, 6, null);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!(!Intrinsics.areEqual(NameSuggestion.Companion.sanitizeName(it), it))) continue;
                    bl = true;
                    break block6;
                }
                bl = hasIllegalChars = false;
            }
        }
        if (hasIllegalChars) {
            PsiElement psiElement = simpleNameExpression.getIdentifier();
            if (psiElement == null) {
                return;
            }
            PsiElement identifier = psiElement;
            diagnosticHolder.report(Errors.INVALID_CHARACTERS.on(identifier, "contains illegal characters"));
        }
    }

    @Override
    public void checkDeclaration(@NotNull KtDeclaration declaration, @NotNull DiagnosticSink diagnosticHolder) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(diagnosticHolder, "diagnosticHolder");
    }
}

