/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.error;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.error.ErrorClassDescriptor;
import org.jetbrains.kotlin.types.error.ErrorEntity;
import org.jetbrains.kotlin.types.error.ErrorModuleDescriptor;
import org.jetbrains.kotlin.types.error.ErrorPropertyDescriptor;
import org.jetbrains.kotlin.types.error.ErrorScope;
import org.jetbrains.kotlin.types.error.ErrorScopeKind;
import org.jetbrains.kotlin.types.error.ErrorType;
import org.jetbrains.kotlin.types.error.ErrorTypeConstructor;
import org.jetbrains.kotlin.types.error.ErrorTypeKind;
import org.jetbrains.kotlin.types.error.ThrowingScope;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ)\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\"0!\"\u00020\"H\u0007\u00a2\u0006\u0002\u0010#J1\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\u00192\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\"0!\"\u00020\"H\u0007\u00a2\u0006\u0002\u0010%J)\u0010&\u001a\u00020'2\u0006\u0010\u001e\u001a\u00020(2\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\"0!\"\u00020\"H\u0007\u00a2\u0006\u0002\u0010)J/\u0010&\u001a\u00020'2\u0006\u0010\u001e\u001a\u00020(2\u0006\u0010*\u001a\u00020+2\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\"0!\"\u00020\"\u00a2\u0006\u0002\u0010,J5\u0010-\u001a\u00020'2\u0006\u0010\u001e\u001a\u00020(2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/2\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\"0!\"\u00020\"\u00a2\u0006\u0002\u00101J=\u0010-\u001a\u00020'2\u0006\u0010\u001e\u001a\u00020(2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/2\u0006\u0010*\u001a\u00020+2\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\"0!\"\u00020\"\u00a2\u0006\u0002\u00102J'\u00103\u001a\u0002042\u0006\u0010\u001e\u001a\u00020(2\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\"0!\"\u00020\"\u00a2\u0006\u0002\u00105J\u0010\u00106\u001a\u00020\u00192\b\u00107\u001a\u0004\u0018\u00010\rJ\u0012\u00108\u001a\u00020\u00192\b\u00109\u001a\u0004\u0018\u00010:H\u0007J\u0012\u0010;\u001a\u00020\u00192\b\u00109\u001a\u0004\u0018\u00010:H\u0002J\u0012\u0010<\u001a\u00020\u00192\b\u00107\u001a\u0004\u0018\u00010\rH\u0007J\u000e\u0010=\u001a\u00020\u00192\u0006\u00107\u001a\u00020\rJ\u000e\u0010>\u001a\u00020\"2\u0006\u00107\u001a\u00020\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006?"}, d2={"Lorg/jetbrains/kotlin/types/error/ErrorUtils;", "", "<init>", "()V", "errorModule", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "getErrorModule", "()Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "errorClass", "Lorg/jetbrains/kotlin/types/error/ErrorClassDescriptor;", "getErrorClass", "()Lorg/jetbrains/kotlin/types/error/ErrorClassDescriptor;", "errorTypeForLoopInSupertypes", "Lorg/jetbrains/kotlin/types/KotlinType;", "getErrorTypeForLoopInSupertypes", "()Lorg/jetbrains/kotlin/types/KotlinType;", "errorPropertyType", "getErrorPropertyType", "errorProperty", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "errorPropertyGroup", "", "getErrorPropertyGroup", "()Ljava/util/Set;", "containsErrorTypeInParameters", "", "function", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "createErrorScope", "Lorg/jetbrains/kotlin/types/error/ErrorScope;", "kind", "Lorg/jetbrains/kotlin/types/error/ErrorScopeKind;", "formatParams", "", "", "(Lorg/jetbrains/kotlin/types/error/ErrorScopeKind;[Ljava/lang/String;)Lorg/jetbrains/kotlin/types/error/ErrorScope;", "throwExceptions", "(Lorg/jetbrains/kotlin/types/error/ErrorScopeKind;Z[Ljava/lang/String;)Lorg/jetbrains/kotlin/types/error/ErrorScope;", "createErrorType", "Lorg/jetbrains/kotlin/types/error/ErrorType;", "Lorg/jetbrains/kotlin/types/error/ErrorTypeKind;", "(Lorg/jetbrains/kotlin/types/error/ErrorTypeKind;[Ljava/lang/String;)Lorg/jetbrains/kotlin/types/error/ErrorType;", "typeConstructor", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "(Lorg/jetbrains/kotlin/types/error/ErrorTypeKind;Lorg/jetbrains/kotlin/types/TypeConstructor;[Ljava/lang/String;)Lorg/jetbrains/kotlin/types/error/ErrorType;", "createErrorTypeWithArguments", "arguments", "", "Lorg/jetbrains/kotlin/types/TypeProjection;", "(Lorg/jetbrains/kotlin/types/error/ErrorTypeKind;Ljava/util/List;[Ljava/lang/String;)Lorg/jetbrains/kotlin/types/error/ErrorType;", "(Lorg/jetbrains/kotlin/types/error/ErrorTypeKind;Ljava/util/List;Lorg/jetbrains/kotlin/types/TypeConstructor;[Ljava/lang/String;)Lorg/jetbrains/kotlin/types/error/ErrorType;", "createErrorTypeConstructor", "Lorg/jetbrains/kotlin/types/error/ErrorTypeConstructor;", "(Lorg/jetbrains/kotlin/types/error/ErrorTypeKind;[Ljava/lang/String;)Lorg/jetbrains/kotlin/types/error/ErrorTypeConstructor;", "containsErrorType", "type", "isError", "candidate", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "isErrorClass", "isUninferredTypeVariable", "containsUninferredTypeVariable", "unresolvedTypeAsItIs", "descriptors"})
public final class ErrorUtils {
    @NotNull
    public static final ErrorUtils INSTANCE = new ErrorUtils();
    @NotNull
    private static final ModuleDescriptor errorModule = ErrorModuleDescriptor.INSTANCE;
    @NotNull
    private static final ErrorClassDescriptor errorClass;
    @NotNull
    private static final KotlinType errorTypeForLoopInSupertypes;
    @NotNull
    private static final KotlinType errorPropertyType;
    @NotNull
    private static final PropertyDescriptor errorProperty;
    @NotNull
    private static final Set<PropertyDescriptor> errorPropertyGroup;

    private ErrorUtils() {
    }

    @NotNull
    public final ModuleDescriptor getErrorModule() {
        return errorModule;
    }

    @NotNull
    public final ErrorClassDescriptor getErrorClass() {
        return errorClass;
    }

    @NotNull
    public final KotlinType getErrorTypeForLoopInSupertypes() {
        return errorTypeForLoopInSupertypes;
    }

    @NotNull
    public final KotlinType getErrorPropertyType() {
        return errorPropertyType;
    }

    @NotNull
    public final Set<PropertyDescriptor> getErrorPropertyGroup() {
        return errorPropertyGroup;
    }

    public final boolean containsErrorTypeInParameters(@NotNull FunctionDescriptor function2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        ReceiverParameterDescriptor receiverParameter = function2.getExtensionReceiverParameter();
        if (receiverParameter != null && this.containsErrorType(receiverParameter.getType())) {
            return true;
        }
        for (ValueParameterDescriptor valueParameterDescriptor : function2.getValueParameters()) {
            if (!this.containsErrorType(valueParameterDescriptor.getType())) continue;
            return true;
        }
        for (TypeParameterDescriptor typeParameterDescriptor : function2.getTypeParameters()) {
            for (KotlinType upperBound : typeParameterDescriptor.getUpperBounds()) {
                if (!this.containsErrorType(upperBound)) continue;
                return true;
            }
        }
        return false;
    }

    @JvmStatic
    @NotNull
    public static final ErrorScope createErrorScope(@NotNull ErrorScopeKind kind, String ... formatParams) {
        Intrinsics.checkNotNullParameter((Object)kind, "kind");
        Intrinsics.checkNotNullParameter(formatParams, "formatParams");
        return ErrorUtils.createErrorScope(kind, false, Arrays.copyOf(formatParams, formatParams.length));
    }

    @JvmStatic
    @NotNull
    public static final ErrorScope createErrorScope(@NotNull ErrorScopeKind kind, boolean throwExceptions, String ... formatParams) {
        Intrinsics.checkNotNullParameter((Object)kind, "kind");
        Intrinsics.checkNotNullParameter(formatParams, "formatParams");
        return throwExceptions ? (ErrorScope)new ThrowingScope(kind, Arrays.copyOf(formatParams, formatParams.length)) : new ErrorScope(kind, Arrays.copyOf(formatParams, formatParams.length));
    }

    @JvmStatic
    @NotNull
    public static final ErrorType createErrorType(@NotNull ErrorTypeKind kind, String ... formatParams) {
        Intrinsics.checkNotNullParameter((Object)kind, "kind");
        Intrinsics.checkNotNullParameter(formatParams, "formatParams");
        return INSTANCE.createErrorTypeWithArguments(kind, CollectionsKt.emptyList(), Arrays.copyOf(formatParams, formatParams.length));
    }

    @NotNull
    public final ErrorType createErrorType(@NotNull ErrorTypeKind kind, @NotNull TypeConstructor typeConstructor2, String ... formatParams) {
        Intrinsics.checkNotNullParameter((Object)kind, "kind");
        Intrinsics.checkNotNullParameter(typeConstructor2, "typeConstructor");
        Intrinsics.checkNotNullParameter(formatParams, "formatParams");
        return this.createErrorTypeWithArguments(kind, CollectionsKt.emptyList(), typeConstructor2, Arrays.copyOf(formatParams, formatParams.length));
    }

    @NotNull
    public final ErrorType createErrorTypeWithArguments(@NotNull ErrorTypeKind kind, @NotNull List<? extends TypeProjection> arguments2, String ... formatParams) {
        Intrinsics.checkNotNullParameter((Object)kind, "kind");
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        Intrinsics.checkNotNullParameter(formatParams, "formatParams");
        return this.createErrorTypeWithArguments(kind, arguments2, this.createErrorTypeConstructor(kind, Arrays.copyOf(formatParams, formatParams.length)), Arrays.copyOf(formatParams, formatParams.length));
    }

    @NotNull
    public final ErrorType createErrorTypeWithArguments(@NotNull ErrorTypeKind kind, @NotNull List<? extends TypeProjection> arguments2, @NotNull TypeConstructor typeConstructor2, String ... formatParams) {
        Intrinsics.checkNotNullParameter((Object)kind, "kind");
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        Intrinsics.checkNotNullParameter(typeConstructor2, "typeConstructor");
        Intrinsics.checkNotNullParameter(formatParams, "formatParams");
        String[] stringArray = new String[]{typeConstructor2.toString()};
        return new ErrorType(typeConstructor2, (MemberScope)ErrorUtils.createErrorScope(ErrorScopeKind.ERROR_TYPE_SCOPE, stringArray), kind, arguments2, false, Arrays.copyOf(formatParams, formatParams.length));
    }

    @NotNull
    public final ErrorTypeConstructor createErrorTypeConstructor(@NotNull ErrorTypeKind kind, String ... formatParams) {
        Intrinsics.checkNotNullParameter((Object)kind, "kind");
        Intrinsics.checkNotNullParameter(formatParams, "formatParams");
        return new ErrorTypeConstructor(kind, Arrays.copyOf(formatParams, formatParams.length));
    }

    public final boolean containsErrorType(@Nullable KotlinType type2) {
        if (type2 == null) {
            return false;
        }
        if (KotlinTypeKt.isError(type2)) {
            return true;
        }
        for (TypeProjection projection : type2.getArguments()) {
            if (projection.isStarProjection() || !this.containsErrorType(projection.getType())) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean isError(@Nullable DeclarationDescriptor candidate2) {
        if (candidate2 == null) return false;
        if (INSTANCE.isErrorClass(candidate2)) return true;
        if (INSTANCE.isErrorClass(candidate2.getContainingDeclaration())) return true;
        if (candidate2 != errorModule) return false;
        return true;
    }

    private final boolean isErrorClass(DeclarationDescriptor candidate2) {
        return candidate2 instanceof ErrorClassDescriptor;
    }

    @JvmStatic
    public static final boolean isUninferredTypeVariable(@Nullable KotlinType type2) {
        if (type2 == null) {
            return false;
        }
        TypeConstructor constructor = type2.getConstructor();
        return constructor instanceof ErrorTypeConstructor && ((ErrorTypeConstructor)constructor).getKind() == ErrorTypeKind.UNINFERRED_TYPE_VARIABLE;
    }

    public final boolean containsUninferredTypeVariable(@NotNull KotlinType type2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        return TypeUtilsKt.contains(type2, (Function1<? super UnwrappedType, Boolean>)new Function1<KotlinType, Boolean>((Object)INSTANCE){

            public final Boolean invoke(KotlinType p0) {
                return ErrorUtils.isUninferredTypeVariable(p0);
            }
        });
    }

    @NotNull
    public final String unresolvedTypeAsItIs(@NotNull KotlinType type2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        boolean bl = TypeUtilsKt.isUnresolvedType(type2);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        TypeConstructor typeConstructor2 = type2.getConstructor();
        Intrinsics.checkNotNull(typeConstructor2, "null cannot be cast to non-null type org.jetbrains.kotlin.types.error.ErrorTypeConstructor");
        return ((ErrorTypeConstructor)typeConstructor2).getParam(0);
    }

    static {
        String string = ErrorEntity.ERROR_CLASS.getDebugText();
        Object[] objectArray = new Object[]{"unknown class"};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        Name name2 = Name.special(string2);
        Intrinsics.checkNotNullExpressionValue(name2, "special(...)");
        errorClass = new ErrorClassDescriptor(name2);
        errorTypeForLoopInSupertypes = ErrorUtils.createErrorType(ErrorTypeKind.CYCLIC_SUPERTYPES, new String[0]);
        errorPropertyType = ErrorUtils.createErrorType(ErrorTypeKind.ERROR_PROPERTY_TYPE, new String[0]);
        errorProperty = new ErrorPropertyDescriptor();
        errorPropertyGroup = SetsKt.setOf(errorProperty);
    }
}

