/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.Nullability;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JV\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000e2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u000eH\u0007\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/types/expressions/SenselessComparisonChecker;", "", "<init>", "()V", "checkSenselessComparisonWithNull", "", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "left", "Lorg/jetbrains/kotlin/psi/KtExpression;", "right", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "getType", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/types/KotlinType;", "getNullability", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue;", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/Nullability;", "frontend"})
public final class SenselessComparisonChecker {
    @NotNull
    public static final SenselessComparisonChecker INSTANCE = new SenselessComparisonChecker();

    private SenselessComparisonChecker() {
    }

    @JvmStatic
    public static final void checkSenselessComparisonWithNull(@NotNull KtBinaryExpression expression2, @NotNull KtExpression left, @NotNull KtExpression right, @NotNull ResolutionContext<?> context2, @NotNull Function1<? super KtExpression, ? extends KotlinType> getType, @NotNull Function1<? super DataFlowValue, ? extends Nullability> getNullability) {
        boolean bl;
        KtExpression ktExpression;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(left, "left");
        Intrinsics.checkNotNullParameter(right, "right");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(getType, "getType");
        Intrinsics.checkNotNullParameter(getNullability, "getNullability");
        if (KtPsiUtil.isNullConstant(left)) {
            ktExpression = right;
        } else if (KtPsiUtil.isNullConstant(right)) {
            ktExpression = left;
        } else {
            return;
        }
        KtExpression expr = ktExpression;
        KotlinType type2 = getType.invoke(expr);
        if (type2 == null || KotlinTypeKt.isError(type2)) {
            return;
        }
        KtOperationReferenceExpression ktOperationReferenceExpression = expression2.getOperationReference();
        Intrinsics.checkNotNullExpressionValue(ktOperationReferenceExpression, "getOperationReference(...)");
        KtOperationReferenceExpression operationSign = ktOperationReferenceExpression;
        DataFlowValue value2 = context2.dataFlowValueFactory.createDataFlowValue(expr, type2, context2);
        boolean equality = Intrinsics.areEqual(operationSign.getReferencedNameElementType(), KtTokens.EQEQ) || Intrinsics.areEqual(operationSign.getReferencedNameElementType(), KtTokens.EQEQEQ);
        Nullability nullability = getNullability.invoke(value2);
        switch (WhenMappings.$EnumSwitchMapping$0[nullability.ordinal()]) {
            case 1: {
                bl = equality;
                break;
            }
            case 2: {
                if (!equality) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 3: {
                bl = false;
                break;
            }
            default: {
                return;
            }
        }
        boolean expressionIsAlways = bl;
        context2.trace.report(Errors.SENSELESS_COMPARISON.on((KtBinaryExpression)((PsiElement)expression2), expression2, expressionIsAlways));
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Nullability.values().length];
            try {
                nArray[Nullability.NULL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Nullability.NOT_NULL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Nullability.IMPOSSIBLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

