/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.jetbrains.org.objectweb.asm.tree;

import java.util.ArrayList;
import java.util.List;
import shadow.org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import shadow.org.jetbrains.org.objectweb.asm.Attribute;
import shadow.org.jetbrains.org.objectweb.asm.ClassVisitor;
import shadow.org.jetbrains.org.objectweb.asm.FieldVisitor;
import shadow.org.jetbrains.org.objectweb.asm.MethodVisitor;
import shadow.org.jetbrains.org.objectweb.asm.ModuleVisitor;
import shadow.org.jetbrains.org.objectweb.asm.RecordComponentVisitor;
import shadow.org.jetbrains.org.objectweb.asm.TypePath;
import shadow.org.jetbrains.org.objectweb.asm.tree.AnnotationNode;
import shadow.org.jetbrains.org.objectweb.asm.tree.FieldNode;
import shadow.org.jetbrains.org.objectweb.asm.tree.InnerClassNode;
import shadow.org.jetbrains.org.objectweb.asm.tree.MethodNode;
import shadow.org.jetbrains.org.objectweb.asm.tree.ModuleNode;
import shadow.org.jetbrains.org.objectweb.asm.tree.RecordComponentNode;
import shadow.org.jetbrains.org.objectweb.asm.tree.TypeAnnotationNode;
import shadow.org.jetbrains.org.objectweb.asm.tree.UnsupportedClassVersionException;
import shadow.org.jetbrains.org.objectweb.asm.tree.Util;

public class ClassNode
extends ClassVisitor {
    public int version;
    public int access;
    public String name;
    public String signature;
    public String superName;
    public List<String> interfaces = new ArrayList<String>();
    public String sourceFile;
    public String sourceDebug;
    public ModuleNode module;
    public String outerClass;
    public String outerMethod;
    public String outerMethodDesc;
    public List<AnnotationNode> visibleAnnotations;
    public List<AnnotationNode> invisibleAnnotations;
    public List<TypeAnnotationNode> visibleTypeAnnotations;
    public List<TypeAnnotationNode> invisibleTypeAnnotations;
    public List<Attribute> attrs;
    public List<InnerClassNode> innerClasses = new ArrayList<InnerClassNode>();
    public String nestHostClass;
    public List<String> nestMembers;
    public List<String> permittedSubclasses;
    public List<RecordComponentNode> recordComponents;
    public List<FieldNode> fields = new ArrayList<FieldNode>();
    public List<MethodNode> methods = new ArrayList<MethodNode>();

    public ClassNode() {
        this(589824);
        if (this.getClass() != ClassNode.class) {
            throw new IllegalStateException();
        }
    }

    public ClassNode(int api) {
        super(api);
    }

    public void visit(int version2, int access, String name2, String signature2, String superName, String[] interfaces) {
        this.version = version2;
        this.access = access;
        this.name = name2;
        this.signature = signature2;
        this.superName = superName;
        this.interfaces = Util.asArrayList(interfaces);
    }

    public void visitSource(String file, String debug) {
        this.sourceFile = file;
        this.sourceDebug = debug;
    }

    public ModuleVisitor visitModule(String name2, int access, String version2) {
        this.module = new ModuleNode(name2, access, version2);
        return this.module;
    }

    public void visitNestHost(String nestHost) {
        this.nestHostClass = nestHost;
    }

    public void visitOuterClass(String owner, String name2, String descriptor2) {
        this.outerClass = owner;
        this.outerMethod = name2;
        this.outerMethodDesc = descriptor2;
    }

    public AnnotationVisitor visitAnnotation(String descriptor2, boolean visible) {
        AnnotationNode annotation = new AnnotationNode(descriptor2);
        if (visible) {
            this.visibleAnnotations = Util.add(this.visibleAnnotations, annotation);
        } else {
            this.invisibleAnnotations = Util.add(this.invisibleAnnotations, annotation);
        }
        return annotation;
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor2, boolean visible) {
        TypeAnnotationNode typeAnnotation = new TypeAnnotationNode(typeRef, typePath, descriptor2);
        if (visible) {
            this.visibleTypeAnnotations = Util.add(this.visibleTypeAnnotations, typeAnnotation);
        } else {
            this.invisibleTypeAnnotations = Util.add(this.invisibleTypeAnnotations, typeAnnotation);
        }
        return typeAnnotation;
    }

    public void visitAttribute(Attribute attribute) {
        this.attrs = Util.add(this.attrs, attribute);
    }

    public void visitNestMember(String nestMember) {
        this.nestMembers = Util.add(this.nestMembers, nestMember);
    }

    public void visitPermittedSubclass(String permittedSubclass) {
        this.permittedSubclasses = Util.add(this.permittedSubclasses, permittedSubclass);
    }

    public void visitInnerClass(String name2, String outerName, String innerName, int access) {
        InnerClassNode innerClass = new InnerClassNode(name2, outerName, innerName, access);
        this.innerClasses.add(innerClass);
    }

    public RecordComponentVisitor visitRecordComponent(String name2, String descriptor2, String signature2) {
        RecordComponentNode recordComponent = new RecordComponentNode(name2, descriptor2, signature2);
        this.recordComponents = Util.add(this.recordComponents, recordComponent);
        return recordComponent;
    }

    public FieldVisitor visitField(int access, String name2, String descriptor2, String signature2, Object value2) {
        FieldNode field = new FieldNode(access, name2, descriptor2, signature2, value2);
        this.fields.add(field);
        return field;
    }

    public MethodVisitor visitMethod(int access, String name2, String descriptor2, String signature2, String[] exceptions) {
        MethodNode method = new MethodNode(access, name2, descriptor2, signature2, exceptions);
        this.methods.add(method);
        return method;
    }

    public void visitEnd() {
    }

    public void check(int api) {
        int i2;
        if (api < 589824 && this.permittedSubclasses != null) {
            throw new UnsupportedClassVersionException();
        }
        if (api < 524288 && ((this.access & 0x10000) != 0 || this.recordComponents != null)) {
            throw new UnsupportedClassVersionException();
        }
        if (api < 458752 && (this.nestHostClass != null || this.nestMembers != null)) {
            throw new UnsupportedClassVersionException();
        }
        if (api < 393216 && this.module != null) {
            throw new UnsupportedClassVersionException();
        }
        if (api < 327680) {
            if (this.visibleTypeAnnotations != null && !this.visibleTypeAnnotations.isEmpty()) {
                throw new UnsupportedClassVersionException();
            }
            if (this.invisibleTypeAnnotations != null && !this.invisibleTypeAnnotations.isEmpty()) {
                throw new UnsupportedClassVersionException();
            }
        }
        if (this.visibleAnnotations != null) {
            for (i2 = this.visibleAnnotations.size() - 1; i2 >= 0; --i2) {
                this.visibleAnnotations.get(i2).check(api);
            }
        }
        if (this.invisibleAnnotations != null) {
            for (i2 = this.invisibleAnnotations.size() - 1; i2 >= 0; --i2) {
                this.invisibleAnnotations.get(i2).check(api);
            }
        }
        if (this.visibleTypeAnnotations != null) {
            for (i2 = this.visibleTypeAnnotations.size() - 1; i2 >= 0; --i2) {
                this.visibleTypeAnnotations.get(i2).check(api);
            }
        }
        if (this.invisibleTypeAnnotations != null) {
            for (i2 = this.invisibleTypeAnnotations.size() - 1; i2 >= 0; --i2) {
                this.invisibleTypeAnnotations.get(i2).check(api);
            }
        }
        if (this.recordComponents != null) {
            for (i2 = this.recordComponents.size() - 1; i2 >= 0; --i2) {
                this.recordComponents.get(i2).check(api);
            }
        }
        for (i2 = this.fields.size() - 1; i2 >= 0; --i2) {
            this.fields.get(i2).check(api);
        }
        for (i2 = this.methods.size() - 1; i2 >= 0; --i2) {
            this.methods.get(i2).check(api);
        }
    }

    public void accept(ClassVisitor classVisitor2) {
        TypeAnnotationNode typeAnnotation;
        AnnotationNode annotation;
        int i2;
        int n2;
        String[] interfacesArray = new String[this.interfaces.size()];
        this.interfaces.toArray(interfacesArray);
        classVisitor2.visit(this.version, this.access, this.name, this.signature, this.superName, interfacesArray);
        if (this.sourceFile != null || this.sourceDebug != null) {
            classVisitor2.visitSource(this.sourceFile, this.sourceDebug);
        }
        if (this.module != null) {
            this.module.accept(classVisitor2);
        }
        if (this.nestHostClass != null) {
            classVisitor2.visitNestHost(this.nestHostClass);
        }
        if (this.outerClass != null) {
            classVisitor2.visitOuterClass(this.outerClass, this.outerMethod, this.outerMethodDesc);
        }
        if (this.visibleAnnotations != null) {
            n2 = this.visibleAnnotations.size();
            for (i2 = 0; i2 < n2; ++i2) {
                annotation = this.visibleAnnotations.get(i2);
                annotation.accept(classVisitor2.visitAnnotation(annotation.desc, true));
            }
        }
        if (this.invisibleAnnotations != null) {
            n2 = this.invisibleAnnotations.size();
            for (i2 = 0; i2 < n2; ++i2) {
                annotation = this.invisibleAnnotations.get(i2);
                annotation.accept(classVisitor2.visitAnnotation(annotation.desc, false));
            }
        }
        if (this.visibleTypeAnnotations != null) {
            n2 = this.visibleTypeAnnotations.size();
            for (i2 = 0; i2 < n2; ++i2) {
                typeAnnotation = this.visibleTypeAnnotations.get(i2);
                typeAnnotation.accept(classVisitor2.visitTypeAnnotation(typeAnnotation.typeRef, typeAnnotation.typePath, typeAnnotation.desc, true));
            }
        }
        if (this.invisibleTypeAnnotations != null) {
            n2 = this.invisibleTypeAnnotations.size();
            for (i2 = 0; i2 < n2; ++i2) {
                typeAnnotation = this.invisibleTypeAnnotations.get(i2);
                typeAnnotation.accept(classVisitor2.visitTypeAnnotation(typeAnnotation.typeRef, typeAnnotation.typePath, typeAnnotation.desc, false));
            }
        }
        if (this.attrs != null) {
            n2 = this.attrs.size();
            for (i2 = 0; i2 < n2; ++i2) {
                classVisitor2.visitAttribute(this.attrs.get(i2));
            }
        }
        if (this.nestMembers != null) {
            n2 = this.nestMembers.size();
            for (i2 = 0; i2 < n2; ++i2) {
                classVisitor2.visitNestMember(this.nestMembers.get(i2));
            }
        }
        if (this.permittedSubclasses != null) {
            n2 = this.permittedSubclasses.size();
            for (i2 = 0; i2 < n2; ++i2) {
                classVisitor2.visitPermittedSubclass(this.permittedSubclasses.get(i2));
            }
        }
        n2 = this.innerClasses.size();
        for (i2 = 0; i2 < n2; ++i2) {
            this.innerClasses.get(i2).accept(classVisitor2);
        }
        if (this.recordComponents != null) {
            n2 = this.recordComponents.size();
            for (i2 = 0; i2 < n2; ++i2) {
                this.recordComponents.get(i2).accept(classVisitor2);
            }
        }
        n2 = this.fields.size();
        for (i2 = 0; i2 < n2; ++i2) {
            this.fields.get(i2).accept(classVisitor2);
        }
        n2 = this.methods.size();
        for (i2 = 0; i2 < n2; ++i2) {
            this.methods.get(i2).accept(classVisitor2);
        }
        classVisitor2.visitEnd();
    }
}

