/*
 * Decompiled with CFR 0.152.
 */
package io.nlopez.compose.rules;

import io.nlopez.compose.core.ComposeKtConfig;
import io.nlopez.compose.core.ComposeKtVisitor;
import io.nlopez.compose.core.Emitter;
import io.nlopez.compose.core.EmitterKt;
import io.nlopez.compose.core.util.LambdasKt;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0018\u0010\f\u001a\u00020\r*\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lio/nlopez/compose/rules/ParameterNaming;", "Lio/nlopez/compose/core/ComposeKtVisitor;", "<init>", "()V", "visitComposable", "", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "emitter", "Lio/nlopez/compose/core/Emitter;", "config", "Lio/nlopez/compose/core/ComposeKtConfig;", "isPastTense", "", "", "(Ljava/lang/String;)Z", "Companion", "common-ktlint"})
@SourceDebugExtension(value={"SMAP\nParameterNaming.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParameterNaming.kt\nio/nlopez/compose/rules/ParameterNaming\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,248:1\n2746#2,3:249\n1761#2,3:252\n*S KotlinDebug\n*F\n+ 1 ParameterNaming.kt\nio/nlopez/compose/rules/ParameterNaming\n*L\n41#1:249,3\n42#1:252,3\n*E\n"})
public final class ParameterNaming
implements ComposeKtVisitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Lazy<Set<String>> IrregularVerbsInPastTense$delegate = LazyKt.lazy(ParameterNaming::IrregularVerbsInPastTense_delegate$lambda$0);
    @NotNull
    private static final Lazy<Set<String>> VerbsPresentTenseEndingInEd$delegate = LazyKt.lazy(ParameterNaming::VerbsPresentTenseEndingInEd_delegate$lambda$0);
    @NotNull
    private static final Lazy<Set<String>> ExceptionsInCompose$delegate = LazyKt.lazy(ParameterNaming::ExceptionsInCompose_delegate$lambda$0);
    @NotNull
    private static final String LambdaParametersInPresentTense = "Lambda parameters in a composable function should be in present tense, not past tense.\nExamples: `onClick` and not `onClicked`, `onTextChange` and not `onTextChanged`, etc.\nSee https://mrmans0n.github.io/compose-rules/rules/#naming-parameters-properly for more information.";

    @Override
    public void visitComposable(@NotNull KtFunction function2, @NotNull Emitter emitter, @NotNull ComposeKtConfig config) {
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(emitter, "emitter");
        Intrinsics.checkNotNullParameter(config, "config");
        KtFile ktFile = function2.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue(ktFile, "getContainingKtFile(...)");
        Set<String> lambdaTypes = LambdasKt.lambdaTypes(ktFile, config);
        Set<String> allowed = config.getSet("allowedLambdaParameterNames", SetsKt.emptySet());
        List<KtParameter> list = function2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, "getValueParameters(...)");
        List<KtParameter> errors = SequencesKt.toList(SequencesKt.filter(SequencesKt.filterNot(SequencesKt.filterNot(SequencesKt.filter(SequencesKt.filter(CollectionsKt.asSequence((Iterable)list), arg_0 -> ParameterNaming.visitComposable$lambda$0(lambdaTypes, arg_0)), ParameterNaming::visitComposable$lambda$1), arg_0 -> ParameterNaming.visitComposable$lambda$2(allowed, arg_0)), ParameterNaming::visitComposable$lambda$3), arg_0 -> ParameterNaming.visitComposable$lambda$4(this, arg_0)));
        for (KtParameter error : errors) {
            Intrinsics.checkNotNull(error);
            EmitterKt.report(emitter, error, LambdaParametersInPresentTense);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isPastTense(String $this$isPastTense) {
        String it;
        boolean bl;
        Iterable $this$none$iv = ParameterNaming.Companion.getVerbsPresentTenseEndingInEd();
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            bl = true;
        } else {
            for (Object element$iv : $this$none$iv) {
                it = (String)element$iv;
                boolean bl2 = false;
                if (!StringsKt.endsWith$default($this$isPastTense, it, false, 2, null)) continue;
                return false;
            }
            bl = true;
        }
        if (!bl) return false;
        if (StringsKt.endsWith$default($this$isPastTense, "ed", false, 2, null)) return true;
        Iterable $this$any$iv = ParameterNaming.Companion.getIrregularVerbsInPastTense();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            Object element$iv;
            if (!iterator2.hasNext()) return false;
            element$iv = iterator2.next();
            it = (String)element$iv;
            boolean bl3 = false;
        } while (!StringsKt.endsWith$default($this$isPastTense, it, false, 2, null));
        return true;
    }

    private static final boolean visitComposable$lambda$0(Set $lambdaTypes, KtParameter it) {
        KtTypeReference ktTypeReference = it.getTypeReference();
        return ktTypeReference != null ? LambdasKt.isLambda(ktTypeReference, (Set<String>)$lambdaTypes) : false;
    }

    private static final boolean visitComposable$lambda$1(KtParameter it) {
        String string = it.getName();
        return string != null ? StringsKt.startsWith$default(string, "on", false, 2, null) : false;
    }

    private static final boolean visitComposable$lambda$2(Set $allowed, KtParameter it) {
        return CollectionsKt.contains($allowed, it.getName());
    }

    private static final boolean visitComposable$lambda$3(KtParameter it) {
        return CollectionsKt.contains(ParameterNaming.Companion.getExceptionsInCompose(), it.getName());
    }

    private static final boolean visitComposable$lambda$4(ParameterNaming this$0, KtParameter it) {
        String string = it.getName();
        return string != null ? this$0.isPastTense(string) : false;
    }

    private static final Set IrregularVerbsInPastTense_delegate$lambda$0() {
        String[] stringArray = new String[]{"Arose", "Arisen", "Ate", "Awoke", "Awoken", "Beaten", "Became", "Been", "Began", "Begun", "Bent", "Bit", "Bitten", "Bled", "Blew", "Blown", "Bore", "Borne", "Bought", "Bound", "Bred", "Broke", "Broken", "Brought", "Built", "Burnt", "Burst", "Came", "Caught", "Chose", "Chosen", "Clung", "Crept", "Dealt", "Did", "Done", "Drank", "Drawn", "Dreamt", "Drew", "Driven", "Drove", "Drunk", "Eaten", "Fallen", "Fed", "Felt", "Fled", "Flew", "Flown", "Forbade", "Forbidden", "Forgave", "Forgiven", "Forgot", "Forgotten", "Fought", "Found", "Froze", "Frozen", "Gave", "Given", "Gone", "Got", "Gotten", "Grew", "Grown", "Had", "Heard", "Held", "Hid", "Hidden", "Hung", "Kept", "Knew", "Known", "Laid", "Lain", "Lay", "Led", "Lent", "Lit", "Lost", "Made", "Meant", "Met", "Paid", "Ran", "Rang", "Ridden", "Risen", "Rode", "Rose", "Rung", "Said", "Sang", "Sank", "Sat", "Saw", "Seen", "Sent", "Shaken", "Shone", "Shook", "Shot", "Showed", "Shown", "Shrank", "Shrunk", "Slept", "Slid", "Sold", "Sought", "Spent", "Spoke", "Spoken", "Sprang", "Sprung", "Spun", "Stole", "Stolen", "Stood", "Struck", "Stuck", "Stung", "Sung", "Sunk", "Swam", "Swept", "Swore", "Sworn", "Swum", "Swung", "Taken", "Taught", "Thought", "Threw", "Thrown", "Told", "Took", "Tore", "Torn", "Understood", "Was", "Went", "Were", "Woke", "Woken", "Won", "Wore", "Worn", "Wound", "Written", "Wrote"};
        return SetsKt.setOf(stringArray);
    }

    private static final Set VerbsPresentTenseEndingInEd_delegate$lambda$0() {
        String[] stringArray = new String[]{"Bed", "Bleed", "Embed", "Exceed", "Feed", "Heed", "Need", "Proceed", "Seed", "Shed", "Shred", "Sled", "Speed", "Succeed", "Wed", "Weed"};
        return SetsKt.setOf(stringArray);
    }

    private static final Set ExceptionsInCompose_delegate$lambda$0() {
        String[] stringArray = new String[]{"onFocusChanged", "onPlaced", "onValueChangeFinished", "onDone"};
        return SetsKt.setOf(stringArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u000e\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R!\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR!\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\n\u001a\u0004\b\f\u0010\bR!\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\n\u001a\u0004\b\u000f\u0010\bR\u0011\u0010\u0011\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lio/nlopez/compose/rules/ParameterNaming$Companion;", "", "<init>", "()V", "IrregularVerbsInPastTense", "", "", "getIrregularVerbsInPastTense", "()Ljava/util/Set;", "IrregularVerbsInPastTense$delegate", "Lkotlin/Lazy;", "VerbsPresentTenseEndingInEd", "getVerbsPresentTenseEndingInEd", "VerbsPresentTenseEndingInEd$delegate", "ExceptionsInCompose", "getExceptionsInCompose", "ExceptionsInCompose$delegate", "LambdaParametersInPresentTense", "getLambdaParametersInPresentTense", "()Ljava/lang/String;", "common-ktlint"})
    public static final class Companion {
        private Companion() {
        }

        private final Set<String> getIrregularVerbsInPastTense() {
            Lazy lazy = IrregularVerbsInPastTense$delegate;
            return (Set)lazy.getValue();
        }

        private final Set<String> getVerbsPresentTenseEndingInEd() {
            Lazy lazy = VerbsPresentTenseEndingInEd$delegate;
            return (Set)lazy.getValue();
        }

        private final Set<String> getExceptionsInCompose() {
            Lazy lazy = ExceptionsInCompose$delegate;
            return (Set)lazy.getValue();
        }

        @NotNull
        public final String getLambdaParametersInPresentTense() {
            return LambdaParametersInPresentTense;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

