/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.common.collect;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import org.jetbrains.kotlin.com.google.common.base.Preconditions;
import org.jetbrains.kotlin.com.google.common.collect.AbstractMultimap;
import org.jetbrains.kotlin.com.google.common.collect.CollectSpliterators;
import org.jetbrains.kotlin.com.google.common.collect.Collections2;
import org.jetbrains.kotlin.com.google.common.collect.Iterators;
import org.jetbrains.kotlin.com.google.common.collect.Maps;
import org.jetbrains.kotlin.com.google.common.collect.Multimaps;
import org.jetbrains.kotlin.com.google.common.collect.Multiset;
import org.jetbrains.kotlin.com.google.common.collect.NullnessCasts;
import org.jetbrains.kotlin.com.google.common.collect.SetMultimap;
import org.jetbrains.kotlin.com.google.common.collect.Sets;

abstract class AbstractMapBasedMultimap<K, V>
extends AbstractMultimap<K, V>
implements Serializable {
    private transient Map<K, Collection<V>> map;
    private transient int totalSize;
    private static final long serialVersionUID = 2447537837011683357L;

    protected AbstractMapBasedMultimap(Map<K, Collection<V>> map2) {
        Preconditions.checkArgument(map2.isEmpty());
        this.map = map2;
    }

    final void setMap(Map<K, Collection<V>> map2) {
        this.map = map2;
        this.totalSize = 0;
        for (Collection<Collection<V>> values2 : map2.values()) {
            Preconditions.checkArgument(!values2.isEmpty());
            this.totalSize += values2.size();
        }
    }

    Collection<V> createUnmodifiableEmptyCollection() {
        return this.unmodifiableCollectionSubclass(this.createCollection());
    }

    abstract Collection<V> createCollection();

    Collection<V> createCollection(K key) {
        return this.createCollection();
    }

    Map<K, Collection<V>> backingMap() {
        return this.map;
    }

    @Override
    public int size() {
        return this.totalSize;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean put(K key, V value2) {
        Collection<V> collection = this.map.get(key);
        if (collection == null) {
            collection = this.createCollection(key);
            if (collection.add(value2)) {
                ++this.totalSize;
                this.map.put(key, collection);
                return true;
            }
            throw new AssertionError((Object)"New Collection violated the Collection spec");
        }
        if (collection.add(value2)) {
            ++this.totalSize;
            return true;
        }
        return false;
    }

    private Collection<V> getOrCreateCollection(K key) {
        Collection<V> collection = this.map.get(key);
        if (collection == null) {
            collection = this.createCollection(key);
            this.map.put(key, collection);
        }
        return collection;
    }

    @Override
    public Collection<V> replaceValues(K key, Iterable<? extends V> values2) {
        Iterator<V> iterator2 = values2.iterator();
        if (!iterator2.hasNext()) {
            return this.removeAll(key);
        }
        Collection<V> collection = this.getOrCreateCollection(key);
        Collection<V> oldValues = this.createCollection();
        oldValues.addAll(collection);
        this.totalSize -= collection.size();
        collection.clear();
        while (iterator2.hasNext()) {
            if (!collection.add(iterator2.next())) continue;
            ++this.totalSize;
        }
        return this.unmodifiableCollectionSubclass(oldValues);
    }

    @Override
    public Collection<V> removeAll(Object key) {
        Collection<V> collection = this.map.remove(key);
        if (collection == null) {
            return this.createUnmodifiableEmptyCollection();
        }
        Collection<V> output2 = this.createCollection();
        output2.addAll(collection);
        this.totalSize -= collection.size();
        collection.clear();
        return this.unmodifiableCollectionSubclass(output2);
    }

    <E> Collection<E> unmodifiableCollectionSubclass(Collection<E> collection) {
        return Collections.unmodifiableCollection(collection);
    }

    @Override
    public void clear() {
        for (Collection<V> collection : this.map.values()) {
            collection.clear();
        }
        this.map.clear();
        this.totalSize = 0;
    }

    @Override
    public Collection<V> get(K key) {
        Collection<V> collection = this.map.get(key);
        if (collection == null) {
            collection = this.createCollection(key);
        }
        return this.wrapCollection(key, collection);
    }

    Collection<V> wrapCollection(K key, Collection<V> collection) {
        return new WrappedCollection(key, collection, null);
    }

    final List<V> wrapList(K key, List<V> list, WrappedCollection ancestor) {
        return list instanceof RandomAccess ? new RandomAccessWrappedList(key, list, ancestor) : new WrappedList(key, list, ancestor);
    }

    private static <E> Iterator<E> iteratorOrListIterator(Collection<E> collection) {
        return collection instanceof List ? ((List)collection).listIterator() : collection.iterator();
    }

    @Override
    Set<K> createKeySet() {
        return new KeySet(this.map);
    }

    final Set<K> createMaybeNavigableKeySet() {
        if (this.map instanceof NavigableMap) {
            return new NavigableKeySet((NavigableMap)this.map);
        }
        if (this.map instanceof SortedMap) {
            return new SortedKeySet((SortedMap)this.map);
        }
        return new KeySet(this.map);
    }

    private void removeValuesForKey(Object key) {
        Collection<V> collection = Maps.safeRemove(this.map, key);
        if (collection != null) {
            int count2 = collection.size();
            collection.clear();
            this.totalSize -= count2;
        }
    }

    @Override
    public Collection<V> values() {
        return super.values();
    }

    @Override
    Collection<V> createValues() {
        return new AbstractMultimap.Values(this);
    }

    @Override
    Iterator<V> valueIterator() {
        return new Itr(){

            V output(K key, V value2) {
                return value2;
            }
        };
    }

    @Override
    Spliterator<V> valueSpliterator() {
        return CollectSpliterators.flatMap(this.map.values().spliterator(), Collection::spliterator, 64, this.size());
    }

    @Override
    Multiset<K> createKeys() {
        return new Multimaps.Keys(this);
    }

    @Override
    public Collection<Map.Entry<K, V>> entries() {
        return super.entries();
    }

    @Override
    Collection<Map.Entry<K, V>> createEntries() {
        if (this instanceof SetMultimap) {
            return new AbstractMultimap.EntrySet(this);
        }
        return new AbstractMultimap.Entries(this);
    }

    @Override
    Iterator<Map.Entry<K, V>> entryIterator() {
        return new Itr(){

            Map.Entry<K, V> output(K key, V value2) {
                return Maps.immutableEntry(key, value2);
            }
        };
    }

    @Override
    Spliterator<Map.Entry<K, V>> entrySpliterator() {
        return CollectSpliterators.flatMap(this.map.entrySet().spliterator(), keyToValueCollectionEntry -> {
            Object key = keyToValueCollectionEntry.getKey();
            Collection valueCollection = (Collection)keyToValueCollectionEntry.getValue();
            return CollectSpliterators.map(valueCollection.spliterator(), value2 -> Maps.immutableEntry(key, value2));
        }, 64, this.size());
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        Preconditions.checkNotNull(action);
        this.map.forEach((key, valueCollection) -> valueCollection.forEach((? super T value2) -> action.accept((Object)key, (Object)value2)));
    }

    @Override
    Map<K, Collection<V>> createAsMap() {
        return new AsMap(this.map);
    }

    final Map<K, Collection<V>> createMaybeNavigableAsMap() {
        if (this.map instanceof NavigableMap) {
            return new NavigableAsMap((NavigableMap)this.map);
        }
        if (this.map instanceof SortedMap) {
            return new SortedAsMap((SortedMap)this.map);
        }
        return new AsMap(this.map);
    }

    class WrappedCollection
    extends AbstractCollection<V> {
        final K key;
        Collection<V> delegate;
        final WrappedCollection ancestor;
        final Collection<V> ancestorDelegate;

        WrappedCollection(K key, Collection<V> delegate, WrappedCollection ancestor) {
            this.key = key;
            this.delegate = delegate;
            this.ancestor = ancestor;
            this.ancestorDelegate = ancestor == null ? null : ancestor.getDelegate();
        }

        void refreshIfEmpty() {
            Collection newDelegate;
            if (this.ancestor != null) {
                this.ancestor.refreshIfEmpty();
                if (this.ancestor.getDelegate() != this.ancestorDelegate) {
                    throw new ConcurrentModificationException();
                }
            } else if (this.delegate.isEmpty() && (newDelegate = (Collection)AbstractMapBasedMultimap.this.map.get(this.key)) != null) {
                this.delegate = newDelegate;
            }
        }

        void removeIfEmpty() {
            if (this.ancestor != null) {
                this.ancestor.removeIfEmpty();
            } else if (this.delegate.isEmpty()) {
                AbstractMapBasedMultimap.this.map.remove(this.key);
            }
        }

        K getKey() {
            return this.key;
        }

        void addToMap() {
            if (this.ancestor != null) {
                this.ancestor.addToMap();
            } else {
                AbstractMapBasedMultimap.this.map.put(this.key, this.delegate);
            }
        }

        @Override
        public int size() {
            this.refreshIfEmpty();
            return this.delegate.size();
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            this.refreshIfEmpty();
            return this.delegate.equals(object);
        }

        @Override
        public int hashCode() {
            this.refreshIfEmpty();
            return this.delegate.hashCode();
        }

        @Override
        public String toString() {
            this.refreshIfEmpty();
            return this.delegate.toString();
        }

        Collection<V> getDelegate() {
            return this.delegate;
        }

        @Override
        public Iterator<V> iterator() {
            this.refreshIfEmpty();
            return new WrappedIterator();
        }

        @Override
        public Spliterator<V> spliterator() {
            this.refreshIfEmpty();
            return this.delegate.spliterator();
        }

        @Override
        public boolean add(V value2) {
            this.refreshIfEmpty();
            boolean wasEmpty = this.delegate.isEmpty();
            boolean changed = this.delegate.add(value2);
            if (changed) {
                AbstractMapBasedMultimap.this.totalSize++;
                if (wasEmpty) {
                    this.addToMap();
                }
            }
            return changed;
        }

        WrappedCollection getAncestor() {
            return this.ancestor;
        }

        @Override
        public boolean addAll(Collection<? extends V> collection) {
            if (collection.isEmpty()) {
                return false;
            }
            int oldSize = this.size();
            boolean changed = this.delegate.addAll(collection);
            if (changed) {
                int newSize = this.delegate.size();
                AbstractMapBasedMultimap.this.totalSize += newSize - oldSize;
                if (oldSize == 0) {
                    this.addToMap();
                }
            }
            return changed;
        }

        @Override
        public boolean contains(Object o2) {
            this.refreshIfEmpty();
            return this.delegate.contains(o2);
        }

        @Override
        public boolean containsAll(Collection<?> c2) {
            this.refreshIfEmpty();
            return this.delegate.containsAll(c2);
        }

        @Override
        public void clear() {
            int oldSize = this.size();
            if (oldSize == 0) {
                return;
            }
            this.delegate.clear();
            AbstractMapBasedMultimap.this.totalSize -= oldSize;
            this.removeIfEmpty();
        }

        @Override
        public boolean remove(Object o2) {
            this.refreshIfEmpty();
            boolean changed = this.delegate.remove(o2);
            if (changed) {
                AbstractMapBasedMultimap.this.totalSize--;
                this.removeIfEmpty();
            }
            return changed;
        }

        @Override
        public boolean removeAll(Collection<?> c2) {
            if (c2.isEmpty()) {
                return false;
            }
            int oldSize = this.size();
            boolean changed = this.delegate.removeAll(c2);
            if (changed) {
                int newSize = this.delegate.size();
                AbstractMapBasedMultimap.this.totalSize += newSize - oldSize;
                this.removeIfEmpty();
            }
            return changed;
        }

        @Override
        public boolean retainAll(Collection<?> c2) {
            Preconditions.checkNotNull(c2);
            int oldSize = this.size();
            boolean changed = this.delegate.retainAll(c2);
            if (changed) {
                int newSize = this.delegate.size();
                AbstractMapBasedMultimap.this.totalSize += newSize - oldSize;
                this.removeIfEmpty();
            }
            return changed;
        }

        class WrappedIterator
        implements Iterator<V> {
            final Iterator<V> delegateIterator;
            final Collection<V> originalDelegate;

            WrappedIterator() {
                this.originalDelegate = WrappedCollection.this.delegate;
                this.delegateIterator = AbstractMapBasedMultimap.iteratorOrListIterator(WrappedCollection.this.delegate);
            }

            WrappedIterator(Iterator<V> delegateIterator) {
                this.originalDelegate = WrappedCollection.this.delegate;
                this.delegateIterator = delegateIterator;
            }

            void validateIterator() {
                WrappedCollection.this.refreshIfEmpty();
                if (WrappedCollection.this.delegate != this.originalDelegate) {
                    throw new ConcurrentModificationException();
                }
            }

            @Override
            public boolean hasNext() {
                this.validateIterator();
                return this.delegateIterator.hasNext();
            }

            @Override
            public V next() {
                this.validateIterator();
                return this.delegateIterator.next();
            }

            @Override
            public void remove() {
                this.delegateIterator.remove();
                AbstractMapBasedMultimap.this.totalSize--;
                WrappedCollection.this.removeIfEmpty();
            }

            Iterator<V> getDelegateIterator() {
                this.validateIterator();
                return this.delegateIterator;
            }
        }
    }

    private class RandomAccessWrappedList
    extends WrappedList
    implements RandomAccess {
        RandomAccessWrappedList(K key, List<V> delegate, WrappedCollection ancestor) {
            super(key, delegate, ancestor);
        }
    }

    class WrappedList
    extends WrappedCollection
    implements List {
        WrappedList(K key, List<V> delegate, WrappedCollection ancestor) {
            super(key, delegate, ancestor);
        }

        List<V> getListDelegate() {
            return (List)this.getDelegate();
        }

        public boolean addAll(int index, Collection<? extends V> c2) {
            if (c2.isEmpty()) {
                return false;
            }
            int oldSize = this.size();
            boolean changed = this.getListDelegate().addAll(index, c2);
            if (changed) {
                int newSize = this.getDelegate().size();
                AbstractMapBasedMultimap.this.totalSize += newSize - oldSize;
                if (oldSize == 0) {
                    this.addToMap();
                }
            }
            return changed;
        }

        public V get(int index) {
            this.refreshIfEmpty();
            return this.getListDelegate().get(index);
        }

        public V set(int index, V element) {
            this.refreshIfEmpty();
            return this.getListDelegate().set(index, element);
        }

        public void add(int index, V element) {
            this.refreshIfEmpty();
            boolean wasEmpty = this.getDelegate().isEmpty();
            this.getListDelegate().add(index, element);
            AbstractMapBasedMultimap.this.totalSize++;
            if (wasEmpty) {
                this.addToMap();
            }
        }

        public V remove(int index) {
            this.refreshIfEmpty();
            Object value2 = this.getListDelegate().remove(index);
            AbstractMapBasedMultimap.this.totalSize--;
            this.removeIfEmpty();
            return value2;
        }

        @Override
        public int indexOf(Object o2) {
            this.refreshIfEmpty();
            return this.getListDelegate().indexOf(o2);
        }

        @Override
        public int lastIndexOf(Object o2) {
            this.refreshIfEmpty();
            return this.getListDelegate().lastIndexOf(o2);
        }

        public ListIterator<V> listIterator() {
            this.refreshIfEmpty();
            return new WrappedListIterator();
        }

        public ListIterator<V> listIterator(int index) {
            this.refreshIfEmpty();
            return new WrappedListIterator(index);
        }

        public List<V> subList(int fromIndex, int toIndex) {
            this.refreshIfEmpty();
            return AbstractMapBasedMultimap.this.wrapList(this.getKey(), this.getListDelegate().subList(fromIndex, toIndex), this.getAncestor() == null ? this : this.getAncestor());
        }

        private class WrappedListIterator
        extends WrappedCollection.WrappedIterator
        implements ListIterator {
            WrappedListIterator() {
            }

            public WrappedListIterator(int index) {
                super(WrappedList.this.getListDelegate().listIterator(index));
            }

            private ListIterator<V> getDelegateListIterator() {
                return (ListIterator)this.getDelegateIterator();
            }

            @Override
            public boolean hasPrevious() {
                return this.getDelegateListIterator().hasPrevious();
            }

            public V previous() {
                return this.getDelegateListIterator().previous();
            }

            @Override
            public int nextIndex() {
                return this.getDelegateListIterator().nextIndex();
            }

            @Override
            public int previousIndex() {
                return this.getDelegateListIterator().previousIndex();
            }

            public void set(V value2) {
                this.getDelegateListIterator().set(value2);
            }

            public void add(V value2) {
                boolean wasEmpty = WrappedList.this.isEmpty();
                this.getDelegateListIterator().add(value2);
                AbstractMapBasedMultimap.this.totalSize++;
                if (wasEmpty) {
                    WrappedList.this.addToMap();
                }
            }
        }
    }

    private class KeySet
    extends Maps.KeySet<K, Collection<V>> {
        KeySet(Map<K, Collection<V>> subMap) {
            super(subMap);
        }

        @Override
        public Iterator<K> iterator() {
            final Iterator entryIterator = this.map().entrySet().iterator();
            return new Iterator<K>(){
                Map.Entry<K, Collection<V>> entry;
                final /* synthetic */ KeySet this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public boolean hasNext() {
                    return entryIterator.hasNext();
                }

                @Override
                public K next() {
                    this.entry = (Map.Entry)entryIterator.next();
                    return this.entry.getKey();
                }

                @Override
                public void remove() {
                    Preconditions.checkState(this.entry != null, "no calls to next() since the last call to remove()");
                    Collection collection = this.entry.getValue();
                    entryIterator.remove();
                    this.this$1.AbstractMapBasedMultimap.this.totalSize -= collection.size();
                    collection.clear();
                    this.entry = null;
                }
            };
        }

        @Override
        public Spliterator<K> spliterator() {
            return this.map().keySet().spliterator();
        }

        @Override
        public boolean remove(Object key) {
            int count2 = 0;
            Collection collection = (Collection)this.map().remove(key);
            if (collection != null) {
                count2 = collection.size();
                collection.clear();
                AbstractMapBasedMultimap.this.totalSize -= count2;
            }
            return count2 > 0;
        }

        @Override
        public void clear() {
            Iterators.clear(this.iterator());
        }

        @Override
        public boolean containsAll(Collection<?> c2) {
            return this.map().keySet().containsAll(c2);
        }

        @Override
        public boolean equals(Object object) {
            return this == object || this.map().keySet().equals(object);
        }

        @Override
        public int hashCode() {
            return this.map().keySet().hashCode();
        }
    }

    private final class NavigableKeySet
    extends SortedKeySet
    implements NavigableSet {
        NavigableKeySet(NavigableMap<K, Collection<V>> subMap) {
            super(subMap);
        }

        NavigableMap<K, Collection<V>> sortedMap() {
            return (NavigableMap)super.sortedMap();
        }

        public K lower(K k2) {
            return this.sortedMap().lowerKey(k2);
        }

        public K floor(K k2) {
            return this.sortedMap().floorKey(k2);
        }

        public K ceiling(K k2) {
            return this.sortedMap().ceilingKey(k2);
        }

        public K higher(K k2) {
            return this.sortedMap().higherKey(k2);
        }

        public K pollFirst() {
            return Iterators.pollNext(this.iterator());
        }

        public K pollLast() {
            return Iterators.pollNext(this.descendingIterator());
        }

        public NavigableSet<K> descendingSet() {
            return new NavigableKeySet(this.sortedMap().descendingMap());
        }

        public Iterator<K> descendingIterator() {
            return this.descendingSet().iterator();
        }

        @Override
        public NavigableSet<K> headSet(K toElement) {
            return this.headSet((K)toElement, false);
        }

        public NavigableSet<K> headSet(K toElement, boolean inclusive) {
            return new NavigableKeySet(this.sortedMap().headMap(toElement, inclusive));
        }

        @Override
        public NavigableSet<K> subSet(K fromElement, K toElement) {
            return this.subSet((K)fromElement, true, (K)toElement, false);
        }

        public NavigableSet<K> subSet(K fromElement, boolean fromInclusive, K toElement, boolean toInclusive) {
            return new NavigableKeySet(this.sortedMap().subMap(fromElement, fromInclusive, toElement, toInclusive));
        }

        @Override
        public NavigableSet<K> tailSet(K fromElement) {
            return this.tailSet((K)fromElement, true);
        }

        public NavigableSet<K> tailSet(K fromElement, boolean inclusive) {
            return new NavigableKeySet(this.sortedMap().tailMap(fromElement, inclusive));
        }
    }

    private class SortedKeySet
    extends KeySet
    implements SortedSet {
        SortedKeySet(SortedMap<K, Collection<V>> subMap) {
            super(subMap);
        }

        SortedMap<K, Collection<V>> sortedMap() {
            return (SortedMap)super.map();
        }

        public Comparator<? super K> comparator() {
            return this.sortedMap().comparator();
        }

        public K first() {
            return this.sortedMap().firstKey();
        }

        public SortedSet<K> headSet(K toElement) {
            return new SortedKeySet(this.sortedMap().headMap(toElement));
        }

        public K last() {
            return this.sortedMap().lastKey();
        }

        public SortedSet<K> subSet(K fromElement, K toElement) {
            return new SortedKeySet(this.sortedMap().subMap(fromElement, toElement));
        }

        public SortedSet<K> tailSet(K fromElement) {
            return new SortedKeySet(this.sortedMap().tailMap(fromElement));
        }
    }

    private class AsMap
    extends Maps.ViewCachingAbstractMap<K, Collection<V>> {
        final transient Map<K, Collection<V>> submap;

        AsMap(Map<K, Collection<V>> submap) {
            this.submap = submap;
        }

        @Override
        protected Set<Map.Entry<K, Collection<V>>> createEntrySet() {
            return new AsMapEntries();
        }

        @Override
        public boolean containsKey(Object key) {
            return Maps.safeContainsKey(this.submap, key);
        }

        @Override
        public Collection<V> get(Object key) {
            Collection collection = Maps.safeGet(this.submap, key);
            if (collection == null) {
                return null;
            }
            Object k2 = key;
            return AbstractMapBasedMultimap.this.wrapCollection(k2, collection);
        }

        @Override
        public Set<K> keySet() {
            return AbstractMapBasedMultimap.this.keySet();
        }

        @Override
        public int size() {
            return this.submap.size();
        }

        @Override
        public Collection<V> remove(Object key) {
            Collection collection = this.submap.remove(key);
            if (collection == null) {
                return null;
            }
            Collection output2 = AbstractMapBasedMultimap.this.createCollection();
            output2.addAll(collection);
            AbstractMapBasedMultimap.this.totalSize -= collection.size();
            collection.clear();
            return output2;
        }

        @Override
        public boolean equals(Object object) {
            return this == object || this.submap.equals(object);
        }

        @Override
        public int hashCode() {
            return this.submap.hashCode();
        }

        @Override
        public String toString() {
            return this.submap.toString();
        }

        @Override
        public void clear() {
            if (this.submap == AbstractMapBasedMultimap.this.map) {
                AbstractMapBasedMultimap.this.clear();
            } else {
                Iterators.clear(new AsMapIterator());
            }
        }

        Map.Entry<K, Collection<V>> wrapEntry(Map.Entry<K, Collection<V>> entry) {
            Object key = entry.getKey();
            return Maps.immutableEntry(key, AbstractMapBasedMultimap.this.wrapCollection(key, entry.getValue()));
        }

        class AsMapEntries
        extends Maps.EntrySet<K, Collection<V>> {
            AsMapEntries() {
            }

            @Override
            Map<K, Collection<V>> map() {
                return AsMap.this;
            }

            @Override
            public Iterator<Map.Entry<K, Collection<V>>> iterator() {
                return new AsMapIterator();
            }

            @Override
            public Spliterator<Map.Entry<K, Collection<V>>> spliterator() {
                return CollectSpliterators.map(AsMap.this.submap.entrySet().spliterator(), AsMap.this::wrapEntry);
            }

            @Override
            public boolean contains(Object o2) {
                return Collections2.safeContains(AsMap.this.submap.entrySet(), o2);
            }

            @Override
            public boolean remove(Object o2) {
                if (!this.contains(o2)) {
                    return false;
                }
                Map.Entry entry = Objects.requireNonNull((Map.Entry)o2);
                AbstractMapBasedMultimap.this.removeValuesForKey(entry.getKey());
                return true;
            }
        }

        class AsMapIterator
        implements Iterator<Map.Entry<K, Collection<V>>> {
            final Iterator<Map.Entry<K, Collection<V>>> delegateIterator;
            Collection<V> collection;

            AsMapIterator() {
                this.delegateIterator = AsMap.this.submap.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.delegateIterator.hasNext();
            }

            @Override
            public Map.Entry<K, Collection<V>> next() {
                Map.Entry entry = this.delegateIterator.next();
                this.collection = entry.getValue();
                return AsMap.this.wrapEntry(entry);
            }

            @Override
            public void remove() {
                Preconditions.checkState(this.collection != null, "no calls to next() since the last call to remove()");
                this.delegateIterator.remove();
                AbstractMapBasedMultimap.this.totalSize -= this.collection.size();
                this.collection.clear();
                this.collection = null;
            }
        }
    }

    private final class NavigableAsMap
    extends SortedAsMap
    implements NavigableMap {
        NavigableAsMap(NavigableMap<K, Collection<V>> submap) {
            super(submap);
        }

        NavigableMap<K, Collection<V>> sortedMap() {
            return (NavigableMap)super.sortedMap();
        }

        public Map.Entry<K, Collection<V>> lowerEntry(K key) {
            Map.Entry entry = this.sortedMap().lowerEntry(key);
            return entry == null ? null : this.wrapEntry(entry);
        }

        @Override
        public K lowerKey(K key) {
            return this.sortedMap().lowerKey(key);
        }

        public Map.Entry<K, Collection<V>> floorEntry(K key) {
            Map.Entry entry = this.sortedMap().floorEntry(key);
            return entry == null ? null : this.wrapEntry(entry);
        }

        @Override
        public K floorKey(K key) {
            return this.sortedMap().floorKey(key);
        }

        public Map.Entry<K, Collection<V>> ceilingEntry(K key) {
            Map.Entry entry = this.sortedMap().ceilingEntry(key);
            return entry == null ? null : this.wrapEntry(entry);
        }

        @Override
        public K ceilingKey(K key) {
            return this.sortedMap().ceilingKey(key);
        }

        public Map.Entry<K, Collection<V>> higherEntry(K key) {
            Map.Entry entry = this.sortedMap().higherEntry(key);
            return entry == null ? null : this.wrapEntry(entry);
        }

        @Override
        public K higherKey(K key) {
            return this.sortedMap().higherKey(key);
        }

        @Override
        public Map.Entry<K, Collection<V>> firstEntry() {
            Map.Entry entry = this.sortedMap().firstEntry();
            return entry == null ? null : this.wrapEntry(entry);
        }

        @Override
        public Map.Entry<K, Collection<V>> lastEntry() {
            Map.Entry entry = this.sortedMap().lastEntry();
            return entry == null ? null : this.wrapEntry(entry);
        }

        @Override
        public Map.Entry<K, Collection<V>> pollFirstEntry() {
            return this.pollAsMapEntry(this.entrySet().iterator());
        }

        @Override
        public Map.Entry<K, Collection<V>> pollLastEntry() {
            return this.pollAsMapEntry(this.descendingMap().entrySet().iterator());
        }

        Map.Entry<K, Collection<V>> pollAsMapEntry(Iterator<Map.Entry<K, Collection<V>>> entryIterator) {
            if (!entryIterator.hasNext()) {
                return null;
            }
            Map.Entry entry = entryIterator.next();
            Collection output2 = AbstractMapBasedMultimap.this.createCollection();
            output2.addAll(entry.getValue());
            entryIterator.remove();
            return Maps.immutableEntry(entry.getKey(), AbstractMapBasedMultimap.this.unmodifiableCollectionSubclass(output2));
        }

        public NavigableMap<K, Collection<V>> descendingMap() {
            return new NavigableAsMap(this.sortedMap().descendingMap());
        }

        @Override
        public NavigableSet<K> keySet() {
            return (NavigableSet)super.keySet();
        }

        @Override
        NavigableSet<K> createKeySet() {
            return new NavigableKeySet(this.sortedMap());
        }

        @Override
        public NavigableSet<K> navigableKeySet() {
            return this.keySet();
        }

        @Override
        public NavigableSet<K> descendingKeySet() {
            return this.descendingMap().navigableKeySet();
        }

        @Override
        public NavigableMap<K, Collection<V>> subMap(K fromKey, K toKey) {
            return this.subMap(fromKey, true, toKey, false);
        }

        public NavigableMap<K, Collection<V>> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
            return new NavigableAsMap(this.sortedMap().subMap(fromKey, fromInclusive, toKey, toInclusive));
        }

        @Override
        public NavigableMap<K, Collection<V>> headMap(K toKey) {
            return this.headMap(toKey, false);
        }

        public NavigableMap<K, Collection<V>> headMap(K toKey, boolean inclusive) {
            return new NavigableAsMap(this.sortedMap().headMap(toKey, inclusive));
        }

        @Override
        public NavigableMap<K, Collection<V>> tailMap(K fromKey) {
            return this.tailMap(fromKey, true);
        }

        public NavigableMap<K, Collection<V>> tailMap(K fromKey, boolean inclusive) {
            return new NavigableAsMap(this.sortedMap().tailMap(fromKey, inclusive));
        }
    }

    private class SortedAsMap
    extends AsMap
    implements SortedMap {
        SortedSet<K> sortedKeySet;

        SortedAsMap(SortedMap<K, Collection<V>> submap) {
            super(submap);
        }

        SortedMap<K, Collection<V>> sortedMap() {
            return (SortedMap)this.submap;
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.sortedMap().comparator();
        }

        @Override
        public K firstKey() {
            return this.sortedMap().firstKey();
        }

        @Override
        public K lastKey() {
            return this.sortedMap().lastKey();
        }

        public SortedMap<K, Collection<V>> headMap(K toKey) {
            return new SortedAsMap(this.sortedMap().headMap(toKey));
        }

        public SortedMap<K, Collection<V>> subMap(K fromKey, K toKey) {
            return new SortedAsMap(this.sortedMap().subMap(fromKey, toKey));
        }

        public SortedMap<K, Collection<V>> tailMap(K fromKey) {
            return new SortedAsMap(this.sortedMap().tailMap(fromKey));
        }

        @Override
        public SortedSet<K> keySet() {
            SortedSet result2 = this.sortedKeySet;
            return result2 == null ? (this.sortedKeySet = this.createKeySet()) : result2;
        }

        @Override
        SortedSet<K> createKeySet() {
            return new SortedKeySet(this.sortedMap());
        }
    }

    private abstract class Itr<T>
    implements Iterator<T> {
        final Iterator<Map.Entry<K, Collection<V>>> keyIterator;
        K key;
        Collection<V> collection;
        Iterator<V> valueIterator;

        Itr() {
            this.keyIterator = AbstractMapBasedMultimap.this.map.entrySet().iterator();
            this.key = null;
            this.collection = null;
            this.valueIterator = Iterators.emptyModifiableIterator();
        }

        abstract T output(K var1, V var2);

        @Override
        public boolean hasNext() {
            return this.keyIterator.hasNext() || this.valueIterator.hasNext();
        }

        @Override
        public T next() {
            if (!this.valueIterator.hasNext()) {
                Map.Entry mapEntry = this.keyIterator.next();
                this.key = mapEntry.getKey();
                this.collection = mapEntry.getValue();
                this.valueIterator = this.collection.iterator();
            }
            return this.output(NullnessCasts.uncheckedCastNullableTToT(this.key), this.valueIterator.next());
        }

        @Override
        public void remove() {
            this.valueIterator.remove();
            if (Objects.requireNonNull(this.collection).isEmpty()) {
                this.keyIterator.remove();
            }
            AbstractMapBasedMultimap.this.totalSize--;
        }
    }

    class WrappedNavigableSet
    extends WrappedSortedSet
    implements NavigableSet {
        WrappedNavigableSet(K key, NavigableSet<V> delegate, WrappedCollection ancestor) {
            super(key, delegate, ancestor);
        }

        NavigableSet<V> getSortedSetDelegate() {
            return (NavigableSet)super.getSortedSetDelegate();
        }

        public V lower(V v2) {
            return this.getSortedSetDelegate().lower(v2);
        }

        public V floor(V v2) {
            return this.getSortedSetDelegate().floor(v2);
        }

        public V ceiling(V v2) {
            return this.getSortedSetDelegate().ceiling(v2);
        }

        public V higher(V v2) {
            return this.getSortedSetDelegate().higher(v2);
        }

        public V pollFirst() {
            return Iterators.pollNext(this.iterator());
        }

        public V pollLast() {
            return Iterators.pollNext(this.descendingIterator());
        }

        private NavigableSet<V> wrap(NavigableSet<V> wrapped) {
            return new WrappedNavigableSet(this.key, wrapped, this.getAncestor() == null ? this : this.getAncestor());
        }

        public NavigableSet<V> descendingSet() {
            return this.wrap(this.getSortedSetDelegate().descendingSet());
        }

        public Iterator<V> descendingIterator() {
            return new WrappedCollection.WrappedIterator(this.getSortedSetDelegate().descendingIterator());
        }

        public NavigableSet<V> subSet(V fromElement, boolean fromInclusive, V toElement, boolean toInclusive) {
            return this.wrap(this.getSortedSetDelegate().subSet(fromElement, fromInclusive, toElement, toInclusive));
        }

        public NavigableSet<V> headSet(V toElement, boolean inclusive) {
            return this.wrap(this.getSortedSetDelegate().headSet(toElement, inclusive));
        }

        public NavigableSet<V> tailSet(V fromElement, boolean inclusive) {
            return this.wrap(this.getSortedSetDelegate().tailSet(fromElement, inclusive));
        }
    }

    class WrappedSortedSet
    extends WrappedCollection
    implements SortedSet {
        WrappedSortedSet(K key, SortedSet<V> delegate, WrappedCollection ancestor) {
            super(key, delegate, ancestor);
        }

        SortedSet<V> getSortedSetDelegate() {
            return (SortedSet)this.getDelegate();
        }

        public Comparator<? super V> comparator() {
            return this.getSortedSetDelegate().comparator();
        }

        public V first() {
            this.refreshIfEmpty();
            return this.getSortedSetDelegate().first();
        }

        public V last() {
            this.refreshIfEmpty();
            return this.getSortedSetDelegate().last();
        }

        public SortedSet<V> headSet(V toElement) {
            this.refreshIfEmpty();
            return new WrappedSortedSet(this.getKey(), this.getSortedSetDelegate().headSet(toElement), this.getAncestor() == null ? this : this.getAncestor());
        }

        public SortedSet<V> subSet(V fromElement, V toElement) {
            this.refreshIfEmpty();
            return new WrappedSortedSet(this.getKey(), this.getSortedSetDelegate().subSet(fromElement, toElement), this.getAncestor() == null ? this : this.getAncestor());
        }

        public SortedSet<V> tailSet(V fromElement) {
            this.refreshIfEmpty();
            return new WrappedSortedSet(this.getKey(), this.getSortedSetDelegate().tailSet(fromElement), this.getAncestor() == null ? this : this.getAncestor());
        }
    }

    class WrappedSet
    extends WrappedCollection
    implements Set {
        WrappedSet(K key, Set<V> delegate) {
            super(key, delegate, null);
        }

        @Override
        public boolean removeAll(Collection<?> c2) {
            if (c2.isEmpty()) {
                return false;
            }
            int oldSize = this.size();
            boolean changed = Sets.removeAllImpl((Set)this.delegate, c2);
            if (changed) {
                int newSize = this.delegate.size();
                AbstractMapBasedMultimap.this.totalSize += newSize - oldSize;
                this.removeIfEmpty();
            }
            return changed;
        }
    }
}

