<?php
/**
 * Aliases for MobileFrontend extension
 *
 * @file
 * @ingroup Extensions
 */

$specialPageAliases = [];

/** English (English) */
$specialPageAliases['en'] = [
	'Uploads' => [ 'Uploads' ],
	'History' => [ 'History' ],
	'MobileOptions' => [ 'MobileOptions' ],
	'MobileDiff' => [ 'MobileDiff' ],
	'MobileLanguages' => [ 'MobileLanguages' ],
];

/** Afrikaans (Afrikaans) */
$specialPageAliases['af'] = [
	'History' => [ 'Geskiedenis' ],
	'Uploads' => [ 'Oplaaie' ],
];

/** Arabic (العربية) */
$specialPageAliases['ar'] = [
	'History' => [ 'تاريخ' ],
	'MobileOptions' => [ 'خيارات_المحمول' ],
	'Uploads' => [ 'مرفوعات' ],
	'MobileDiff' => [ 'فرق_المحمول' ],
	'MobileLanguages' => [ 'لغات_المحمول' ],
];

/** Egyptian Arabic (مصرى) */
$specialPageAliases['arz'] = [
	'History' => [ 'تاريخ' ],
	'MobileOptions' => [ 'خيارات_الموبايل' ],
	'Uploads' => [ 'مرفوعات' ],
	'MobileDiff' => [ 'فرق_الموبايل' ],
	'MobileLanguages' => [ 'لغات_الموبايل' ],
];

/** Avaric (авар) */
$specialPageAliases['av'] = [
	'MobileOptions' => [ 'Настройки_мобильной_версии' ],
	'Uploads' => [ 'Загрузки' ],
	'MobileDiff' => [ 'Сравнение_версий' ],
];

/** Azerbaijani (azərbaycanca) */
$specialPageAliases['az'] = [
	'Uploads' => [ 'Yükləmələrim' ],
	'History' => [ 'Tarixçə' ],
	'MobileOptions' => [ 'MobilSeçimlər' ],
	'MobileDiff' => [ 'MobilFərq' ],
	'MobileLanguages' => [ 'MobilDillər' ],
];

/** Western Balochi (بلوچی رخشانی) */
$specialPageAliases['bgn'] = [
	'History' => [ 'تاریخچه_گ' ],
	'MobileOptions' => [ 'موبایل_ئی_تنزیمان' ],
	'Uploads' => [ 'بُرز_بوته_ئینان' ],
	'MobileDiff' => [ 'موبایل_ئی_پرک' ],
	'MobileLanguages' => [ 'موبایل_ئی_زبانان' ],
];

/** Bengali (বাংলা) */
$specialPageAliases['bn'] = [
	'History' => [ 'ইতিহাস' ],
	'MobileOptions' => [ 'মোবাইল_বিকল্প' ],
	'Uploads' => [ 'আপলোডসমূহ' ],
	'MobileDiff' => [ 'মোবাইল_পার্থক্য' ],
	'MobileLanguages' => [ 'মোবাইল_ভাষাসমূহ' ],
];

/** Chechen (нохчийн) */
$specialPageAliases['ce'] = [
	'MobileOptions' => [ 'Мобильни_верси_нисяр' ],
	'Uploads' => [ 'Чуйохурш' ],
	'MobileDiff' => [ 'Версеш_юстар' ],
];

/** Czech (čeština) */
$specialPageAliases['cs'] = [
	'History' => [ 'Historie' ],
	'MobileOptions' => [ 'Mobilní_nastavení' ],
	'Uploads' => [ 'Vaše_soubory' ],
	'MobileDiff' => [ 'Mobilní_rozdíl' ],
	'MobileLanguages' => [ 'Mobilní_jazyky' ],
];

/** German (Deutsch) */
$specialPageAliases['de'] = [
	'History' => [ 'Versionsgeschichte' ],
	'MobileOptions' => [ 'Mobile_Optionen' ],
	'Uploads' => [ 'Hochgeladene_Dateien' ],
	'MobileDiff' => [ 'Mobiler_Unterschied' ],
	'MobileLanguages' => [ 'Mobile_Sprachen' ],
];

/** Zazaki (Zazaki) */
$specialPageAliases['diq'] = [
	'History' => [ 'Tarix' ],
	'MobileOptions' => [ 'MobilWeçenegi' ],
	'Uploads' => [ 'Barkerdışi' ],
	'MobileDiff' => [ 'MobilVer' ],
	'MobileLanguages' => [ 'MobilZıwani' ],
];

/** Esperanto (Esperanto) */
$specialPageAliases['eo'] = [
	'MobileOptions' => [ 'Opcioj_pri_poŝaparato' ],
	'Uploads' => [ 'Alŝutoj' ],
];

/** Spanish (español) */
$specialPageAliases['es'] = [
	'MobileOptions' => [ 'OpcionesParaMóvil' ],
	'Uploads' => [ 'Subidas' ],
];

/** Estonian (eesti) */
$specialPageAliases['et'] = [
	'History' => [ 'Ajalugu' ],
	'MobileOptions' => [ 'Mobiili_suvandid' ],
	'Uploads' => [ 'Üleslaaditud_failid' ],
	'MobileDiff' => [ 'Mobiilierinevus' ],
	'MobileLanguages' => [ 'Mobiilikeeled' ],
];

/** Persian (فارسی) */
$specialPageAliases['fa'] = [
	'History' => [ 'تاریخچه' ],
	'MobileOptions' => [ 'گزینه‌های_گوشی_همراه' ],
	'Uploads' => [ 'بارگذاری‌ها' ],
	'MobileDiff' => [ 'تفاوت_گوشی_همراه' ],
	'MobileLanguages' => [ 'زبان‌های_گوشی_همراه' ],
];

/** Galician (galego) */
$specialPageAliases['gl'] = [
	'Uploads' => [ 'Subidas', 'Cargas' ],
];

/** Hebrew (עברית) */
$specialPageAliases['he'] = [
	'History' => [ 'היסטוריה' ],
	'MobileOptions' => [ 'הגדרות_נייד', 'הגדרות_פלאפון', 'הגדרות_סלולרי' ],
	'Uploads' => [ 'העלאות' ],
	'MobileDiff' => [ 'השוואה_ניידת' ],
	'MobileLanguages' => [ 'שפות_בנייד' ],
];

/** Hindi (हिन्दी) */
$specialPageAliases['hi'] = [
	'History' => [ 'इतिहास' ],
	'MobileOptions' => [ 'मोबाइल_विकल्प' ],
	'MobileLanguages' => [ 'मोबाइल_भाषा' ],
];

/** Upper Sorbian (hornjoserbsce) */
$specialPageAliases['hsb'] = [
	'History' => [ 'Stawizny' ],
	'MobileOptions' => [ 'Mobilne_opcije' ],
	'Uploads' => [ 'Nahrate_dataje' ],
	'MobileDiff' => [ 'Mobilny_rozdźěl' ],
	'MobileLanguages' => [ 'Mobilne_rěče' ],
];

/** Italian (italiano) */
$specialPageAliases['it'] = [
	'History' => [ 'Cronologia' ],
	'MobileOptions' => [ 'OpzioniMobile' ],
	'Uploads' => [ 'Caricamenti' ],
	'MobileDiff' => [ 'DiffMobile' ],
	'MobileLanguages' => [ 'LingueMobile' ],
];

/** Japanese (日本語) */
$specialPageAliases['ja'] = [
	'History' => [ '履歴' ],
	'MobileOptions' => [ '携帯機器オプション' ],
	'Uploads' => [ '携帯機器アップロード' ],
	'MobileDiff' => [ '携帯機器差分' ],
	'MobileLanguages' => [ '携帯機器言語', '言語' ],
];

/** Georgian (ქართული) */
$specialPageAliases['ka'] = [
	'History' => [ 'ისტორია' ],
	'Uploads' => [ 'ატვირთვები' ],
];

/** Korean (한국어) */
$specialPageAliases['ko'] = [
	'History' => [ '역사' ],
	'MobileOptions' => [ '모바일설정' ],
	'Uploads' => [ '올린파일' ],
	'MobileDiff' => [ '모바일차이' ],
	'MobileLanguages' => [ '모바일언어' ],
];

/** Luxembourgish (Lëtzebuergesch) */
$specialPageAliases['lb'] = [
	'History' => [ 'Versiounen' ],
	'MobileOptions' => [ 'Mobil_Optiounen' ],
	'Uploads' => [ 'Eropgeluede_Fichieren' ],
	'MobileDiff' => [ 'Mobilen_Ënnerscheed' ],
	'MobileLanguages' => [ 'Mobil_Sproochen' ],
	'Nearby' => [ 'Nobäi' ],
];

/** Northern Luri (لۊری شومالی) */
$specialPageAliases['lrc'] = [
	'History' => [ 'ڤیرگار' ],
	'MobileOptions' => [ 'خوصوٙصیات_موبایلی' ],
	'Uploads' => [ 'سوڤارکئردیا' ],
	'MobileDiff' => [ 'فأرخ_موبایلی' ],
	'MobileLanguages' => [ 'زوٙنا_موبایل' ],
];

/** Macedonian (македонски) */
$specialPageAliases['mk'] = [
	'History' => [ 'Историја' ],
	'MobileOptions' => [ 'МобилниПоставки' ],
	'Uploads' => [ 'Подигања' ],
	'MobileDiff' => [ 'МобилнаРазлика' ],
	'MobileLanguages' => [ 'МобилниЈазици' ],
];

/** Malayalam (മലയാളം) */
$specialPageAliases['ml'] = [
	'History' => [ 'ഹിസ്റ്ററി' ],
	'MobileOptions' => [ 'മൊബൈൽഐച്ഛികങ്ങൾ' ],
	'Uploads' => [ 'അപ്‌ലോഡുകൾ' ],
	'MobileDiff' => [ 'മൊബൈൽവ്യത്യാസം' ],
	'MobileLanguages' => [ 'മൊബൈൽഭാഷകൾ' ],
];

/** Marathi (मराठी) */
$specialPageAliases['mr'] = [
	'History' => [ 'इतिहास' ],
];

/** Min Nan Chinese (Bân-lâm-gú) */
$specialPageAliases['nan'] = [
	'Uploads' => [ 'Kā--ê_tóng-àn' ],
];

/** Norwegian Bokmål (norsk bokmål) */
$specialPageAliases['nb'] = [
	'Uploads' => [ 'Opplastinger' ],
	'History' => [ 'Historikk' ],
	'MobileOptions' => [ 'Mobilinnstillinger' ],
	'MobileDiff' => [ 'Mobildiff' ],
	'MobileLanguages' => [ 'Mobilspråk' ],
];

/** Dutch (Nederlands) */
$specialPageAliases['nl'] = [
	'History' => [ 'Geschiedenis' ],
	'MobileOptions' => [ 'MobieleVoorkeuren' ],
	'MobileDiff' => [ 'MobielVerschillen' ],
	'MobileLanguages' => [ 'MobielTalen' ],
];

/** Norwegian Nynorsk (norsk nynorsk) */
$specialPageAliases['nn'] = [
	'Uploads' => [ 'Opplastingar' ],
	'MobileOptions' => [ 'Mobilval' ],
	'MobileDiff' => [ 'Mobildiff' ],
	'MobileLanguages' => [ 'Mobilspråk' ],
];

/** Punjabi (ਪੰਜਾਬੀ) */
$specialPageAliases['pa'] = [
	'History' => [ 'ਇਤਿਹਾਸ' ],
];

/** Polish (polski) */
$specialPageAliases['pl'] = [
	'Uploads' => [ 'Przesłane' ],
	'History' => [ 'Historia' ],
	'MobileOptions' => [ 'Ustawienia_mobile' ],
	'MobileDiff' => [ 'Różnica_mobilna' ],
	'MobileLanguages' => [ 'Języki_mobilne' ],
];

/** Russian (русский) */
$specialPageAliases['ru'] = [
	'MobileOptions' => [ 'Настройки_мобильной_версии' ],
	'Uploads' => [ 'Загрузки' ],
	'MobileDiff' => [ 'Сравнение_версий' ],
];

/** Sicilian (sicilianu) */
$specialPageAliases['scn'] = [
	'MobileOptions' => [ 'OpzioniMobile' ],
];

/** Slovak (slovenčina) */
$specialPageAliases['sk'] = [
	'History' => [ 'História', 'Historia' ],
	'MobileOptions' => [ 'Mobilné_nastavenia', 'MobilnéNastavenia', 'Mobilne_nastavenia', 'MobilneNastavenia' ],
	'Uploads' => [ 'Nahrané_súbory', 'NahranéSúbory', 'Nahrane_subory', 'NahraneSubory' ],
	'MobileDiff' => [ 'Mobilný_rozdiel', 'MobilnýRozdiel', 'Mobilny_rozdiel', 'MobilnyRozdiel' ],
	'MobileLanguages' => [ 'Mobilné_jazyky', 'MobilnéJazyky', 'Mobilne_jazyky', 'MobilneJazyky' ],
];

/** Serbian (Cyrillic script) (српски (ћирилица)) */
$specialPageAliases['sr-cyrl'] = [
	'History' => [ 'Историја' ],
	'MobileOptions' => [ 'МобилнаПодешавања', 'Мобилна_подешавања' ],
	'Uploads' => [ 'Отпремања' ],
	'MobileDiff' => [ 'МобилнеРазлике', 'Мобилне_разлике' ],
	'MobileLanguages' => [ 'МобилниЈезици', 'Мобилни_језици' ],
];

/** Serbian (Latin script) (srpski (latinica)) */
$specialPageAliases['sr-latn'] = [
	'History' => [ 'Istorija' ],
	'MobileOptions' => [ 'MobilnaPodešavanja', 'Mobilna_podešavanja' ],
	'Uploads' => [ 'Otpremanja' ],
	'MobileDiff' => [ 'MobilneRazlike', 'Mobilne_razlike' ],
	'MobileLanguages' => [ 'MobilniJezici', 'Mobilni_jezici' ],
];

/** Swedish (svenska) */
$specialPageAliases['sv'] = [
	'History' => [ 'Historik' ],
	'MobileDiff' => [ 'Mobil_diff' ],
	'MobileLanguages' => [ 'Mobil_språk' ],
];

/** Ukrainian (українська) */
$specialPageAliases['uk'] = [
	'History' => [ 'Історія' ],
	'MobileOptions' => [ 'Налаштування_мобільної_версії', 'Настройки_мобильной_версии' ],
	'Uploads' => [ 'Мобільне_Завантаження', 'Загрузки' ],
	'MobileDiff' => [ 'Мобільна_різниця_версій', 'Сравнение_версий' ],
];

/** Urdu (اردو) */
$specialPageAliases['ur'] = [
	'History' => [ 'تاریخچہ', 'تاریخ' ],
	'MobileOptions' => [ 'اختیارات_موبائل', 'موبائل_اختیارات' ],
	'Uploads' => [ 'اپلوڈ_کردہ' ],
	'MobileDiff' => [ 'موبائل_فرق' ],
	'MobileLanguages' => [ 'موبائل_کی_زبانیں' ],
];

/** Vietnamese (Tiếng Việt) */
$specialPageAliases['vi'] = [
	'History' => [ 'Lịch_sử' ],
	'MobileOptions' => [ 'Tùy_chọn_di_động' ],
	'Uploads' => [ 'Tập_tin_tải_lên' ],
	'MobileDiff' => [ 'So_sánh_di_động' ],
	'MobileLanguages' => [ 'Ngôn_ngữ_di_động' ],
];

/** Simplified Chinese (中文（简体）) */
$specialPageAliases['zh-hans'] = [
	'History' => [ '历史' ],
	'MobileOptions' => [ '移动版选项' ],
	'Uploads' => [ '已上传文件' ],
	'MobileDiff' => [ '移动版差异' ],
	'MobileLanguages' => [ '移动版语言' ],
];

/** Traditional Chinese (中文（繁體）) */
$specialPageAliases['zh-hant'] = [
	'History' => [ '歷史' ],
	'MobileOptions' => [ '行動版選項', '流動版選項' ],
	'Uploads' => [ '已上傳檔案', '已上載檔案' ],
	'MobileDiff' => [ '行動版差異', '流動版差異', '手機版差異' ],
	'MobileLanguages' => [ '行動版語言', '流動版語言', '手機版語言' ],
];

/** Hong Kong Traditional Chinese (中文（香港）) */
$specialPageAliases['zh-hk'] = [
	'MobileOptions' => [ '流動版選項' ],
	'Uploads' => [ '已上載檔案' ],
	'MobileDiff' => [ '流動版差異' ],
	'MobileLanguages' => [ '流動版語言' ],
];
